/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPResourceManager;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.rm.core.rtsystem.AbstractRemoteCommandJob;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystem;
import org.eclipse.ptp.rm.mpi.mpich2.core.MPICH2Plugin;
import org.eclipse.ptp.rm.mpi.mpich2.core.messages.Messages;
import org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem.MPICH2JobMap;
import org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem.MPICH2ListJobsParser;
import org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem.MPICH2RuntimeSystem;

public class MPICH2PeriodicJob
extends AbstractRemoteCommandJob {
    MPICH2RuntimeSystem rts;

    public MPICH2PeriodicJob(MPICH2RuntimeSystem rts) {
        super((AbstractToolRuntimeSystem)rts, NLS.bind((String)Messages.MPICH2MonitorJob_name, (Object)rts.getRmConfiguration().getName()), rts.retrieveEffectiveToolRmConfiguration().getPeriodicMonitorCmd(), Messages.MPICH2MonitorJob_interruptedErrorMessage, Messages.MPICH2MonitorJob_processErrorMessage, Messages.MPICH2MonitorJob_parsingErrorMessage, rts.retrieveEffectiveToolRmConfiguration().getPeriodicMonitorTime());
        this.rts = rts;
    }

    protected void parse(BufferedReader output) throws CoreException {
        MPICH2JobMap jobMap;
        IPResourceManager rm = this.rts.getPResourceManager();
        MPICH2ListJobsParser parser = new MPICH2ListJobsParser();
        try {
            jobMap = parser.parse(output);
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, MPICH2Plugin.getDefault().getBundle().getSymbolicName(), parser.getErrorMessage()));
        }
        for (List<MPICH2JobMap.Job> jobs : jobMap.getJobs()) {
            for (MPICH2JobMap.Job job : jobs) {
                boolean processHasNode;
                IPJob pJob = rm.getJobById(job.getJobAlias());
                if (pJob == null) continue;
                int jobRank = job.getRank();
                boolean hasProcess = pJob.hasProcessByJobRank(jobRank);
                String processNodeId = hasProcess ? pJob.getProcessNodeId(jobRank) : null;
                boolean bl = processHasNode = processNodeId != null;
                if (!hasProcess || processHasNode) continue;
                String nodeID = this.rts.getNodeIDforName(job.getHost());
                if (nodeID == null) {
                    throw new CoreException((IStatus)new Status(4, MPICH2Plugin.getDefault().getBundle().getSymbolicName(), Messages.MPICH2RuntimeSystemJob_Exception_HostnamesDoNotMatch));
                }
                AttributeManager attrMrg = new AttributeManager();
                attrMrg.addAttribute((IAttribute)ProcessAttributes.getNodeIdAttributeDefinition().create(nodeID));
                BitSet processJobRanks = new BitSet();
                processJobRanks.set(jobRank);
                this.rts.changeProcesses(pJob.getID(), processJobRanks, attrMrg);
            }
        }
    }
}

