/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.calls.engine;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnMemberAccess;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnMessageSend;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnQualifiedNameReference;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContextFactory;
import org.eclipse.recommenders.internal.completion.rcp.calls.engine.AstBasedObjectUsageResolver;
import org.eclipse.recommenders.internal.completion.rcp.calls.engine.CallsRecommendation;
import org.eclipse.recommenders.internal.completion.rcp.calls.engine.ProposalMatcher;
import org.eclipse.recommenders.internal.completion.rcp.calls.net.IObjectMethodCallsNet;
import org.eclipse.recommenders.internal.completion.rcp.calls.wiring.CallsCompletionModule;
import org.eclipse.recommenders.internal.rcp.models.IModelArchiveStore;
import org.eclipse.recommenders.internal.utils.codestructs.DefinitionSite;
import org.eclipse.recommenders.internal.utils.codestructs.ObjectUsage;
import org.eclipse.recommenders.internal.utils.codestructs.Variable;
import org.eclipse.recommenders.rcp.RecommendersPlugin;
import org.eclipse.recommenders.utils.Constants;
import org.eclipse.recommenders.utils.Tuple;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmMethodName;
import org.eclipse.recommenders.utils.rcp.CompletionProposalDecorator;
import org.eclipse.recommenders.utils.rcp.JavaElementResolver;
import org.eclipse.recommenders.utils.rcp.JdtUtils;
import org.eclipse.recommenders.utils.rcp.ast.MethodDeclarationFinder;

public class CallsCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    public static String CATEGORY_ID = "org.eclipse.recommenders.rcp.category.completion";
    private final Set<Class<?>> supportedCompletionRequests = new HashSet<Class<?>>(){
        {
            this.add(CompletionOnMemberAccess.class);
            this.add(CompletionOnMessageSend.class);
            this.add(CompletionOnQualifiedNameReference.class);
            this.add(CompletionOnSingleNameReference.class);
        }
    };
    private final IRecommendersCompletionContextFactory ctxFactory;
    private final JavaElementResolver jdtResolver;
    private IRecommendersCompletionContext ctx;
    private String receiverName;
    private IType receiverType;
    @VisibleForTesting
    public ObjectUsage query;
    private IObjectMethodCallsNet model;
    private List<ICompletionProposal> proposals;
    private List<CallsRecommendation> recommendations;
    private JavaContentAssistInvocationContext javaContext;
    private final IModelArchiveStore<IType, IObjectMethodCallsNet> modelStore;
    private final IPreferenceStore prefStore;

    @Inject
    public CallsCompletionProposalComputer(IModelArchiveStore<IType, IObjectMethodCallsNet> modelStore, JavaElementResolver jdtResolver, IRecommendersCompletionContextFactory ctxFactory, @CallsCompletionModule.CallCompletion IPreferenceStore prefStore) {
        this.modelStore = modelStore;
        this.jdtResolver = jdtResolver;
        this.ctxFactory = ctxFactory;
        this.prefStore = prefStore;
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext javaContext, IProgressMonitor monitor) {
        this.initalize(javaContext);
        if (!this.isCompletionRequestSupported()) {
            return Collections.emptyList();
        }
        if (!this.findReceiver()) {
            return Collections.emptyList();
        }
        try {
            if (!this.acquireModel()) {
                List<ICompletionProposal> list = Collections.emptyList();
                return list;
            }
            if (!this.completeQuery()) {
                List<ICompletionProposal> list = Collections.emptyList();
                return list;
            }
            if (!this.findRecommendations()) {
                List<ICompletionProposal> list = Collections.emptyList();
                return list;
            }
            this.createProspsals();
        }
        finally {
            this.releaseModel();
        }
        return this.proposals;
    }

    private void initalize(ContentAssistInvocationContext javaContext) {
        this.javaContext = (JavaContentAssistInvocationContext)javaContext;
        this.ctx = this.ctxFactory.create(this.javaContext);
        this.query = ObjectUsage.newObjectUsageWithDefaults();
        this.proposals = Lists.newLinkedList();
    }

    private boolean isCompletionRequestSupported() {
        ASTNode node = this.ctx.getCompletionNode();
        return node == null ? false : this.supportedCompletionRequests.contains(node.getClass());
    }

    private boolean findReceiver() {
        this.receiverName = this.ctx.getReceiverName();
        this.receiverType = (IType)this.ctx.getReceiverType().orNull();
        if (this.isReceiverNameThis() || this.isReceiverNameSuper() || this.isImplicitThis()) {
            this.setReceiverToSupertype();
        }
        return this.receiverType != null;
    }

    private boolean isReceiverNameThis() {
        return "this".equals(this.receiverName);
    }

    private boolean isReceiverNameSuper() {
        return "super".equals(this.receiverName);
    }

    private boolean isImplicitThis() {
        return this.receiverType == null && this.receiverName.isEmpty();
    }

    private void setReceiverToSupertype() {
        try {
            IMethod m = (IMethod)this.ctx.getEnclosingMethod().orNull();
            if (m == null || JdtFlags.isStatic((IMember)m)) {
                return;
            }
            IType type = m.getDeclaringType();
            ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy((IType)type);
            this.receiverType = hierarchy.getSuperclass(type);
        }
        catch (Exception e) {
            RecommendersPlugin.logError((Exception)e, (String)"Failed to resolve super type of %s", (Object[])new Object[]{this.ctx.getEnclosingElement()});
        }
    }

    private boolean acquireModel() {
        this.model = (IObjectMethodCallsNet)this.modelStore.aquireModel((Object)this.receiverType).orNull();
        return this.model != null;
    }

    private boolean completeQuery() {
        this.setCalls();
        this.setReceiverType();
        this.setFirstMethodDeclaration();
        this.setDefinition();
        return true;
    }

    private void setDefinition() {
        if (this.query.definition.equals(Constants.UNKNOWN_METHOD)) {
            Optional methodDef = this.ctx.getMethodDef();
            if (methodDef.isPresent()) {
                this.query.definition = (IMethodName)methodDef.get();
                this.query.kind = DefinitionSite.Kind.METHOD_RETURN;
            } else if (this.query.kind == DefinitionSite.Kind.UNKNOWN) {
                this.query.kind = DefinitionSite.Kind.FIELD;
            }
        } else if (this.query.definition != null && this.query.kind == DefinitionSite.Kind.PARAMETER) {
            this.query.definition = this.query.contextFirst;
        }
    }

    private void setFirstMethodDeclaration() {
        Optional enclosingMethod = this.ctx.getEnclosingMethod();
        if (!enclosingMethod.isPresent()) {
            return;
        }
        IMethod first = JdtUtils.findFirstDeclaration((IMethod)((IMethod)enclosingMethod.get()));
        this.query.contextFirst = (IMethodName)this.jdtResolver.toRecMethod(first).or((Object)VmMethodName.NULL);
    }

    private void setReceiverType() {
        this.query.type = this.jdtResolver.toRecType(this.receiverType);
    }

    private void setCalls() {
        IMethod jdtMethod;
        IMethodName recMethod;
        Optional astMethod;
        CompilationUnit ast = this.ctx.getAST();
        Optional enclosingMethod = this.ctx.getEnclosingMethod();
        if (enclosingMethod.isPresent() && (astMethod = MethodDeclarationFinder.find((CompilationUnit)ast, (IMethodName)(recMethod = (IMethodName)this.jdtResolver.toRecMethod(jdtMethod = (IMethod)enclosingMethod.get()).or((Object)VmMethodName.NULL)))).isPresent()) {
            AstBasedObjectUsageResolver r = new AstBasedObjectUsageResolver();
            ObjectUsage usage = r.findObjectUsage(this.receiverName, (MethodDeclaration)astMethod.get());
            this.query.calls = usage.calls;
            if (usage.kind != null) {
                this.query.kind = usage.kind;
            }
            if (usage.definition != null) {
                this.query.definition = usage.definition;
                Optional def = this.ctx.getMethodDef();
                if (def.isPresent()) {
                    this.query.definition = (IMethodName)def.get();
                }
            }
        }
    }

    private boolean findRecommendations() {
        this.recommendations = Lists.newLinkedList();
        this.model.setQuery(this.query);
        double minProbability = (double)this.prefStore.getInt("recommenders.calls.min_probability") * 0.01;
        int maxProposals = this.prefStore.getInt("recommenders.calls.max_proposals");
        SortedSet<Tuple<IMethodName, Double>> recommendedMethodCalls = this.model.getRecommendedMethodCalls(minProbability);
        Variable var = Variable.create((String)this.receiverName, (ITypeName)this.jdtResolver.toRecType(this.receiverType), null);
        boolean expectsReturnType = this.ctx.getExpectedTypeSignature().isPresent();
        String prefix = this.ctx.getPrefix();
        for (Tuple tuple : recommendedMethodCalls) {
            IMethodName method = (IMethodName)tuple.getFirst();
            Double probability = (Double)tuple.getSecond();
            String proposalPrefix = StringUtils.substring((String)method.getName(), (int)0, (int)prefix.length());
            if (!proposalPrefix.equalsIgnoreCase(prefix) || expectsReturnType && method.isVoid()) continue;
            CallsRecommendation recommendation = CallsRecommendation.create(var, method, probability);
            this.recommendations.add(recommendation);
        }
        this.recommendations = this.recommendations.subList(0, Math.min(this.recommendations.size(), maxProposals));
        return !this.recommendations.isEmpty();
    }

    private void createProspsals() {
        Map proposals = this.ctx.getProposals();
        for (Map.Entry p : proposals.entrySet()) {
            CompletionProposal compilerProposal = (CompletionProposal)p.getValue();
            switch (compilerProposal.getKind()) {
                case 6: 
                case 12: 
                case 24: {
                    this.createCallProposalIfRecommended(compilerProposal, (IJavaCompletionProposal)p.getKey());
                }
            }
        }
    }

    private void createCallProposalIfRecommended(CompletionProposal compilerProposal, IJavaCompletionProposal jdtuiProposal) {
        ProposalMatcher matcher = new ProposalMatcher(compilerProposal);
        for (CallsRecommendation call : this.recommendations) {
            IMethodName crMethod = call.method;
            if (!matcher.match(crMethod)) continue;
            if (jdtuiProposal instanceof AbstractJavaCompletionProposal) {
                int baseRelevance = jdtuiProposal.getRelevance();
                ((AbstractJavaCompletionProposal)jdtuiProposal).setRelevance(baseRelevance += 250 + (int)Math.rint(call.probability * 100.0));
            }
            CompletionProposalDecorator decoratedProposal = new CompletionProposalDecorator(jdtuiProposal, call.probability);
            this.proposals.add((ICompletionProposal)decoratedProposal);
        }
    }

    private void releaseModel() {
        if (this.model != null) {
            this.modelStore.releaseModel((Object)this.model);
            this.model = null;
        }
    }

    public void sessionStarted() {
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }
}

