/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.calls.extdoc;

import com.google.common.base.Optional;
import com.google.common.eventbus.EventBus;
import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import javax.inject.Inject;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.recommenders.extdoc.rcp.providers.ExtdocProvider;
import org.eclipse.recommenders.extdoc.rcp.providers.JavaSelectionSubscriber;
import org.eclipse.recommenders.internal.completion.rcp.calls.engine.AstBasedObjectUsageResolver;
import org.eclipse.recommenders.internal.completion.rcp.calls.net.IObjectMethodCallsNet;
import org.eclipse.recommenders.internal.extdoc.rcp.ui.ExtdocUtils;
import org.eclipse.recommenders.internal.rcp.models.IModelArchiveStore;
import org.eclipse.recommenders.internal.utils.codestructs.DefinitionSite;
import org.eclipse.recommenders.internal.utils.codestructs.ObjectUsage;
import org.eclipse.recommenders.rcp.events.JavaSelectionEvent;
import org.eclipse.recommenders.utils.Names;
import org.eclipse.recommenders.utils.Tuple;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmMethodName;
import org.eclipse.recommenders.utils.rcp.JavaElementResolver;
import org.eclipse.recommenders.utils.rcp.JdtUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;

public final class CallsProvider
extends ExtdocProvider {
    private final IModelArchiveStore<IType, IObjectMethodCallsNet> modelStore;
    private final JavaElementResolver jdtResolver;
    private final EventBus workspaceBus;
    private IType receiverType;
    private IObjectMethodCallsNet model;

    @Inject
    public CallsProvider(IModelArchiveStore<IType, IObjectMethodCallsNet> modelStore, JavaElementResolver jdtResolver, EventBus workspaceBus) {
        this.modelStore = modelStore;
        this.jdtResolver = jdtResolver;
        this.workspaceBus = workspaceBus;
    }

    @JavaSelectionSubscriber
    public ExtdocProvider.Status onVariableSelection(ILocalVariable var, JavaSelectionEvent event, Composite parent) {
        return this.handle((IJavaElement)var, var.getElementName(), var.getTypeSignature(), event, parent);
    }

    @JavaSelectionSubscriber(value={JavaSelectionEvent.JavaSelectionLocation.METHOD_BODY})
    public ExtdocProvider.Status onFieldSelection(IField var, JavaSelectionEvent event, Composite parent) throws JavaModelException {
        return this.handle((IJavaElement)var, var.getElementName(), var.getTypeSignature(), event, parent);
    }

    private ExtdocProvider.Status handle(IJavaElement variable, String elementName, String typeSignature, JavaSelectionEvent event, Composite parent) {
        Optional opt = event.getSelectedNode();
        if (!opt.isPresent()) {
            return ExtdocProvider.Status.NOT_AVAILABLE;
        }
        Optional<IType> varType = this.findVariableType(typeSignature, variable);
        if (!varType.isPresent()) {
            return ExtdocProvider.Status.NOT_AVAILABLE;
        }
        this.receiverType = (IType)varType.get();
        if (!this.acquireModel()) {
            return ExtdocProvider.Status.NOT_AVAILABLE;
        }
        try {
            ASTNode node = (ASTNode)opt.get();
            Optional<MethodDeclaration> optAstMethod = this.findEnclosingMethod(node);
            Optional optJdtMethod = JdtUtils.resolveMethod((MethodDeclaration)((MethodDeclaration)optAstMethod.orNull()));
            if (!optJdtMethod.isPresent()) {
                ExtdocProvider.Status status = ExtdocProvider.Status.NOT_AVAILABLE;
                return status;
            }
            AstBasedObjectUsageResolver r = new AstBasedObjectUsageResolver();
            ObjectUsage usage = r.findObjectUsage(variable.getElementName(), (MethodDeclaration)optAstMethod.get());
            IMethod first = JdtUtils.findFirstDeclaration((IMethod)((IMethod)optJdtMethod.get()));
            usage.contextFirst = (IMethodName)this.jdtResolver.toRecMethod(first).or((Object)VmMethodName.NULL);
            if (usage.kind == DefinitionSite.Kind.PARAMETER) {
                usage.definition = usage.contextFirst;
            }
            this.model.setQuery(usage);
            SortedSet<Tuple<IMethodName, Double>> methodCalls = this.model.getRecommendedMethodCalls(0.05);
            IMethodName ctx = this.model.getActiveContext();
            IMethodName def = this.model.getActiveDefinition();
            DefinitionSite.Kind kind = this.model.getActiveKind();
            Set<IMethodName> calls = this.model.getActiveCalls();
            this.runSyncInUiThread(new CallRecommendationsRenderer(ctx, methodCalls, calls, variable.getElementName(), def, kind, parent));
        }
        finally {
            this.releaseModel();
        }
        return ExtdocProvider.Status.OK;
    }

    private Optional<IType> findVariableType(String typeSignature, IJavaElement parent) {
        Optional varType = JdtUtils.findTypeFromSignature((String)typeSignature, (IJavaElement)parent);
        return varType;
    }

    private Optional<MethodDeclaration> findEnclosingMethod(ASTNode node) {
        MethodDeclaration declaringNode = null;
        ASTNode p = node;
        while (p != null) {
            if (p instanceof MethodDeclaration) {
                declaringNode = (MethodDeclaration)p;
                break;
            }
            p = p.getParent();
        }
        return Optional.fromNullable(declaringNode);
    }

    private boolean acquireModel() {
        this.model = (IObjectMethodCallsNet)this.modelStore.aquireModel((Object)this.receiverType).orNull();
        return this.model != null;
    }

    private void releaseModel() {
        if (this.model != null) {
            this.modelStore.releaseModel((Object)this.model);
            this.model = null;
        }
    }

    private final class CallRecommendationsRenderer
    implements Runnable {
        private final IMethodName ctx;
        private final Collection<Tuple<IMethodName, Double>> methodCalls;
        private final Set<IMethodName> calls;
        private final String varName;
        private final IMethodName def;
        private final DefinitionSite.Kind kind;
        private final Composite parent;

        private CallRecommendationsRenderer(IMethodName ctx, Collection<Tuple<IMethodName, Double>> methodCalls, Set<IMethodName> calls, String varName, IMethodName def, DefinitionSite.Kind kind, Composite parent) {
            this.ctx = ctx;
            this.methodCalls = methodCalls;
            this.calls = calls;
            this.varName = varName;
            this.def = def;
            this.kind = kind;
            this.parent = parent;
        }

        @Override
        public void run() {
            Composite container = ExtdocUtils.createComposite((Composite)this.parent, (int)4);
            Label preamble2 = new Label(container, 0);
            preamble2.setLayoutData((Object)GridDataFactory.swtDefaults().span(4, 1).indent(0, 0).create());
            if (this.methodCalls.isEmpty()) {
                preamble2.setText(String.format("For %s %s no recommendations are made.", CallsProvider.this.receiverType.getElementName(), this.varName));
            } else {
                preamble2.setText(String.format("For %s %s the following recommendations are made.\nIf you want to invoke a method on %s, then you...", CallsProvider.this.receiverType.getElementName(), this.varName, this.varName));
            }
            new Label(container, 0).setLayoutData((Object)GridDataFactory.swtDefaults().span(4, 1).indent(0, 0).hint(-1, 1).create());
            for (Tuple<IMethodName, Double> rec : this.methodCalls) {
                int percentage = (int)Math.rint((Double)rec.getSecond() * 100.0);
                ExtdocUtils.createLabel((Composite)container, (String)ExtdocUtils.percentageToRecommendationPhrase((int)percentage), (boolean)true, (boolean)false, (int)2, (boolean)false);
                ExtdocUtils.createLabel((Composite)container, (String)"call", (boolean)false);
                this.createMethodLink(container, (IMethodName)rec.getFirst());
                ExtdocUtils.createLabel((Composite)container, (String)(" - " + percentage + "%"), (boolean)false);
            }
            new Label(container, 258);
            ExtdocUtils.createLabel((Composite)container, (String)"", (boolean)false);
            ExtdocUtils.createLabel((Composite)container, (String)"", (boolean)false);
            ExtdocUtils.createLabel((Composite)container, (String)"", (boolean)false);
            Label preamble = new Label(container, 0);
            preamble.setLayoutData((Object)GridDataFactory.swtDefaults().span(4, 1).indent(0, 5).create());
            String text = String.format("Proposals were computed based on variable type '%s' in '%s'.", CallsProvider.this.receiverType.getElementName(), this.ctx == VmMethodName.NULL ? "untrained context" : String.valueOf(Names.vm2srcSimpleTypeName((ITypeName)this.ctx.getDeclaringType())) + "." + Names.vm2srcSimpleMethod((IMethodName)this.ctx));
            preamble.setText(text);
            new Label(container, 0).setLayoutData((Object)GridDataFactory.swtDefaults().span(4, 1).indent(0, 5).hint(-1, 1).create());
            if (this.def != null) {
                ExtdocUtils.createLabel((Composite)container, (String)"defined by", (boolean)true, (boolean)false, (int)16, (boolean)false);
                ExtdocUtils.createLabel((Composite)container, (String)"", (boolean)false, (boolean)false, (int)16, (boolean)false);
                if (this.def == VmMethodName.NULL) {
                    ExtdocUtils.createLabel((Composite)container, (String)"untrained definition", (boolean)false, (boolean)false, (int)16, (boolean)false);
                } else {
                    this.createMethodLink(container, this.def);
                }
                ExtdocUtils.createLabel((Composite)container, (String)("- " + this.kind.toString().toLowerCase()), (boolean)true, (boolean)false, (int)16, (boolean)false);
            }
            for (IMethodName observedCall : this.calls) {
                ExtdocUtils.createLabel((Composite)container, (String)"observed", (boolean)true, (boolean)false, (int)16, (boolean)false);
                ExtdocUtils.createLabel((Composite)container, (String)" call", (boolean)false, (boolean)false, (int)16, (boolean)false);
                this.createMethodLink(container, observedCall);
                ExtdocUtils.createLabel((Composite)container, (String)"", (boolean)true, (boolean)false, (int)16, (boolean)false);
            }
        }

        Link createMethodLink(Composite parent, final IMethodName method) {
            String text = "<a>" + (method.isInit() ? "new " : "") + Names.vm2srcSimpleMethod((IMethodName)method) + "</a>";
            String tooltip = Names.vm2srcQualifiedMethod((IMethodName)method);
            final Link link = new Link(parent, 0);
            link.setText(text);
            link.setBackground(ExtdocUtils.createColor((int)29));
            link.setToolTipText(tooltip);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Optional opt = CallsProvider.this.jdtResolver.toJdtMethod(method);
                    if (opt.isPresent()) {
                        JavaSelectionEvent event = new JavaSelectionEvent((IJavaElement)opt.get(), JavaSelectionEvent.JavaSelectionLocation.METHOD_DECLARATION);
                        CallsProvider.this.workspaceBus.post((Object)event);
                    } else {
                        link.setEnabled(false);
                    }
                }
            });
            return link;
        }
    }
}

