/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.chain;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnMemberAccess;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnQualifiedNameReference;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContextFactory;
import org.eclipse.recommenders.internal.completion.rcp.DisableContentAssistCategoryJob;
import org.eclipse.recommenders.internal.completion.rcp.chain.ChainCompletionModule;
import org.eclipse.recommenders.internal.completion.rcp.chain.ChainCompletionProposal;
import org.eclipse.recommenders.internal.completion.rcp.chain.CompletionTemplateBuilder;
import org.eclipse.recommenders.internal.completion.rcp.chain.GraphBuilder;
import org.eclipse.recommenders.internal.completion.rcp.chain.MemberEdge;
import org.eclipse.recommenders.utils.rcp.JdtUtils;
import org.eclipse.recommenders.utils.rcp.internal.RecommendersUtilsPlugin;

public class ChainCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    static final String CATEGORY_ID = "org.eclipse.recommenders.completion.rcp.chain.category";
    private IRecommendersCompletionContext ctx;
    private IType expectedType;
    private List<MemberEdge> entrypoints;
    private String error;
    private final IRecommendersCompletionContextFactory ctxFactory;
    private final IPreferenceStore prefStore;

    @Inject
    public ChainCompletionProposalComputer(IRecommendersCompletionContextFactory ctxFactory, @ChainCompletionModule.ChainCompletion IPreferenceStore preferenceStore) {
        this.ctxFactory = ctxFactory;
        this.prefStore = preferenceStore;
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (!this.shouldMakeProposals()) {
            return Collections.emptyList();
        }
        this.initalizeContexts(context);
        if (!this.allRequiredContextsAvailable()) {
            return Collections.emptyList();
        }
        if (!this.findExpectedType()) {
            return Collections.emptyList();
        }
        if (!this.findEntrypoints()) {
            return Collections.emptyList();
        }
        try {
            return this.executeCallChainSearch();
        }
        catch (Exception e) {
            this.logError(e);
            return Collections.emptyList();
        }
    }

    @VisibleForTesting
    protected boolean shouldMakeProposals() {
        Object[] excluded = PreferenceConstants.getExcludedCompletionProposalCategories();
        HashSet ex = Sets.newHashSet((Object[])excluded);
        if (!ex.contains(CATEGORY_ID)) {
            new DisableContentAssistCategoryJob(CATEGORY_ID).schedule();
            return false;
        }
        return true;
    }

    private void initalizeContexts(ContentAssistInvocationContext context) {
        this.ctx = this.ctxFactory.create((JavaContentAssistInvocationContext)context);
    }

    private boolean allRequiredContextsAvailable() {
        return this.ctx != null;
    }

    private boolean findExpectedType() {
        this.expectedType = (IType)this.ctx.getExpectedType().orNull();
        if (this.expectedType == null) {
            return false;
        }
        String[] excludedTypes = this.prefStore.getString("recommenders.chain.ignore_types").split("\\|");
        String fullyQualified = this.expectedType.getFullyQualifiedName();
        String[] stringArray = excludedTypes;
        int n = excludedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String excludedType = stringArray[n2];
            if (excludedType.equals(fullyQualified)) {
                this.expectedType = null;
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean findEntrypoints() {
        this.entrypoints = new LinkedList<MemberEdge>();
        ASTNode node = this.ctx.getCompletionNode();
        if (node instanceof CompletionOnQualifiedNameReference) {
            this.findEntrypointsForCompletionOnQualifiedName((CompletionOnQualifiedNameReference)node);
        } else if (node instanceof CompletionOnMemberAccess) {
            this.findEntrypointsForCompletionOnMemberAccess((CompletionOnMemberAccess)node);
        } else if (node instanceof CompletionOnSingleNameReference) {
            this.findEntrypointsForCompletionOnSingleName();
        }
        return !this.entrypoints.isEmpty();
    }

    private void findEntrypointsForCompletionOnQualifiedName(CompletionOnQualifiedNameReference node) {
        Binding b = node.binding;
        if (b == null) {
            return;
        }
        switch (b.kind()) {
            case 4: {
                Optional type = JdtUtils.createUnresolvedType((TypeBinding)((TypeBinding)b));
                if (!type.isPresent()) break;
                this.addPublicStaticMembersToEntrypoints((IType)type.get());
                break;
            }
            case 1: {
                Optional optType;
                Optional field = JdtUtils.createUnresolvedField((FieldBinding)((FieldBinding)b));
                if (!field.isPresent() || !(optType = JdtUtils.findTypeOfField((IField)((IField)field.get()))).isPresent()) break;
                this.addPublicInstanceMembersToEntrypoints((IType)optType.get());
                break;
            }
            case 2: {
                ILocalVariable var = JdtUtils.createUnresolvedLocaVariable((VariableBinding)((VariableBinding)b), (JavaElement)this.findEnclosingElement());
                this.addPublicInstanceMembersToEntrypoints(var);
            }
        }
    }

    private void addPublicStaticMembersToEntrypoints(IType type) {
        for (IMember m : JdtUtils.findAllPublicStaticFieldsAndNonVoidNonPrimitiveStaticMethods((IType)type)) {
            if (!this.matchesExpectedPrefix(m)) continue;
            MemberEdge edge = new MemberEdge((IJavaElement)m);
            this.entrypoints.add(edge);
        }
    }

    private boolean matchesExpectedPrefix(IMember m) {
        return m.getElementName().startsWith(this.ctx.getPrefix());
    }

    private JavaElement findEnclosingElement() {
        return (JavaElement)this.ctx.getEnclosingElement().get();
    }

    private void addPublicInstanceMembersToEntrypoints(ILocalVariable var) {
        Optional optType = JdtUtils.findTypeFromSignature((String)var.getTypeSignature(), (IJavaElement)var);
        if (!optType.isPresent()) {
            return;
        }
        this.addPublicInstanceMembersToEntrypoints((IType)optType.get());
    }

    private void addPublicInstanceMembersToEntrypoints(IType type) {
        for (IMember m : JdtUtils.findAllPublicInstanceFieldsAndNonVoidNonPrimitiveInstanceMethods((IType)type)) {
            if (!this.matchesExpectedPrefix(m)) continue;
            this.entrypoints.add(new MemberEdge((IJavaElement)m));
        }
    }

    private void findEntrypointsForCompletionOnMemberAccess(CompletionOnMemberAccess node) {
        TypeBinding b = node.actualReceiverType;
        if (b == null) {
            return;
        }
        switch (b.kind()) {
            case 4: {
                Optional type = JdtUtils.createUnresolvedType((TypeBinding)b);
                if (!type.isPresent()) break;
                this.addPublicInstanceMembersToEntrypoints((IType)type.get());
                break;
            }
            case 2: {
                ILocalVariable var = JdtUtils.createUnresolvedLocaVariable((VariableBinding)((VariableBinding)b), (JavaElement)this.findEnclosingElement());
                this.addPublicInstanceMembersToEntrypoints(var);
            }
        }
    }

    private void findEntrypointsForCompletionOnSingleName() {
        this.resolveEntrypoints(this.ctx.getVisibleFields());
        this.resolveEntrypoints(this.ctx.getVisibleLocals());
        this.resolveEntrypoints(this.ctx.getVisibleMethods());
    }

    private void resolveEntrypoints(Collection<? extends IJavaElement> elements) {
        for (IJavaElement iJavaElement : elements) {
            MemberEdge e;
            if (!this.matchesPrefixToken(iJavaElement) || !(e = new MemberEdge(iJavaElement)).getReturnType().isPresent()) continue;
            this.entrypoints.add(e);
        }
    }

    private boolean matchesPrefixToken(IJavaElement decl) {
        return decl.getElementName().startsWith(this.ctx.getPrefix());
    }

    private List<ICompletionProposal> executeCallChainSearch() throws JavaModelException {
        final GraphBuilder b = new GraphBuilder();
        final int expectedDimension = Signature.getArrayCount((char[])((String)this.ctx.getExpectedTypeSignature().get()).toCharArray());
        try {
            new SimpleTimeLimiter().callWithTimeout((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    b.startChainSearch((IJavaElement)ChainCompletionProposalComputer.this.findEnclosingElement(), ChainCompletionProposalComputer.this.entrypoints, ChainCompletionProposalComputer.this.expectedType, expectedDimension, ChainCompletionProposalComputer.this.prefStore.getInt("recommenders.chain.max_chains"), ChainCompletionProposalComputer.this.prefStore.getInt("recommenders.chain.max_chain_length"));
                    return null;
                }
            }, (long)this.prefStore.getInt("recommenders.chain.timeout"), TimeUnit.SECONDS, true);
        }
        catch (Exception exception) {
            this.setError("Timeout limit hit during call chain computation.");
        }
        return this.buildCompletionProposals(b.getChains(), expectedDimension);
    }

    private List<ICompletionProposal> buildCompletionProposals(List<List<MemberEdge>> chains, int expectedDimension) {
        LinkedList proposals = Lists.newLinkedList();
        for (List<MemberEdge> chain : chains) {
            TemplateProposal completion = new CompletionTemplateBuilder().create(chain, expectedDimension, this.ctx.getJavaContext());
            ChainCompletionProposal completionProposal = new ChainCompletionProposal(completion, chain);
            proposals.add(completionProposal);
        }
        return proposals;
    }

    private void setError(String errorMessage) {
        this.error = errorMessage;
    }

    private void logError(Exception e) {
        RecommendersUtilsPlugin.logError((Exception)e, (String)"Chain completion failed in %s.", (Object[])new Object[]{this.ctx.getCompilationUnit().getElementName()});
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public void sessionStarted() {
        this.setError(null);
    }

    public String getErrorMessage() {
        return this.error;
    }

    public void sessionEnded() {
    }
}

