/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.chain;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.recommenders.internal.completion.rcp.chain.MemberEdge;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.rcp.JdtUtils;
import org.eclipse.recommenders.utils.rcp.internal.RecommendersUtilsPlugin;

public class GraphBuilder {
    private static final Predicate<IField> FILTER_FIELDS = new Predicate<IField>(){

        public boolean apply(IField m) {
            try {
                return JdtFlags.isStatic((IMember)m);
            }
            catch (Exception exception) {
                return true;
            }
        }
    };
    private static final Predicate<IMethod> FILTER_METHODS = new Predicate<IMethod>(){

        public boolean apply(IMethod m) {
            block3: {
                try {
                    if (!JdtUtils.isVoid((IMethod)m) && !m.isConstructor() && !JdtFlags.isStatic((IMember)m) && !JdtUtils.hasPrimitiveReturnType((IMethod)m)) break block3;
                    return true;
                }
                catch (Exception exception) {
                    return true;
                }
            }
            return m.getElementName().equals("toString") && m.getSignature().equals("()java.lang.String;");
        }
    };
    private final List<List<MemberEdge>> chains = Lists.newLinkedList();
    private final Map<IJavaElement, MemberEdge> edgeCache = Maps.newHashMap();
    private final Map<IType, Collection<IMember>> fieldsAndMethodsCache = Maps.newHashMap();
    private final Table<MemberEdge, IType, Boolean> assignableCache = HashBasedTable.create();

    void startChainSearch(IJavaElement enclosingElement, List<MemberEdge> entrypoints, IType expectedType, int expectedDimension, int maxChains, int maxDepth) {
        LinkedList<LinkedList<MemberEdge>> incompleteChains = GraphBuilder.prepareQueue(entrypoints);
        IType enclosingType = (IType)enclosingElement.getAncestor(7);
        while (!incompleteChains.isEmpty()) {
            LinkedList<MemberEdge> chain = incompleteChains.poll();
            MemberEdge edge = chain.getLast();
            Optional<IType> returnTypeOpt = edge.getReturnType();
            if (!returnTypeOpt.isPresent()) continue;
            if (this.isAssignableTo(edge, expectedType, expectedDimension)) {
                if (chain.size() <= 1) continue;
                this.chains.add(chain);
                if (this.chains.size() != maxChains) continue;
                break;
            }
            if (chain.size() >= maxDepth) continue;
            Collection<IMember> allMethodsAndFields = this.findAllFieldsAndMethods((IType)returnTypeOpt.get(), enclosingType);
            for (IJavaElement iJavaElement : allMethodsAndFields) {
                MemberEdge newEdge = this.createEdge(iJavaElement);
                if (chain.contains(newEdge)) continue;
                incompleteChains.add(GraphBuilder.cloneChainAndAppend(chain, newEdge));
            }
        }
    }

    public List<List<MemberEdge>> getChains() {
        return this.chains;
    }

    private static LinkedList<LinkedList<MemberEdge>> prepareQueue(List<MemberEdge> entrypoints) {
        LinkedList incompleteChains = Lists.newLinkedList();
        for (MemberEdge entrypoint : entrypoints) {
            LinkedList chain = Lists.newLinkedList();
            chain.add(entrypoint);
            incompleteChains.add(chain);
        }
        return incompleteChains;
    }

    private boolean isAssignableTo(MemberEdge edge, IType expectedType, int expectedDimension) {
        Boolean isAssignable = (Boolean)this.assignableCache.get((Object)edge, (Object)expectedType);
        if (isAssignable == null) {
            isAssignable = expectedDimension <= edge.getDimension() && JdtUtils.isAssignable((IType)expectedType, (IType)((IType)edge.getReturnType().get()));
            this.assignableCache.put((Object)edge, (Object)expectedType, (Object)isAssignable);
        }
        return isAssignable;
    }

    private Collection<IMember> findAllFieldsAndMethods(IType chainElementType, IType contextEnclosingType) {
        LinkedList cached = this.fieldsAndMethodsCache.get(chainElementType);
        if (cached == null) {
            cached = Lists.newLinkedList();
            boolean isEverythingVisible = GraphBuilder.isVisibleFromCompletionContext(contextEnclosingType, chainElementType);
            for (IMember element : JdtUtils.findAllRelevanFieldsAndMethods((IType)chainElementType, FILTER_FIELDS, FILTER_METHODS)) {
                block5: {
                    try {
                        if (!isEverythingVisible && !JdtFlags.isPublic((IMember)element)) {
                        }
                        break block5;
                    }
                    catch (Exception e) {
                        RecommendersUtilsPlugin.logError((Exception)e, (String)"Exception in JDT", (Object[])new Object[0]);
                    }
                    continue;
                }
                cached.add(element);
            }
            this.fieldsAndMethodsCache.put(chainElementType, cached);
        }
        return cached;
    }

    private static boolean isVisibleFromCompletionContext(IType contextEnclosingType, IType element) {
        return contextEnclosingType.equals(element);
    }

    private MemberEdge createEdge(IJavaElement member) {
        MemberEdge cached = this.edgeCache.get(member);
        if (cached == null) {
            cached = new MemberEdge(member);
            this.edgeCache.put(member, cached);
        }
        return cached;
    }

    private static LinkedList<MemberEdge> cloneChainAndAppend(LinkedList<MemberEdge> chain, MemberEdge newEdge) {
        LinkedList chainCopy = (LinkedList)Checks.cast((Object)chain.clone());
        chainCopy.add(newEdge);
        return chainCopy;
    }
}

