/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.overrides;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.recommenders.jayes.inference.junctionTree.JunctionTreeAlgorithm;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Tuple;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmMethodName;

public class ClassOverridesNetwork {
    private final ITypeName typeName;
    private final List<BayesNode> methodNodes;
    private final JunctionTreeAlgorithm junctionTreeAlgorithm;
    private HashMap<IMethodName, BayesNode> methodNameMapping;

    protected ClassOverridesNetwork(ITypeName typeName, BayesNet network, BayesNode patternNode, List<BayesNode> methodNodes) {
        this.typeName = typeName;
        this.methodNodes = methodNodes;
        this.junctionTreeAlgorithm = new JunctionTreeAlgorithm();
        this.junctionTreeAlgorithm.setNetwork(network);
        this.createMethodNameMapping();
    }

    private void createMethodNameMapping() {
        this.methodNameMapping = Maps.newHashMap();
        for (BayesNode methodNode : this.methodNodes) {
            this.methodNameMapping.put((IMethodName)VmMethodName.get((String)methodNode.getName()), methodNode);
        }
    }

    public void clearEvidence() {
        this.junctionTreeAlgorithm.setEvidence(new HashMap());
    }

    public String toString() {
        return String.format("Model for '%s'", this.typeName);
    }

    public void observeMethodNode(IMethodName methodName) {
        BayesNode methodNode = this.methodNameMapping.get(methodName);
        if (methodNode != null) {
            this.junctionTreeAlgorithm.addEvidence(methodNode, "true");
        }
    }

    public SortedSet<Tuple<IMethodName, Double>> getRecommendedMethodOverrides(double minProbability) {
        TreeSet<Tuple<IMethodName, Double>> recommendations = ClassOverridesNetwork.createSortedSetForMethodRecommendations();
        for (BayesNode node : this.methodNodes) {
            double probability;
            if (this.junctionTreeAlgorithm.getEvidence().containsKey(node) || (probability = this.junctionTreeAlgorithm.getBeliefs(node)[0]) < minProbability) continue;
            VmMethodName method = VmMethodName.get((String)node.getName());
            Tuple item = Tuple.newTuple((Object)method, (Object)probability);
            recommendations.add((Tuple<IMethodName, Double>)item);
        }
        return recommendations;
    }

    public SortedSet<Tuple<IMethodName, Double>> getRecommendedMethodOverrides(double minProbabilityThreshold, int maxNumberOfRecommendations) {
        SortedSet<Tuple<IMethodName, Double>> recommendations = this.getRecommendedMethodOverrides(minProbabilityThreshold);
        if (recommendations.size() <= maxNumberOfRecommendations) {
            return recommendations;
        }
        Tuple firstExcludedRecommendation = (Tuple)Iterables.get(recommendations, (int)maxNumberOfRecommendations);
        SortedSet<Tuple<IMethodName, Double>> res = recommendations.headSet((Tuple<IMethodName, Double>)firstExcludedRecommendation);
        Checks.ensureEquals((Object)res.size(), (Object)maxNumberOfRecommendations, (String)"filter op did not return expected number of compilationUnits2recommendationsIndex");
        return res;
    }

    public static TreeSet<Tuple<IMethodName, Double>> createSortedSetForMethodRecommendations() {
        TreeSet res = Sets.newTreeSet((Comparator)new Comparator<Tuple<IMethodName, Double>>(){

            @Override
            public int compare(Tuple<IMethodName, Double> o1, Tuple<IMethodName, Double> o2) {
                int probabilityCompare = Double.compare((Double)o2.getSecond(), (Double)o1.getSecond());
                return probabilityCompare != 0 ? probabilityCompare : ((IMethodName)o1.getFirst()).compareTo((Object)((IMethodName)o2.getFirst()));
            }
        });
        return res;
    }
}

