/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.subwords;

import java.util.Set;
import org.eclipse.recommenders.internal.completion.rcp.subwords.SubwordsCompletionProposalComputer;
import org.eclipse.recommenders.internal.completion.rcp.subwords.SubwordsUtils;
import org.eclipse.recommenders.utils.rcp.internal.ContentAssistEnablementBlock;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class PreferencePage
extends org.eclipse.jface.preference.PreferencePage
implements IWorkbenchPreferencePage {
    private ContentAssistEnablementBlock enablement;

    public PreferencePage() {
        this.setDescription("Subwords is a new experimental content assist for Java. It uses 'fuzzy word matching' which allows you to specify just a subsequence of the proposal's text you want to insert.\n\nNote that Subwords essentially makes the same proposals as the standard Java content assist, and thus, will automatically disabled itself when either JDT or Mylyn completion is active to avoid duplicated proposals. The button below is a shortcut for enabling Subwords and disabling standard Java and Mylyn content assist (and reverse).");
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        Link link = new Link(container, 64);
        link.setText("See <a>'Java > Editor > Content Assist > Advanced'</a> to configure content assist directly.");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)PreferencePage.this.getShell(), (String)"org.eclipse.jdt.ui.preferences.CodeAssistPreferenceAdvanced", null, null);
            }
        });
        this.enablement = new ContentAssistEnablementBlock(container, "Enable Java Subwords Proposals.", SubwordsCompletionProposalComputer.CATEGORY_ID){

            protected void additionalExcludedCompletionCategoriesUpdates(boolean isEnabled, Set<String> cats) {
                if (isEnabled) {
                    cats.add("org.eclipse.jdt.ui.javaAllProposalCategory");
                    cats.add("org.eclipse.mylyn.java.ui.javaAllProposalCategory");
                } else if (SubwordsUtils.isMylynInstalled()) {
                    cats.remove("org.eclipse.mylyn.java.ui.javaAllProposalCategory");
                } else {
                    cats.remove("org.eclipse.jdt.ui.javaAllProposalCategory");
                }
            }
        };
        return container;
    }

    public void init(IWorkbench workbench) {
    }

    public void setVisible(boolean visible) {
        this.enablement.loadSelection();
        super.setVisible(visible);
    }
}

