/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.subwords;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.recommenders.internal.completion.rcp.subwords.DisableContentAssistCategoryJob;
import org.eclipse.recommenders.internal.completion.rcp.subwords.SubwordsCompletionRequestor;
import org.eclipse.recommenders.internal.completion.rcp.subwords.SubwordsUtils;
import org.eclipse.recommenders.internal.completion.rcp.subwords.TimeDelimitedProgressMonitor;
import org.eclipse.recommenders.utils.rcp.internal.RecommendersUtilsPlugin;
import org.eclipse.swt.graphics.Point;

public class SubwordsCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    private static final int TIMEOUT = 8000;
    public static String CATEGORY_ID = "org.eclipse.recommenders.subwords.rcp.category";
    private JavaContentAssistInvocationContext ctx;

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        this.ctx = (JavaContentAssistInvocationContext)context;
        if (!this.shouldReturnResults()) {
            return Collections.emptyList();
        }
        return this.findSubwordMatchingProposals(new TimeDelimitedProgressMonitor(monitor, 8000));
    }

    @VisibleForTesting
    protected boolean shouldReturnResults() {
        HashSet cats = Sets.newHashSet((Object[])PreferenceConstants.getExcludedCompletionProposalCategories());
        if (cats.contains(CATEGORY_ID)) {
            return true;
        }
        if (this.isJdtAllEnabled(cats) || this.isMylynInstalledAndEnabled(cats)) {
            new DisableContentAssistCategoryJob(CATEGORY_ID).schedule(300L);
            return false;
        }
        return true;
    }

    private boolean isMylynInstalledAndEnabled(Set<String> cats) {
        return SubwordsUtils.isMylynInstalled() && !cats.contains("org.eclipse.mylyn.java.ui.javaAllProposalCategory");
    }

    private boolean isJdtAllEnabled(Set<String> cats) {
        return !cats.contains("org.eclipse.jdt.ui.javaAllProposalCategory");
    }

    private String getToken() {
        char[] token = this.ctx.getCoreContext().getToken();
        if (token == null) {
            return "";
        }
        return String.valueOf(token);
    }

    private List<IJavaCompletionProposal> findSubwordMatchingProposals(IProgressMonitor monitor) {
        String token = this.getToken();
        SubwordsCompletionRequestor requestor = new SubwordsCompletionRequestor(token, this.ctx);
        ITextViewer viewer = this.ctx.getViewer();
        Point selection = viewer.getSelectedRange();
        if (selection.y > 0) {
            requestor.setReplacementLength(selection.y);
        }
        ICompilationUnit cu = this.ctx.getCompilationUnit();
        int offsetBeforeTokenBegin = this.ctx.getInvocationOffset() - token.length();
        try {
            cu.codeComplete(this.ctx.getInvocationOffset(), (CompletionRequestor)requestor, monitor);
            if (token.length() > 0) {
                cu.codeComplete(offsetBeforeTokenBegin, (CompletionRequestor)requestor, monitor);
            }
        }
        catch (Exception e) {
            RecommendersUtilsPlugin.logWarning((Exception)e, (String)"Exception while computing completions: %s", (Object[])new Object[]{e.getMessage()});
        }
        return requestor.getProposals();
    }

    public void sessionStarted() {
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }
}

