/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.extdoc.rcp.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.recommenders.extdoc.rcp.providers.ExtdocProvider;
import org.eclipse.recommenders.utils.Throws;
import org.osgi.service.prefs.BackingStoreException;

public class PreferencesFacade {
    private final IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.recommenders.extdoc.rcp");
    private static final String PROVIDER_NAMES = "providerNames";
    private static final String DISABLED_PROVIDERS = "disabledProviders";
    private static final String SASH_WEIGHTS = "sashWeights";

    public void storeOrderedProviders(List<ExtdocProvider> providers) {
        String[] providerNames = PreferencesFacade.getProviderNames(providers);
        String toSave = this.createString(providerNames);
        this.preferences.put(PROVIDER_NAMES, toSave);
        this.flush();
    }

    private static String[] getProviderNames(List<ExtdocProvider> providers) {
        String[] names = new String[providers.size()];
        int i = 0;
        for (ExtdocProvider p : providers) {
            names[i] = p.getDescription().getName();
            ++i;
        }
        return names;
    }

    private String createString(String[] names) {
        if (names.length > 0) {
            String out = "";
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                out = String.valueOf(out) + "," + name;
                ++n2;
            }
            return out.substring(1);
        }
        return "";
    }

    public String[] loadOrderedProviderNames() {
        String orderedNameString = this.preferences.get(PROVIDER_NAMES, "");
        String[] orderedNames = orderedNameString.split(",");
        return orderedNames;
    }

    public boolean isProviderEnabled(ExtdocProvider p) {
        String arrayString = this.preferences.get(DISABLED_PROVIDERS, "");
        String[] deactivatedProviders = arrayString.split(",");
        String providerName = p.getDescription().getName();
        String[] stringArray = deactivatedProviders;
        int n = deactivatedProviders.length;
        int n2 = 0;
        while (n2 < n) {
            String deactivatedName = stringArray[n2];
            if (deactivatedName.equals(providerName)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void storeProviderEnablement(List<ExtdocProvider> providers) {
        String[] disabledProviderNames = this.getDisabledProviderNames(providers);
        String toSave = this.createString(disabledProviderNames);
        this.preferences.put(DISABLED_PROVIDERS, toSave);
        this.flush();
    }

    private String[] getDisabledProviderNames(List<ExtdocProvider> providers) {
        ArrayList<String> disabledProviders = new ArrayList<String>();
        for (ExtdocProvider p : providers) {
            if (p.isEnabled()) continue;
            disabledProviders.add(p.getDescription().getName());
        }
        return disabledProviders.toArray(new String[0]);
    }

    public int[] loadSashWeights() {
        String weightString = this.preferences.get(SASH_WEIGHTS, "1,3");
        String[] weights = weightString.split(",");
        return new int[]{Integer.parseInt(weights[0]), Integer.parseInt(weights[1])};
    }

    public void storeSashWeights(int[] weights) {
        String toSave = String.valueOf(weights[0]) + "," + weights[1];
        this.preferences.put(SASH_WEIGHTS, toSave);
        this.flush();
    }

    private void flush() {
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            Throws.throwUnhandledException((Exception)((Object)e));
        }
    }
}

