/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp.repo;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Response;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.repository.internal.DefaultServiceLocator;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.recommenders.internal.rcp.repo.ManualWagonProvider;
import org.eclipse.recommenders.internal.rcp.repo.TransferListener;
import org.eclipse.recommenders.internal.rcp.wiring.RecommendersModule;
import org.eclipse.recommenders.rcp.repo.IModelRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.AbstractRepositoryListener;
import org.sonatype.aether.RepositoryEvent;
import org.sonatype.aether.RepositoryListener;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.DependencyCollectionContext;
import org.sonatype.aether.collection.DependencySelector;
import org.sonatype.aether.connector.file.FileRepositoryConnectorFactory;
import org.sonatype.aether.connector.wagon.WagonProvider;
import org.sonatype.aether.connector.wagon.WagonRepositoryConnectorFactory;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.installation.InstallRequest;
import org.sonatype.aether.installation.InstallationException;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.DependencyRequest;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.resolution.VersionRangeRequest;
import org.sonatype.aether.resolution.VersionRangeResult;
import org.sonatype.aether.spi.connector.RepositoryConnectorFactory;
import org.sonatype.aether.util.DefaultRepositorySystemSession;
import org.sonatype.aether.version.Version;

@Singleton
public class ModelRepository
implements IModelRepository {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private AsyncHttpClient http = new AsyncHttpClient();
    private final File location;
    private RepositorySystem system;
    private RemoteRepository remote;
    private IProxyService proxy;

    @Inject
    public ModelRepository(@RecommendersModule.LocalModelRepositoryLocation File localLocation, @RecommendersModule.RemoteModelRepositoryLocation String remoteLocation, IProxyService proxy) throws Exception {
        this.location = localLocation;
        this.proxy = proxy;
        this.system = this.createRepositorySystem();
        this.setRemote(remoteLocation);
    }

    public ModelRepository(@RecommendersModule.LocalModelRepositoryLocation File localLocation, @RecommendersModule.RemoteModelRepositoryLocation String remoteLocation) throws Exception {
        this(localLocation, remoteLocation, null);
    }

    protected RepositorySystem createRepositorySystem() throws Exception {
        DefaultServiceLocator locator = new DefaultServiceLocator();
        locator.setServices(WagonProvider.class, (Object[])new WagonProvider[]{new ManualWagonProvider()});
        locator.addService(RepositoryConnectorFactory.class, WagonRepositoryConnectorFactory.class);
        locator.addService(RepositoryConnectorFactory.class, FileRepositoryConnectorFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    private DefaultRepositorySystemSession newSession() {
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        LocalRepository localRepo = new LocalRepository(this.location);
        session.setLocalRepositoryManager(this.system.newLocalRepositoryManager(localRepo));
        return session;
    }

    @Override
    public boolean isLatest(Artifact artifact) {
        Optional<String> remoteEtag = this.remoteEtag(artifact);
        Optional<String> localEtag = this.localEtag(artifact);
        return remoteEtag.equals(localEtag);
    }

    @VisibleForTesting
    public Optional<String> remoteEtag(Artifact artifact) {
        try {
            String remoteBaseurl = StringUtils.removeEnd((String)this.remote.getUrl(), (String)"/");
            String url = String.format("%1$s/%2$s", remoteBaseurl, this.computePath(artifact));
            if (url.startsWith("file:")) {
                File file = new File(new URI(url));
                if (file.exists()) {
                    return Optional.of((Object)String.valueOf(file.lastModified()));
                }
                return Optional.absent();
            }
            Response r = (Response)this.http.prepareHead(url).execute().get();
            String header = r.getHeader("ETag");
            if (StringUtils.isNotEmpty((CharSequence)header)) {
                header = StringUtils.remove((String)header, (String)"\"");
                return Optional.of((Object)header);
            }
        }
        catch (Exception e) {
            this.log.debug(e.getMessage());
        }
        this.log.warn("'{}' did not send ETAG header for '{}'.", (Object)this.remote, (Object)artifact);
        return Optional.absent();
    }

    private Optional<String> localEtag(Artifact artifact) {
        try {
            File local = this.etagFile(artifact);
            if (!local.exists()) {
                return Optional.absent();
            }
            String line = Files.readFirstLine((File)local, (Charset)Charset.defaultCharset());
            if (line != null && !line.isEmpty()) {
                return Optional.of((Object)line);
            }
        }
        catch (Exception exception) {}
        return Optional.absent();
    }

    private File etagFile(Artifact artifact) {
        return new File(String.valueOf(this.location(artifact).getAbsolutePath()) + ".etag");
    }

    @Override
    public File location(Artifact artifact) {
        return new File(this.location, this.computePath(artifact));
    }

    private String computePath(Artifact artifact) {
        String groupId = artifact.getGroupId().replace('.', '/');
        String artifactId = artifact.getArtifactId();
        String version = artifact.getVersion();
        String classifier = artifact.getClassifier();
        String extension = artifact.getExtension();
        StringBuilder sb = new StringBuilder();
        sb.append(groupId).append('/').append(artifactId).append('/').append(version).append('/').append(artifactId).append('-').append(version);
        if (!StringUtils.isEmpty((CharSequence)classifier)) {
            sb.append('-').append(classifier);
        }
        sb.append('.').append(extension);
        return sb.toString();
    }

    @Override
    public void delete(Artifact artifact) {
        File file = this.location(artifact);
        File etag = this.etagFile(artifact);
        file.delete();
        etag.delete();
    }

    @Override
    public synchronized File resolve(Artifact artifact, final IProgressMonitor monitor) throws DependencyResolutionException {
        monitor.subTask("Resolving...");
        DefaultRepositorySystemSession session = this.newSession();
        session.setDependencySelector((DependencySelector)new TheArtifactOnlyDependencySelector());
        session.setTransferListener((org.sonatype.aether.transfer.TransferListener)new TransferListener(monitor));
        session.setRepositoryListener((RepositoryListener)new AbstractRepositoryListener(){

            public void artifactDownloaded(RepositoryEvent event) {
                monitor.subTask("downloaded " + event.getArtifact());
                ModelRepository.this.saveEtag(event.getArtifact());
            }
        });
        Dependency dependency = new Dependency(artifact, "model");
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(dependency);
        collectRequest.addRepository(this.remote);
        DependencyRequest dependencyRequest = new DependencyRequest();
        dependencyRequest.setCollectRequest(collectRequest);
        DependencyNode root = this.system.resolveDependencies((RepositorySystemSession)session, dependencyRequest).getRoot();
        File file = root.getDependency().getArtifact().getFile();
        return file;
    }

    private void saveEtag(Artifact artifact) {
        Optional<String> remoteEtag = this.remoteEtag(artifact);
        if (remoteEtag.isPresent()) {
            File etagFile = this.etagFile(artifact);
            try {
                Files.write((CharSequence)((CharSequence)remoteEtag.get()), (File)etagFile, (Charset)Charset.defaultCharset());
            }
            catch (Exception e) {
                this.log.error("Failed to write etag to file " + etagFile, (Throwable)e);
            }
        }
    }

    @Override
    public void install(Artifact artifact) throws InstallationException {
        DefaultRepositorySystemSession session = this.newSession();
        InstallRequest r = new InstallRequest();
        r.addArtifact(artifact);
        this.system.install((RepositorySystemSession)session, r);
        this.log.info("installed '{}' to {}", (Object)artifact, (Object)this.location);
    }

    public String toString() {
        return this.location.getAbsolutePath();
    }

    @Override
    public Optional<Artifact> findHigestVersion(Artifact artifact) {
        Optional<VersionRangeResult> opt = this.resolveVersionRange(artifact);
        if (!opt.isPresent()) {
            return Optional.absent();
        }
        ArrayList versions = Lists.newArrayList((Iterable)((VersionRangeResult)opt.get()).getVersions());
        Collections.reverse(versions);
        for (Version v : versions) {
            Artifact query = artifact.setVersion(v.toString());
            if (!this.remoteEtag(query).isPresent()) continue;
            return Optional.of((Object)query);
        }
        return Optional.absent();
    }

    private Optional<VersionRangeResult> resolveVersionRange(Artifact a) {
        VersionRangeRequest rangeRequest = new VersionRangeRequest(a, Collections.singletonList(this.remote), a.getClassifier());
        try {
            VersionRangeResult range = this.system.resolveVersionRange((RepositorySystemSession)this.newSession(), rangeRequest);
            return Optional.of((Object)range);
        }
        catch (Exception e) {
            this.log.error("Failed to resolve version range for artifact " + a + ".", (Throwable)e);
            return Optional.absent();
        }
    }

    @Override
    public Optional<Artifact> findLowestVersion(Artifact artifact) {
        Optional<VersionRangeResult> opt = this.resolveVersionRange(artifact);
        if (!opt.isPresent()) {
            return Optional.absent();
        }
        for (Version v : ((VersionRangeResult)opt.get()).getVersions()) {
            Artifact query = artifact.setVersion(v.toString());
            if (!this.remoteEtag(query).isPresent()) continue;
            return Optional.of((Object)query);
        }
        return Optional.absent();
    }

    @Override
    public void setRemote(String url) {
        this.remote = new RemoteRepository("remote-models", "default", url);
        if (this.proxy == null) {
            return;
        }
        URI uri = URI.create(url);
        IProxyData[] iProxyDataArray = this.proxy.select(uri);
        int n = iProxyDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyData data = iProxyDataArray[n2];
            String host = data.getHost();
            if (host != null) {
                String type = data.getType();
                int port = data.getPort();
                String userId = data.getUserId();
                String password = data.getPassword();
                Authentication auth = new Authentication(userId, password);
                Proxy p = new Proxy(type, host, port, auth);
                this.remote.setProxy(p);
            }
            ++n2;
        }
    }

    public String getRemote() {
        return this.remote.getUrl();
    }

    @Override
    public File getLocation() {
        return this.location;
    }

    public static class TheArtifactOnlyDependencySelector
    implements DependencySelector {
        public boolean selectDependency(Dependency d) {
            return false;
        }

        public DependencySelector deriveChildSelector(DependencyCollectionContext c) {
            return this;
        }
    }
}

