/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.gson;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.recommenders.utils.gson.GsonFieldNameDeserializer;
import org.eclipse.recommenders.utils.gson.GsonFileDeserializer;
import org.eclipse.recommenders.utils.gson.GsonFileSerializer;
import org.eclipse.recommenders.utils.gson.GsonMethodNameDeserializer;
import org.eclipse.recommenders.utils.gson.GsonNameSerializer;
import org.eclipse.recommenders.utils.gson.GsonTypeNameDeserializer;
import org.eclipse.recommenders.utils.gson.ISO8601DateParser;
import org.eclipse.recommenders.utils.gson.MultimapTypeAdapter;
import org.eclipse.recommenders.utils.names.IFieldName;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmFieldName;
import org.eclipse.recommenders.utils.names.VmMethodName;
import org.eclipse.recommenders.utils.names.VmTypeName;

public class GsonUtil {
    public static final Type T_LIST_STRING = new TypeToken<List<String>>(){}.getType();
    private static Gson gson;

    public static synchronized Gson getInstance() {
        if (gson == null) {
            GsonBuilder builder = new GsonBuilder();
            builder.registerTypeAdapter(VmMethodName.class, (Object)new GsonNameSerializer());
            builder.registerTypeAdapter(IMethodName.class, (Object)new GsonNameSerializer());
            builder.registerTypeAdapter(VmMethodName.class, (Object)new GsonMethodNameDeserializer());
            builder.registerTypeAdapter(IMethodName.class, (Object)new GsonMethodNameDeserializer());
            builder.registerTypeAdapter(VmTypeName.class, (Object)new GsonNameSerializer());
            builder.registerTypeAdapter(ITypeName.class, (Object)new GsonNameSerializer());
            builder.registerTypeAdapter(VmTypeName.class, (Object)new GsonTypeNameDeserializer());
            builder.registerTypeAdapter(ITypeName.class, (Object)new GsonTypeNameDeserializer());
            builder.registerTypeAdapter(VmFieldName.class, (Object)new GsonNameSerializer());
            builder.registerTypeAdapter(IFieldName.class, (Object)new GsonNameSerializer());
            builder.registerTypeAdapter(VmFieldName.class, (Object)new GsonFieldNameDeserializer());
            builder.registerTypeAdapter(IFieldName.class, (Object)new GsonFieldNameDeserializer());
            builder.registerTypeAdapter(File.class, (Object)new GsonFileDeserializer());
            builder.registerTypeAdapter(File.class, (Object)new GsonFileSerializer());
            builder.setPrettyPrinting();
            builder.registerTypeAdapter(Date.class, (Object)new ISO8601DateParser());
            builder.registerTypeAdapter(Multimap.class, (Object)new MultimapTypeAdapter());
            builder.enableComplexMapKeySerialization();
            gson = builder.create();
        }
        return gson;
    }

    public static <T> T deserialize(CharSequence json, Type classOfT) {
        return GsonUtil.deserialize(json.toString(), classOfT);
    }

    public static <T> T deserialize(String json, Type classOfT) {
        Checks.ensureIsNotNull(json);
        Checks.ensureIsNotNull(classOfT);
        return (T)GsonUtil.getInstance().fromJson(json, classOfT);
    }

    public static <T> T deserialize(InputStream jsonStream, Type classOfT) {
        Checks.ensureIsNotNull(jsonStream);
        Checks.ensureIsNotNull(classOfT);
        InputStreamReader reader = new InputStreamReader(jsonStream);
        Object res = GsonUtil.getInstance().fromJson((Reader)reader, classOfT);
        IOUtils.closeQuietly(reader);
        return (T)res;
    }

    public static <T> T deserialize(File jsonFile, Type classOfT) {
        BufferedInputStream fis;
        Checks.ensureIsNotNull(jsonFile);
        Checks.ensureIsNotNull(classOfT);
        try {
            fis = new BufferedInputStream(new FileInputStream(jsonFile));
        }
        catch (FileNotFoundException e) {
            throw Throws.throwUnhandledException(e, "Unable to deserialize from file " + jsonFile.getAbsolutePath(), new Object[0]);
        }
        return GsonUtil.deserialize(fis, classOfT);
    }

    public static String serialize(Object obj) {
        Checks.ensureIsNotNull(obj);
        StringBuilder sb = new StringBuilder();
        GsonUtil.serialize(obj, sb);
        return sb.toString();
    }

    public static void serialize(Object obj, Appendable writer) {
        Checks.ensureIsNotNull(obj);
        Checks.ensureIsNotNull(writer);
        GsonUtil.getInstance().toJson(obj, writer);
    }

    public static void serialize(Object obj, File dest) {
        block5: {
            Checks.ensureIsNotNull(obj, "object to serialize cannot be null", new Object[0]);
            Checks.ensureIsNotNull(dest, "serialization destination cannot be null", new Object[0]);
            BufferedWriter fw = null;
            try {
                try {
                    fw = new BufferedWriter(new FileWriter(dest));
                    GsonUtil.getInstance().toJson(obj, (Appendable)fw);
                }
                catch (IOException x) {
                    Throws.throwUnhandledException(x);
                    IOUtils.closeQuietly(fw);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fw);
                throw throwable;
            }
            IOUtils.closeQuietly(fw);
        }
    }

    public static <T> List<T> deserializeZip(File zip, Class<T> classOfT) throws IOException {
        LinkedList res = Lists.newLinkedList();
        ZipInputStream zis = null;
        try {
            ZipEntry entry;
            InputSupplier fis = Files.newInputStreamSupplier((File)zip);
            zis = new ZipInputStream((InputStream)fis.getInput());
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                InputStreamReader reader = new InputStreamReader(zis);
                Object data = GsonUtil.getInstance().fromJson((Reader)reader, classOfT);
                res.add(data);
            }
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(zis);
            throw throwable;
        }
        Closeables.closeQuietly((Closeable)zis);
        return res;
    }
}

