/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rtp.httpdeployer.feature;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.rtp.core.RuntimeProvisioningService;
import org.eclipse.rtp.core.model.Feature;
import org.eclipse.rtp.core.model.SourceVersion;
import org.eclipse.rtp.httpdeployer.feature.FeatureInstallException;

public class FeatureManager {
    private RuntimeProvisioningService rtpService;

    public FeatureManager(RuntimeProvisioningService rtpService) {
        this.rtpService = rtpService;
    }

    public void installFeature(String featureId, String version) throws FeatureInstallException {
        Feature feature = new Feature(featureId, version);
        SourceVersion sourceVersion = new SourceVersion();
        sourceVersion.addFeature(feature);
        IStatus result = this.rtpService.install(sourceVersion);
        if (!result.isOK()) {
            throw new FeatureInstallException(result.getMessage());
        }
    }

    public void uninstallFeature(String featureId, String version) throws FeatureInstallException {
        Feature feature = new Feature(featureId, version);
        SourceVersion sourceVersion = new SourceVersion();
        sourceVersion.addFeature(feature);
        ArrayList<SourceVersion> sourceVersionsToUninstall = new ArrayList<SourceVersion>();
        sourceVersionsToUninstall.add(sourceVersion);
        IStatus result = this.rtpService.remove(sourceVersionsToUninstall);
        if (!result.isOK()) {
            throw new FeatureInstallException(result.getMessage());
        }
    }
}

