/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.List;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.util.IdentityCache;
import org.eclipse.sapphire.util.ReadOnlyListFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LayeredListBindingImpl
extends ListBindingImpl {
    private final IdentityCache<Object, Resource> cache = new IdentityCache();

    public final List<Resource> read() {
        this.cache.track();
        ReadOnlyListFactory<Resource> list = ReadOnlyListFactory.create();
        for (Object obj : this.readUnderlyingList()) {
            Resource resource = this.cache.get(obj);
            if (resource == null) {
                resource = this.resource(obj);
                this.cache.put(obj, resource);
            }
            list.add(resource);
        }
        this.cache.purge();
        return list.export();
    }

    protected abstract List<?> readUnderlyingList();

    @Override
    public final Resource insert(ModelElementType type, int position) {
        Object obj = this.insertUnderlyingObject(type, position);
        Resource resource = this.cache.get(obj);
        if (resource == null) {
            resource = this.resource(obj);
            this.cache.put(obj, resource);
        }
        return resource;
    }

    protected Object insertUnderlyingObject(ModelElementType type, int position) {
        throw new UnsupportedOperationException();
    }

    protected abstract Resource resource(Object var1);
}

