/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.util.CollectionsUtil;
import org.eclipse.sapphire.util.ReadOnlyListFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListSelectionService
extends Service {
    private List<IModelElement> elements = Collections.emptyList();

    public List<IModelElement> selection() {
        return this.elements;
    }

    public void select(IModelElement element) {
        List<IModelElement> elements = Collections.singletonList(element);
        if (!CollectionsUtil.equalsBasedOnEntryIdentity(elements, this.elements)) {
            List<IModelElement> before = this.elements;
            this.elements = elements;
            this.broadcast(new ListSelectionChangedEvent(before, this.elements));
        }
    }

    public void select(List<IModelElement> elements) {
        if (!CollectionsUtil.equalsBasedOnEntryIdentity(this.elements, elements)) {
            List<IModelElement> before = this.elements;
            this.elements = ReadOnlyListFactory.create(elements);
            this.broadcast(new ListSelectionChangedEvent(before, this.elements));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ListSelectionChangedEvent
    extends Event {
        private List<IModelElement> before;
        private List<IModelElement> after;

        public ListSelectionChangedEvent(List<IModelElement> before, List<IModelElement> after) {
            this.before = before;
            this.after = after;
        }

        public List<IModelElement> before() {
            return this.before;
        }

        public List<IModelElement> after() {
            return this.after;
        }
    }
}

