/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.Collections;
import java.util.Set;
import org.eclipse.help.IContext;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireComposite;
import org.eclipse.sapphire.ui.SapphireCondition;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireDocumentation;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationDef;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationRef;
import org.eclipse.sapphire.ui.def.ISapphireSectionDef;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.swt.renderer.SapphireKeyboardActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.SapphireToolBarActionPresentation;
import org.eclipse.sapphire.ui.util.SapphireHelpSystem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SapphireSection
extends SapphireComposite {
    private SapphireCondition visibleWhenCondition;
    private Section section;
    private FunctionResult titleFunctionResult;
    private boolean expanded;

    @Override
    protected void init() {
        super.init();
        ISapphireSectionDef def = this.definition();
        this.visibleWhenCondition = null;
        JavaType visibleWhenConditionClass = (JavaType)def.getVisibleWhenConditionClass().resolve();
        if (visibleWhenConditionClass != null) {
            String parameter = def.getVisibleWhenConditionParameter().getText();
            this.visibleWhenCondition = SapphireCondition.create(this, visibleWhenConditionClass.artifact(), parameter);
        }
        this.expanded = (Boolean)def.getCollapsedInitially().getContent() == false;
    }

    @Override
    public ISapphireSectionDef definition() {
        return (ISapphireSectionDef)super.definition();
    }

    @Override
    protected Composite createOuterComposite(SapphireRenderingContext context) {
        FormToolkit toolkit = new FormToolkit(context.getDisplay());
        ISapphireSectionDef def = this.definition();
        Composite outerComposite = new Composite(context.getComposite(), 0);
        outerComposite.setLayoutData(this.createSectionLayoutData());
        outerComposite.setLayout((Layout)GridLayoutUtil.glayout(1, 10, 10, 10, 20));
        context.adapt((Control)outerComposite);
        boolean collapsible = (Boolean)def.getCollapsible().getContent();
        int style = 0x100 | (collapsible ? 2 : 0);
        this.section = toolkit.createSection(outerComposite, style);
        this.section.setLayoutData((Object)GridLayoutUtil.gdfill());
        if (collapsible) {
            this.section.setExpanded(this.expanded);
            this.section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent event) {
                    SapphireSection.this.expanded = event.getState();
                }
            });
        }
        this.titleFunctionResult = this.initExpression(this.getModelElement(), (Function)def.getLabel().getContent(), String.class, null, new Runnable(){

            public void run() {
                SapphireSection.this.refreshTitle();
            }
        });
        this.refreshTitle();
        Composite sectionContentComposite = new Composite((Composite)this.section, 0);
        sectionContentComposite.setLayout((Layout)GridLayoutUtil.glayout(2, 0, 0));
        context.adapt((Control)sectionContentComposite);
        SapphireActionGroup actions = this.getActions();
        SapphireActionPresentationManager actionPresentationManager = new SapphireActionPresentationManager(context, actions);
        SapphireToolBarActionPresentation toolBarActionsPresentation = new SapphireToolBarActionPresentation(actionPresentationManager);
        ToolBar toolbar = new ToolBar((Composite)this.section, 8519936);
        toolBarActionsPresentation.setToolBar(toolbar);
        toolBarActionsPresentation.render();
        this.section.setTextClient((Control)toolbar);
        SapphireKeyboardActionPresentation keyboardActionsPresentation = new SapphireKeyboardActionPresentation(actionPresentationManager);
        keyboardActionsPresentation.attach((Control)toolbar);
        keyboardActionsPresentation.render();
        toolkit.paintBordersFor((Composite)this.section);
        this.section.setClient((Control)sectionContentComposite);
        return sectionContentComposite;
    }

    protected Object createSectionLayoutData() {
        return GridLayoutUtil.gdhspan(this.getScaleVertically() ? GridLayoutUtil.gdfill() : GridLayoutUtil.gdhfill(), 2);
    }

    private void refreshTitle() {
        String title = null;
        if (this.titleFunctionResult != null) {
            title = (String)this.titleFunctionResult.value();
        }
        if (title == null) {
            title = "#null#";
        } else {
            title = title.trim();
            title = ((LocalizationService)this.definition.adapt(LocalizationService.class)).transform(title, CapitalizationType.TITLE_STYLE, false);
        }
        this.section.setText(title.trim());
    }

    @Override
    public Set<String> getActionContexts() {
        return Collections.singleton("Sapphire.Section");
    }

    @Override
    public IContext getDocumentationContext() {
        ISapphireDocumentation doc = (ISapphireDocumentation)this.definition.getDocumentation().element();
        if (doc != null) {
            ISapphireDocumentationDef docdef = null;
            docdef = doc instanceof ISapphireDocumentationDef ? (ISapphireDocumentationDef)doc : ((ISapphireDocumentationRef)doc).resolve();
            if (docdef != null) {
                return SapphireHelpSystem.getContext(docdef);
            }
        }
        return null;
    }

    public SapphireCondition getVisibleWhenCondition() {
        return this.visibleWhenCondition;
    }

    public boolean checkVisibleWhenCondition() {
        if (this.visibleWhenCondition != null) {
            return this.visibleWhenCondition.getConditionState();
        }
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.visibleWhenCondition != null) {
            this.visibleWhenCondition.dispose();
        }
    }
}

