/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.form.editors.masterdetails;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.ElementValidationEvent;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.ui.IPropertiesViewContributorPart;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.PropertiesViewContributionManager;
import org.eclipse.sapphire.ui.PropertiesViewContributionPart;
import org.eclipse.sapphire.ui.SapphireCondition;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePropertyEnabledCondition;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.SapphireSection;
import org.eclipse.sapphire.ui.def.ISapphireParam;
import org.eclipse.sapphire.ui.def.ISapphireSectionDef;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentOutline;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsEditorPagePart;
import org.eclipse.sapphire.ui.form.editors.masterdetails.def.IMasterDetailsContentNodeChildDef;
import org.eclipse.sapphire.ui.form.editors.masterdetails.def.IMasterDetailsContentNodeDef;
import org.eclipse.sapphire.ui.form.editors.masterdetails.def.IMasterDetailsContentNodeFactoryCaseDef;
import org.eclipse.sapphire.ui.form.editors.masterdetails.def.IMasterDetailsContentNodeFactoryDef;
import org.eclipse.sapphire.ui.form.editors.masterdetails.def.IMasterDetailsContentNodeInclude;
import org.eclipse.sapphire.ui.internal.TableWrapLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.SwtUtil;
import org.eclipse.sapphire.util.ReadOnlyListFactory;
import org.eclipse.sapphire.util.ReadOnlyMapFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MasterDetailsContentNode
extends SapphirePart
implements IPropertiesViewContributorPart {
    private static final ImageData IMG_CONTAINER_NODE = ImageData.createFromClassLoader(MasterDetailsContentNode.class, (String)"ContainerNode.png");
    private static final ImageData IMG_LEAF_NODE = ImageData.createFromClassLoader(MasterDetailsContentNode.class, (String)"LeafNode.png");
    public static final String HINT_HIDE_IF_DISABLED = "hide.if.disabled";
    private MasterDetailsContentOutline contentTree;
    private IMasterDetailsContentNodeDef definition;
    private IModelElement modelElement;
    private ImpliedElementProperty modelElementProperty;
    private Listener modelElementListener;
    private MasterDetailsContentNode parentNode;
    private FunctionResult labelFunctionResult;
    private SapphirePart.ImageManager imageManager;
    private Listener childPartListener;
    private List<Object> rawChildren;
    private List<SapphireSection> sections;
    private List<SapphireSection> sectionsReadOnly;
    private PropertiesViewContributionManager propertiesViewContributionManager;
    private boolean expanded;
    private SapphireCondition visibleWhenCondition;
    private final List<SapphireCondition> allConditions = new ArrayList<SapphireCondition>();
    private boolean transformLabelCase = true;

    @Override
    protected void init() {
        String hideIfDisabled;
        super.init();
        ISapphirePart parent = this.getParentPart();
        this.parentNode = parent instanceof MasterDetailsContentNode ? (MasterDetailsContentNode)parent : null;
        this.contentTree = this.nearest(MasterDetailsEditorPagePart.class).outline();
        this.definition = (IMasterDetailsContentNodeDef)((SapphirePart)this).definition;
        this.modelElementProperty = (ImpliedElementProperty)this.resolve((String)this.definition.getProperty().getContent());
        if (this.modelElementProperty != null) {
            this.modelElement = this.getModelElement().read(this.modelElementProperty);
            this.modelElementListener = new FilteredListener<PropertyEvent>(){

                protected void handleTypedEvent(PropertyEvent event) {
                    MasterDetailsContentNode.this.handleModelElementChange((Event)event);
                }
            };
            this.modelElement.attach(this.modelElementListener);
        } else {
            this.modelElement = this.getModelElement();
        }
        this.visibleWhenCondition = null;
        Class<SapphirePropertyEnabledCondition> visibleWhenConditionClass = null;
        String visibleWhenConditionParameter = null;
        Status visibleWhenConditionClassValidation = this.definition.getVisibleWhenConditionClass().validation();
        if (visibleWhenConditionClassValidation.severity() != Status.Severity.ERROR) {
            JavaType visibleWhenConditionType = (JavaType)this.definition.getVisibleWhenConditionClass().resolve();
            if (visibleWhenConditionType != null) {
                visibleWhenConditionClass = visibleWhenConditionType.artifact();
                visibleWhenConditionParameter = this.definition.getVisibleWhenConditionParameter().getText();
            }
        } else {
            LoggingService.log((Status)visibleWhenConditionClassValidation);
        }
        if (visibleWhenConditionClass == null && this.modelElementProperty != null && Boolean.parseBoolean(hideIfDisabled = this.definition.getHint(HINT_HIDE_IF_DISABLED))) {
            visibleWhenConditionClass = SapphirePropertyEnabledCondition.class;
            visibleWhenConditionParameter = this.modelElementProperty.getName();
        }
        if (visibleWhenConditionClass != null) {
            this.visibleWhenCondition = SapphireCondition.create(this, visibleWhenConditionClass, visibleWhenConditionParameter);
            if (this.visibleWhenCondition != null) {
                this.allConditions.add(this.visibleWhenCondition);
                this.visibleWhenCondition.attach(new Listener(){

                    public void handle(Event event) {
                        MasterDetailsContentNode.this.getContentTree().refresh();
                    }
                });
            }
        }
        this.expanded = false;
        FilteredListener<ElementValidationEvent> elementValidationListener = new FilteredListener<ElementValidationEvent>(){

            protected void handleTypedEvent(ElementValidationEvent event) {
                MasterDetailsContentNode.this.updateValidationState();
            }
        };
        this.modelElement.attach((Listener)elementValidationListener);
        this.attach(new Listener((Listener)elementValidationListener){
            private final /* synthetic */ Listener val$elementValidationListener;
            {
                this.val$elementValidationListener = listener;
            }

            public void handle(Event event) {
                if (event instanceof DisposeEvent) {
                    MasterDetailsContentNode.this.getModelElement().detach(this.val$elementValidationListener);
                }
            }
        });
        this.childPartListener = new Listener(){

            public void handle(Event event) {
                if (event instanceof SapphirePart.ValidationChangedEvent) {
                    MasterDetailsContentNode.this.updateValidationState();
                }
            }
        };
        Listener validationStateListener = new Listener(){

            public void handle(Event event) {
                if (event instanceof SapphirePart.ValidationChangedEvent) {
                    MasterDetailsContentNode.this.getContentTree().notifyOfNodeUpdate(MasterDetailsContentNode.this);
                }
            }
        };
        this.attach(validationStateListener);
        this.labelFunctionResult = this.initExpression(this.modelElement, (Function)this.definition.getLabel().getContent(), String.class, null, new Runnable(){

            public void run() {
                MasterDetailsContentNode.this.getContentTree().notifyOfNodeUpdate(MasterDetailsContentNode.this);
            }
        });
        Literal defaultImageLiteral = Literal.create((Object)(this.definition.getChildNodes().isEmpty() ? IMG_LEAF_NODE : IMG_CONTAINER_NODE));
        Function imageFunction = (Function)this.definition.getImage().getContent();
        this.imageManager = new SapphirePart.ImageManager(this.modelElement, imageFunction, (Function)defaultImageLiteral);
        this.attach(new Listener(){

            public void handle(Event event) {
                if (event instanceof SapphirePart.ImageChangedEvent) {
                    MasterDetailsContentNode.this.getContentTree().notifyOfNodeUpdate(MasterDetailsContentNode.this);
                }
            }
        });
        this.sections = new ArrayList<SapphireSection>();
        this.sectionsReadOnly = Collections.unmodifiableList(this.sections);
        this.rawChildren = new ArrayList<Object>();
        for (ISapphireSectionDef secdef : this.definition.getSections()) {
            SapphireSection section = new SapphireSection(){

                protected Object createSectionLayoutData() {
                    return TableWrapLayoutUtil.twd();
                }
            };
            section.init(this, this.modelElement, secdef, this.params);
            section.attach(this.childPartListener);
            this.sections.add(section);
        }
        for (IMasterDetailsContentNodeChildDef entry : this.definition.getChildNodes()) {
            IMasterDetailsContentNodeChildDef def;
            HashMap<String, String> params = new HashMap<String, String>(this.params);
            if (entry instanceof IMasterDetailsContentNodeInclude) {
                IMasterDetailsContentNodeInclude inc = (IMasterDetailsContentNodeInclude)entry;
                if ((entry = inc.resolve()) == null) {
                    String msg = NLS.bind((String)Resources.couldNotResolveNode, (Object[])new Object[]{inc.getPart()});
                    throw new RuntimeException(msg);
                }
                for (ISapphireParam param : inc.getParams()) {
                    String paramName = param.getName().getText();
                    String paramValue = param.getValue().getText();
                    if (paramName == null || paramValue == null) continue;
                    params.put(paramName, paramValue);
                }
            }
            if (entry instanceof IMasterDetailsContentNodeDef) {
                def = (IMasterDetailsContentNodeDef)entry;
                MasterDetailsContentNode node = new MasterDetailsContentNode();
                node.init(this, this.modelElement, def, params);
                node.attach(this.childPartListener);
                this.rawChildren.add(node);
                continue;
            }
            if (entry instanceof IMasterDetailsContentNodeFactoryDef) {
                NodeFactory factory;
                ListProperty prop;
                def = (IMasterDetailsContentNodeFactoryDef)entry;
                ModelProperty property = MasterDetailsContentNode.resolve(this.getLocalModelElement(), (String)def.getProperty().getContent(), params);
                if (property instanceof ListProperty) {
                    prop = (ListProperty)property;
                    factory = new NodeFactory((IMasterDetailsContentNodeFactoryDef)def, params){

                        @Override
                        public ModelProperty property() {
                            return prop;
                        }

                        @Override
                        protected List<IModelElement> elements() {
                            return ReadOnlyListFactory.create((Collection)MasterDetailsContentNode.this.getLocalModelElement().read(prop));
                        }
                    };
                } else if (property instanceof ElementProperty) {
                    prop = (ElementProperty)property;
                    factory = new NodeFactory((IMasterDetailsContentNodeFactoryDef)def, params, (ElementProperty)prop){
                        private final /* synthetic */ ElementProperty val$prop;
                        {
                            this.val$prop = elementProperty;
                            super($anonymous0, $anonymous1);
                        }

                        @Override
                        public ModelProperty property() {
                            return this.val$prop;
                        }

                        @Override
                        protected List<IModelElement> elements() {
                            IModelElement element = MasterDetailsContentNode.this.getLocalModelElement().read(this.val$prop).element();
                            if (element == null) {
                                return Collections.emptyList();
                            }
                            return Collections.singletonList(element);
                        }
                    };
                } else {
                    throw new IllegalStateException();
                }
                this.rawChildren.add(factory);
                continue;
            }
            throw new IllegalStateException();
        }
    }

    public MasterDetailsContentOutline getContentTree() {
        return this.contentTree;
    }

    public MasterDetailsContentNode getParentNode() {
        return this.parentNode;
    }

    public boolean isAncestorOf(MasterDetailsContentNode node) {
        MasterDetailsContentNode n = node;
        while (n != null) {
            if (n == this) {
                return true;
            }
            n = n.getParentNode();
        }
        return false;
    }

    @Override
    public IModelElement getLocalModelElement() {
        return this.modelElement;
    }

    public String getLabel() {
        String label = null;
        if (this.labelFunctionResult != null) {
            label = (String)this.labelFunctionResult.value();
        }
        if (label == null) {
            label = "#null#";
        } else {
            label = label.trim();
            CapitalizationType capType = this.transformLabelCase ? CapitalizationType.TITLE_STYLE : CapitalizationType.NO_CAPS;
            label = ((LocalizationService)this.definition.adapt(LocalizationService.class)).transform(label, capType, false);
        }
        return label;
    }

    public ImageDescriptor getImage() {
        return this.imageManager.getImage();
    }

    public boolean isVisible() {
        if (this.visibleWhenCondition != null) {
            return this.visibleWhenCondition.getConditionState();
        }
        return true;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.setExpanded(expanded, false);
    }

    public void setExpanded(boolean expanded, boolean applyToChildren) {
        if (this.parentNode != null && !this.parentNode.isExpanded() && expanded) {
            this.parentNode.setExpanded(true);
        }
        if (this.expanded != expanded) {
            MasterDetailsContentNode selection;
            if (!expanded && (selection = this.getContentTree().getSelectedNode()) != null && this.isAncestorOf(selection)) {
                this.select();
            }
            if (expanded) {
                this.expanded = expanded;
                this.getContentTree().notifyOfNodeExpandedStateChange(this);
            }
        }
        if (applyToChildren) {
            for (MasterDetailsContentNode child : this.getChildNodes()) {
                if (!child.hasChildNodes()) continue;
                child.setExpanded(expanded, applyToChildren);
            }
        }
        if (this.expanded != expanded && !expanded) {
            this.expanded = expanded;
            this.getContentTree().notifyOfNodeExpandedStateChange(this);
        }
    }

    public List<MasterDetailsContentNode> getExpandedNodes() {
        ArrayList<MasterDetailsContentNode> result = new ArrayList<MasterDetailsContentNode>();
        this.getExpandedNodes(result);
        return result;
    }

    public void getExpandedNodes(List<MasterDetailsContentNode> result) {
        if (this.isExpanded()) {
            result.add(this);
            for (MasterDetailsContentNode child : this.getChildNodes()) {
                child.getExpandedNodes(result);
            }
        }
    }

    public void select() {
        this.getContentTree().setSelectedNode(this);
    }

    public List<SapphireSection> getSections() {
        return this.sectionsReadOnly;
    }

    public List<ModelProperty> getChildNodeFactoryProperties() {
        ArrayList<ModelProperty> properties = new ArrayList<ModelProperty>();
        for (Object object : this.rawChildren) {
            NodeFactory factory;
            if (!(object instanceof NodeFactory) || !(factory = (NodeFactory)object).visible()) continue;
            properties.add(factory.property());
        }
        return properties;
    }

    public boolean isChildNodeFactoryProperty(ModelProperty property) {
        if (this.rawChildren != null) {
            for (Object object : this.rawChildren) {
                NodeFactory factory;
                if (!(object instanceof NodeFactory) || !(factory = (NodeFactory)object).visible() || factory.property() != property) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasChildNodes() {
        return !this.rawChildren.isEmpty();
    }

    public List<MasterDetailsContentNode> getChildNodes() {
        ArrayList<MasterDetailsContentNode> nodes = new ArrayList<MasterDetailsContentNode>();
        for (Object entry : this.rawChildren) {
            if (entry instanceof MasterDetailsContentNode) {
                MasterDetailsContentNode node = (MasterDetailsContentNode)entry;
                if (!node.isVisible()) continue;
                nodes.add(node);
                continue;
            }
            if (entry instanceof NodeFactory) {
                NodeFactory factory = (NodeFactory)entry;
                if (!factory.visible()) continue;
                nodes.addAll(factory.nodes());
                continue;
            }
            throw new IllegalStateException(entry.getClass().getName());
        }
        return nodes;
    }

    public MasterDetailsContentNode getChildNodeByLabel(String label) {
        for (MasterDetailsContentNode child : this.getChildNodes()) {
            if (!label.equals(child.getLabel())) continue;
            return child;
        }
        return null;
    }

    public MasterDetailsContentNode findNodeByModelElement(IModelElement element) {
        if (this.getModelElement() == element) {
            return this;
        }
        for (MasterDetailsContentNode child : this.getChildNodes()) {
            MasterDetailsContentNode res = child.findNodeByModelElement(element);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    @Override
    public PropertiesViewContributionPart getPropertiesViewContribution() {
        if (this.propertiesViewContributionManager == null) {
            this.propertiesViewContributionManager = new PropertiesViewContributionManager(this, this.getLocalModelElement());
        }
        return this.propertiesViewContributionManager.getPropertiesViewContribution();
    }

    @Override
    public Set<String> getActionContexts() {
        return Collections.singleton("Sapphire.EditorPage.Outline.Node");
    }

    @Override
    protected Status computeValidationState() {
        Status.CompositeStatusFactory factory = Status.factoryForComposite();
        if (this.basis()) {
            factory.merge(this.getModelElement().validation());
        }
        for (SapphirePart sapphirePart : this.sections) {
            factory.merge(sapphirePart.getValidationState());
        }
        for (SapphirePart sapphirePart : this.getChildNodes()) {
            factory.merge(sapphirePart.getValidationState());
        }
        return factory.create();
    }

    private boolean basis() {
        ISapphirePart parentPart;
        IModelElement element = this.getModelElement();
        if (element.parent() instanceof ModelElementList && (parentPart = this.getParentPart()) != null && parentPart instanceof MasterDetailsContentNode) {
            MasterDetailsContentNode parentNode = (MasterDetailsContentNode)parentPart;
            return element != parentNode.getLocalModelElement();
        }
        return false;
    }

    @Override
    protected void handleModelElementChange(Event event) {
        super.handleModelElementChange(event);
        if (event instanceof PropertyEvent && this.isChildNodeFactoryProperty(((PropertyEvent)event).property())) {
            if (event instanceof PropertyContentEvent) {
                SwtUtil.runOnDisplayThread(new Runnable(){

                    public void run() {
                        MasterDetailsContentNode.this.getContentTree().notifyOfNodeStructureChange(MasterDetailsContentNode.this);
                    }
                });
            } else if (event instanceof PropertyValidationEvent) {
                SwtUtil.runOnDisplayThread(new Runnable(){

                    public void run() {
                        MasterDetailsContentNode.this.updateValidationState();
                    }
                });
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.modelElementListener != null) {
            this.modelElement.detach(this.modelElementListener);
        }
        for (SapphirePart sapphirePart : this.sections) {
            sapphirePart.dispose();
        }
        for (SapphirePart sapphirePart : this.getChildNodes()) {
            sapphirePart.dispose();
        }
        for (SapphireCondition sapphireCondition : this.allConditions) {
            sapphireCondition.dispose();
        }
        if (this.labelFunctionResult != null) {
            this.labelFunctionResult.dispose();
        }
        if (this.imageManager != null) {
            this.imageManager.dispose();
        }
    }

    @Override
    public void render(SapphireRenderingContext context) {
        throw new UnsupportedOperationException();
    }

    public boolean controls(IModelElement element) {
        ISapphirePart parentPart;
        if (element == this.getModelElement() && (parentPart = this.getParentPart()) != null && parentPart instanceof MasterDetailsContentNode) {
            MasterDetailsContentNode parentNode = (MasterDetailsContentNode)parentPart;
            return element != parentNode.getLocalModelElement();
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class NodeFactory {
        private final IMasterDetailsContentNodeFactoryDef definition;
        private final Map<String, String> params;
        private SapphireCondition visibleWhenCondition;
        private final Map<IModelElement, MasterDetailsContentNode> nodesCache = new IdentityHashMap<IModelElement, MasterDetailsContentNode>();

        public NodeFactory(IMasterDetailsContentNodeFactoryDef definition, Map<String, String> params) {
            this.definition = definition;
            this.params = params;
            JavaType visibleWhenConditionClass = (JavaType)this.definition.getVisibleWhenConditionClass().resolve();
            if (visibleWhenConditionClass != null) {
                String parameter = this.definition.getVisibleWhenConditionParameter().getText();
                this.visibleWhenCondition = SapphireCondition.create(MasterDetailsContentNode.this, visibleWhenConditionClass.artifact(), parameter);
                if (this.visibleWhenCondition != null) {
                    MasterDetailsContentNode.this.allConditions.add(this.visibleWhenCondition);
                }
            }
        }

        public final boolean visible() {
            if (this.visibleWhenCondition != null) {
                return this.visibleWhenCondition.getConditionState();
            }
            return true;
        }

        public abstract ModelProperty property();

        protected abstract List<IModelElement> elements();

        public final List<MasterDetailsContentNode> nodes() {
            Map oldCache = ReadOnlyMapFactory.create(this.nodesCache);
            ReadOnlyListFactory nodes = ReadOnlyListFactory.create();
            for (IModelElement element : this.elements()) {
                MasterDetailsContentNode node = this.nodesCache.get(element);
                if (node == null) {
                    IMasterDetailsContentNodeFactoryCaseDef relevantCaseDef = null;
                    for (IMasterDetailsContentNodeFactoryCaseDef entry : this.definition.getCases()) {
                        JavaType type = (JavaType)entry.getType().resolve();
                        if (type == null) {
                            relevantCaseDef = entry;
                            break;
                        }
                        Class cl = type.artifact();
                        if (cl != null && !cl.isAssignableFrom(element.getClass())) continue;
                        relevantCaseDef = entry;
                        break;
                    }
                    if (relevantCaseDef == null) {
                        throw new RuntimeException();
                    }
                    node = new MasterDetailsContentNode();
                    this.nodesCache.put(element, node);
                    node.init(MasterDetailsContentNode.this, element, relevantCaseDef, this.params);
                    node.attach(MasterDetailsContentNode.this.childPartListener);
                    node.transformLabelCase = false;
                }
                nodes.add((Object)node);
            }
            for (Map.Entry entry : oldCache.entrySet()) {
                if (this.nodesCache.containsKey(entry.getKey())) continue;
                ((MasterDetailsContentNode)entry.getValue()).dispose();
            }
            return nodes.export();
        }
    }

    private static final class Resources
    extends NLS {
        public static String couldNotResolveNode;

        static {
            Resources.initializeMessages((String)MasterDetailsContentNode.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

