/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.CommandMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.MailcapCommandMap;
import javax.activation.MimetypesFileTypeMap;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.util.ByteArrayDataSource;
import org.eclipse.scout.commons.CharsetSafeMimeMessage;
import org.eclipse.scout.commons.FileUtility;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.RFCWrapperPart;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public final class MailUtility {
    public static final IScoutLogger LOG = ScoutLogManager.getLogger(MailUtility.class);
    private static final String CONTENT_TYPE_ID = "Content-Type";
    public static final String CONTENT_TYPE_TEXT_HTML = "text/html; charset=\"UTF-8\"";
    public static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain; charset=\"UTF-8\"";
    public static final String CONTENT_TYPE_MESSAGE_RFC822 = "message/rfc822";
    public static final String CONTENT_TYPE_MULTIPART = "alternative";
    private static MailUtility instance = new MailUtility();

    static {
        MailUtility.fixMailcapCommandMap();
    }

    private MailUtility() {
    }

    public static Part[] getBodyParts(Part message) throws ProcessingException {
        return instance.getBodyPartsImpl(message);
    }

    private Part[] getBodyPartsImpl(Part message) throws ProcessingException {
        ArrayList<Part> bodyCollector = new ArrayList<Part>();
        ArrayList<Part> attachementCollector = new ArrayList<Part>();
        this.collectMailPartsReqImpl(message, bodyCollector, attachementCollector);
        return bodyCollector.toArray(new Part[bodyCollector.size()]);
    }

    public static Part[] getAttachmentParts(Part message) throws ProcessingException {
        return instance.getAttachmentPartsImpl(message);
    }

    private Part[] getAttachmentPartsImpl(Part message) throws ProcessingException {
        ArrayList<Part> bodyCollector = new ArrayList<Part>();
        ArrayList<Part> attachementCollector = new ArrayList<Part>();
        this.collectMailPartsReqImpl(message, bodyCollector, attachementCollector);
        return attachementCollector.toArray(new Part[attachementCollector.size()]);
    }

    public static void collectMailParts(Part message, List<Part> bodyCollector, List<Part> attachementCollector) throws ProcessingException {
        instance.collectMailPartsReqImpl(message, bodyCollector, attachementCollector);
    }

    private void collectMailPartsReqImpl(Part part, List<Part> bodyCollector, List<Part> attachementCollector) throws ProcessingException {
        if (part == null) {
            return;
        }
        try {
            String disp = part.getDisposition();
            if (disp != null && disp.equalsIgnoreCase("attachment")) {
                attachementCollector.add(part);
            } else if (part.getContent() instanceof Multipart) {
                Multipart multiPart = (Multipart)part.getContent();
                int i = 0;
                while (i < multiPart.getCount()) {
                    this.collectMailPartsReqImpl((Part)multiPart.getBodyPart(i), bodyCollector, attachementCollector);
                    ++i;
                }
            } else if (part.isMimeType(CONTENT_TYPE_TEXT_PLAIN)) {
                bodyCollector.add(part);
            } else if (part.isMimeType(CONTENT_TYPE_TEXT_HTML)) {
                bodyCollector.add(part);
            } else if (part.isMimeType(CONTENT_TYPE_MESSAGE_RFC822) && part.getContent() instanceof MimeMessage) {
                MimeMessage msg = (MimeMessage)part.getContent();
                String filteredSubjectText = StringUtility.filterText(msg.getSubject(), "a-zA-Z0-9_-", "");
                String fileName = String.valueOf(StringUtility.hasText(filteredSubjectText) ? filteredSubjectText : "originalMessage") + ".eml";
                RFCWrapperPart wrapperPart = new RFCWrapperPart(part, fileName);
                attachementCollector.add(wrapperPart);
            }
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ProcessingException("Unexpected: ", t);
        }
    }

    public static String getPlainText(Part part) throws ProcessingException {
        return instance.getPlainTextImpl(part);
    }

    private String getPlainTextImpl(Part part) throws ProcessingException {
        String text = null;
        try {
            MimePart mimePart;
            byte[] content;
            Part[] bodyParts = this.getBodyPartsImpl(part);
            Part plainTextPart = MailUtility.getPlainTextPart(bodyParts);
            if (plainTextPart instanceof MimePart && (content = IOUtility.getContent((mimePart = (MimePart)plainTextPart).getInputStream())) != null) {
                try {
                    text = new String(content, this.getCharacterEncodingOfMimePart(mimePart));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    text = new String(content);
                }
            }
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ProcessingException("Unexpected: ", t);
        }
        return text;
    }

    public static Part getHtmlPart(Part[] bodyParts) throws ProcessingException {
        Part[] partArray = bodyParts;
        int n = bodyParts.length;
        int n2 = 0;
        while (n2 < n) {
            Part p = partArray[n2];
            try {
                if (p != null && p.isMimeType(CONTENT_TYPE_TEXT_HTML)) {
                    return p;
                }
            }
            catch (Throwable t) {
                throw new ProcessingException("Unexpected: ", t);
            }
            ++n2;
        }
        return null;
    }

    public static Part getPlainTextPart(Part[] bodyParts) throws ProcessingException {
        Part[] partArray = bodyParts;
        int n = bodyParts.length;
        int n2 = 0;
        while (n2 < n) {
            Part p = partArray[n2];
            try {
                if (p != null && p.isMimeType(CONTENT_TYPE_TEXT_PLAIN)) {
                    return p;
                }
            }
            catch (Throwable t) {
                throw new ProcessingException("Unexpected: ", t);
            }
            ++n2;
        }
        return null;
    }

    public static DataSource createDataSource(File file) throws ProcessingException {
        try {
            int indexDot = file.getName().lastIndexOf(".");
            if (indexDot > 0) {
                String fileName = file.getName();
                String ext = fileName.substring(indexDot + 1);
                return instance.createDataSourceImpl(new FileInputStream(file), fileName, ext);
            }
            return null;
        }
        catch (Throwable t) {
            throw new ProcessingException("Unexpected: ", t);
        }
    }

    public static DataSource createDataSource(InputStream inStream, String fileName, String fileExtension) throws ProcessingException {
        return instance.createDataSourceImpl(inStream, fileName, fileExtension);
    }

    private DataSource createDataSourceImpl(InputStream inStream, String fileName, String fileExtension) throws ProcessingException {
        try {
            ByteArrayDataSource item = new ByteArrayDataSource(inStream, MailUtility.getContentTypeForExtension(fileExtension));
            item.setName(fileName);
            return item;
        }
        catch (Throwable t) {
            throw new ProcessingException("Unexpected: ", t);
        }
    }

    public static MailMessage extractMailMessageFromWordArchive(File archiveFile) {
        return instance.extractMailMessageFromWordArchiveInternal(archiveFile);
    }

    private MailMessage extractMailMessageFromWordArchiveInternal(File archiveFile) {
        MailMessage mailMessage = null;
        File tempDir = this.extractWordArchive(archiveFile);
        String simpleName = this.extractSimpleNameFromWordArchive(archiveFile);
        String messagePlainText = this.extractPlainTextFromWordArchiveInternal(tempDir, simpleName);
        String messageHtml = this.extractHtmlFromWordArchiveInternal(tempDir, simpleName);
        File attachmentFolder = null;
        if (tempDir.isDirectory()) {
            File[] fileArray = tempDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory() && file.getName().startsWith(simpleName)) {
                    attachmentFolder = file;
                    break;
                }
                ++n2;
            }
        }
        String folderName = null;
        if (attachmentFolder != null) {
            folderName = attachmentFolder.getName();
        }
        messageHtml = messageHtml.replaceAll(String.valueOf(folderName) + "/", "");
        messageHtml = this.removeWordTags(messageHtml);
        ArrayList<File> attachmentList = new ArrayList<File>();
        if (attachmentFolder != null) {
            File[] fileArray = attachmentFolder.listFiles();
            int n = fileArray.length;
            int n3 = 0;
            while (n3 < n) {
                File attFile = fileArray[n3];
                if (!attFile.isDirectory() && !this.isWordSpecificFile(attFile.getName())) {
                    attachmentList.add(attFile);
                }
                ++n3;
            }
        }
        mailMessage = new MailMessage(messagePlainText, messageHtml, attachmentList);
        return mailMessage;
    }

    private String extractHtmlFromWordArchiveInternal(File dir, String simpleName) {
        String txt = null;
        try {
            txt = this.extractTextFromWordArchiveInternal(dir, simpleName, "html");
        }
        catch (Exception e) {
            LOG.error("Error occured while trying to extract plain text file", e);
        }
        return txt;
    }

    private String extractSimpleNameFromWordArchive(File archiveFile) {
        String simpleName = archiveFile.getName();
        if (archiveFile.getName().lastIndexOf(46) != -1) {
            simpleName = archiveFile.getName().substring(0, archiveFile.getName().lastIndexOf(46));
        }
        return simpleName;
    }

    private File extractWordArchive(File archiveFile) {
        File tempDir = null;
        try {
            tempDir = IOUtility.createTempDirectory("");
            FileUtility.extractArchive(archiveFile, tempDir);
        }
        catch (Exception e) {
            LOG.error("Error occured while trying to extract word archive", e);
        }
        return tempDir;
    }

    public static String extractPlainTextFromWordArchive(File archiveFile) {
        return instance.extractPlainTextFromWordArchiveInternal(archiveFile);
    }

    private String extractPlainTextFromWordArchiveInternal(File archiveFile) {
        File tempDir = this.extractWordArchive(archiveFile);
        String simpleName = this.extractSimpleNameFromWordArchive(archiveFile);
        return this.extractPlainTextFromWordArchiveInternal(tempDir, simpleName);
    }

    private String extractPlainTextFromWordArchiveInternal(File dir, String simpleName) {
        String plainText = null;
        try {
            plainText = this.extractTextFromWordArchiveInternal(dir, simpleName, "txt");
        }
        catch (Exception e) {
            LOG.error("Error occured while trying to extract plain text file", e);
        }
        return plainText;
    }

    private String extractTextFromWordArchiveInternal(File dir, String simpleName, String fileType) throws ProcessingException, IOException {
        String txt = null;
        File plainTextFile = new File(dir, String.valueOf(simpleName) + "." + fileType);
        if (plainTextFile.exists() && plainTextFile.canRead()) {
            FileReader reader = new FileReader(plainTextFile);
            txt = IOUtility.getContent(reader);
            ((Reader)reader).close();
        }
        return txt;
    }

    public static MimeMessage createMimeMessage(String[] toRecipients, String sender, String subject, String bodyTextPlain, DataSource[] attachements) throws ProcessingException {
        return instance.createMimeMessageInternal(toRecipients, null, null, sender, subject, bodyTextPlain, attachements);
    }

    public static MimeMessage createMimeMessage(String[] toRecipients, String[] ccRecipients, String[] bccRecipients, String sender, String subject, String bodyTextPlain, DataSource[] attachements) throws ProcessingException {
        return instance.createMimeMessageInternal(toRecipients, ccRecipients, bccRecipients, sender, subject, bodyTextPlain, attachements);
    }

    private MimeMessage createMimeMessageInternal(String[] toRecipients, String[] ccRecipients, String[] bccRecipients, String sender, String subject, String bodyTextPlain, DataSource[] attachements) throws ProcessingException {
        try {
            MimeMessage msg = MailUtility.createMimeMessage(bodyTextPlain, null, attachements);
            if (sender != null) {
                InternetAddress addrSender = new InternetAddress(sender);
                msg.setFrom((Address)addrSender);
                msg.setSender((Address)addrSender);
            }
            msg.setSentDate(new Date());
            msg.setSubject(subject, "UTF-8");
            msg.setRecipients(Message.RecipientType.TO, (Address[])this.parseAddresses(toRecipients));
            msg.setRecipients(Message.RecipientType.CC, (Address[])this.parseAddresses(ccRecipients));
            msg.setRecipients(Message.RecipientType.BCC, (Address[])this.parseAddresses(bccRecipients));
            return msg;
        }
        catch (ProcessingException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ProcessingException("Failed to create MimeMessage.", e);
        }
    }

    public static MimeMessage createMimeMessage(String messagePlain, String messageHtml, DataSource[] attachements) throws ProcessingException {
        return instance.createMimeMessageInternal(messagePlain, messageHtml, attachements);
    }

    public static MimeMessage createMimeMessageFromWordArchiveDirectory(File archiveDir, String simpleName, File[] attachments, boolean markAsUnsent) throws ProcessingException {
        return instance.createMimeMessageFromWordArchiveInternal(archiveDir, simpleName, attachments, markAsUnsent);
    }

    public static MimeMessage createMimeMessageFromWordArchive(File archiveFile, File[] attachments) throws ProcessingException {
        return MailUtility.createMimeMessageFromWordArchive(archiveFile, attachments, false);
    }

    public static MimeMessage createMimeMessageFromWordArchive(File archiveFile, File[] attachments, boolean markAsUnsent) throws ProcessingException {
        try {
            File tempDir = IOUtility.createTempDirectory("");
            FileUtility.extractArchive(archiveFile, tempDir);
            String simpleName = archiveFile.getName();
            if (archiveFile.getName().lastIndexOf(46) != -1) {
                simpleName = archiveFile.getName().substring(0, archiveFile.getName().lastIndexOf(46));
            }
            return instance.createMimeMessageFromWordArchiveInternal(tempDir, simpleName, attachments, markAsUnsent);
        }
        catch (ProcessingException pe) {
            throw pe;
        }
        catch (IOException e) {
            throw new ProcessingException("Error occured while accessing files", e);
        }
    }

    private MimeMessage createMimeMessageFromWordArchiveInternal(File archiveDir, String simpleName, File[] attachments, boolean markAsUnsent) throws ProcessingException {
        try {
            File plainTextFile = new File(archiveDir, String.valueOf(simpleName) + ".txt");
            String plainTextMessage = null;
            boolean hasPlainText = false;
            if (plainTextFile.exists()) {
                FileReader reader = new FileReader(plainTextFile);
                plainTextMessage = IOUtility.getContent(reader);
                ((Reader)reader).close();
                hasPlainText = StringUtility.hasText(plainTextMessage);
            }
            String folderName = null;
            ArrayList<DataSource> htmlDataSourceList = new ArrayList<DataSource>();
            File[] fileArray = archiveDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File filesFolder = fileArray[n2];
                if (filesFolder.isDirectory() && filesFolder.getName().startsWith(simpleName)) {
                    folderName = filesFolder.getName();
                    File[] fileArray2 = filesFolder.listFiles();
                    int n3 = fileArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File file = fileArray2[n4];
                        String filename = file.getName();
                        if (!this.isWordSpecificFile(filename)) {
                            FileDataSource fds = new FileDataSource(file);
                            htmlDataSourceList.add((DataSource)fds);
                        }
                        ++n4;
                    }
                    break;
                }
                ++n2;
            }
            File htmlFile = new File(archiveDir, String.valueOf(simpleName) + ".html");
            String htmlMessage = null;
            boolean hasHtml = false;
            if (htmlFile.exists()) {
                FileReader reader = new FileReader(htmlFile);
                htmlMessage = IOUtility.getContent(reader);
                ((Reader)reader).close();
                htmlMessage = htmlMessage.replaceAll("\"" + folderName + "/", "\"cid:");
                htmlMessage = this.removeWordTags(htmlMessage);
                htmlMessage = htmlMessage.replaceAll("<!--\\[if gte vml 1(.*\\r?\\n)*?.*?endif\\]-->", "");
                htmlMessage = Pattern.compile("<!\\[if !vml\\]>(.*?)<!\\[endif\\]>", 32).matcher(htmlMessage).replaceAll("$1");
                Iterator it = htmlDataSourceList.iterator();
                while (it.hasNext()) {
                    DataSource ds = (DataSource)it.next();
                    if (htmlMessage.contains("cid:" + ds.getName())) continue;
                    it.remove();
                }
                hasHtml = StringUtility.hasText(htmlMessage);
            }
            if (!hasPlainText && !hasHtml) {
                throw new ProcessingException("message has no body");
            }
            CharsetSafeMimeMessage mimeMessage = new CharsetSafeMimeMessage();
            CharsetSafeMimeMessage bodyPart = null;
            if (attachments != null && attachments.length > 0) {
                MimeMultipart multiPart = new MimeMultipart();
                mimeMessage.setContent((Multipart)multiPart);
                MimeBodyPart multiPartBody = new MimeBodyPart();
                multiPart.addBodyPart((BodyPart)multiPartBody);
                bodyPart = multiPartBody;
                File[] fileArray3 = attachments;
                int n5 = attachments.length;
                int n6 = 0;
                while (n6 < n5) {
                    File attachment = fileArray3[n6];
                    MimeBodyPart part = new MimeBodyPart();
                    FileDataSource fds = new FileDataSource(attachment);
                    DataHandler handler = new DataHandler((DataSource)fds);
                    part.setDataHandler(handler);
                    part.setFileName(attachment.getName());
                    multiPart.addBodyPart((BodyPart)part);
                    ++n6;
                }
            } else {
                bodyPart = mimeMessage;
            }
            if (hasPlainText && hasHtml) {
                MimeMultipart alternativePart = new MimeMultipart(CONTENT_TYPE_MULTIPART);
                bodyPart.setContent((Multipart)alternativePart);
                MimeBodyPart plainBodyPart = new MimeBodyPart();
                alternativePart.addBodyPart((BodyPart)plainBodyPart);
                MailUtility.writePlainBody((MimePart)plainBodyPart, plainTextMessage);
                MimeBodyPart htmlBodyPart = new MimeBodyPart();
                alternativePart.addBodyPart((BodyPart)htmlBodyPart);
                MailUtility.writeHtmlBody((MimePart)htmlBodyPart, htmlMessage, htmlDataSourceList);
            } else if (hasPlainText) {
                MailUtility.writePlainBody((MimePart)bodyPart, plainTextMessage);
            } else {
                MailUtility.writeHtmlBody((MimePart)bodyPart, htmlMessage, htmlDataSourceList);
            }
            if (markAsUnsent) {
                mimeMessage.setHeader("X-Unsent", "1");
            }
            return mimeMessage;
        }
        catch (IOException e) {
            throw new ProcessingException("Error occured while accessing files", e);
        }
        catch (MessagingException e) {
            throw new ProcessingException("Error occured while creating MIME-message", e);
        }
    }

    private String removeWordTags(String htmlMessage) {
        htmlMessage = htmlMessage.replaceAll("<link rel=File-List href=\"cid:filelist.xml\">", "");
        htmlMessage = htmlMessage.replaceAll("<link rel=colorSchemeMapping href=\"cid:colorschememapping.xml\">", "");
        htmlMessage = htmlMessage.replaceAll("<link rel=themeData href=\"cid:themedata.thmx\">", "");
        htmlMessage = htmlMessage.replaceAll("<link rel=Edit-Time-Data href=\"cid:editdata.mso\">", "");
        htmlMessage = htmlMessage.replaceAll("<!--\\[if gte mso(.*\\r?\\n)*?.*?endif\\]-->", "");
        return htmlMessage;
    }

    private boolean isWordSpecificFile(String filename) {
        return filename.equalsIgnoreCase("filelist.xml") || filename.equalsIgnoreCase("colorschememapping.xml") || filename.equalsIgnoreCase("themedata.thmx") || filename.equalsIgnoreCase("header.html") || filename.equalsIgnoreCase("editdata.mso") || filename.matches("item\\d{4}\\.xml") || filename.matches("props\\d{4}\\.xml");
    }

    private static void writeHtmlBody(MimePart htmlBodyPart, String htmlMessage, List<DataSource> htmlDataSourceList) throws MessagingException {
        MimeMultipart multiPartHtml = new MimeMultipart("related");
        htmlBodyPart.setContent((Multipart)multiPartHtml);
        MimeBodyPart part = new MimeBodyPart();
        part.setContent((Object)htmlMessage, CONTENT_TYPE_TEXT_HTML);
        part.setHeader(CONTENT_TYPE_ID, CONTENT_TYPE_TEXT_HTML);
        part.setHeader("Content-Transfer-Encoding", "quoted-printable");
        multiPartHtml.addBodyPart((BodyPart)part);
        for (DataSource source : htmlDataSourceList) {
            part = new MimeBodyPart();
            DataHandler handler = new DataHandler(source);
            part.setDataHandler(handler);
            part.setFileName(source.getName());
            part.addHeader("Content-ID", "<" + source.getName() + ">");
            multiPartHtml.addBodyPart((BodyPart)part);
        }
    }

    private static void writePlainBody(MimePart plainBodyPart, String plainTextMessage) throws MessagingException {
        plainBodyPart.setText(plainTextMessage, "UTF-8");
        plainBodyPart.setHeader(CONTENT_TYPE_ID, CONTENT_TYPE_TEXT_PLAIN);
        plainBodyPart.setHeader("Content-Transfer-Encoding", "quoted-printable");
    }

    private MimeMessage createMimeMessageInternal(String bodyTextPlain, String bodyTextHtml, DataSource[] attachements) throws ProcessingException {
        BodyPart bodyPart;
        MimeMultipart multiPart;
        CharsetSafeMimeMessage m;
        block5: {
            m = new CharsetSafeMimeMessage();
            multiPart = new MimeMultipart();
            bodyPart = this.createBodyPart(bodyTextPlain, bodyTextHtml);
            if (bodyPart != null) break block5;
            return null;
        }
        try {
            multiPart.addBodyPart(bodyPart);
            if (attachements != null) {
                DataSource[] dataSourceArray = attachements;
                int n = attachements.length;
                int n2 = 0;
                while (n2 < n) {
                    DataSource source = dataSourceArray[n2];
                    MimeBodyPart part = new MimeBodyPart();
                    DataHandler handler = new DataHandler(source);
                    part.setDataHandler(handler);
                    part.setFileName(source.getName());
                    multiPart.addBodyPart((BodyPart)part);
                    ++n2;
                }
            }
            m.setContent((Multipart)multiPart);
            return m;
        }
        catch (Throwable t) {
            throw new ProcessingException("Failed to create MimeMessage.", t);
        }
    }

    private BodyPart createBodyPart(String bodyTextPlain, String bodyTextHtml) throws MessagingException {
        if (!StringUtility.isNullOrEmpty(bodyTextPlain) && !StringUtility.isNullOrEmpty(bodyTextHtml)) {
            MimeBodyPart plainPart = new MimeBodyPart();
            plainPart.setText(bodyTextPlain, "UTF-8");
            plainPart.addHeader(CONTENT_TYPE_ID, CONTENT_TYPE_TEXT_PLAIN);
            MimeBodyPart htmlPart = new MimeBodyPart();
            htmlPart.setText(bodyTextHtml, "UTF-8");
            htmlPart.addHeader(CONTENT_TYPE_ID, CONTENT_TYPE_TEXT_HTML);
            MimeMultipart multiPart = new MimeMultipart(CONTENT_TYPE_MULTIPART);
            multiPart.addBodyPart((BodyPart)plainPart);
            multiPart.addBodyPart((BodyPart)htmlPart);
            MimeBodyPart multiBodyPart = new MimeBodyPart();
            multiBodyPart.setContent((Multipart)multiPart);
            return multiBodyPart;
        }
        if (!StringUtility.isNullOrEmpty(bodyTextPlain)) {
            MimeBodyPart part = new MimeBodyPart();
            part.setText(bodyTextPlain, "UTF-8");
            part.addHeader(CONTENT_TYPE_ID, CONTENT_TYPE_TEXT_PLAIN);
            return part;
        }
        if (!StringUtility.isNullOrEmpty(bodyTextHtml)) {
            MimeBodyPart part = new MimeBodyPart();
            part.setText(bodyTextHtml, "UTF-8");
            part.addHeader(CONTENT_TYPE_ID, CONTENT_TYPE_TEXT_HTML);
            return part;
        }
        return null;
    }

    public static MimeMessage createMessageFromBytes(byte[] bytes) throws ProcessingException {
        return instance.createMessageFromBytesImpl(bytes);
    }

    private MimeMessage createMessageFromBytesImpl(byte[] bytes) throws ProcessingException {
        try {
            ByteArrayInputStream st = new ByteArrayInputStream(bytes);
            return new MimeMessage(null, (InputStream)st);
        }
        catch (Throwable t) {
            throw new ProcessingException("Unexpected: ", t);
        }
    }

    public static String getContentTypeForExtension(String ext) {
        String type;
        if (ext == null) {
            return null;
        }
        if (ext.startsWith(".")) {
            ext = ext.substring(1);
        }
        if ((type = FileUtility.getContentTypeForExtension(ext = ext.toLowerCase())) == null) {
            type = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType("tmp." + ext);
        }
        return type;
    }

    private InternetAddress[] parseAddresses(String[] addresses) throws AddressException {
        if (addresses == null) {
            return null;
        }
        ArrayList<InternetAddress> addrList = new ArrayList<InternetAddress>();
        int i = 0;
        while (i < Array.getLength(addresses)) {
            addrList.add(new InternetAddress(addresses[i]));
            ++i;
        }
        if (addrList.size() == 0) {
            return null;
        }
        return addrList.toArray(new InternetAddress[addrList.size()]);
    }

    private String getCharacterEncodingOfMimePart(MimePart part) throws MessagingException {
        Pattern pattern = Pattern.compile("charset=\".*\"", 10);
        Matcher matcher = pattern.matcher(part.getContentType());
        String characterEncoding = "UTF-8";
        if (matcher.find()) {
            if (matcher.group(0).split("\"").length >= 2) {
                characterEncoding = matcher.group(0).split("\"")[1];
            }
        } else if (part.getContentType().contains("charset=") && part.getContentType().split("charset=").length == 2) {
            characterEncoding = part.getContentType().split("charset=")[1];
        }
        return characterEncoding;
    }

    private static void fixMailcapCommandMap() {
        try {
            Class<?> textPlainClass;
            try {
                textPlainClass = Class.forName("com.sun.mail.handlers.text_plain");
            }
            catch (Throwable throwable) {
                return;
            }
            CommandMap cmap = MailcapCommandMap.getDefaultCommandMap();
            if (!(cmap instanceof MailcapCommandMap)) {
                return;
            }
            ((MailcapCommandMap)cmap).addMailcap("text/plain;;x-java-content-handler=" + textPlainClass.getName());
            Field f = MailcapCommandMap.class.getDeclaredField("DB");
            f.setAccessible(true);
            Object[] dbArray = (Object[])f.get(cmap);
            f = Class.forName("com.sun.activation.registries.MailcapFile").getDeclaredField("type_hash");
            f.setAccessible(true);
            Map db0 = (Map)f.get(dbArray[0]);
            Map typeMap = (Map)db0.get("text/plain");
            List handlerList = (List)typeMap.get("content-handler");
            handlerList.remove("com.sun.mail.handlers.text_plain");
            handlerList.add(0, "com.sun.mail.handlers.text_plain");
        }
        catch (Throwable t) {
            ScoutLogManager.getLogger(MailUtility.class).warn("Failed fixing MailcapComandMap string handling: " + t);
        }
    }

    public class MailMessage {
        private String m_plainText;
        private String m_htmlText;
        private List<File> m_htmlAttachmentList;

        public MailMessage(String plainText, String htmlText, List<File> htmlAttachmentList) {
            this.m_plainText = plainText;
            this.m_htmlText = htmlText;
            this.m_htmlAttachmentList = htmlAttachmentList;
        }

        public String getPlainText() {
            return this.m_plainText;
        }

        public String getHtmlText() {
            return this.m_htmlText;
        }

        public List<File> getHtmlAttachmentList() {
            return this.m_htmlAttachmentList;
        }
    }
}

