/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.parsers;

import java.text.ParsePosition;
import java.util.ArrayList;
import org.eclipse.scout.commons.internal.Activator;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.parsers.BindModel;
import org.eclipse.scout.commons.parsers.token.DatabaseSpecificToken;
import org.eclipse.scout.commons.parsers.token.FunctionInputToken;
import org.eclipse.scout.commons.parsers.token.IToken;
import org.eclipse.scout.commons.parsers.token.TextToken;
import org.eclipse.scout.commons.parsers.token.ValueInputToken;
import org.eclipse.scout.commons.parsers.token.ValueOutputToken;

public class BindParser {
    private static final IScoutLogger LOG;
    private static final String PLAIN_SQL_BIND_PROPERTY_NAME = "org.eclipse.scout.commons.sqlplainbind";
    private static final Boolean PLAIN_SQL_BIND_ENABLED;
    private static final String S_MAP;
    private static final String NAME_MAP;
    private String m_str;
    private ParsePosition m_pos;
    private ArrayList<IToken> m_tokenList = new ArrayList();
    private int m_lastTokenEndIndex;

    static {
        String s;
        LOG = ScoutLogManager.getLogger(BindParser.class);
        S_MAP = " \n\t\r";
        NAME_MAP = "_.0123456789{}[]ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        String string = s = Activator.getDefault() != null ? Activator.getDefault().getBundle().getBundleContext().getProperty(PLAIN_SQL_BIND_PROPERTY_NAME) : System.getProperty(PLAIN_SQL_BIND_PROPERTY_NAME);
        PLAIN_SQL_BIND_ENABLED = "true".equalsIgnoreCase(s) ? Boolean.TRUE : ("false".equalsIgnoreCase(s) ? Boolean.FALSE : null);
    }

    public BindParser(String sqlStatement) {
        this.m_str = sqlStatement.trim();
    }

    public BindModel parse() {
        this.m_pos = new ParsePosition(0);
        this.parseStatement();
        this.addTextTokenUntil(this.m_str.length());
        if (this.m_pos.getIndex() < this.m_str.length()) {
            LOG.warn("statement not fully parsed (index " + this.m_pos.getIndex() + "): " + this.m_str);
        }
        return new BindModel(this.m_tokenList.toArray(new IToken[this.m_tokenList.size()]));
    }

    private boolean parseStatement() {
        if (LOG.isTraceEnabled()) {
            this.trace("parseStatement");
        }
        int index = this.m_pos.getIndex();
        this.parseWhitespace(0);
        if (this.parseTokenList()) {
            return true;
        }
        this.m_pos.setIndex(index);
        return false;
    }

    private boolean parseTokenList() {
        if (LOG.isTraceEnabled()) {
            this.trace("parseTokenList");
        }
        int index = this.m_pos.getIndex();
        if (this.parseToken()) {
            index = this.m_pos.getIndex();
            this.parseWhitespace(0);
            while (this.parseToken()) {
                index = this.m_pos.getIndex();
                this.parseWhitespace(0);
            }
            this.m_pos.setIndex(index);
            return true;
        }
        this.m_pos.setIndex(index);
        return false;
    }

    private ArrayList<String> parseFunctionArgList() {
        if (LOG.isTraceEnabled()) {
            this.trace("parseFunctionArgList");
        }
        int index = this.m_pos.getIndex();
        ArrayList<String> textList = new ArrayList<String>();
        String text = this.parseFunctionArg();
        if (text != null) {
            textList.add(text);
            index = this.m_pos.getIndex();
            this.parseWhitespace(0);
            while (this.matches(",") && this.parseWhitespace(0) && (text = this.parseFunctionArg()) != null) {
                textList.add(text);
                index = this.m_pos.getIndex();
                this.parseWhitespace(0);
            }
            this.m_pos.setIndex(index);
            return textList;
        }
        this.m_pos.setIndex(index);
        return textList;
    }

    private boolean parseToken() {
        if (LOG.isTraceEnabled()) {
            this.trace("parseToken");
        }
        return this.parseText() != null || this.parseExtendedBind() != null || this.parseChar();
    }

    private String parseText() {
        if (LOG.isTraceEnabled()) {
            this.trace("parseText");
        }
        int index = this.m_pos.getIndex();
        if (this.matches("'")) {
            while (this.parseTextChar()) {
            }
            if (!this.matches("'")) {
                LOG.warn("expected ' at position " + this.m_pos.getIndex() + " of " + this.m_str);
            }
            String text = this.m_str.substring(index + 1, this.m_pos.getIndex()).replaceAll("''", "'");
            return text;
        }
        this.m_pos.setIndex(index);
        return null;
    }

    private String parseFunctionArg() {
        if (LOG.isTraceEnabled()) {
            this.trace("parseFunctionArg");
        }
        int index = this.m_pos.getIndex();
        String arg = this.parseText();
        if (arg != null || (arg = this.parseName()) != null || (arg = this.parseNumber()) != null) {
            return arg;
        }
        this.m_pos.setIndex(index);
        return null;
    }

    private IToken parseExtendedBind() {
        if (LOG.isTraceEnabled()) {
            this.trace("parseExtendedBind");
        }
        int index = this.m_pos.getIndex();
        String attribute = null;
        String op = null;
        IToken token = null;
        attribute = this.parseAttribute();
        if (attribute == null || !this.parseWhitespace(0) || (op = this.parseOp()) == null || !this.parseWhitespace(0)) {
            this.m_pos.setIndex(index);
            attribute = null;
            op = null;
            op = this.parseOp();
            if (op == null || !this.parseWhitespace(0)) {
                this.m_pos.setIndex(index);
            }
        }
        int indexAfterOp = this.m_pos.getIndex();
        token = this.parseBind();
        if (token != null) {
            if (token instanceof ValueInputToken) {
                this.addTextTokenUntil(index);
                ((ValueInputToken)token).setParsedAttribute(attribute);
                ((ValueInputToken)token).setParsedOp(op);
            } else {
                this.addTextTokenUntil(indexAfterOp);
            }
            this.addToken(token, this.m_pos.getIndex());
            return token;
        }
        this.m_pos.setIndex(index);
        return null;
    }

    private String parseAttribute() {
        if (LOG.isTraceEnabled()) {
            this.trace("parseAttribute");
        }
        int index = this.m_pos.getIndex();
        if (this.parseOp() == null) {
            return this.parseName();
        }
        this.m_pos.setIndex(index);
        return null;
    }

    private String parseOp() {
        if (LOG.isTraceEnabled()) {
            this.trace("parseOp");
        }
        int index = this.m_pos.getIndex();
        if (this.matches("=")) {
            return "=";
        }
        this.m_pos.setIndex(index);
        if (this.matches("<>")) {
            return "<>";
        }
        this.m_pos.setIndex(index);
        if (this.matches("!=")) {
            return "!=";
        }
        this.m_pos.setIndex(index);
        if (this.matches("<=")) {
            return "<=";
        }
        this.m_pos.setIndex(index);
        if (this.matches(">=")) {
            return ">=";
        }
        this.m_pos.setIndex(index);
        if (this.matches("<")) {
            return "<";
        }
        this.m_pos.setIndex(index);
        if (this.matches(">")) {
            return ">";
        }
        this.m_pos.setIndex(index);
        if (this.matches("IN") && !this.peekNameChar()) {
            return "IN";
        }
        this.m_pos.setIndex(index);
        if (this.matches("NOT") && this.parseWhitespace(1) && this.matches("IN") && !this.peekNameChar()) {
            return "NOT IN";
        }
        this.m_pos.setIndex(index);
        if (this.matches("LIKE") && !this.peekNameChar()) {
            return "LIKE";
        }
        this.m_pos.setIndex(index);
        if (this.matches("NOT") && this.parseWhitespace(1) && this.matches("LIKE") && !this.peekNameChar()) {
            return "NOT LIKE";
        }
        this.m_pos.setIndex(index);
        return null;
    }

    private IToken parseBind() {
        if (LOG.isTraceEnabled()) {
            this.trace("parseBind");
        }
        IToken token = null;
        int index = this.m_pos.getIndex();
        token = this.parsePlainValueBind();
        if (token != null || (token = this.parsePlainSqlBind()) != null || (token = this.parseFunctionBind()) != null || (token = this.parseDatabaseSpecificToken()) != null || (token = this.parseStdBind()) != null) {
            return token;
        }
        this.m_pos.setIndex(index);
        return null;
    }

    private IToken parsePlainValueBind() {
        String name;
        if (LOG.isTraceEnabled()) {
            this.trace("parsePlainValueBind");
        }
        int index = this.m_pos.getIndex();
        if (this.matches("#") && (name = this.parseName()) != null && this.matches("#")) {
            if (name.startsWith("[OUT]")) {
                return new ValueOutputToken(this.m_str.substring(index, this.m_pos.getIndex()), name.substring(5), false);
            }
            return new ValueInputToken(this.m_str.substring(index, this.m_pos.getIndex()), name, true, false);
        }
        this.m_pos.setIndex(index);
        return null;
    }

    @Deprecated
    private IToken parsePlainSqlBind() {
        String name;
        if (LOG.isTraceEnabled()) {
            this.trace("parsePlainSqlBind");
        }
        int index = this.m_pos.getIndex();
        if (this.matches("&") && (name = this.parseName()) != null && this.matches("&")) {
            if (PLAIN_SQL_BIND_ENABLED == null) {
                LOG.warn("using plain sql bind can cause sql injections: &" + name + "&. Set property " + PLAIN_SQL_BIND_PROPERTY_NAME + "=true when legacy logic is necessarily being used");
            } else if (PLAIN_SQL_BIND_ENABLED == Boolean.FALSE) {
                String msg = "using plain sql bind: &" + name + "&. Property " + PLAIN_SQL_BIND_PROPERTY_NAME + " is set to false which causes this error";
                LOG.error(msg);
                throw new IllegalArgumentException(msg);
            }
            if (name.startsWith("[OUT]")) {
                return new ValueOutputToken(this.m_str.substring(index, this.m_pos.getIndex()), name.substring(5), false);
            }
            return new ValueInputToken(this.m_str.substring(index, this.m_pos.getIndex()), name, false, true);
        }
        this.m_pos.setIndex(index);
        return null;
    }

    private IToken parseFunctionBind() {
        if (LOG.isTraceEnabled()) {
            this.trace("parseFunctionBind");
        }
        int index = this.m_pos.getIndex();
        if (this.matches("::") || this.matches("##")) {
            ArrayList<String> args;
            boolean plainValue = this.m_str.substring(index, index + 2).equals("##");
            String name = this.parseName();
            if (name != null && this.parseWhitespace(0) && this.matches("(") && this.parseWhitespace(0) && (args = this.parseFunctionArgList()).size() > 0 && this.parseWhitespace(0) && this.matches(")")) {
                return new FunctionInputToken(this.m_str.substring(index, this.m_pos.getIndex()), name, args.toArray(new String[0]), plainValue, false);
            }
        }
        this.m_pos.setIndex(index);
        return null;
    }

    private IToken parseDatabaseSpecificToken() {
        String name;
        if (LOG.isTraceEnabled()) {
            this.trace("parseDatabaseSpecificToken");
        }
        int index = this.m_pos.getIndex();
        if (this.matches("$$") && (name = this.parseName()) != null) {
            return new DatabaseSpecificToken(this.m_str.substring(index, this.m_pos.getIndex()), name);
        }
        this.m_pos.setIndex(index);
        return null;
    }

    private IToken parseStdBind() {
        String name;
        if (LOG.isTraceEnabled()) {
            this.trace("parseStdBind");
        }
        int index = this.m_pos.getIndex();
        if (this.matches(":") && (name = this.parseName()) != null) {
            if (name.startsWith("[OUT]")) {
                return new ValueOutputToken(this.m_str.substring(index, this.m_pos.getIndex()), name.substring(5), false);
            }
            return new ValueInputToken(this.m_str.substring(index, this.m_pos.getIndex()), name, false, false);
        }
        this.m_pos.setIndex(index);
        return null;
    }

    private String parseName() {
        if (LOG.isTraceEnabled()) {
            this.trace("parseName");
        }
        int index = this.m_pos.getIndex();
        while (this.parseNameChar()) {
        }
        if (this.m_pos.getIndex() > index) {
            return this.m_str.substring(index, this.m_pos.getIndex());
        }
        this.m_pos.setIndex(index);
        return null;
    }

    private String parseNumber() {
        if (LOG.isTraceEnabled()) {
            this.trace("parseNumber");
        }
        int index = this.m_pos.getIndex();
        while (this.parseNumberChar()) {
        }
        if (this.m_pos.getIndex() > index) {
            return this.m_str.substring(index, this.m_pos.getIndex());
        }
        this.m_pos.setIndex(index);
        return null;
    }

    private boolean parseChar() {
        int index;
        if (LOG.isTraceEnabled()) {
            this.trace("parseChar");
        }
        if ((index = this.m_pos.getIndex()) < this.m_str.length()) {
            this.m_pos.setIndex(index + 1);
            return true;
        }
        return false;
    }

    private boolean matches(String m) {
        int len;
        int index = this.m_pos.getIndex();
        if (index + (len = m.length()) <= this.m_str.length() && m.equalsIgnoreCase(this.m_str.substring(index, index + len))) {
            this.m_pos.setIndex(index + len);
            return true;
        }
        return false;
    }

    private boolean parseTextChar() {
        int len;
        int index;
        if (LOG.isTraceEnabled()) {
            this.trace("parseTextChar");
        }
        if ((index = this.m_pos.getIndex()) < (len = this.m_str.length()) && this.m_str.charAt(index) != '\'') {
            this.m_pos.setIndex(index + 1);
            return true;
        }
        if (index + 1 < len && this.m_str.charAt(index + 1) == '\'') {
            this.m_pos.setIndex(index + 2);
            return true;
        }
        return false;
    }

    private boolean parseNumberChar() {
        int len;
        int index;
        if (LOG.isTraceEnabled()) {
            this.trace("parseNumberChar");
        }
        if ((index = this.m_pos.getIndex()) < (len = this.m_str.length()) && Character.isDigit(this.m_str.charAt(index))) {
            this.m_pos.setIndex(index + 1);
            return true;
        }
        return false;
    }

    private boolean parseNameChar() {
        int len;
        int index;
        if (LOG.isTraceEnabled()) {
            this.trace("parseNameChar");
        }
        if ((index = this.m_pos.getIndex()) < (len = this.m_str.length()) && NAME_MAP.indexOf(this.m_str.charAt(index)) >= 0) {
            this.m_pos.setIndex(index + 1);
            return true;
        }
        return false;
    }

    private boolean peekNameChar() {
        int len;
        int index;
        if (LOG.isTraceEnabled()) {
            this.trace("parseNameChar");
        }
        return (index = this.m_pos.getIndex()) < (len = this.m_str.length()) && NAME_MAP.indexOf(this.m_str.charAt(index)) >= 0;
    }

    private boolean parseWhitespace(int nunRequired) {
        int index = this.m_pos.getIndex();
        int len = this.m_str.length();
        int i = index;
        while (i < len && S_MAP.indexOf(this.m_str.charAt(i)) >= 0) {
            ++i;
        }
        if (i - index >= nunRequired) {
            this.m_pos.setIndex(i);
            return true;
        }
        return false;
    }

    private void trace(String s) {
        int len = this.m_str.length();
        int i0 = Math.min(this.m_pos.getIndex(), len - 1);
        int i1 = Math.min(i0 + 32, len);
        LOG.trace("# " + s + " at:" + this.m_str.substring(i0, i1));
    }

    private void addTextTokenUntil(int endIndex) {
        if (endIndex > this.m_lastTokenEndIndex) {
            this.m_tokenList.add(new TextToken(this.m_str.substring(this.m_lastTokenEndIndex, endIndex)));
        }
        this.m_lastTokenEndIndex = endIndex;
    }

    private void addToken(IToken t, int endIndex) {
        this.m_tokenList.add(t);
        this.m_lastTokenEndIndex = endIndex;
    }
}

