/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.http.servletfilter.internal;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.http.servletfilter.internal.Activator;
import org.osgi.framework.Bundle;

public class FilterConfigImpl
implements FilterConfig {
    private ServletContext m_servletContext;
    private final IConfigurationElement m_serviceElement;
    private final Bundle m_definingBundle;
    private final HashMap<String, String> m_initParams;
    private final String m_alias;
    private Filter m_filter;
    private boolean m_destroyed;
    private final String m_equalityCode;

    public FilterConfigImpl(String alias, IConfigurationElement serviceElement, Bundle definingBundle) {
        this.m_alias = alias;
        this.m_serviceElement = serviceElement;
        this.m_definingBundle = definingBundle;
        String className = serviceElement.getAttribute("class");
        this.m_initParams = new HashMap();
        IConfigurationElement[] iConfigurationElementArray = serviceElement.getChildren("init-param");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement initParam = iConfigurationElementArray[n2];
            String name = initParam.getAttribute("name");
            String value = initParam.getAttribute("value");
            this.m_initParams.put(name, value);
            ++n2;
        }
        this.m_equalityCode = String.valueOf(this.m_definingBundle.getSymbolicName()) + "/" + className + alias;
    }

    public boolean isFiltering(String servletPath) {
        return servletPath != null && servletPath.startsWith(this.m_alias);
    }

    public Filter getFilter(ServletContext servletContext) throws ServletException {
        if (this.m_filter == null && !this.m_destroyed) {
            try {
                this.m_servletContext = servletContext;
                this.m_filter = (Filter)this.m_serviceElement.createExecutableExtension("class");
                if (Activator.DEBUG) {
                    Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.scout.http.servletfilter", "ServletFilterConfig: init " + this.m_filter.getClass().getSimpleName()));
                }
                this.m_filter.init((FilterConfig)this);
            }
            catch (Throwable t) {
                String className = this.m_serviceElement.getAttribute("class");
                throw new ServletException("init " + className, t);
            }
        }
        return this.m_filter;
    }

    public void destroy() {
        if (this.m_filter != null) {
            try {
                try {
                    if (Activator.DEBUG) {
                        Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.scout.http.servletfilter", "ServletFilterConfig: destroy " + this.m_filter.getClass().getSimpleName()));
                    }
                    this.m_filter.destroy();
                }
                catch (Throwable t) {
                    String className = this.m_serviceElement.getAttribute("class");
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.scout.http.servletfilter", "destroy " + className, t));
                    this.m_filter = null;
                    this.m_destroyed = true;
                }
            }
            finally {
                this.m_filter = null;
                this.m_destroyed = true;
            }
        }
    }

    public Bundle getDefiningBundle() {
        return this.m_definingBundle;
    }

    public int hashCode() {
        return this.m_equalityCode.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.m_equalityCode.equals(((FilterConfigImpl)o).m_equalityCode);
    }

    public String getFilterName() {
        String className = this.m_serviceElement.getAttribute("class");
        return className;
    }

    public String getInitParameter(String name) {
        return this.m_initParams.get(name);
    }

    public Enumeration getInitParameterNames() {
        return new Vector<String>(this.m_initParams.keySet()).elements();
    }

    public ServletContext getServletContext() {
        return this.m_servletContext;
    }

    public String toString() {
        return String.valueOf(this.getFilterName()) + "[" + this.m_alias + "]";
    }
}

