/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.services.operation;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.simple.operations.CreateSimpleNlsProjectOperation;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.method.MethodOverrideOperation;
import org.eclipse.scout.sdk.operation.service.ServiceNewOperation;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class CreateServiceNlsProjectOperation
implements IOperation {
    private IType m_superType;
    private IScoutBundle m_bundle;
    private String m_translationFolder;
    private String m_translationFilePrefix;
    private String m_serviceName;
    private String[] m_languages;

    public String getOperationName() {
        return "Create new NLS Service Project...";
    }

    public void validate() throws IllegalArgumentException {
        if (this.m_superType == null) {
            throw new IllegalArgumentException("super type not set.");
        }
        if (this.m_bundle == null) {
            throw new IllegalArgumentException("bundle not set.");
        }
        if (StringUtility.isNullOrEmpty((String)this.getTranslationFolder())) {
            throw new IllegalArgumentException("translation folder not set.");
        }
        if (StringUtility.isNullOrEmpty((String)this.getTranslationFilePrefix())) {
            throw new IllegalArgumentException("translation file prefix not set.");
        }
        if (StringUtility.isNullOrEmpty((String)this.getServiceName())) {
            throw new IllegalArgumentException("service name not set.");
        }
        if (this.m_languages == null || this.m_languages.length < 1) {
            throw new IllegalArgumentException("no languages set.");
        }
    }

    private void createLanguageFiles(IProgressMonitor monitor) throws CoreException {
        IFolder folder = this.getBundle().getProject().getFolder(this.getTranslationFolder());
        String[] stringArray = this.getLanguages();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String lang = stringArray[n2];
            CreateSimpleNlsProjectOperation.createLanguageFile((String)lang, (IFolder)folder, (String)this.getTranslationFilePrefix(), (IProgressMonitor)monitor);
            ++n2;
        }
    }

    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        this.getBundle().getProject().refreshLocal(2, monitor);
        this.createLanguageFiles(monitor);
        ServiceNewOperation serviceOp = new ServiceNewOperation();
        serviceOp.addServiceRegistrationBundle(this.getBundle());
        serviceOp.setImplementationBundle(this.getBundle());
        serviceOp.setServiceName(this.getServiceName());
        serviceOp.setServicePackageName(String.valueOf(this.getBundle().getProject().getName()) + ".services.common.text");
        serviceOp.setServiceSuperTypeSignature(Signature.createTypeSignature((String)this.getSuperType().getFullyQualifiedName(), (boolean)true));
        serviceOp.validate();
        serviceOp.run(monitor, workingCopyManager);
        MethodOverrideOperation methodOp = new MethodOverrideOperation(serviceOp.getCreatedServiceImplementation(), "getDynamicNlsBaseName", true);
        methodOp.setSimpleBody("return \"" + CreateSimpleNlsProjectOperation.getResourcePathString((String)this.getTranslationFolder(), (String)this.getTranslationFilePrefix()) + "\";");
        methodOp.validate();
        methodOp.run(monitor, workingCopyManager);
        this.getBundle().getScoutProject().clearNlsProjectCache();
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        this.m_superType = superType;
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public String getTranslationFolder() {
        return this.m_translationFolder;
    }

    public void setTranslationFolder(String translationFolder) {
        this.m_translationFolder = translationFolder;
    }

    public String getTranslationFilePrefix() {
        return this.m_translationFilePrefix;
    }

    public void setTranslationFilePrefix(String translationFilePrefix) {
        this.m_translationFilePrefix = translationFilePrefix;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    public void setLanguages(String[] languages) {
        this.m_languages = languages;
    }

    public String[] getLanguages() {
        return this.m_languages;
    }
}

