/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.simple.model.ws.nlsfile;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.simple.model.ws.nlsfile.AbstractNlsFile;

public class WorkspaceNlsFile
extends AbstractNlsFile {
    private IFile m_file;

    public WorkspaceNlsFile(IFile file) throws CoreException {
        super(file);
        this.m_file = file;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new P_NlsFileChangeListener(), 1);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    private class P_NlsFileChangeListener
    implements IResourceChangeListener {
        private P_NlsFileChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta d) {
                            IResource resource = d.getResource();
                            if (resource != null && resource.equals((Object)WorkspaceNlsFile.this.m_file) && WorkspaceNlsFile.this.m_file.exists()) {
                                WorkspaceNlsFile.this.parseInput(WorkspaceNlsFile.this.m_file);
                            }
                            return true;
                        }
                    });
                }
            }
            catch (CoreException e) {
                NlsCore.logWarning((Throwable)e);
            }
        }
    }
}

