/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.fields;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.internal.ui.fields.IInputChangedListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FileChooserField
extends Composite {
    private Text m_text;
    private Label m_label;
    private Button m_button;
    private String[] m_extendsionFilter;
    private String m_fileName;
    private String m_title;
    private List<IInputChangedListener<String>> m_focusOutListener = new LinkedList<IInputChangedListener<String>>();
    private List<IInputChangedListener<String>> m_modifyListener = new LinkedList<IInputChangedListener<String>>();

    public FileChooserField(Composite parent, String title) {
        super(parent, 0);
        this.m_title = title;
        this.createComponent(this);
    }

    protected void createComponent(Composite parent) {
        this.m_label = new Label(parent, 0);
        this.m_text = new Text(parent, 2048);
        this.m_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                for (IInputChangedListener listener : FileChooserField.this.m_modifyListener) {
                    listener.inputChanged(FileChooserField.this.m_text.getText());
                }
            }
        });
        this.m_text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                for (IInputChangedListener listener : FileChooserField.this.m_focusOutListener) {
                    listener.inputChanged(FileChooserField.this.m_text.getText());
                }
            }
        });
        this.m_button = new Button(parent, 0x800008);
        this.m_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileChooserField.this.showFileChooserDialog();
            }
        });
        this.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(40, 0);
        data.bottom = new FormAttachment(100, 0);
        this.m_label.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment((Control)this.m_label, 5);
        data.right = new FormAttachment((Control)this.m_button, -5);
        data.bottom = new FormAttachment(100, 0);
        this.m_text.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.m_button.setLayoutData((Object)data);
    }

    public void addInputChangedListener(int type, IInputChangedListener<String> listener) {
        if (type == 16) {
            this.m_focusOutListener.add(listener);
        } else if (type == 24) {
            this.m_modifyListener.add(listener);
        }
    }

    public void removeInputChangedListener(int type, IInputChangedListener<String> listener) {
        if (type == 16) {
            this.m_focusOutListener.remove(listener);
        } else if (type == 24) {
            this.m_modifyListener.remove(listener);
        }
    }

    public void setButtonImage(Image img) {
        this.m_button.setImage(img);
    }

    public Image getButtonImage() {
        return this.m_button.getImage();
    }

    public void setButtonText(String string) {
        this.m_button.setText(string);
    }

    public String getButtonText() {
        return this.m_button.getText();
    }

    public void setLabelText(String text) {
        this.m_label.setText(text);
    }

    public String getLabelText() {
        return this.m_label.getText();
    }

    public void setEditable(boolean editable) {
        this.m_text.setEditable(editable);
    }

    public void setInput(Object input) {
    }

    public String[] getExtendsionFilter() {
        return this.m_extendsionFilter;
    }

    public void setExtendsionFilter(String[] extendsionFilter) {
        this.m_extendsionFilter = extendsionFilter;
    }

    private void showFileChooserDialog() {
        String file;
        FileDialog dialog = new FileDialog(this.getShell());
        if (this.m_extendsionFilter != null) {
            dialog.setFilterExtensions(this.m_extendsionFilter);
        }
        dialog.setText(this.m_title);
        if (!StringUtility.isNullOrEmpty((String)this.getFileName())) {
            dialog.setFileName(this.getFileName());
        }
        if ((file = dialog.open()) != null) {
            this.setSelectedFile(file);
        }
    }

    private void setSelectedFile(String fileName) {
        this.m_text.setText(fileName);
        for (IInputChangedListener<String> listener : this.m_focusOutListener) {
            listener.inputChanged(fileName);
        }
        for (IInputChangedListener<String> listener : this.m_modifyListener) {
            listener.inputChanged(fileName);
        }
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    public String getFileName() {
        return this.m_fileName;
    }
}

