/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.model.workspace.project;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.nls.sdk.model.workspace.translationResource.ITranslationResource;

public class NlsResourceProvider {
    private Language[] m_languageOrder;
    private HashMap<Language, ITranslationResource> m_resourceMap = new HashMap();

    public NlsResourceProvider() {
        this.m_languageOrder = new Language[0];
    }

    public void addResource(ITranslationResource r) {
        Language language = r.getLanguage();
        if (this.m_resourceMap.containsKey(language)) {
            NlsCore.logWarning("language already exists!");
        } else {
            this.m_resourceMap.put(language, r);
            this.m_languageOrder = this.getOrderedLanguages(this.m_resourceMap.keySet());
        }
    }

    private Language[] getOrderedLanguages(Set<Language> languages) {
        TreeMap<CompositeObject, Language> orderedLanguages = new TreeMap<CompositeObject, Language>();
        for (Language l : languages) {
            int index = 3;
            if (l.equals(Language.LANGUAGE_KEY)) {
                index = 1;
            } else if (l.equals(Language.LANGUAGE_DEFAULT)) {
                index = 2;
            }
            orderedLanguages.put(new CompositeObject(new Object[]{index, l.getDispalyName()}), l);
        }
        return orderedLanguages.values().toArray(new Language[orderedLanguages.size()]);
    }

    public void remove(ITranslationResource r) {
        if (!this.m_resourceMap.containsValue(r)) {
            NlsCore.logWarning("trying to remove a non existing resource!");
        } else {
            this.m_resourceMap.remove(r.getLanguage());
            this.m_languageOrder = this.getOrderedLanguages(this.m_resourceMap.keySet());
        }
    }

    public ITranslationResource[] getSortedResources() {
        LinkedList<ITranslationResource> resources = new LinkedList<ITranslationResource>();
        Language[] languageArray = this.m_languageOrder;
        int n = this.m_languageOrder.length;
        int n2 = 0;
        while (n2 < n) {
            Language lang = languageArray[n2];
            resources.add(this.m_resourceMap.get(lang));
            ++n2;
        }
        return resources.toArray(new ITranslationResource[resources.size()]);
    }

    public ITranslationResource[] getResources() {
        return this.m_resourceMap.values().toArray(new ITranslationResource[this.m_resourceMap.size()]);
    }

    public ITranslationResource getResource(Language language) {
        return this.m_resourceMap.get(language);
    }

    public boolean containsResource(Language language) {
        return this.m_resourceMap.containsKey(language);
    }

    public Language[] getAllLanguages() {
        return this.m_languageOrder;
    }
}

