/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.extension;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.extension.AbstractImportExportWizard;
import org.eclipse.scout.nls.sdk.extension.WizardExtension;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.osgi.framework.Bundle;

public class NlsExportImportExtensionPoints {
    private static final NlsExportImportExtensionPoints instance = new NlsExportImportExtensionPoints();
    public static final String EXTENSION_POINT_ID_NLS_EXPORTER = "nlsExporter";
    public static final String EXTENSION_POINT_ID_NLS_IMPORTER = "nlsImporter";
    private HashMap<String, WizardExtension[]> m_extensions = new HashMap();

    private NlsExportImportExtensionPoints() {
        this.init();
    }

    private void init() {
        this.m_extensions.put(EXTENSION_POINT_ID_NLS_EXPORTER, this.loadExtensionPoints(EXTENSION_POINT_ID_NLS_EXPORTER));
        this.m_extensions.put(EXTENSION_POINT_ID_NLS_IMPORTER, this.loadExtensionPoints(EXTENSION_POINT_ID_NLS_IMPORTER));
    }

    private WizardExtension[] loadExtensionPoints(String id) {
        IExtension[] extensions;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        ArrayList<WizardExtension> wizardExtensions = new ArrayList<WizardExtension>();
        IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.nls.sdk", id);
        IExtension[] iExtensionArray = extensions = xp.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    WizardExtension wizardExt = new WizardExtension();
                    String attWizard = element.getAttribute("wizard");
                    if (!StringUtility.isNullOrEmpty((String)attWizard)) {
                        Bundle contributerBundle = Platform.getBundle((String)extension.getNamespaceIdentifier());
                        Class wizard = contributerBundle.loadClass(attWizard);
                        if (!AbstractImportExportWizard.class.isAssignableFrom(wizard)) {
                            NlsCore.logError("extension '" + extension.getExtensionPointUniqueIdentifier() + "' has a wizard not instance of '" + AbstractImportExportWizard.class.getName() + "'. Ignoring extension.");
                        } else {
                            wizardExt.setWizard(wizard);
                            String attName = element.getAttribute("name");
                            if (!StringUtility.isNullOrEmpty((String)attName)) {
                                wizardExt.setName(attName);
                                wizardExtensions.add(wizardExt);
                            }
                        }
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    NlsCore.logError("could not create an executable extension of point '" + extension.getExtensionPointUniqueIdentifier() + "'.");
                }
                ++n4;
            }
            ++n2;
        }
        return wizardExtensions.toArray(new WizardExtension[wizardExtensions.size()]);
    }

    public static WizardExtension[] getExtensions(String extensionPointId) {
        return instance.getExtensionsImpl(extensionPointId);
    }

    private WizardExtension[] getExtensionsImpl(String extensionPointId) {
        return this.m_extensions.get(extensionPointId);
    }
}

