/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.ui.action;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.NlsEntryModifyDialog;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.NlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.nls.sdk.ui.action.AbstractWorkspaceAction;
import org.eclipse.swt.widgets.Display;

public class NlsEntryModifyAction
extends AbstractWorkspaceAction {
    private NlsEntry m_entry;
    private final INlsProject m_project;

    public NlsEntryModifyAction(INlsEntry entry, INlsProject project) {
        super("Modify Entry...", true);
        this.m_entry = new NlsEntry(entry);
        if (this.m_entry == null) {
            this.m_entry = new NlsEntry("", project);
        }
        this.m_project = project;
        this.setImageDescriptor(NlsCore.getImageDescriptor("text"));
    }

    @Override
    protected void execute(IProgressMonitor monitor) {
        if (this.getEntry() != null) {
            this.m_project.updateRow(this.getEntry(), monitor);
        }
    }

    @Override
    protected boolean interactWithUi() {
        NlsEntryModifyDialog dialog = new NlsEntryModifyDialog(Display.getDefault().getActiveShell(), this.m_entry, this.m_project);
        this.m_entry = dialog.show();
        return this.m_entry != null;
    }

    public NlsEntry getEntry() {
        return this.m_entry;
    }
}

