/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.calendar;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.DateUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarComponent;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarEvent;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarItemConflict;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarListener;
import org.eclipse.scout.rt.client.ui.basic.calendar.DateTimeFormatFactory;
import org.eclipse.scout.rt.client.ui.basic.calendar.ICalendar;
import org.eclipse.scout.rt.client.ui.basic.calendar.ICalendarUIFacade;
import org.eclipse.scout.rt.client.ui.basic.calendar.provider.ICalendarItemProvider;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarItem;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractCalendar
extends AbstractPropertyObserver
implements ICalendar {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractCalendar.class);
    private boolean m_initialized;
    private IMenu[] m_menus;
    private ICalendarItemProvider[] m_providers;
    private final HashMap<Class<? extends ICalendarItemProvider>, Collection<CalendarComponent>> m_componentsByProvider;
    private ICalendarUIFacade m_uiFacade;
    private int m_calendarChanging;
    private final DateTimeFormatFactory m_dateTimeFormatFactory;
    private ArrayList<CalendarEvent> m_calendarEventBuffer = new ArrayList();
    private final EventListenerList m_listenerList = new EventListenerList();

    public AbstractCalendar() {
        this(true);
    }

    public AbstractCalendar(boolean callInitializer) {
        this.m_dateTimeFormatFactory = new DateTimeFormatFactory();
        this.m_componentsByProvider = new HashMap();
        if (callInitializer) {
            this.initConfig();
        }
    }

    protected void callInitializer() {
        if (!this.m_initialized) {
            this.initConfig();
            this.m_initialized = true;
        }
    }

    @ConfigProperty(value="TEXT")
    @Order(value=10.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredTitle() {
        return null;
    }

    private Class<? extends ICalendarItemProvider>[] getConfiguredProducers() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])dca, ICalendarItemProvider.class);
    }

    private Class<? extends IMenu>[] getConfiguredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])dca, IMenu.class);
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execInitCalendar() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=15.0)
    protected void execDisposeCalendar() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execFilterCalendarItems(Set<Class<? extends ICalendarItemProvider>> changedProviderTypes, Map<Class<? extends ICalendarItemProvider>, Collection<CalendarComponent>> componentsByProvider) {
    }

    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        this.setTitle(this.getConfiguredTitle());
        this.setSelectedDate(new Date());
        ArrayList<IMenu> menuList = new ArrayList<IMenu>();
        Class<? extends IMenu>[] ma = this.getConfiguredMenus();
        int i = 0;
        while (i < ma.length) {
            try {
                IMenu menu = (IMenu)ConfigurationUtility.newInnerInstance((Object)this, ma[i]);
                menuList.add(menu);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
            ++i;
        }
        try {
            this.injectMenusInternal(menuList);
        }
        catch (Exception e) {
            LOG.error("error occured while dynamically contributing menus.", (Throwable)e);
        }
        this.m_menus = menuList.toArray(new IMenu[0]);
        ArrayList<ICalendarItemProvider> producerList = new ArrayList<ICalendarItemProvider>();
        Class<? extends ICalendarItemProvider>[] pa = this.getConfiguredProducers();
        int i2 = 0;
        while (i2 < pa.length) {
            try {
                ICalendarItemProvider producer = (ICalendarItemProvider)ConfigurationUtility.newInnerInstance((Object)this, pa[i2]);
                producerList.add(producer);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
            ++i2;
        }
        ICalendarItemProvider[] iCalendarItemProviderArray = this.m_providers = producerList.toArray(new ICalendarItemProvider[0]);
        int n = this.m_providers.length;
        int n2 = 0;
        while (n2 < n) {
            final ICalendarItemProvider p = iCalendarItemProviderArray[n2];
            p.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("items")) {
                        AbstractCalendar.this.updateComponentsInternal(new ICalendarItemProvider[]{p});
                    } else if (e.getPropertyName().equals("loadInProgress")) {
                        AbstractCalendar.this.updateLoadInProgressInternal();
                    }
                }
            });
            ++n2;
        }
    }

    protected void injectMenusInternal(List<IMenu> menuList) {
    }

    @Override
    public void initCalendar() throws ProcessingException {
        this.execInitCalendar();
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("viewRange")) {
                    AbstractCalendar.this.updateComponentsInternal(AbstractCalendar.this.m_providers);
                }
            }
        });
        this.updateComponentsInternal(this.m_providers);
    }

    private void disposeCalendarInternal() {
        ICalendarItemProvider[] iCalendarItemProviderArray = this.m_providers;
        int n = this.m_providers.length;
        int n2 = 0;
        while (n2 < n) {
            ICalendarItemProvider p = iCalendarItemProviderArray[n2];
            try {
                p.disposeProvider();
            }
            catch (Throwable t) {
                LOG.warn(p.getClass().getName(), t);
            }
            ++n2;
        }
    }

    @Override
    public void disposeCalendar() {
        this.disposeCalendarInternal();
        try {
            this.execDisposeCalendar();
        }
        catch (Throwable t) {
            LOG.warn(this.getClass().getName(), t);
        }
    }

    @Override
    public String getTitle() {
        return this.propertySupport.getPropertyString("title");
    }

    @Override
    public void setTitle(String s) {
        this.propertySupport.setPropertyString("title", s);
    }

    @Override
    public boolean isLoadInProgress() {
        return this.propertySupport.getPropertyBool("loadInProgress");
    }

    @Override
    public void setLoadInProgress(boolean b) {
        this.propertySupport.setPropertyBool("loadInProgress", b);
    }

    @Override
    public boolean isCalendarChanging() {
        return this.m_calendarChanging > 0;
    }

    @Override
    public void setCalendarChanging(boolean b) {
        if (b) {
            ++this.m_calendarChanging;
            if (this.m_calendarChanging == 1) {
                this.propertySupport.setPropertiesChanging(true);
            }
        } else if (this.m_calendarChanging > 0) {
            --this.m_calendarChanging;
            if (this.m_calendarChanging == 0) {
                try {
                    this.processChangeBuffer();
                }
                finally {
                    this.propertySupport.setPropertiesChanging(false);
                }
            }
        }
    }

    private void processChangeBuffer() {
        CalendarEvent[] a = this.m_calendarEventBuffer.toArray(new CalendarEvent[0]);
        this.m_calendarEventBuffer = new ArrayList();
        HashSet<Integer> types = new HashSet<Integer>();
        LinkedList<CalendarEvent> coalescedEvents = new LinkedList<CalendarEvent>();
        int i = a.length - 1;
        while (i >= 0) {
            switch (a[i].getType()) {
                case 20: {
                    if (types.contains(a[i].getType())) break;
                    coalescedEvents.add(0, a[i]);
                    types.add(a[i].getType());
                    break;
                }
                default: {
                    coalescedEvents.add(0, a[i]);
                }
            }
            --i;
        }
        this.fireCalendarEventBatchInternal(coalescedEvents.toArray(new CalendarEvent[0]));
    }

    public IMenu[] getMenus() {
        return this.m_menus;
    }

    @Override
    public int getDisplayMode() {
        return this.propertySupport.getPropertyInt("displayMode");
    }

    @Override
    public void setDisplayMode(int mode) {
        this.propertySupport.setPropertyInt("displayMode", mode);
    }

    @Override
    public boolean isDisplayCondensed() {
        return this.propertySupport.getPropertyBool("displayCondensed");
    }

    @Override
    public void setDisplayCondensed(boolean condensed) {
        this.propertySupport.setPropertyBool("displayCondensed", condensed);
    }

    @Override
    public Date[] getViewRange() {
        Date[] a = (Date[])this.propertySupport.getProperty("viewRange");
        if (a == null) {
            a = new Date[2];
        }
        return a;
    }

    @Override
    public void setViewRange(Date minDate, Date maxDate) {
        this.propertySupport.setProperty("viewRange", (Object)new Date[]{minDate, maxDate});
    }

    @Override
    public Date getSelectedDate() {
        return (Date)this.propertySupport.getProperty("selectedDate");
    }

    @Override
    public void setSelectedDate(Date d) {
        this.propertySupport.setProperty("selectedDate", (Object)d);
    }

    @Override
    public CalendarComponent getSelectedComponent() {
        return (CalendarComponent)this.propertySupport.getProperty("selectedComponent");
    }

    @Override
    public <T extends ICalendarItem> T getSelectedItem(Class<T> c) {
        CalendarComponent comp = this.getSelectedComponent();
        if (comp != null && comp.getItem() != null && c.isAssignableFrom(comp.getItem().getClass())) {
            return (T)comp.getItem();
        }
        return null;
    }

    @Override
    public void setSelectedComponent(CalendarComponent comp) {
        comp = this.resolveComponent(comp);
        this.propertySupport.setProperty("selectedComponent", (Object)comp);
    }

    private CalendarComponent resolveComponent(CalendarComponent comp) {
        return comp;
    }

    @Override
    public DateTimeFormatFactory getDateTimeFormatFactory() {
        return this.m_dateTimeFormatFactory;
    }

    @Override
    public CalendarComponent[] getComponents() {
        CalendarComponent[] a = (CalendarComponent[])this.propertySupport.getProperty("components");
        if (a == null) {
            a = new CalendarComponent[]{};
        }
        return a;
    }

    private void updateComponentsInternal(ICalendarItemProvider[] changedProviders) {
        Date[] d = this.getViewRange();
        if (d[0] != null && d[1] != null) {
            ICalendarItemProvider[] iCalendarItemProviderArray = changedProviders;
            int n = changedProviders.length;
            int n2 = 0;
            while (n2 < n) {
                ICalendarItemProvider p = iCalendarItemProviderArray[n2];
                LinkedList<CalendarComponent> components = new LinkedList<CalendarComponent>();
                ICalendarItem[] iCalendarItemArray = p.getItems(d[0], d[1]);
                int n3 = iCalendarItemArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICalendarItem item = iCalendarItemArray[n4];
                    Cell cell = new Cell();
                    p.decorateCell(cell, item);
                    components.add(new CalendarComponent(this, p, item, cell));
                    ++n4;
                }
                this.m_componentsByProvider.put(p.getClass(), components);
                ++n2;
            }
            HashSet<Class<? extends ICalendarItemProvider>> providerTypes = new HashSet<Class<? extends ICalendarItemProvider>>();
            int i = 0;
            while (i < changedProviders.length) {
                providerTypes.add(changedProviders[i].getClass());
                ++i;
            }
            this.execFilterCalendarItems(providerTypes, this.m_componentsByProvider);
            TreeMap<CompositeObject, CalendarComponent> sortMap = new TreeMap<CompositeObject, CalendarComponent>();
            int index = 0;
            for (Collection<CalendarComponent> c : this.m_componentsByProvider.values()) {
                for (CalendarComponent comp : c) {
                    sortMap.put(new CompositeObject(new Object[]{comp.getFromDate(), index++}), comp);
                }
            }
            this.propertySupport.setProperty("components", (Object)sortMap.values().toArray(new CalendarComponent[0]));
            this.setSelectedComponent(this.getSelectedComponent());
        }
    }

    @Override
    public Object getContainer() {
        return this.propertySupport.getProperty("container");
    }

    public void setContainerInternal(Object container) {
        this.propertySupport.setProperty("container", container);
    }

    public Collection<CalendarItemConflict> findConflictingItems(Map<Class<? extends ICalendarItemProvider>, Collection<CalendarComponent>> componentsByProvider, Class<? extends ICalendarItemProvider> ... providerTypes) {
        if (providerTypes != null && providerTypes.length >= 2) {
            HashMap<String, ArrayList<CalendarComponent>> classificationMap = new HashMap<String, ArrayList<CalendarComponent>>();
            int i = 0;
            while (i < providerTypes.length) {
                Collection<CalendarComponent> a = componentsByProvider.get(providerTypes[i]);
                if (a != null) {
                    for (CalendarComponent comp : a) {
                        String key = StringUtility.emptyIfNull((Object)comp.getItem().getSubject()).toLowerCase().trim();
                        ArrayList<CalendarComponent> list = (ArrayList<CalendarComponent>)classificationMap.get(key);
                        if (list == null) {
                            list = new ArrayList<CalendarComponent>();
                            classificationMap.put(key, list);
                        }
                        list.add(comp);
                    }
                }
                ++i;
            }
            ArrayList<CalendarItemConflict> conflicts = new ArrayList<CalendarItemConflict>();
            for (Map.Entry e : classificationMap.entrySet()) {
                if (((List)e.getValue()).size() < 2) continue;
                List list = (List)e.getValue();
                HashMap groups = new HashMap();
                for (CalendarComponent c : list) {
                    if (groups.containsKey(c.getProvider())) {
                        ((ArrayList)groups.get(c.getProvider())).add(c);
                        continue;
                    }
                    ArrayList<CalendarComponent> tmp = new ArrayList<CalendarComponent>();
                    tmp.add(c);
                    groups.put(c.getProvider(), tmp);
                }
                ArrayList<CalendarComponent> groupComp = new ArrayList<CalendarComponent>();
                for (ArrayList g : groups.values()) {
                    if (g.size() <= 1) continue;
                    groupComp.addAll(g);
                }
                if (groupComp.size() == 0) {
                    groupComp.add((CalendarComponent)list.get(0));
                }
                for (CalendarComponent ref : groupComp) {
                    ArrayList<CalendarComponent> matchList = new ArrayList<CalendarComponent>();
                    double matchSum = 0.0;
                    matchList.add(ref);
                    for (CalendarComponent test : list) {
                        if (ref == test || test.getProvider() == ref.getProvider() || !DateUtility.intersects((Date)test.getFromDate(), (Date)test.getToDate(), (Date)ref.getFromDate(), (Date)ref.getToDate())) continue;
                        matchList.add(test);
                        double minOfStart = Math.min(test.getFromDate().getTime(), ref.getFromDate().getTime());
                        double maxOfStart = Math.max(test.getFromDate().getTime(), ref.getFromDate().getTime());
                        double minOfEnd = Math.min(test.getToDate().getTime(), ref.getToDate().getTime());
                        double maxOfEnd = Math.max(test.getToDate().getTime(), ref.getToDate().getTime());
                        if (maxOfEnd - minOfStart > 1.0E-6) {
                            matchSum += (minOfEnd - maxOfStart) / (maxOfEnd - minOfStart);
                            continue;
                        }
                        matchSum += 1.0;
                    }
                    if (matchList.size() < 2) continue;
                    conflicts.add(new CalendarItemConflict(componentsByProvider, matchList, matchSum / (double)(matchList.size() - 1)));
                }
            }
            return conflicts;
        }
        return Collections.emptyList();
    }

    private void updateLoadInProgressInternal() {
        boolean b = false;
        ICalendarItemProvider[] iCalendarItemProviderArray = this.m_providers;
        int n = this.m_providers.length;
        int n2 = 0;
        while (n2 < n) {
            ICalendarItemProvider p = iCalendarItemProviderArray[n2];
            if (p.isLoadInProgress()) {
                b = true;
                break;
            }
            ++n2;
        }
        this.setLoadInProgress(b);
    }

    @Override
    public void reloadCalendarItems() {
        ICalendarItemProvider[] iCalendarItemProviderArray = this.m_providers;
        int n = this.m_providers.length;
        int n2 = 0;
        while (n2 < n) {
            ICalendarItemProvider p = iCalendarItemProviderArray[n2];
            p.reloadProvider();
            ++n2;
        }
    }

    private IMenu[] fireComponentPopup(CalendarComponent comp) {
        if (comp != null) {
            CalendarEvent e = new CalendarEvent(this, 30, comp);
            this.addComponentPopupMenus(e, comp);
            this.fireCalendarEventInternal(e);
            return e.getPopupMenus();
        }
        return new IMenu[0];
    }

    private void addComponentPopupMenus(CalendarEvent e, CalendarComponent comp) {
        IMenu menu;
        IMenu[] iMenuArray = this.getMenus();
        int n = iMenuArray.length;
        int n2 = 0;
        while (n2 < n) {
            menu = iMenuArray[n2];
            if (menu.isSingleSelectionAction()) {
                menu.prepareAction();
                if (menu.isVisible()) {
                    e.addPopupMenu(menu);
                }
            }
            ++n2;
        }
        iMenuArray = comp.getProvider().getMenus();
        n = iMenuArray.length;
        n2 = 0;
        while (n2 < n) {
            menu = iMenuArray[n2];
            if (menu.isSingleSelectionAction()) {
                menu.prepareAction();
                if (menu.isVisible()) {
                    e.addPopupMenu(menu);
                }
            }
            ++n2;
        }
    }

    private IMenu[] fireNewPopup() {
        CalendarEvent e = new CalendarEvent(this, 31);
        this.addNewPopupMenus(e);
        this.fireCalendarEventInternal(e);
        return e.getPopupMenus();
    }

    private void addNewPopupMenus(CalendarEvent e) {
        IPropertyObserver[] iPropertyObserverArray = this.getMenus();
        int n = iPropertyObserverArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMenu menu = iPropertyObserverArray[n2];
            if (!menu.isSingleSelectionAction()) {
                menu.prepareAction();
                if (menu.isVisible()) {
                    e.addPopupMenu(menu);
                }
            }
            ++n2;
        }
        iPropertyObserverArray = this.m_providers;
        n = this.m_providers.length;
        n2 = 0;
        while (n2 < n) {
            IPropertyObserver p = iPropertyObserverArray[n2];
            IMenu[] iMenuArray = p.getMenus();
            int n3 = iMenuArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IMenu menu = iMenuArray[n4];
                if (!menu.isSingleSelectionAction()) {
                    menu.prepareAction();
                    if (menu.isVisible()) {
                        e.addPopupMenu(menu);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public void addCalendarListener(CalendarListener listener) {
        this.m_listenerList.add(CalendarListener.class, (EventListener)listener);
    }

    @Override
    public void removeCalendarListener(CalendarListener listener) {
        this.m_listenerList.remove(CalendarListener.class, (EventListener)listener);
    }

    private void fireCalendarComponentAction() {
        CalendarComponent comp = this.getSelectedComponent();
        if (comp != null) {
            try {
                comp.getProvider().onItemAction(comp.getItem());
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
            this.fireCalendarEventInternal(new CalendarEvent(this, 20, comp));
        }
    }

    private void fireCalendarEventInternal(CalendarEvent e) {
        if (this.isCalendarChanging()) {
            this.m_calendarEventBuffer.add(e);
        } else {
            EventListener[] listeners = this.m_listenerList.getListeners(CalendarListener.class);
            if (listeners != null && listeners.length > 0) {
                int i = 0;
                while (i < listeners.length) {
                    ((CalendarListener)listeners[i]).calendarChanged(e);
                    ++i;
                }
            }
        }
    }

    private void fireCalendarEventBatchInternal(CalendarEvent[] batch) {
        if (this.isCalendarChanging()) {
            LOG.error("Illegal State: firing a event batch while calendar is changing");
        } else {
            EventListener[] listeners = this.m_listenerList.getListeners(CalendarListener.class);
            if (listeners != null && listeners.length > 0) {
                int i = 0;
                while (i < listeners.length) {
                    ((CalendarListener)listeners[i]).calendarChangedBatch(batch);
                    ++i;
                }
            }
        }
    }

    @Override
    public ICalendarUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    private class P_UIFacade
    implements ICalendarUIFacade {
        private int m_uiProcessorCount = 0;

        private P_UIFacade() {
        }

        protected void pushUIProcessor() {
            ++this.m_uiProcessorCount;
        }

        protected void popUIProcessor() {
            --this.m_uiProcessorCount;
        }

        @Override
        public boolean isUIProcessing() {
            return this.m_uiProcessorCount > 0;
        }

        @Override
        public void setSelectionFromUI(Date d, CalendarComponent comp) {
            try {
                this.pushUIProcessor();
                AbstractCalendar.this.setSelectedDate(d);
                AbstractCalendar.this.setSelectedComponent(comp);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void setVisibleRangeFromUI(Date minDate, Date maxDate) {
            try {
                this.pushUIProcessor();
                AbstractCalendar.this.setViewRange(minDate, maxDate);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireReloadFromUI() {
            try {
                this.pushUIProcessor();
                AbstractCalendar.this.reloadCalendarItems();
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public IMenu[] fireComponentPopupFromUI() {
            try {
                this.pushUIProcessor();
                IMenu[] iMenuArray = AbstractCalendar.this.fireComponentPopup(AbstractCalendar.this.getSelectedComponent());
                return iMenuArray;
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public IMenu[] fireNewPopupFromUI() {
            try {
                this.pushUIProcessor();
                IMenu[] iMenuArray = AbstractCalendar.this.fireNewPopup();
                return iMenuArray;
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireComponentActionFromUI() {
            try {
                this.pushUIProcessor();
                AbstractCalendar.this.fireCalendarComponentAction();
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireComponentMovedFromUI(CalendarComponent comp, Date newDate) {
            try {
                this.pushUIProcessor();
                comp = AbstractCalendar.this.resolveComponent(comp);
                if (comp != null) {
                    try {
                        comp.getProvider().onItemMoved(comp.getItem(), newDate);
                    }
                    catch (ProcessingException e) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                    }
                    catch (Throwable e) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", e));
                    }
                }
                AbstractCalendar.this.fireCalendarComponentAction();
            }
            finally {
                this.popUIProcessor();
            }
        }
    }
}

