/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.ProcessingStatus;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.holders.IHolder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.services.common.bookmark.internal.BookmarkUtility;
import org.eclipse.scout.rt.client.ui.DataChangeListener;
import org.eclipse.scout.rt.client.ui.action.ActionFinder;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.keystroke.KeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.tool.IToolButton;
import org.eclipse.scout.rt.client.ui.action.view.IViewButton;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeAdapter;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.desktop.ContributionCommand;
import org.eclipse.scout.rt.client.ui.desktop.DesktopEvent;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.IDesktopExtension;
import org.eclipse.scout.rt.client.ui.desktop.IDesktopUIFacade;
import org.eclipse.scout.rt.client.ui.desktop.navigation.INavigationHistoryService;
import org.eclipse.scout.rt.client.ui.desktop.outline.AbstractFormToolButton;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutlineTableForm;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.PrintDevice;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBoxEvent;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBoxListener;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractDesktop
extends AbstractPropertyObserver
implements IDesktop {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractDesktop.class);
    private final IDesktopExtension m_localDesktopExtension = new P_LocalDesktopExtension();
    private List<IDesktopExtension> m_desktopExtensions;
    private final EventListenerList m_listenerList = new EventListenerList();
    private final Map<Object, EventListenerList> m_dataChangeListenerList = new HashMap<Object, EventListenerList>();
    private final IDesktopUIFacade m_uiFacade;
    private IOutline[] m_availableOutlines;
    private IOutline m_outline;
    private boolean m_outlineChanging = false;
    private P_ActiveOutlineListener m_activeOutlineListener;
    private final P_ActivatedFormListener m_activatedFormListener;
    private final LinkedList<WeakReference<IForm>> m_lastActiveFormList;
    private ITable m_pageDetailTable;
    private IOutlineTableForm m_outlineTableForm;
    private boolean m_outlineTableFormVisible = true;
    private IForm m_pageDetailForm;
    private IForm m_pageSearchForm;
    private final ArrayList<IForm> m_viewStack = new ArrayList();
    private final ArrayList<IForm> m_dialogStack = new ArrayList();
    private final ArrayList<IMessageBox> m_messageBoxStack = new ArrayList();
    private IMenu[] m_menus;
    private IViewButton[] m_viewButtons;
    private IToolButton[] m_toolButtons;
    private boolean m_autoPrefixWildcardForTextSearch;
    private boolean m_desktopInited;
    private boolean m_trayVisible;

    public AbstractDesktop() {
        this.m_uiFacade = new P_UIFacade();
        this.m_activatedFormListener = new P_ActivatedFormListener();
        this.m_lastActiveFormList = new LinkedList();
        this.initConfig();
    }

    @ConfigProperty(value="TEXT")
    @Order(value=10.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredTitle() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=15.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredTrayVisible() {
        return false;
    }

    @ConfigProperty(value="OUTLINES")
    @Order(value=20.0)
    @ConfigPropertyValue(value="null")
    protected Class<? extends IOutline>[] getConfiguredOutlines() {
        return null;
    }

    private Class<? extends IAction>[] getConfiguredActions() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClasses((Class[])dca, IAction.class);
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execInit() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=12.0)
    protected void execOpened() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=15.0)
    protected void execClosing() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execGuiAttached() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=25.0)
    protected void execGuiDetached() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=30.0)
    protected void execOutlineChanged(IOutline oldOutline, IOutline newOutline) throws ProcessingException {
    }

    @Order(value=40.0)
    @ConfigOperation
    protected void execPageSearchFormChanged(IForm oldForm, IForm newForm) throws ProcessingException {
        if (oldForm != null) {
            this.removeForm(oldForm);
        }
        if (newForm != null) {
            GridData gd = newForm.getRootGroupBox().getGridData();
            if (gd.weightY <= 0.0) {
                gd.weightY = 0.0;
                newForm.getRootGroupBox().setGridDataInternal(gd);
            }
            this.addForm(newForm);
        }
    }

    @Order(value=50.0)
    @ConfigOperation
    protected void execPageDetailFormChanged(IForm oldForm, IForm newForm) throws ProcessingException {
        if (oldForm != null) {
            this.removeForm(oldForm);
        }
        if (newForm != null) {
            this.addForm(newForm);
        }
    }

    @Order(value=60.0)
    @ConfigOperation
    protected void execPageDetailTableChanged(ITable oldTable, ITable newTable) throws ProcessingException {
        if (this.m_outlineTableForm != null) {
            this.m_outlineTableForm.setCurrentTable(newTable);
        }
        this.setOutlineTableFormVisible(newTable != null);
    }

    @Order(value=62.0)
    @ConfigOperation
    protected void execTablePageLoaded(IPageWithTable<?> tablePage) throws ProcessingException {
        ISearchForm searchForm = tablePage.getSearchFormInternal();
        if (searchForm != null) {
            searchForm.setMinimized(((ITable)tablePage.getTable()).getRowCount() > 0);
        }
    }

    @Order(value=70.0)
    @ConfigOperation
    protected void execAddTrayMenus(List<IMenu> menus) throws ProcessingException {
    }

    public IDesktopExtension[] getDesktopExtensions() {
        return this.m_desktopExtensions.toArray(new IDesktopExtension[this.m_desktopExtensions.size()]);
    }

    protected IDesktopExtension getLocalDesktopExtension() {
        return this.m_localDesktopExtension;
    }

    protected void initConfig() {
        int n;
        this.initDesktopExtensions();
        this.setTitle(this.getConfiguredTitle());
        this.setTrayVisible(this.getConfiguredTrayVisible());
        this.propertySupport.setProperty("keyStrokes", (Object)new IKeyStroke[0]);
        IDesktopExtension[] extensions = this.getDesktopExtensions();
        ArrayList<IOutline> outlineList = new ArrayList<IOutline>();
        if (extensions != null) {
            IDesktopExtension[] iDesktopExtensionArray = extensions;
            n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IDesktopExtension ext = iDesktopExtensionArray[n2];
                try {
                    ext.contributeOutlines(outlineList);
                }
                catch (Throwable t) {
                    LOG.error("contrinuting outlines by " + ext, t);
                }
                ++n2;
            }
        }
        this.m_availableOutlines = ConfigurationUtility.sortByOrder(outlineList).toArray(new IOutline[outlineList.size()]);
        ArrayList<IAction> actionList = new ArrayList<IAction>();
        if (extensions != null) {
            IDesktopExtension[] t = extensions;
            int n3 = extensions.length;
            n = 0;
            while (n < n3) {
                IDesktopExtension ext = t[n];
                try {
                    ext.contributeActions(actionList);
                }
                catch (Throwable t2) {
                    LOG.error("contrinuting actions by " + ext, t2);
                }
                ++n;
            }
        }
        for (IMenu menu : new ActionFinder().findActions(actionList, IMenu.class, true)) {
            if (menu.getKeyStroke() == null) continue;
            try {
                KeyStroke ks = new KeyStroke(menu.getKeyStroke(), menu);
                actionList.add(ks);
            }
            catch (Throwable t) {
                LOG.error(null, t);
            }
        }
        List<IMenu> menuList = new ActionFinder().findActions(actionList, IMenu.class, false);
        this.m_menus = ConfigurationUtility.sortByOrder(menuList).toArray(new IMenu[menuList.size()]);
        List<IViewButton> viewButtonList = new ActionFinder().findActions(actionList, IViewButton.class, false);
        this.m_viewButtons = ConfigurationUtility.sortByOrder(viewButtonList).toArray(new IViewButton[viewButtonList.size()]);
        List<IToolButton> toolButtonList = new ActionFinder().findActions(actionList, IToolButton.class, false);
        this.m_toolButtons = ConfigurationUtility.sortByOrder(toolButtonList).toArray(new IToolButton[toolButtonList.size()]);
        List<IKeyStroke> ksList = new ActionFinder().findActions(actionList, IKeyStroke.class, true);
        this.addKeyStrokes(ksList.toArray(new IKeyStroke[ksList.size()]));
        IOutline[] iOutlineArray = this.m_availableOutlines;
        int n4 = this.m_availableOutlines.length;
        int n5 = 0;
        while (n5 < n4) {
            IOutline o = iOutlineArray[n5];
            try {
                o.initTree();
            }
            catch (Throwable t) {
                LOG.error(null, t);
            }
            ++n5;
        }
    }

    private void initDesktopExtensions() {
        this.m_desktopExtensions = new LinkedList<IDesktopExtension>();
        this.m_desktopExtensions.add(this.getLocalDesktopExtension());
        this.injectDesktopExtensions(this.m_desktopExtensions);
    }

    protected void injectDesktopExtensions(List<IDesktopExtension> desktopExtensions) {
    }

    @Override
    public void initDesktop() throws ProcessingException {
        if (!this.m_desktopInited) {
            this.m_desktopInited = true;
            this.prepareAllMenus();
            IDesktopExtension[] extensions = this.getDesktopExtensions();
            if (extensions != null) {
                IDesktopExtension[] iDesktopExtensionArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IDesktopExtension ext = iDesktopExtensionArray[n2];
                    try {
                        ContributionCommand cc = ext.initDelegate();
                        if (cc == ContributionCommand.Stop) {
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        LOG.error("extension " + ext);
                    }
                    ++n2;
                }
            }
        }
    }

    @Override
    public boolean isTrayVisible() {
        return this.m_trayVisible;
    }

    @Override
    public void setTrayVisible(boolean b) {
        this.m_trayVisible = b;
    }

    @Override
    public boolean isShowing(IForm form) {
        for (IForm f : this.m_viewStack) {
            if (f != form) continue;
            return true;
        }
        for (IForm f : this.m_dialogStack) {
            if (f != form) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T extends IForm> T findForm(Class<T> formType) {
        ArrayList<IForm> list = new ArrayList<IForm>();
        list.addAll(this.m_viewStack);
        list.addAll(this.m_dialogStack);
        for (IForm f : list) {
            if (!formType.isAssignableFrom(f.getClass())) continue;
            return (T)f;
        }
        return null;
    }

    @Override
    public <T extends IOutline> T findOutline(Class<T> outlineType) {
        IOutline[] iOutlineArray = this.getAvailableOutlines();
        int n = iOutlineArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOutline o = iOutlineArray[n2];
            if (outlineType.isAssignableFrom(o.getClass())) {
                return (T)o;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public <T extends IAction> T findAction(Class<T> actionType) {
        return new ActionFinder().findAction(this.getActions(), actionType);
    }

    @Override
    public <T extends IToolButton> T findToolButton(Class<T> toolButtonType) {
        return (T)((IToolButton)this.findAction(toolButtonType));
    }

    @Override
    public <T extends IViewButton> T findViewButton(Class<T> viewButtonType) {
        return (T)((IViewButton)this.findAction(viewButtonType));
    }

    @Override
    public IFormField getFocusOwner() {
        return this.fireFindFocusOwner();
    }

    @Override
    public <T extends IForm> T[] findForms(Class<T> formType) {
        ArrayList<IForm> resultList = new ArrayList<IForm>();
        if (formType != null) {
            ArrayList<IForm> list = new ArrayList<IForm>();
            list.addAll(this.m_viewStack);
            list.addAll(this.m_dialogStack);
            for (IForm f : list) {
                if (!formType.isAssignableFrom(f.getClass())) continue;
                resultList.add(f);
            }
        }
        return resultList.toArray((IForm[])Array.newInstance(formType, resultList.size()));
    }

    @Override
    public <T extends IForm> T findLastActiveForm(Class<T> formType) {
        if (this.m_lastActiveFormList != null && formType != null) {
            for (WeakReference weakReference : this.m_lastActiveFormList) {
                if (weakReference.get() == null || !formType.isAssignableFrom(((IForm)weakReference.get()).getClass())) continue;
                return (T)((IForm)weakReference.get());
            }
        }
        return null;
    }

    @Override
    public <T extends IMenu> T getMenu(Class<? extends T> searchType) {
        return (T)((IMenu)new ActionFinder().findAction(this.getMenus(), searchType));
    }

    @Override
    public IForm[] getViewStack() {
        return this.m_viewStack.toArray(new IForm[this.m_viewStack.size()]);
    }

    @Override
    public IForm[] getDialogStack() {
        return this.m_dialogStack.toArray(new IForm[this.m_dialogStack.size()]);
    }

    @Override
    public IForm[] getSimilarViewForms(IForm form) {
        ArrayList<IForm> forms = new ArrayList<IForm>(3);
        try {
            if (form != null && form.computeExclusiveKey() != null) {
                Object originalKey = form.computeExclusiveKey();
                for (IForm f : this.m_viewStack) {
                    Object candidateKey = f.computeExclusiveKey();
                    if (this.getPageDetailForm() == f || this.getPageSearchForm() == f || candidateKey == null || originalKey == null) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("form: " + candidateKey + " vs " + originalKey);
                    }
                    if (!f.getClass().getName().equals(form.getClass().getName()) || !originalKey.equals(candidateKey)) continue;
                    forms.add(f);
                }
            }
        }
        catch (ProcessingException e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
        return forms.toArray(new IForm[forms.size()]);
    }

    @Override
    public void ensureViewStackVisible() {
        IForm[] viewStack;
        IForm[] iFormArray = viewStack = this.getViewStack();
        int n = viewStack.length;
        int n2 = 0;
        while (n2 < n) {
            IForm form = iFormArray[n2];
            this.ensureVisible(form);
            ++n2;
        }
    }

    @Override
    public void ensureVisible(IForm form) {
        if (form != null && (this.m_viewStack.contains(form) || this.m_dialogStack.contains(form))) {
            this.fireFormEnsureVisible(form);
        }
    }

    @Override
    public void addForm(IForm form) {
        IDesktopExtension[] extensions = this.getDesktopExtensions();
        if (extensions != null) {
            Holder formHolder = new Holder(IForm.class, (Object)form);
            IDesktopExtension[] iDesktopExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IDesktopExtension ext = iDesktopExtensionArray[n2];
                try {
                    ContributionCommand cc = ext.customFormModificationDelegate((IHolder<IForm>)formHolder);
                    if (cc == ContributionCommand.Stop) {
                        break;
                    }
                }
                catch (ProcessingException e) {
                    formHolder.setValue((Object)form);
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                }
                catch (Throwable t) {
                    formHolder.setValue((Object)form);
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Formmodification error: " + form, t));
                }
                ++n2;
            }
            form = (IForm)formHolder.getValue();
        }
        if (form != null) {
            switch (form.getDisplayHint()) {
                case 0: 
                case 10: 
                case 12: {
                    if (this.m_viewStack.remove(form)) {
                        this.fireFormRemoved(form);
                    }
                    if (form.getDisplayHint() == 10) {
                        for (IForm f : new ArrayList<IForm>(this.m_dialogStack)) {
                            if (f.getDisplayHint() != 10) continue;
                            try {
                                f.doClose();
                            }
                            catch (Throwable t) {
                                LOG.error("Failed closing popup " + f, t);
                            }
                        }
                    }
                    if (this.m_dialogStack.contains(form)) break;
                    this.m_dialogStack.add(form);
                    this.fireFormAdded(form);
                    break;
                }
                case 20: {
                    if (this.m_dialogStack.remove(form)) {
                        this.fireFormRemoved(form);
                    }
                    if (this.m_viewStack.contains(form)) break;
                    this.m_viewStack.add(form);
                    this.fireFormAdded(form);
                }
            }
            this.m_lastActiveFormList.add(new WeakReference<IForm>(form));
            form.addFormListener(this.m_activatedFormListener);
        }
    }

    @Override
    public void removeForm(IForm form) {
        if (form != null) {
            if (this.m_lastActiveFormList != null) {
                Iterator it = this.m_lastActiveFormList.iterator();
                while (it.hasNext()) {
                    WeakReference formRef = (WeakReference)it.next();
                    if (formRef.get() != null && !form.equals(formRef.get())) continue;
                    it.remove();
                }
            }
            form.removeFormListener(this.m_activatedFormListener);
            boolean b1 = this.m_dialogStack.remove(form);
            boolean b2 = this.m_viewStack.remove(form);
            if (b1 || b2) {
                this.fireFormRemoved(form);
            }
        }
    }

    @Override
    public IMessageBox[] getMessageBoxStack() {
        return this.m_messageBoxStack.toArray(new IMessageBox[0]);
    }

    @Override
    public void addMessageBox(final IMessageBox mb) {
        this.m_messageBoxStack.add(mb);
        mb.addMessageBoxListener(new MessageBoxListener(){

            @Override
            public void messageBoxChanged(MessageBoxEvent e) {
                switch (e.getType()) {
                    case 900: {
                        AbstractDesktop.this.removeMessageBoxInternal(mb);
                    }
                }
            }
        });
        this.fireMessageBoxAdded(mb);
    }

    private void removeMessageBoxInternal(IMessageBox mb) {
        this.m_messageBoxStack.remove(mb);
    }

    @Override
    public IOutline[] getAvailableOutlines() {
        return this.m_availableOutlines;
    }

    @Override
    public void setAvailableOutlines(IOutline[] availableOutlines) {
        this.setOutline((IOutline)null);
        this.m_availableOutlines = availableOutlines != null ? availableOutlines : new IOutline[]{};
    }

    @Override
    public IOutline getOutline() {
        return this.m_outline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOutline(IOutline outline) {
        if (this.m_outline == (outline = this.resolveOutline(outline)) || this.m_outlineChanging) {
            return;
        }
        AbstractDesktop abstractDesktop = this;
        synchronized (abstractDesktop) {
            block22: {
                try {
                    IPage oldActivePage;
                    this.m_outlineChanging = true;
                    if (this.m_outline != null && (oldActivePage = this.m_outline.getActivePage()) != null) {
                        ((INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class)).addStep(0, oldActivePage);
                    }
                    IOutline oldOutline = this.m_outline;
                    if (this.m_activeOutlineListener != null && oldOutline != null) {
                        oldOutline.removeTreeListener(this.m_activeOutlineListener);
                        oldOutline.removePropertyChangeListener(this.m_activeOutlineListener);
                        this.m_activeOutlineListener = null;
                    }
                    this.m_outline = outline;
                    if (oldOutline != null) {
                        oldOutline.clearContextPage();
                    }
                    if (this.m_outline != null) {
                        this.m_activeOutlineListener = new P_ActiveOutlineListener();
                        this.m_outline.addTreeListener(this.m_activeOutlineListener);
                        this.m_outline.addPropertyChangeListener(this.m_activeOutlineListener);
                    }
                    if (this.m_outline == null) {
                        this.setPageDetailForm(null);
                        this.setPageDetailTable(null);
                        this.setPageSearchForm(null, true);
                    }
                    this.fireOutlineChanged(oldOutline, this.m_outline);
                    if (this.m_outline == null) break block22;
                    if (this.m_outline.getActivePage() != null) {
                        try {
                            this.m_outline.getActivePage().ensureChildrenLoaded();
                        }
                        catch (ProcessingException e) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                        }
                    }
                    this.m_outline.setNodeExpanded(this.m_outline.getRootNode(), true);
                    this.setPageDetailForm(this.m_outline.getDetailForm());
                    this.setPageDetailTable(this.m_outline.getDetailTable());
                    this.setPageSearchForm(this.m_outline.getSearchForm(), true);
                    this.m_outline.makeActivePageToContextPage();
                    IPage newActivePage = this.m_outline.getActivePage();
                    if (newActivePage == null) {
                        if (this.m_outline.isRootNodeVisible()) {
                            this.m_outline.selectNode(this.m_outline.getRootNode(), false);
                        } else {
                            ITreeNode[] children = this.m_outline.getRootNode().getChildNodes();
                            if (children.length > 0) {
                                ITreeNode[] iTreeNodeArray = children;
                                int n = children.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    ITreeNode node = iTreeNodeArray[n2];
                                    if (node.isVisible() && node.isEnabled()) {
                                        this.m_outline.selectNode(node, false);
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                        }
                        newActivePage = this.m_outline.getActivePage();
                    }
                    if (newActivePage != null) {
                        ((INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class)).addStep(0, newActivePage);
                    }
                }
                finally {
                    this.m_outlineChanging = false;
                }
            }
        }
    }

    private IOutline resolveOutline(IOutline outline) {
        IOutline[] iOutlineArray = this.getAvailableOutlines();
        int n = iOutlineArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOutline o = iOutlineArray[n2];
            if (o == outline) {
                return o;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void setOutline(Class<? extends IOutline> outlineType) {
        IOutline[] iOutlineArray = this.getAvailableOutlines();
        int n = iOutlineArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOutline o = iOutlineArray[n2];
            if (o.getClass() == outlineType) {
                this.setOutline(o);
                return;
            }
            ++n2;
        }
    }

    @Override
    public IKeyStroke[] getKeyStrokes() {
        return (IKeyStroke[])this.propertySupport.getProperty("keyStrokes");
    }

    @Override
    public void setKeyStrokes(IKeyStroke[] ks) {
        if (ks == null) {
            ks = new IKeyStroke[]{};
        }
        this.propertySupport.setProperty("keyStrokes", (Object)ks);
    }

    @Override
    public void addKeyStrokes(IKeyStroke ... keyStrokes) {
        if (keyStrokes != null && keyStrokes.length > 0) {
            IKeyStroke ks;
            HashMap<String, IKeyStroke> map = new HashMap<String, IKeyStroke>();
            IKeyStroke[] iKeyStrokeArray = this.getKeyStrokes();
            int n = iKeyStrokeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ks = iKeyStrokeArray[n2];
                map.put(ks.getKeyStroke(), ks);
                ++n2;
            }
            iKeyStrokeArray = keyStrokes;
            n = keyStrokes.length;
            n2 = 0;
            while (n2 < n) {
                ks = iKeyStrokeArray[n2];
                map.put(ks.getKeyStroke(), ks);
                ++n2;
            }
            this.setKeyStrokes(map.values().toArray(new IKeyStroke[map.size()]));
        }
    }

    @Override
    public void removeKeyStrokes(IKeyStroke ... keyStrokes) {
        if (keyStrokes != null && keyStrokes.length > 0) {
            IKeyStroke ks;
            HashMap<String, IKeyStroke> map = new HashMap<String, IKeyStroke>();
            IKeyStroke[] iKeyStrokeArray = this.getKeyStrokes();
            int n = iKeyStrokeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ks = iKeyStrokeArray[n2];
                map.put(ks.getKeyStroke(), ks);
                ++n2;
            }
            iKeyStrokeArray = keyStrokes;
            n = keyStrokes.length;
            n2 = 0;
            while (n2 < n) {
                ks = iKeyStrokeArray[n2];
                map.remove(ks.getKeyStroke());
                ++n2;
            }
            this.setKeyStrokes(map.values().toArray(new IKeyStroke[map.size()]));
        }
    }

    @Override
    public IMenu[] getMenus() {
        IMenu[] a = new IMenu[this.m_menus.length];
        System.arraycopy(this.m_menus, 0, a, 0, a.length);
        return a;
    }

    @Override
    public void prepareAllMenus() {
        IMenu[] iMenuArray = this.getMenus();
        int n = iMenuArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMenu child = iMenuArray[n2];
            this.prepareMenuRec(child);
            ++n2;
        }
    }

    private void prepareMenuRec(IMenu menu) {
        menu.prepareAction();
        for (IMenu child : menu.getChildActions()) {
            this.prepareMenuRec(child);
        }
    }

    @Override
    public IAction[] getActions() {
        IAction[] a = this.getKeyStrokes();
        IAction[] b = this.getMenus();
        IAction[] c = this.getViewButtons();
        IAction[] d = this.getToolButtons();
        if (a == null) {
            a = new IAction[]{};
        }
        if (b == null) {
            b = new IAction[]{};
        }
        if (c == null) {
            c = new IAction[]{};
        }
        if (d == null) {
            d = new IAction[]{};
        }
        IAction[] all = new IAction[a.length + b.length + c.length + d.length];
        int offset = 0;
        System.arraycopy(a, 0, all, offset, a.length);
        System.arraycopy(b, 0, all, offset += a.length, b.length);
        System.arraycopy(c, 0, all, offset += b.length, c.length);
        System.arraycopy(d, 0, all, offset += c.length, d.length);
        return all;
    }

    @Override
    public IToolButton[] getToolButtons() {
        IToolButton[] a = new IToolButton[this.m_toolButtons.length];
        System.arraycopy(this.m_toolButtons, 0, a, 0, a.length);
        return a;
    }

    @Override
    public IViewButton[] getViewButtons() {
        IViewButton[] a = new IViewButton[this.m_viewButtons.length];
        System.arraycopy(this.m_viewButtons, 0, a, 0, a.length);
        return a;
    }

    @Override
    public IForm getPageDetailForm() {
        return this.m_pageDetailForm;
    }

    @Override
    public void setPageDetailForm(IForm f) {
        if (this.m_pageDetailForm != f) {
            IForm oldForm = this.m_pageDetailForm;
            this.m_pageDetailForm = f;
            IDesktopExtension[] extensions = this.getDesktopExtensions();
            if (extensions != null) {
                IDesktopExtension[] iDesktopExtensionArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IDesktopExtension ext = iDesktopExtensionArray[n2];
                    try {
                        ContributionCommand cc = ext.pageDetailFormChangedDelegate(oldForm, this.m_pageDetailForm);
                        if (cc == ContributionCommand.Stop) {
                            break;
                        }
                    }
                    catch (Throwable t) {
                        LOG.error("extension " + ext, t);
                    }
                    ++n2;
                }
            }
        }
    }

    @Override
    public IForm getPageSearchForm() {
        return this.m_pageSearchForm;
    }

    @Override
    public void setPageSearchForm(IForm f) {
        this.setPageSearchForm(f, false);
    }

    public void setPageSearchForm(IForm f, boolean force) {
        if (force || this.m_pageSearchForm != f) {
            IForm oldForm = this.m_pageSearchForm;
            this.m_pageSearchForm = f;
            IDesktopExtension[] extensions = this.getDesktopExtensions();
            if (extensions != null) {
                IDesktopExtension[] iDesktopExtensionArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IDesktopExtension ext = iDesktopExtensionArray[n2];
                    try {
                        ContributionCommand cc = ext.pageSearchFormChangedDelegate(oldForm, this.m_pageSearchForm);
                        if (cc == ContributionCommand.Stop) {
                            break;
                        }
                    }
                    catch (Throwable t) {
                        LOG.error("extension " + ext, t);
                    }
                    ++n2;
                }
            }
        }
    }

    @Override
    public IOutlineTableForm getOutlineTableForm() {
        return this.m_outlineTableForm;
    }

    @Override
    public void setOutlineTableForm(IOutlineTableForm f) {
        if (f != this.m_outlineTableForm) {
            if (this.m_outlineTableForm != null) {
                this.removeForm(this.m_outlineTableForm);
            }
            this.m_outlineTableForm = f;
            if (this.m_outlineTableForm != null) {
                this.m_outlineTableForm.setCurrentTable(this.getPageDetailTable());
                this.setOutlineTableFormVisible(this.getPageDetailTable() != null);
            }
            if (this.m_outlineTableForm != null && this.m_outlineTableFormVisible) {
                this.addForm(this.m_outlineTableForm);
            }
        }
    }

    @Override
    public boolean isOutlineTableFormVisible() {
        return this.m_outlineTableFormVisible;
    }

    @Override
    public void setOutlineTableFormVisible(boolean b) {
        if (this.m_outlineTableFormVisible != b) {
            this.m_outlineTableFormVisible = b;
            if (this.m_outlineTableForm != null) {
                if (this.m_outlineTableFormVisible) {
                    this.addForm(this.m_outlineTableForm);
                } else {
                    this.removeForm(this.m_outlineTableForm);
                }
            }
        }
    }

    @Override
    public ITable getPageDetailTable() {
        return this.m_pageDetailTable;
    }

    @Override
    public void setPageDetailTable(ITable t) {
        if (this.m_pageDetailTable != t) {
            ITable oldTable = this.m_pageDetailTable;
            this.m_pageDetailTable = t;
            IDesktopExtension[] extensions = this.getDesktopExtensions();
            if (extensions != null) {
                IDesktopExtension[] iDesktopExtensionArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IDesktopExtension ext = iDesktopExtensionArray[n2];
                    try {
                        ContributionCommand cc = ext.pageDetailTableChangedDelegate(oldTable, this.m_pageDetailTable);
                        if (cc == ContributionCommand.Stop) {
                            break;
                        }
                    }
                    catch (Throwable x) {
                        LOG.error("extension " + ext, x);
                    }
                    ++n2;
                }
            }
        }
    }

    @Override
    public String getTitle() {
        return this.propertySupport.getPropertyString("title");
    }

    @Override
    public void setTitle(String s) {
        this.propertySupport.setPropertyString("title", s);
    }

    @Override
    public IProcessingStatus getStatus() {
        return (IProcessingStatus)this.propertySupport.getProperty("status");
    }

    @Override
    public void setStatus(IProcessingStatus status) {
        this.propertySupport.setProperty("status", (Object)status);
    }

    @Override
    public void setStatusText(String s) {
        if (s != null) {
            this.setStatus((IProcessingStatus)new ProcessingStatus(s, null, 0, 1));
        } else {
            this.setStatus(null);
        }
    }

    @Override
    public void printDesktop(PrintDevice device, Map<String, Object> parameters) {
        try {
            this.firePrint(device, parameters);
        }
        catch (ProcessingException e) {
            e.addContextMessage(String.valueOf(ScoutTexts.get((String)"FormPrint", (String[])new String[0])) + " " + this.getTitle());
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
    }

    @Override
    public void addFileChooser(IFileChooser fc) {
        this.fireFileChooserAdded(fc);
    }

    @Override
    public void openBrowserWindow(String path) {
        this.fireOpenBrowserWindow(path);
    }

    @Override
    public boolean isAutoPrefixWildcardForTextSearch() {
        return this.m_autoPrefixWildcardForTextSearch;
    }

    @Override
    public void setAutoPrefixWildcardForTextSearch(boolean b) {
        this.m_autoPrefixWildcardForTextSearch = b;
    }

    @Override
    public boolean isOpened() {
        return this.propertySupport.getPropertyBool("opened");
    }

    private void setOpenedInternal(boolean b) {
        this.propertySupport.setPropertyBool("opened", b);
    }

    private void setGuiAvailableInternal(boolean guiAvailable) {
        this.propertySupport.setPropertyBool("guiAvailable", guiAvailable);
    }

    @Override
    public boolean isGuiAvailable() {
        return this.propertySupport.getPropertyBool("guiAvailable");
    }

    @Override
    public void addDesktopListener(DesktopListener l) {
        this.m_listenerList.add(DesktopListener.class, (EventListener)l);
    }

    @Override
    public void removeDesktopListener(DesktopListener l) {
        this.m_listenerList.remove(DesktopListener.class, (EventListener)l);
    }

    @Override
    public void addDataChangeListener(DataChangeListener listener, Object ... dataTypes) {
        if (dataTypes == null || dataTypes.length == 0) {
            EventListenerList list = this.m_dataChangeListenerList.get(null);
            if (list == null) {
                list = new EventListenerList();
                this.m_dataChangeListenerList.put(null, list);
            }
            list.add(DataChangeListener.class, (EventListener)listener);
        } else {
            Object[] objectArray = dataTypes;
            int n = dataTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Object dataType = objectArray[n2];
                if (dataType != null) {
                    EventListenerList list = this.m_dataChangeListenerList.get(dataType);
                    if (list == null) {
                        list = new EventListenerList();
                        this.m_dataChangeListenerList.put(dataType, list);
                    }
                    list.add(DataChangeListener.class, (EventListener)listener);
                }
                ++n2;
            }
        }
    }

    @Override
    public void removeDataChangeListener(DataChangeListener listener, Object ... dataTypes) {
        if (dataTypes == null || dataTypes.length == 0) {
            Iterator<EventListenerList> it = this.m_dataChangeListenerList.values().iterator();
            while (it.hasNext()) {
                EventListenerList list = it.next();
                list.remove(DataChangeListener.class, (EventListener)listener);
                if (list.getListenerCount(DataChangeListener.class) != 0) continue;
                it.remove();
            }
        } else {
            Object[] objectArray = dataTypes;
            int n = dataTypes.length;
            int n2 = 0;
            while (n2 < n) {
                EventListenerList list;
                Object dataType = objectArray[n2];
                if (dataType != null && (list = this.m_dataChangeListenerList.get(dataType)) != null) {
                    list.remove(DataChangeListener.class, (EventListener)listener);
                    if (list.getListenerCount(DataChangeListener.class) == 0) {
                        this.m_dataChangeListenerList.remove(dataType);
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public void dataChanged(Object ... dataTypes) {
        if (dataTypes != null && dataTypes.length > 0) {
            HashMap<DataChangeListener, HashSet<Object>> map = new HashMap<DataChangeListener, HashSet<Object>>();
            Object[] objectArray = dataTypes;
            int n = dataTypes.length;
            int n2 = 0;
            while (n2 < n) {
                EventListenerList list;
                Object dataType = objectArray[n2];
                if (dataType != null && (list = this.m_dataChangeListenerList.get(dataType)) != null) {
                    DataChangeListener[] dataChangeListenerArray = (DataChangeListener[])list.getListeners(DataChangeListener.class);
                    int n3 = dataChangeListenerArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        DataChangeListener listener = dataChangeListenerArray[n4];
                        HashSet<Object> typeSet = (HashSet<Object>)map.get(listener);
                        if (typeSet == null) {
                            typeSet = new HashSet<Object>();
                            map.put(listener, typeSet);
                        }
                        typeSet.add(dataType);
                        ++n4;
                    }
                }
                ++n2;
            }
            for (Map.Entry e : map.entrySet()) {
                DataChangeListener listener = (DataChangeListener)e.getKey();
                Set typeSet = (Set)e.getValue();
                try {
                    listener.dataChanged(typeSet.toArray());
                }
                catch (Throwable t) {
                    LOG.error(null, t);
                }
            }
        }
    }

    private void fireDesktopClosed() {
        DesktopEvent e = new DesktopEvent(this, 100);
        this.fireDesktopEvent(e);
    }

    private void firePrint(PrintDevice device, Map<String, Object> parameters) throws ProcessingException {
        this.fireDesktopEvent(new DesktopEvent(this, 900, device, parameters));
    }

    private IMenu[] fireTrayPopup() {
        DesktopEvent e = new DesktopEvent(this, 1010);
        this.addLocalPopupMenus(e);
        this.fireDesktopEvent(e);
        return e.getPopupMenus();
    }

    private void fireDesktopPrinted(File printedFile) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, 901, printedFile);
        this.fireDesktopEvent(e);
    }

    private void fireOutlineChanged(IOutline oldOutline, IOutline newOutline) {
        IDesktopExtension[] extensions;
        if (oldOutline != newOutline && (extensions = this.getDesktopExtensions()) != null) {
            IDesktopExtension[] iDesktopExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IDesktopExtension ext = iDesktopExtensionArray[n2];
                try {
                    ContributionCommand cc = ext.outlineChangedDelegate(oldOutline, newOutline);
                    if (cc == ContributionCommand.Stop) {
                        break;
                    }
                }
                catch (ProcessingException e) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                }
                catch (Throwable t) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException(oldOutline + " -> " + newOutline, t));
                }
                ++n2;
            }
        }
        DesktopEvent e = new DesktopEvent((IDesktop)this, 200, newOutline);
        this.fireDesktopEvent(e);
    }

    private void fireFormAdded(IForm form) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, 600, form);
        this.fireDesktopEvent(e);
    }

    private void fireFormEnsureVisible(IForm form) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, 620, form);
        this.fireDesktopEvent(e);
    }

    private void fireFormRemoved(IForm form) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, 610, form);
        this.fireDesktopEvent(e);
    }

    private void fireMessageBoxAdded(IMessageBox mb) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, 700, mb);
        this.fireDesktopEvent(e);
    }

    private void fireFileChooserAdded(IFileChooser fc) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, 910, fc);
        this.fireDesktopEvent(e);
    }

    private void fireOpenBrowserWindow(String path) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, 920, path);
        this.fireDesktopEvent(e);
    }

    private IFormField fireFindFocusOwner() {
        DesktopEvent e = new DesktopEvent(this, 1000);
        this.fireDesktopEvent(e);
        return e.getFocusedField();
    }

    private void fireDesktopEvent(DesktopEvent e) {
        EventListener[] listeners = this.m_listenerList.getListeners(DesktopListener.class);
        if (listeners != null && listeners.length > 0) {
            EventListener[] eventListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                EventListener element = eventListenerArray[n2];
                try {
                    ((DesktopListener)element).desktopChanged(e);
                }
                catch (Throwable t) {
                    LOG.error(null, t);
                }
                ++n2;
            }
        }
    }

    private void addLocalPopupMenus(DesktopEvent event) {
        try {
            ArrayList<IMenu> list = new ArrayList<IMenu>();
            IDesktopExtension[] extensions = this.getDesktopExtensions();
            if (extensions != null) {
                IDesktopExtension[] iDesktopExtensionArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IDesktopExtension ext = iDesktopExtensionArray[n2];
                    try {
                        ContributionCommand cc = ext.addTrayMenusDelegate(list);
                        if (cc == ContributionCommand.Stop) {
                            break;
                        }
                    }
                    catch (Throwable t) {
                        LOG.error("extension " + ext, t);
                    }
                    ++n2;
                }
            }
            for (IMenu m : list) {
                if (m == null) continue;
                m.prepareAction();
            }
            for (IMenu m : list) {
                if (m == null || !m.isVisible()) continue;
                event.addPopupMenu(m);
            }
        }
        catch (Throwable t) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
        }
    }

    @Override
    public void activateBookmark(Bookmark bm, boolean forceReload) throws ProcessingException {
        BookmarkUtility.activateBookmark(this, bm, forceReload);
    }

    @Override
    public Bookmark createBookmark() throws ProcessingException {
        return BookmarkUtility.createBookmark(this);
    }

    @Override
    public Bookmark createBookmark(IPage page) throws ProcessingException {
        return BookmarkUtility.createBookmark(page);
    }

    @Override
    public void refreshPages(Class ... pageTypes) {
        IOutline[] iOutlineArray = this.getAvailableOutlines();
        int n = iOutlineArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOutline outline = iOutlineArray[n2];
            outline.refreshPages(pageTypes);
            ++n2;
        }
    }

    @Override
    public void releaseUnusedPages() {
        IOutline[] iOutlineArray = this.getAvailableOutlines();
        int n = iOutlineArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOutline outline = iOutlineArray[n2];
            outline.releaseUnusedPages();
            ++n2;
        }
    }

    @Override
    public void afterTablePageLoaded(IPageWithTable<?> tablePage) throws ProcessingException {
        IDesktopExtension[] extensions = this.getDesktopExtensions();
        if (extensions != null) {
            IDesktopExtension[] iDesktopExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IDesktopExtension ext = iDesktopExtensionArray[n2];
                try {
                    ContributionCommand cc = ext.tablePageLoadedDelegate(tablePage);
                    if (cc == ContributionCommand.Stop) {
                        break;
                    }
                }
                catch (Throwable t) {
                    LOG.error("extension " + ext, t);
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeInternal() throws ProcessingException {
        Object[] objectArray;
        void var3_13;
        void var3_11;
        ArrayList<Object> openForms = new ArrayList<Object>();
        IForm[] iFormArray = this.getViewStack();
        int n = iFormArray.length;
        boolean n2 = false;
        while (var3_11 < n) {
            IForm view = iFormArray[var3_11];
            this.removeForm(view);
            openForms.add(view);
            ++var3_11;
        }
        iFormArray = this.getDialogStack();
        n = iFormArray.length;
        boolean bl = false;
        while (var3_13 < n) {
            IForm dialog = iFormArray[var3_13];
            this.removeForm(dialog);
            openForms.add(dialog);
            ++var3_13;
        }
        IDesktopExtension[] extensions = this.getDesktopExtensions();
        if (extensions != null) {
            objectArray = extensions;
            int n3 = extensions.length;
            n = 0;
            while (n < n3) {
                Object object = objectArray[n];
                try {
                    ContributionCommand cc = object.desktopClosingDelegate();
                    if (cc == ContributionCommand.Stop) {
                        break;
                    }
                }
                catch (Throwable t) {
                    LOG.error("extension " + object, t);
                }
                ++n;
            }
        }
        objectArray = this.getToolButtons();
        int n4 = objectArray.length;
        n = 0;
        while (n < n4) {
            AbstractFormToolButton formToolButton;
            Object form;
            Object object = objectArray[n];
            if (object instanceof AbstractFormToolButton && (form = (formToolButton = (AbstractFormToolButton)object).getForm()) != null) {
                openForms.add(form);
                formToolButton.setForm(null);
            }
            ++n;
        }
        for (IForm iForm : openForms) {
            if (iForm == null) continue;
            try {
                iForm.doClose();
            }
            catch (ProcessingException e) {
                LOG.error("Exception while closing form", (Throwable)e);
            }
        }
        objectArray = this.getAvailableOutlines();
        int n5 = objectArray.length;
        int n6 = 0;
        while (n6 < n5) {
            Object object = objectArray[n6];
            object.removeAllChildNodes(object.getRootNode());
            object.disposeTree();
            ++n6;
        }
        this.fireDesktopClosed();
    }

    public boolean runMenu(Class<? extends IMenu> menuType) throws ProcessingException {
        IMenu[] iMenuArray = this.getMenus();
        int n = iMenuArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMenu m = iMenuArray[n2];
            if (this.runMenuRec(m, menuType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean runMenuRec(IMenu m, Class<? extends IMenu> menuType) throws ProcessingException {
        if (m.getClass() == menuType) {
            m.prepareAction();
            if (m.isVisible() && m.isEnabled()) {
                m.doAction();
                return true;
            }
            return false;
        }
        for (IMenu c : m.getChildActions()) {
            if (!this.runMenuRec(c, menuType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IDesktopUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public void changeVisibilityAfterOfflineSwitch() {
    }

    private class P_ActivatedFormListener
    implements FormListener {
        private P_ActivatedFormListener() {
        }

        @Override
        public void formChanged(FormEvent e) throws ProcessingException {
            if (e.getType() != 510) {
                return;
            }
            Iterator it = AbstractDesktop.this.m_lastActiveFormList.iterator();
            while (it.hasNext()) {
                WeakReference formRef = (WeakReference)it.next();
                if (formRef.get() != null && !((IForm)formRef.get()).equals(e.getForm())) continue;
                it.remove();
            }
            AbstractDesktop.this.m_lastActiveFormList.add(0, new WeakReference<IForm>(e.getForm()));
        }
    }

    private class P_ActiveOutlineListener
    extends TreeAdapter
    implements PropertyChangeListener {
        private P_ActiveOutlineListener() {
        }

        @Override
        public void treeChanged(TreeEvent e) {
            switch (e.getType()) {
                case 35: {
                    if (!(e.getDeselectedNode() instanceof IPage)) break;
                    IPage deselectedPage = (IPage)e.getDeselectedNode();
                    ((INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class)).addStep(0, deselectedPage);
                    break;
                }
                case 40: {
                    IPage page = AbstractDesktop.this.m_outline.getActivePage();
                    if (page != null) {
                        ((INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class)).addStep(0, page);
                    }
                    try {
                        ClientSyncJob.getCurrentSession().getMemoryPolicy().afterOutlineSelectionChanged(AbstractDesktop.this);
                        break;
                    }
                    catch (Throwable t) {
                        LOG.warn("MemoryPolicy.afterOutlineSelectionChanged", t);
                    }
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("detailForm")) {
                AbstractDesktop.this.setPageDetailForm(((IOutline)e.getSource()).getDetailForm());
            } else if (e.getPropertyName().equals("detailTable")) {
                AbstractDesktop.this.setPageDetailTable(((IOutline)e.getSource()).getDetailTable());
            } else if (e.getPropertyName().equals("searchForm")) {
                AbstractDesktop.this.setPageSearchForm(((IOutline)e.getSource()).getSearchForm());
            }
        }
    }

    private class P_LocalDesktopExtension
    implements IDesktopExtension {
        private P_LocalDesktopExtension() {
        }

        @Override
        public IDesktop getCoreDesktop() {
            return AbstractDesktop.this;
        }

        @Override
        public void setCoreDesktop(IDesktop desktop) {
        }

        @Override
        public void contributeOutlines(Collection<IOutline> outlines) {
            Class<? extends IOutline>[] a = AbstractDesktop.this.getConfiguredOutlines();
            if (a != null) {
                Class<? extends IOutline>[] classArray = a;
                int n = a.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<? extends IOutline> element = classArray[n2];
                    try {
                        IOutline o = element.newInstance();
                        outlines.add(o);
                    }
                    catch (Throwable t) {
                        LOG.error("adding outline " + element, t);
                    }
                    ++n2;
                }
            }
        }

        @Override
        public void contributeActions(Collection<IAction> actions) {
            Class[] actionArray;
            Class[] classArray = actionArray = AbstractDesktop.this.getConfiguredActions();
            int n = actionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class element = classArray[n2];
                try {
                    IAction tool = (IAction)ConfigurationUtility.newInnerInstance((Object)AbstractDesktop.this, (Class)element);
                    actions.add(tool);
                }
                catch (Exception e) {
                    LOG.error("adding action " + element, (Throwable)e);
                }
                ++n2;
            }
        }

        @Override
        public ContributionCommand initDelegate() throws ProcessingException {
            AbstractDesktop.this.execInit();
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand desktopOpenedDelegate() throws ProcessingException {
            AbstractDesktop.this.execOpened();
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand desktopClosingDelegate() throws ProcessingException {
            AbstractDesktop.this.execClosing();
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand guiAttachedDelegate() throws ProcessingException {
            AbstractDesktop.this.execGuiAttached();
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand guiDetachedDelegate() throws ProcessingException {
            AbstractDesktop.this.execGuiDetached();
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand outlineChangedDelegate(IOutline oldOutline, IOutline newOutline) throws ProcessingException {
            AbstractDesktop.this.execOutlineChanged(oldOutline, newOutline);
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand customFormModificationDelegate(IHolder<IForm> formHolder) throws ProcessingException {
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand pageSearchFormChangedDelegate(IForm oldForm, IForm newForm) throws ProcessingException {
            AbstractDesktop.this.execPageSearchFormChanged(oldForm, newForm);
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand pageDetailFormChangedDelegate(IForm oldForm, IForm newForm) throws ProcessingException {
            AbstractDesktop.this.execPageDetailFormChanged(oldForm, newForm);
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand pageDetailTableChangedDelegate(ITable oldTable, ITable newTable) throws ProcessingException {
            AbstractDesktop.this.execPageDetailTableChanged(oldTable, newTable);
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand tablePageLoadedDelegate(IPageWithTable<?> tablePage) throws ProcessingException {
            AbstractDesktop.this.execTablePageLoaded(tablePage);
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand addTrayMenusDelegate(List<IMenu> menus) throws ProcessingException {
            AbstractDesktop.this.execAddTrayMenus(menus);
            return ContributionCommand.Continue;
        }
    }

    private class P_UIFacade
    implements IDesktopUIFacade {
        private P_UIFacade() {
        }

        @Override
        public void fireGuiAttached() {
            AbstractDesktop.this.setGuiAvailableInternal(true);
            IDesktopExtension[] extensions = AbstractDesktop.this.getDesktopExtensions();
            if (extensions != null) {
                IDesktopExtension[] iDesktopExtensionArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IDesktopExtension ext = iDesktopExtensionArray[n2];
                    try {
                        ContributionCommand cc = ext.guiAttachedDelegate();
                        if (cc == ContributionCommand.Stop) {
                            break;
                        }
                    }
                    catch (ProcessingException e) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                    }
                    catch (Throwable t) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected by " + ext, t));
                    }
                    ++n2;
                }
            }
        }

        @Override
        public void fireGuiDetached() {
            AbstractDesktop.this.setGuiAvailableInternal(false);
            IDesktopExtension[] extensions = AbstractDesktop.this.getDesktopExtensions();
            if (extensions != null) {
                IDesktopExtension[] iDesktopExtensionArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IDesktopExtension ext = iDesktopExtensionArray[n2];
                    try {
                        ContributionCommand cc = ext.guiDetachedDelegate();
                        if (cc == ContributionCommand.Stop) {
                            break;
                        }
                    }
                    catch (ProcessingException e) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                    }
                    catch (Throwable t) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected by " + ext, t));
                    }
                    ++n2;
                }
            }
        }

        @Override
        public void fireDesktopOpenedFromUI() {
            AbstractDesktop.this.setOpenedInternal(true);
            IDesktopExtension[] extensions = AbstractDesktop.this.getDesktopExtensions();
            if (extensions != null) {
                IDesktopExtension[] iDesktopExtensionArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IDesktopExtension ext = iDesktopExtensionArray[n2];
                    try {
                        ContributionCommand cc = ext.desktopOpenedDelegate();
                        if (cc == ContributionCommand.Stop) {
                            break;
                        }
                    }
                    catch (ProcessingException e) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                    }
                    catch (Throwable t) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected by " + ext, t));
                    }
                    ++n2;
                }
            }
        }

        @Override
        public void fireDesktopClosingFromUI() {
            AbstractDesktop.this.setOpenedInternal(false);
            ClientSyncJob.getCurrentSession().stopSession();
        }

        @Override
        public IMenu[] fireTrayPopupFromUI() {
            return AbstractDesktop.this.fireTrayPopup();
        }

        @Override
        public void fireDesktopPrintedFromUI(File printedFile) {
            AbstractDesktop.this.fireDesktopPrinted(printedFile);
        }
    }
}

