/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.annotations.InjectFieldTo;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.rt.client.ui.form.IFormFieldInjection;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;

public class DefaultFormFieldInjection
implements IFormFieldInjection {
    private final ArrayList<IFormField> m_list = new ArrayList();

    public void addField(IFormField f) {
        this.m_list.add(f);
    }

    @Override
    public void injectFields(IFormField container, List<IFormField> fieldList) {
        if (container == null || fieldList == null || this.m_list.isEmpty()) {
            return;
        }
        Class<?> containerClazz = container.getClass();
        for (IFormField f : this.m_list) {
            InjectFieldTo ann = f.getClass().getAnnotation(InjectFieldTo.class);
            if (ann == null || ann.value() != containerClazz) continue;
            this.insertField(fieldList, f);
        }
    }

    protected void insertField(List<IFormField> list, IFormField f) {
        if (list.contains(f)) {
            return;
        }
        Class<?> c = f.getClass();
        if (!c.isAnnotationPresent(Order.class)) {
            list.add(f);
            return;
        }
        double newOrder = c.getAnnotation(Order.class).value();
        int i = 0;
        int n = list.size();
        while (i < n) {
            double existingOrder;
            Class<?> existingClazz = list.get(i).getClass();
            if (existingClazz.isAnnotationPresent(Order.class) && newOrder < (existingOrder = existingClazz.getAnnotation(Order.class).value())) {
                list.add(i, f);
                return;
            }
            ++i;
        }
        list.add(f);
    }
}

