/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.client.ui.form.IFormFieldInjection;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;

public final class FormFieldInjectionThreadLocal {
    private static final ThreadLocal<FormFieldInjectionThreadLocal> THREAD_LOCAL = new ThreadLocal<FormFieldInjectionThreadLocal>(){

        @Override
        protected FormFieldInjectionThreadLocal initialValue() {
            return new FormFieldInjectionThreadLocal(null);
        }
    };
    private final ArrayList<IFormFieldInjection> m_stack = new ArrayList();

    public static void push(IFormFieldInjection injection) {
        THREAD_LOCAL.get().pushInternal(injection);
    }

    public static void pop(IFormFieldInjection injection) {
        THREAD_LOCAL.get().popInternal(injection);
    }

    public static void injectFields(IFormField container, List<IFormField> fieldList) {
        THREAD_LOCAL.get().injectFieldsInternal(container, fieldList);
    }

    private FormFieldInjectionThreadLocal() {
    }

    private void pushInternal(IFormFieldInjection injection) {
        if (injection == null) {
            throw new IllegalArgumentException("injection is null");
        }
        this.m_stack.add(injection);
    }

    private void popInternal(IFormFieldInjection injection) {
        if (injection == null) {
            throw new IllegalArgumentException("injection is null");
        }
        if (this.m_stack.isEmpty()) {
            throw new IllegalArgumentException("push/pop asymmetry; expected nothing but got " + injection.getClass());
        }
        if (this.m_stack.isEmpty() || this.m_stack.get(this.m_stack.size() - 1) != injection) {
            throw new IllegalArgumentException("push/pop asymmetry; expected " + this.m_stack.get(this.m_stack.size() - 1).getClass() + " but got " + injection.getClass());
        }
        this.m_stack.remove(this.m_stack.size() - 1);
    }

    private void injectFieldsInternal(IFormField container, List<IFormField> fieldList) {
        if (this.m_stack.isEmpty()) {
            return;
        }
        for (IFormFieldInjection i : this.m_stack) {
            i.injectFields(container, fieldList);
        }
    }

    /* synthetic */ FormFieldInjectionThreadLocal(FormFieldInjectionThreadLocal formFieldInjectionThreadLocal) {
        this();
    }
}

