/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.groupbox;

import java.util.ArrayList;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.rt.client.ui.action.keystroke.AbstractKeyStroke;
import org.eclipse.scout.rt.client.ui.action.keystroke.DefaultFormEnterKeyStroke;
import org.eclipse.scout.rt.client.ui.action.keystroke.DefaultFormEscapeKeyStroke;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractCompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBoxUIFacade;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal.GroupBoxBodyGrid;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal.GroupBoxProcessButtonGrid;

public abstract class AbstractGroupBox
extends AbstractCompositeField
implements IGroupBox {
    private IGroupBoxUIFacade m_uiFacade;
    private boolean m_mainBoxFlag = false;
    private int m_gridColumnCountHint;
    private boolean m_scrollable;
    private IFormField[] m_controlFields;
    private IGroupBox[] m_groupBoxes;
    private IButton[] m_customButtons;
    private IButton[] m_systemButtons;
    private GroupBoxBodyGrid m_bodyGrid;
    private GroupBoxProcessButtonGrid m_customProcessButtonGrid;
    private GroupBoxProcessButtonGrid m_systemProcessButtonGrid;

    public AbstractGroupBox() {
        this(true);
    }

    public AbstractGroupBox(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredGridUseUiHeight() {
        return true;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=200.0)
    @ConfigPropertyValue(value="-1")
    protected int getConfiguredGridColumnCount() {
        return -1;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=230.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredBorderVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=231.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredExpandable() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=232.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredExpanded() {
        return true;
    }

    @ConfigProperty(value="STRING")
    @Order(value=233.0)
    @ConfigPropertyValue(value="BORDER_DECORATION_AUTO")
    protected String getConfiguredBorderDecoration() {
        return "auto";
    }

    @ConfigProperty(value="STRING")
    @Order(value=240.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredBackgroundImageName() {
        return null;
    }

    @ConfigProperty(value="HORIZONTAL_ALIGNMENT")
    @Order(value=250.0)
    @ConfigPropertyValue(value="0")
    protected int getConfiguredBackgroundImageHorizontalAlignment() {
        return 0;
    }

    @ConfigProperty(value="VERTICAL_ALIGNMENT")
    @Order(value=260.0)
    @ConfigPropertyValue(value="0")
    protected int getConfiguredBackgroundImageVerticalAlignment() {
        return 0;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=270.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredScrollable() {
        return false;
    }

    @Override
    @ConfigPropertyValue(value="FULL_WIDTH")
    protected int getConfiguredGridW() {
        return 0;
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        this.m_bodyGrid = new GroupBoxBodyGrid(this);
        this.m_customProcessButtonGrid = new GroupBoxProcessButtonGrid(this, true, false);
        this.m_systemProcessButtonGrid = new GroupBoxProcessButtonGrid(this, false, true);
        super.initConfig();
        IFormField[] a = this.getFields();
        ArrayList<IFormField> controlList = new ArrayList<IFormField>();
        ArrayList<IGroupBox> groupList = new ArrayList<IGroupBox>();
        ArrayList<IButton> customButtonList = new ArrayList<IButton>();
        ArrayList<IButton> systemButtonList = new ArrayList<IButton>();
        int i = 0;
        while (i < a.length) {
            IFormField f = a[i];
            if (f instanceof IGroupBox) {
                groupList.add((IGroupBox)f);
                controlList.add(f);
            } else if (f instanceof IButton) {
                IButton b = (IButton)f;
                if (b.isProcessButton()) {
                    if (b.getSystemType() != 0) {
                        systemButtonList.add((IButton)f);
                    } else {
                        customButtonList.add((IButton)f);
                    }
                } else {
                    controlList.add(f);
                }
            } else {
                controlList.add(f);
            }
            ++i;
        }
        this.m_controlFields = controlList.toArray(new IFormField[controlList.size()]);
        this.m_groupBoxes = groupList.toArray(new IGroupBox[groupList.size()]);
        this.m_customButtons = customButtonList.toArray(new IButton[customButtonList.size()]);
        this.m_systemButtons = systemButtonList.toArray(new IButton[systemButtonList.size()]);
        this.setExpandable(this.getConfiguredExpandable());
        this.setExpanded(this.getConfiguredExpanded());
        this.setBorderVisible(this.getConfiguredBorderVisible());
        this.setBorderDecoration(this.getConfiguredBorderDecoration());
        this.setGridColumnCountHint(this.getConfiguredGridColumnCount());
        this.setBackgroundImageName(this.getConfiguredBackgroundImageName());
        this.setBackgroundImageHorizontalAlignment(this.getConfiguredBackgroundImageHorizontalAlignment());
        this.setBackgroundImageVerticalAlignment(this.getConfiguredBackgroundImageVerticalAlignment());
        this.setScrollable(this.getConfiguredScrollable());
    }

    @Override
    public IKeyStroke[] getContributedKeyStrokes() {
        ArrayList<AbstractKeyStroke> list = new ArrayList<AbstractKeyStroke>(2);
        if (this.isMainBox() && this.getForm() != null && this.getForm().getOuterForm() == null) {
            boolean hasEnter = false;
            boolean hasEscape = false;
            IKeyStroke[] iKeyStrokeArray = this.getLocalKeyStrokes();
            int n = iKeyStrokeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IKeyStroke ks = iKeyStrokeArray[n2];
                if ("enter".equalsIgnoreCase(ks.getKeyStroke())) {
                    hasEnter = true;
                }
                if ("escape".equalsIgnoreCase(ks.getKeyStroke())) {
                    hasEscape = true;
                }
                ++n2;
            }
            if (!hasEnter) {
                list.add(new DefaultFormEnterKeyStroke(this.getForm()));
            }
            if (!hasEscape) {
                list.add(new DefaultFormEscapeKeyStroke(this.getForm()));
            }
        }
        return list.toArray(new IKeyStroke[list.size()]);
    }

    @Override
    public void rebuildFieldGrid() {
        this.m_bodyGrid.validate();
        this.m_customProcessButtonGrid.validate();
        this.m_systemProcessButtonGrid.validate();
        if (this.isInitialized() && this.getForm() != null) {
            this.getForm().structureChanged(this);
        }
    }

    @Override
    public boolean isMainBox() {
        return this.m_mainBoxFlag;
    }

    @Override
    public void setMainBox(boolean b) {
        this.m_mainBoxFlag = b;
    }

    @Override
    public int getGroupBoxIndex(IGroupBox groupBox) {
        int i = 0;
        while (i < this.m_groupBoxes.length) {
            if (this.m_groupBoxes[i] == groupBox) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getCustomProcessButtonCount() {
        return this.m_customButtons.length;
    }

    @Override
    public int getGroupBoxCount() {
        return this.m_groupBoxes.length;
    }

    @Override
    public int getSystemProcessButtonCount() {
        return this.m_systemButtons.length;
    }

    @Override
    public IGroupBox[] getGroupBoxes() {
        IGroupBox[] a = new IGroupBox[this.m_groupBoxes.length];
        System.arraycopy(this.m_groupBoxes, 0, a, 0, a.length);
        return a;
    }

    @Override
    public IFormField[] getControlFields() {
        IFormField[] a = new IFormField[this.m_controlFields.length];
        System.arraycopy(this.m_controlFields, 0, a, 0, a.length);
        return a;
    }

    @Override
    public IButton[] getCustomProcessButtons() {
        IButton[] a = new IButton[this.m_customButtons.length];
        System.arraycopy(this.m_customButtons, 0, a, 0, a.length);
        return a;
    }

    @Override
    public IButton[] getSystemProcessButtons() {
        IButton[] a = new IButton[this.m_systemButtons.length];
        System.arraycopy(this.m_systemButtons, 0, a, 0, a.length);
        return a;
    }

    @Override
    public final int getGridColumnCount() {
        return this.m_bodyGrid.getGridColumnCount();
    }

    @Override
    public final int getGridRowCount() {
        return this.m_bodyGrid.getGridRowCount();
    }

    @Override
    public void setGridColumnCountHint(int c) {
        this.m_gridColumnCountHint = c;
        if (this.isInitialized()) {
            this.rebuildFieldGrid();
        }
    }

    @Override
    public int getGridColumnCountHint() {
        return this.m_gridColumnCountHint;
    }

    @Override
    public boolean isScrollable() {
        return this.m_scrollable;
    }

    @Override
    public void setScrollable(boolean scrollable) {
        if (this.m_scrollable != scrollable) {
            this.m_scrollable = scrollable;
            if (this.m_scrollable) {
                GridData gd = this.getGridDataHints();
                if (gd.weightY <= 0.0) {
                    gd.weightY = 1.0;
                    this.setGridDataHints(gd);
                }
            }
        }
    }

    @Override
    protected void handleFieldVisibilityChanged() {
        super.handleFieldVisibilityChanged();
        if (this.isInitialized()) {
            this.rebuildFieldGrid();
        }
    }

    @Override
    public boolean isBorderVisible() {
        return this.propertySupport.getPropertyBool("borderVisible");
    }

    @Override
    public void setBorderVisible(boolean b) {
        this.propertySupport.setPropertyBool("borderVisible", b);
    }

    @Override
    public String getBorderDecoration() {
        return this.propertySupport.getPropertyString("borderDecoration");
    }

    @Override
    public void setBorderDecoration(String s) {
        this.propertySupport.setPropertyString("borderDecoration", s);
    }

    @Override
    public boolean isExpandable() {
        return this.propertySupport.getPropertyBool("expandable");
    }

    @Override
    public void setExpandable(boolean b) {
        this.propertySupport.setPropertyBool("expandable", b);
    }

    @Override
    public boolean isExpanded() {
        return this.propertySupport.getPropertyBool("expanded");
    }

    @Override
    public void setExpanded(boolean b) {
        this.propertySupport.setPropertyBool("expanded", b);
    }

    @Override
    public IGroupBoxUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public void setBackgroundImageName(String imageName) {
        this.propertySupport.setPropertyString("backgroundImageName", imageName);
    }

    @Override
    public String getBackgroundImageName() {
        return this.propertySupport.getPropertyString("backgroundImageName");
    }

    @Override
    public void setBackgroundImageVerticalAlignment(int a) {
        this.propertySupport.setPropertyInt("backgroundImageVerticalAlignment", a);
    }

    @Override
    public int getBackgroundImageVerticalAlignment() {
        return this.propertySupport.getPropertyInt("backgroundImageVerticalAlignment");
    }

    @Override
    public void setBackgroundImageHorizontalAlignment(int a) {
        this.propertySupport.setPropertyInt("backgroundImageHorizontalAlignment", a);
    }

    @Override
    public int getBackgroundImageHorizontalAlignment() {
        return this.propertySupport.getPropertyInt("backgroundImageHorizontalAlignment");
    }

    private class P_UIFacade
    implements IGroupBoxUIFacade {
        private P_UIFacade() {
        }

        @Override
        public void setExpandedFromUI(boolean expanded) {
            AbstractGroupBox.this.setExpanded(expanded);
        }
    }
}

