/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.clientnotification.internal;

import java.util.EventListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientAsyncJob;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.clientnotification.ClientNotificationConsumerEvent;
import org.eclipse.scout.rt.client.services.common.clientnotification.IClientNotificationConsumerListener;
import org.eclipse.scout.rt.client.services.common.clientnotification.IClientNotificationConsumerService;
import org.eclipse.scout.rt.shared.services.common.clientnotification.IClientNotification;
import org.eclipse.scout.service.AbstractService;

@Priority(value=-3.0f)
public class ClientNotificationConsumerService
extends AbstractService
implements IClientNotificationConsumerService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ClientNotificationConsumerService.class);
    private static final String SESSION_DATA_KEY = "clientNotificationConsumerServiceState";
    private final EventListenerList m_globalListenerList = new EventListenerList();

    private ServiceState getServiceState(IClientSession session) {
        if (session == null) {
            throw new IllegalStateException("session is null");
        }
        ServiceState data = (ServiceState)session.getData(SESSION_DATA_KEY);
        if (data == null) {
            data = new ServiceState();
            session.setData(SESSION_DATA_KEY, data);
        }
        return data;
    }

    @Override
    public void dispatchClientNotifications(final IClientNotification[] notifications, final IClientSession session) {
        if (notifications == null || notifications.length == 0) {
            return;
        }
        if (ClientJob.getCurrentSession() == session) {
            IClientNotification[] iClientNotificationArray = notifications;
            int n = notifications.length;
            int n2 = 0;
            while (n2 < n) {
                IClientNotification n3 = iClientNotificationArray[n2];
                this.fireEvent(session, n3, true);
                ++n2;
            }
        } else {
            new ClientAsyncJob("Dispatch client notifications", session){

                @Override
                protected void runVoid(IProgressMonitor monitor) throws Throwable {
                    IClientNotification[] iClientNotificationArray = notifications;
                    int n = notifications.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClientNotification n3 = iClientNotificationArray[n2];
                        ClientNotificationConsumerService.this.fireEvent(session, n3, false);
                        ++n2;
                    }
                }
            }.schedule();
        }
    }

    @Override
    @Deprecated
    public void addClientNotificationConsumerListener(IClientNotificationConsumerListener listener) {
        this.addClientNotificationConsumerListener(ClientJob.getCurrentSession(), listener);
    }

    @Override
    @Deprecated
    public void removeClientNotificationConsumerListener(IClientNotificationConsumerListener listener) {
        this.removeClientNotificationConsumerListener(ClientJob.getCurrentSession(), listener);
    }

    @Override
    public void addClientNotificationConsumerListener(IClientSession session, IClientNotificationConsumerListener listener) {
        this.getServiceState((IClientSession)session).m_listenerList.add(IClientNotificationConsumerListener.class, (EventListener)listener);
    }

    @Override
    public void removeClientNotificationConsumerListener(IClientSession session, IClientNotificationConsumerListener listener) {
        this.getServiceState((IClientSession)session).m_listenerList.remove(IClientNotificationConsumerListener.class, (EventListener)listener);
    }

    @Override
    public void addGlobalClientNotificationConsumerListener(IClientNotificationConsumerListener listener) {
        this.m_globalListenerList.add(IClientNotificationConsumerListener.class, (EventListener)listener);
    }

    @Override
    public void removeGlobalClientNotificationConsumerListener(IClientNotificationConsumerListener listener) {
        this.m_globalListenerList.remove(IClientNotificationConsumerListener.class, (EventListener)listener);
    }

    private void fireEvent(IClientSession session, IClientNotification notification, boolean sync) {
        IClientNotificationConsumerListener listener;
        int n;
        int n2;
        IClientNotificationConsumerListener[] iClientNotificationConsumerListenerArray;
        ClientNotificationConsumerEvent e = new ClientNotificationConsumerEvent(this, notification);
        IClientNotificationConsumerListener[] globalListeners = (IClientNotificationConsumerListener[])this.m_globalListenerList.getListeners(IClientNotificationConsumerListener.class);
        IClientNotificationConsumerListener[] listeners = (IClientNotificationConsumerListener[])this.getServiceState((IClientSession)session).m_listenerList.getListeners(IClientNotificationConsumerListener.class);
        if (globalListeners != null) {
            iClientNotificationConsumerListenerArray = globalListeners;
            n2 = globalListeners.length;
            n = 0;
            while (n < n2) {
                listener = iClientNotificationConsumerListenerArray[n];
                try {
                    listener.handleEvent(e, sync);
                }
                catch (Throwable t) {
                    LOG.error("Listener " + listener.getClass().getName() + " on event " + notification, t);
                }
                ++n;
            }
        }
        if (listeners != null) {
            iClientNotificationConsumerListenerArray = listeners;
            n2 = listeners.length;
            n = 0;
            while (n < n2) {
                listener = iClientNotificationConsumerListenerArray[n];
                try {
                    listener.handleEvent(e, sync);
                }
                catch (Throwable t) {
                    LOG.error("Listener " + listener.getClass().getName() + " on event " + notification, t);
                }
                ++n;
            }
        }
    }

    private static class ServiceState {
        EventListenerList m_listenerList = new EventListenerList();

        private ServiceState() {
        }
    }
}

