/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.tree;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.AbstractAction;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionVisitor;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;

public abstract class AbstractActionNode<T extends IActionNode>
extends AbstractAction
implements IActionNode<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractActionNode.class);
    private T m_parent;

    public AbstractActionNode() {
    }

    public AbstractActionNode(boolean callInitializer) {
        super(callInitializer);
    }

    private Class<? extends IActionNode>[] getConfiguredChildActions() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])dca, IActionNode.class);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        ArrayList<IActionNode> nodeList = new ArrayList<IActionNode>();
        Class<IActionNode>[] ma = this.getConfiguredChildActions();
        int i = 0;
        while (i < ma.length) {
            try {
                IActionNode node = (IActionNode)ConfigurationUtility.newInnerInstance((Object)this, ma[i]);
                node.setParent(this);
                nodeList.add(node);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
            ++i;
        }
        try {
            this.injectActionNodesInternal(nodeList);
        }
        catch (Exception e) {
            LOG.error("error occured while dynamically contribute action nodes.", (Throwable)e);
        }
        this.setChildActions(nodeList);
    }

    protected void injectActionNodesInternal(List<T> nodeList) {
    }

    @Override
    public T getParent() {
        return this.m_parent;
    }

    @Override
    public void setParent(T parent) {
        this.m_parent = parent;
    }

    @Override
    protected void prepareActionInternal() throws ProcessingException {
        super.prepareActionInternal();
        for (IActionNode node : this.getChildActionsInternal()) {
            node.prepareAction();
        }
    }

    private List<T> getChildActionsInternal() {
        return (List)this.propertySupport.getProperty("childActions");
    }

    @Override
    public boolean hasChildActions() {
        return this.getChildActionsInternal().size() > 0;
    }

    @Override
    public int getChildActionCount() {
        return this.getChildActionsInternal().size();
    }

    @Override
    public List<T> getChildActions() {
        return new ArrayList<T>(this.getChildActionsInternal());
    }

    @Override
    public void setChildActions(List<T> newList) {
        this.propertySupport.setProperty("childActions", new ArrayList<T>(newList));
    }

    @Override
    public int acceptVisitor(IActionVisitor visitor) {
        switch (visitor.visit(this)) {
            case 0: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 2: {
                this.visitChildren(visitor);
                return 0;
            }
        }
        return this.visitChildren(visitor);
    }

    private int visitChildren(IActionVisitor visitor) {
        for (IAction t : this.getChildActions()) {
            switch (t.acceptVisitor(visitor)) {
                case 0: {
                    return 0;
                }
            }
        }
        return 1;
    }
}

