/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.FormData;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.xmlparser.SimpleXmlElement;
import org.eclipse.scout.rt.client.ui.action.keystroke.AbstractKeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeVisitor;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeAdapter;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.composer.ComposerFieldDataModel;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerField;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerFieldUIFacade;
import org.eclipse.scout.rt.client.ui.form.fields.composer.attribute.IComposerAttribute;
import org.eclipse.scout.rt.client.ui.form.fields.composer.entity.IComposerEntity;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.AttributeNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.EitherOrNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.EntityNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.RootNode;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.composer.AbstractComposerData;
import org.eclipse.scout.rt.shared.data.form.fields.composer.ComposerAttributeNodeData;
import org.eclipse.scout.rt.shared.data.form.fields.composer.ComposerEitherOrNodeData;
import org.eclipse.scout.rt.shared.data.form.fields.composer.ComposerEntityNodeData;
import org.eclipse.scout.rt.shared.data.form.fields.treefield.AbstractTreeFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.treefield.TreeNodeData;
import org.eclipse.scout.rt.shared.data.model.AttributePath;
import org.eclipse.scout.rt.shared.data.model.DataModelAttributeOp;
import org.eclipse.scout.rt.shared.data.model.DataModelUtility;
import org.eclipse.scout.rt.shared.data.model.EntityPath;
import org.eclipse.scout.rt.shared.data.model.IDataModel;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttributeOp;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;

@FormData(value=AbstractComposerData.class, sdkCommand=FormData.SdkCommand.USE, defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.CREATE)
public abstract class AbstractComposerField
extends AbstractFormField
implements IComposerField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractComposerField.class);
    private IComposerFieldUIFacade m_uiFacade;
    private ITree m_tree;
    private SimpleXmlElement m_initValue;
    private IDataModel m_dataModel;

    public AbstractComposerField() {
        this(true);
    }

    public AbstractComposerField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    public IDataModel getDataModel() {
        return this.m_dataModel;
    }

    @Override
    public void setDataModel(IDataModel dm) {
        this.m_dataModel = dm;
    }

    @ConfigOperation
    @Order(value=97.0)
    protected IDataModel execCreateDataModel() {
        ComposerFieldDataModel m = new ComposerFieldDataModel(this);
        m.init();
        return m;
    }

    @ConfigOperation
    @Order(value=98.0)
    protected void execResolveRootPathForTopLevelEntity(IDataModelEntity e, List<IDataModelEntity> lifeList) {
        IDataModelEntity tmp = e != null ? e.getParentEntity() : null;
        while (tmp != null) {
            lifeList.add(0, tmp);
            tmp = tmp.getParentEntity();
        }
    }

    @ConfigOperation
    @Order(value=98.0)
    protected void execResolveRootPathForTopLevelAttribute(IDataModelAttribute a, List<IDataModelEntity> lifeList) {
        IDataModelEntity tmp = a != null ? a.getParentEntity() : null;
        while (tmp != null) {
            lifeList.add(0, tmp);
            tmp = tmp.getParentEntity();
        }
    }

    @ConfigOperation
    @Order(value=99.0)
    protected EntityPath execResolveEntityPath(EntityNode node) {
        LinkedList<IDataModelEntity> list = new LinkedList<IDataModelEntity>();
        EntityNode tmp = node;
        while (tmp != null) {
            if (tmp.getEntity() != null) {
                list.add(0, tmp.getEntity());
            }
            tmp = tmp.getAncestorNode(EntityNode.class);
        }
        if (list.size() > 0) {
            this.execResolveRootPathForTopLevelEntity((IDataModelEntity)list.get(0), list);
        }
        return new EntityPath(list);
    }

    @ConfigOperation
    @Order(value=99.0)
    protected AttributePath execResolveAttributePath(AttributeNode node) {
        LinkedList<IDataModelEntity> list = new LinkedList<IDataModelEntity>();
        if (node == null) {
            return null;
        }
        EntityNode tmp = node.getAncestorNode(EntityNode.class);
        while (tmp != null) {
            if (tmp.getEntity() != null) {
                list.add(0, tmp.getEntity());
            }
            tmp = tmp.getAncestorNode(EntityNode.class);
        }
        if (list.size() > 0) {
            this.execResolveRootPathForTopLevelEntity((IDataModelEntity)list.get(0), list);
        } else {
            this.execResolveRootPathForTopLevelAttribute(node.getAttribute(), list);
        }
        return new AttributePath(list, node.getAttribute());
    }

    private Class<? extends ITree> getConfiguredTree() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        Class[] f = ConfigurationUtility.filterClasses((Class[])dca, ITree.class);
        if (f.length == 1) {
            return f[0];
        }
        Class[] classArray = f;
        int n = f.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            if (c.getDeclaringClass() != AbstractComposerField.class) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    @ConfigOperation
    @Order(value=100.0)
    protected RootNode execCreateRootNode() {
        return new RootNode(this);
    }

    @ConfigOperation
    @Order(value=110.0)
    protected EntityNode execCreateEntityNode(ITreeNode parentNode, IDataModelEntity e, boolean negated, Object[] values, String[] texts) {
        EntityNode node = new EntityNode((IComposerField)this, e);
        node.setValues(values);
        node.setTexts(texts);
        node.setNegative(negated);
        node.setStatus(1);
        return node;
    }

    @ConfigOperation
    @Order(value=120.0)
    protected AttributeNode execCreateAttributeNode(ITreeNode parentNode, IDataModelAttribute a, Integer aggregationType, IDataModelAttributeOp op, Object[] values, String[] texts) {
        if (aggregationType != null && aggregationType == 0) {
            aggregationType = null;
        }
        AttributeNode node = new AttributeNode((IComposerField)this, a);
        node.setAggregationType(aggregationType);
        node.setOp(op);
        node.setValues(values);
        node.setTexts(texts);
        node.setStatus(1);
        return node;
    }

    @ConfigOperation
    @Order(value=130.0)
    protected EitherOrNode execCreateEitherNode(ITreeNode parentNode, boolean negated) {
        EitherOrNode node = new EitherOrNode(this, true);
        node.setNegative(negated);
        node.setStatus(1);
        return node;
    }

    @ConfigOperation
    @Order(value=140.0)
    protected EitherOrNode execCreateAdditionalOrNode(ITreeNode parentNode, boolean negated) {
        EitherOrNode node = new EitherOrNode(this, false);
        node.setNegative(negated);
        node.setStatus(1);
        return node;
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        super.initConfig();
        this.m_dataModel = this.execCreateDataModel();
        if (this.getConfiguredTree() != null) {
            try {
                this.m_tree = (ITree)ConfigurationUtility.newInnerInstance((Object)this, this.getConfiguredTree());
                RootNode rootNode = this.execCreateRootNode();
                rootNode.getCellForUpdate().setText(this.getLabel());
                this.m_tree.setRootNode(rootNode);
                this.m_tree.setNodeExpanded(rootNode, true);
                this.m_tree.setEnabled(this.isEnabled());
                this.m_tree.addTreeListener(new TreeAdapter(){

                    @Override
                    public void treeChanged(TreeEvent e) {
                        switch (e.getType()) {
                            case 10: 
                            case 20: 
                            case 30: {
                                AbstractComposerField.this.checkSaveNeeded();
                                AbstractComposerField.this.checkEmpty();
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            LOG.warn("there is no inner class of type ITree in " + this.getClass());
        }
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (AbstractComposerField.this.m_tree != null) {
                    AbstractComposerField.this.m_tree.setEnabled(AbstractComposerField.this.isEnabled());
                }
            }
        });
    }

    @Override
    protected void initFieldInternal() throws ProcessingException {
        this.getTree().initTree();
        super.initFieldInternal();
    }

    @Override
    protected void disposeFieldInternal() {
        super.disposeFieldInternal();
        this.getTree().disposeTree();
    }

    @Override
    public final ITree getTree() {
        return this.m_tree;
    }

    @Override
    public void exportFormFieldData(AbstractFormFieldData target) throws ProcessingException {
        AbstractTreeFieldData treeFieldData = (AbstractTreeFieldData)target;
        if (this.m_tree != null) {
            this.m_tree.exportTreeData(treeFieldData);
        }
    }

    @Override
    public void importFormFieldData(AbstractFormFieldData source, boolean valueChangeTriggersEnabled) throws ProcessingException {
        AbstractTreeFieldData treeFieldData = (AbstractTreeFieldData)source;
        if (treeFieldData.isValueSet() && this.m_tree != null) {
            try {
                if (!valueChangeTriggersEnabled) {
                    this.setValueChangeTriggerEnabled(false);
                }
                this.m_tree.importTreeData(treeFieldData);
            }
            finally {
                if (!valueChangeTriggersEnabled) {
                    this.setValueChangeTriggerEnabled(true);
                }
            }
        }
    }

    @Override
    public IDataModelAttribute[] getAttributes() {
        return this.m_dataModel.getAttributes();
    }

    @Override
    public IDataModelEntity[] getEntities() {
        return this.m_dataModel.getEntities();
    }

    @Deprecated
    public IComposerEntity[] getComposerEntities() {
        return (IComposerEntity[])this.m_dataModel.getEntities();
    }

    @Deprecated
    public IComposerAttribute[] getComposerAttributes() {
        return (IComposerAttribute[])this.m_dataModel.getAttributes();
    }

    @Override
    public void loadXML(SimpleXmlElement x) throws ProcessingException {
        super.loadXML(x);
        ITree tree = this.getTree();
        try {
            tree.setTreeChanging(true);
            this.getTree().removeAllChildNodes(this.getTree().getRootNode());
            this.loadXMLRec(x, this.getTree().getRootNode());
        }
        finally {
            tree.setTreeChanging(false);
        }
    }

    private void loadXMLRec(SimpleXmlElement x, ITreeNode parent) {
        for (SimpleXmlElement xmlElem : x.getChildren()) {
            boolean negated;
            if ("attribute".equals(xmlElem.getName())) {
                IDataModelAttribute foundAtt;
                Integer aggregationType;
                IDataModelAttributeOp op;
                String id;
                block20: {
                    id = xmlElem.getStringAttribute("id");
                    try {
                        op = DataModelAttributeOp.create((int)xmlElem.getIntAttribute("op", 20));
                        aggregationType = xmlElem.getIntAttribute("aggregationType", 0);
                        if (aggregationType != 0) break block20;
                        aggregationType = null;
                    }
                    catch (Exception e) {
                        LOG.warn("read op", (Throwable)e);
                        continue;
                    }
                }
                ArrayList<Object> valueList = new ArrayList<Object>();
                try {
                    int i = 1;
                    while (i <= 5) {
                        String valueName;
                        String string = valueName = i == 1 ? "value" : "value" + i;
                        if (xmlElem.hasAttribute(valueName)) {
                            valueList.add(xmlElem.getObjectAttribute(valueName, null, this.getClass().getClassLoader()));
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    LOG.warn("read value for attribute " + id, (Throwable)e);
                    continue;
                }
                ArrayList<String> displayValueList = new ArrayList<String>();
                int i = 1;
                while (i <= 5) {
                    String displayValueName;
                    String string = displayValueName = i == 1 ? "displayValue" : "displayValue" + i;
                    if (xmlElem.hasAttribute(displayValueName)) {
                        displayValueList.add(xmlElem.getStringAttribute(displayValueName, null));
                    }
                    ++i;
                }
                AttributePath attPath = DataModelUtility.externalIdToAttributePath((IDataModel)this.getDataModel(), (String)id);
                IDataModelAttribute iDataModelAttribute = foundAtt = attPath != null ? attPath.getAttribute() : null;
                if (foundAtt == null) {
                    LOG.warn("cannot find attribute with id=" + id);
                    continue;
                }
                AttributeNode node = this.addAttributeNode(parent, foundAtt, aggregationType, op, valueList.toArray(), displayValueList.toArray(new String[1]));
                if (node == null) continue;
                this.loadXMLRec(xmlElem, node);
                continue;
            }
            if ("entity".equals(xmlElem.getName())) {
                String[] stringArray;
                IDataModelEntity foundEntity;
                String id = xmlElem.getStringAttribute("id");
                negated = xmlElem.getStringAttribute("negated", "false").equalsIgnoreCase("true");
                String text = xmlElem.getStringAttribute("displayValues", null);
                EntityPath entityPath = DataModelUtility.externalIdToEntityPath((IDataModel)this.getDataModel(), (String)id);
                IDataModelEntity iDataModelEntity = foundEntity = entityPath != null ? entityPath.lastElement() : null;
                if (foundEntity == null) {
                    LOG.warn("cannot find entity with id=" + id);
                    continue;
                }
                if (text != null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = text;
                } else {
                    stringArray = null;
                }
                EntityNode node = this.addEntityNode(parent, foundEntity, negated, null, stringArray);
                if (node == null) continue;
                this.loadXMLRec(xmlElem, node);
                continue;
            }
            if (!"or".equals(xmlElem.getName())) continue;
            boolean beginning = xmlElem.getStringAttribute("begin", "false").equalsIgnoreCase("true");
            negated = xmlElem.getStringAttribute("negated", "false").equalsIgnoreCase("true");
            EitherOrNode node = null;
            if (beginning) {
                node = this.addEitherNode(parent, negated);
            } else {
                EitherOrNode orNode = null;
                ITreeNode[] iTreeNodeArray = parent.getChildNodes();
                int n = iTreeNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITreeNode n3 = iTreeNodeArray[n2];
                    if (n3 instanceof EitherOrNode && ((EitherOrNode)n3).isBeginOfEitherOr()) {
                        orNode = (EitherOrNode)n3;
                    }
                    ++n2;
                }
                if (orNode != null) {
                    node = this.addAdditionalOrNode(orNode, negated);
                }
            }
            if (node == null) continue;
            this.loadXMLRec(xmlElem, node);
        }
    }

    @Override
    public void storeXML(SimpleXmlElement x) throws ProcessingException {
        super.storeXML(x);
        this.storeXMLRec(x, this.getTree().getRootNode());
    }

    private void createDataModelEntityPathRec(EntityNode node, List<IDataModelEntity> list) {
    }

    private void storeXMLRec(SimpleXmlElement x, ITreeNode parent) {
        ITreeNode[] iTreeNodeArray = parent.getChildNodes();
        int n = iTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode node = iTreeNodeArray[n2];
            if (node instanceof EntityNode) {
                EntityNode entityNode = (EntityNode)node;
                SimpleXmlElement xEntity = new SimpleXmlElement("entity");
                xEntity.setAttribute("id", (Object)DataModelUtility.entityPathToExternalId((IDataModel)this.getDataModel(), (EntityPath)this.execResolveEntityPath(entityNode)));
                xEntity.setAttribute("negated", (Object)(entityNode.isNegative() ? "true" : "false"));
                String[] texts = entityNode.getTexts();
                xEntity.setAttribute("displayValues", texts != null && texts.length > 0 ? StringUtility.emptyIfNull((Object)texts[0]) : null);
                x.addChild(xEntity);
                this.storeXMLRec(xEntity, node);
            } else if (node instanceof AttributeNode) {
                Object[] values;
                String[] texts;
                AttributeNode attNode = (AttributeNode)node;
                SimpleXmlElement xAtt = new SimpleXmlElement("attribute");
                xAtt.setAttribute("id", (Object)DataModelUtility.attributePathToExternalId((IDataModel)this.getDataModel(), (AttributePath)this.execResolveAttributePath(attNode)));
                IDataModelAttributeOp op = attNode.getOp();
                try {
                    xAtt.setAttribute("op", (Object)op.getOperator());
                    if (attNode.getAggregationType() != null) {
                        xAtt.setIntAttribute("aggregationType", attNode.getAggregationType().intValue());
                    }
                }
                catch (Exception e) {
                    LOG.warn("write op " + op, (Throwable)e);
                }
                if ((texts = attNode.getTexts()) != null) {
                    int i = 0;
                    while (i < texts.length) {
                        String displayValueName = i == 0 ? "displayValue" : "displayValue" + (i + 1);
                        xAtt.setAttribute(displayValueName, (Object)StringUtility.emptyIfNull((Object)texts[i]));
                        ++i;
                    }
                }
                if ((values = attNode.getValues()) != null) {
                    int i = 0;
                    while (i < values.length) {
                        String valueName = i == 0 ? "value" : "value" + (i + 1);
                        try {
                            xAtt.setObjectAttribute(valueName, values[i]);
                        }
                        catch (Exception e) {
                            LOG.warn("write value[" + i + "] for attribute " + attNode.getAttribute() + ": " + values[i], (Throwable)e);
                        }
                        ++i;
                    }
                }
                x.addChild(xAtt);
            } else if (node instanceof EitherOrNode) {
                EitherOrNode orNode = (EitherOrNode)node;
                SimpleXmlElement xOr = new SimpleXmlElement("or");
                xOr.setAttribute("begin", (Object)("" + orNode.isBeginOfEitherOr()));
                xOr.setAttribute("negated", (Object)(orNode.isNegative() ? "true" : "false"));
                x.addChild(xOr);
                this.storeXMLRec(xOr, node);
            }
            ++n2;
        }
    }

    @Override
    public void resetValue() {
        if (this.m_initValue == null) {
            this.getTree().removeAllChildNodes(this.getTree().getRootNode());
        } else {
            try {
                this.loadXML(this.m_initValue);
            }
            catch (ProcessingException e) {
                LOG.error("unexpected error occured while restoring initial value", (Throwable)e);
                this.getTree().removeAllChildNodes(this.getTree().getRootNode());
            }
        }
        this.checkSaveNeeded();
        this.checkEmpty();
    }

    @Override
    public EntityNode addEntityNode(ITreeNode parentNode, IDataModelEntity e, boolean negated, Object[] values, String[] texts) {
        EntityNode node = this.execCreateEntityNode(parentNode, e, negated, values, texts);
        if (node != null) {
            this.getTree().addChildNode(parentNode, node);
            this.getTree().setNodeExpanded(node, true);
        }
        return node;
    }

    @Override
    public EitherOrNode addEitherNode(ITreeNode parentNode, boolean negated) {
        EitherOrNode node = this.execCreateEitherNode(parentNode, negated);
        if (node != null) {
            this.getTree().addChildNode(parentNode, node);
            this.getTree().setNodeExpanded(node, true);
        }
        return node;
    }

    @Override
    public EitherOrNode addAdditionalOrNode(ITreeNode parentNode, boolean negated) {
        EitherOrNode node = this.execCreateAdditionalOrNode(parentNode, negated);
        if (node != null) {
            this.getTree().addChildNode(parentNode.getChildNodeIndex() + 1, parentNode.getParentNode(), node);
            this.getTree().setNodeExpanded(node, true);
        }
        return node;
    }

    @Override
    public AttributeNode addAttributeNode(ITreeNode parentNode, IDataModelAttribute a, Integer aggregationType, IDataModelAttributeOp op, Object[] values, String[] texts) {
        AttributeNode node = this.execCreateAttributeNode(parentNode, a, aggregationType, op, values, texts);
        if (node != null) {
            this.getTree().addChildNode(parentNode, node);
        }
        return node;
    }

    public void updateInitialValue() {
        try {
            SimpleXmlElement element = new SimpleXmlElement();
            this.storeXML(element);
            this.m_initValue = element;
        }
        catch (ProcessingException e) {
            LOG.warn("unexpected error occured while storing initial value", (Throwable)e);
        }
    }

    @Override
    protected boolean execIsSaveNeeded() throws ProcessingException {
        boolean b = false;
        if (!b && this.m_tree.getDeletedNodeCount() > 0) {
            b = true;
        }
        if (!b && this.m_tree.getInsertedNodeCount() > 0) {
            b = true;
        }
        if (!b && this.m_tree.getUpdatedNodeCount() > 0) {
            b = true;
        }
        return b;
    }

    @Override
    protected void execMarkSaved() throws ProcessingException {
        try {
            this.m_tree.setTreeChanging(true);
            ITreeVisitor v = new ITreeVisitor(){

                @Override
                public boolean visit(ITreeNode node) {
                    if (!node.isStatusNonchanged()) {
                        node.setStatusInternal(0);
                        AbstractComposerField.this.m_tree.updateNode(node);
                    }
                    return true;
                }
            };
            this.m_tree.visitNode(this.m_tree.getRootNode(), v);
            this.m_tree.clearDeletedNodes();
            this.updateInitialValue();
        }
        finally {
            this.m_tree.setTreeChanging(false);
        }
    }

    @Override
    protected boolean execIsEmpty() throws ProcessingException {
        return this.m_tree.getRootNode() == null || this.m_tree.getRootNode().getChildNodeCount() <= 0;
    }

    @Override
    public IComposerFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    private class P_UIFacade
    implements IComposerFieldUIFacade {
        private P_UIFacade() {
        }
    }

    public class Tree
    extends AbstractTree {
        @Override
        protected boolean getConfiguredRootNodeVisible() {
            return true;
        }

        @Override
        protected TreeNodeData exportTreeNodeData(ITreeNode node, AbstractTreeFieldData treeData) throws ProcessingException {
            if (node instanceof EntityNode) {
                EntityNode enode = (EntityNode)node;
                String externalId = DataModelUtility.entityPathToExternalId((IDataModel)AbstractComposerField.this.getDataModel(), (EntityPath)AbstractComposerField.this.execResolveEntityPath(enode));
                if (externalId == null) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("could not find entity data for: " + enode.getEntity());
                    }
                    return null;
                }
                ComposerEntityNodeData data = new ComposerEntityNodeData();
                data.setEntityExternalId(externalId);
                data.setNegative(enode.isNegative());
                return data;
            }
            if (node instanceof AttributeNode) {
                AttributeNode anode = (AttributeNode)node;
                String externalId = DataModelUtility.attributePathToExternalId((IDataModel)AbstractComposerField.this.getDataModel(), (AttributePath)AbstractComposerField.this.execResolveAttributePath(anode));
                if (externalId == null) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("could not find attribute data for: " + anode.getAttribute());
                    }
                    return null;
                }
                ComposerAttributeNodeData data = new ComposerAttributeNodeData();
                data.setAttributeExternalId(externalId);
                data.setNegative(false);
                data.setAggregationType(anode.getAggregationType());
                data.setOperator(anode.getOp().getOperator());
                data.setValues(anode.getValues());
                return data;
            }
            if (node instanceof EitherOrNode) {
                EitherOrNode eonode = (EitherOrNode)node;
                ComposerEitherOrNodeData data = new ComposerEitherOrNodeData();
                data.setNegative(eonode.isNegative());
                data.setBeginOfEitherOr(eonode.isBeginOfEitherOr());
                return data;
            }
            return null;
        }

        @Override
        protected ITreeNode importTreeNodeData(ITreeNode parentNode, AbstractTreeFieldData treeData, TreeNodeData nodeData) throws ProcessingException {
            if (nodeData instanceof ComposerEntityNodeData) {
                IDataModelEntity e;
                ComposerEntityNodeData enodeData = (ComposerEntityNodeData)nodeData;
                String externalId = enodeData.getEntityExternalId();
                EntityPath entityPath = DataModelUtility.externalIdToEntityPath((IDataModel)AbstractComposerField.this.getDataModel(), (String)externalId);
                IDataModelEntity iDataModelEntity = e = entityPath != null ? entityPath.lastElement() : null;
                if (e == null) {
                    LOG.warn("could not find entity for: " + enodeData.getEntityExternalId());
                    return null;
                }
                return AbstractComposerField.this.addEntityNode(parentNode, e, enodeData.isNegative(), null, enodeData.getTexts());
            }
            if (nodeData instanceof ComposerAttributeNodeData) {
                IDataModelAttributeOp op;
                IDataModelAttribute a;
                ComposerAttributeNodeData anodeData = (ComposerAttributeNodeData)nodeData;
                String externalId = anodeData.getAttributeExternalId();
                AttributePath attPath = DataModelUtility.externalIdToAttributePath((IDataModel)AbstractComposerField.this.getDataModel(), (String)externalId);
                IDataModelAttribute iDataModelAttribute = a = attPath != null ? attPath.getAttribute() : null;
                if (a == null) {
                    LOG.warn("could not find attribute for: " + anodeData.getAttributeExternalId());
                    return null;
                }
                try {
                    op = DataModelAttributeOp.create((int)anodeData.getOperator());
                }
                catch (Exception e) {
                    LOG.warn("read op " + anodeData.getOperator(), (Throwable)e);
                    return null;
                }
                return AbstractComposerField.this.addAttributeNode(parentNode, a, anodeData.getAggregationType(), op, anodeData.getValues(), anodeData.getTexts());
            }
            if (nodeData instanceof ComposerEitherOrNodeData) {
                ComposerEitherOrNodeData eonodeData = (ComposerEitherOrNodeData)nodeData;
                if (eonodeData.isBeginOfEitherOr()) {
                    return AbstractComposerField.this.addEitherNode(parentNode, eonodeData.isNegative());
                }
                return AbstractComposerField.this.addAdditionalOrNode(parentNode, eonodeData.isNegative());
            }
            return null;
        }

        @Override
        protected void execDecorateCell(ITreeNode node, Cell cell) throws ProcessingException {
            node.decorateCell();
            if (this.getIconId() != null) {
                cell.setIconId(this.getIconId());
            } else if (node instanceof RootNode) {
                cell.setIconId("composerfield_root");
            } else if (node instanceof EntityNode) {
                cell.setIconId("composerfield_entity");
            } else if (node instanceof AttributeNode) {
                if (((AttributeNode)node).getAggregationType() != null) {
                    cell.setIconId("composerfield_aggregation");
                } else {
                    cell.setIconId("composerfield_attribute");
                }
            } else if (node instanceof EitherOrNode) {
                cell.setIconId("composerfield_eitheror");
            }
        }

        @Order(value=10.0)
        public class DeleteKeyStroke
        extends AbstractKeyStroke {
            @Override
            protected String getConfiguredKeyStroke() {
                return "delete";
            }

            @Override
            protected void execAction() throws ProcessingException {
                ITreeNode node;
                ITree tree = AbstractComposerField.this.getTree();
                if (tree != null && (node = tree.getSelectedNode()) != null && node.getTree() == tree) {
                    AbstractMenu menu = null;
                    if (node instanceof AttributeNode) {
                        menu = node.getMenu(AttributeNode.DeleteAttributeMenu.class);
                    } else if (node instanceof EntityNode) {
                        menu = node.getMenu(EntityNode.DeleteEntityMenu.class);
                    } else if (node instanceof EitherOrNode) {
                        menu = node.getMenu(EitherOrNode.DeleteEitherOrMenu.class);
                    }
                    if (menu != null) {
                        menu.prepareAction();
                        if (menu.isVisible() && menu.isEnabled()) {
                            menu.doAction();
                        }
                    }
                }
            }
        }
    }
}

