/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer.node;

import java.util.ArrayList;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuSeparator;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerField;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.AbstractAddAttributeMenu;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.AbstractComposerNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.EitherOrNode;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;

public class EntityNode
extends AbstractComposerNode {
    private IDataModelEntity m_entity;
    private boolean m_negated = false;
    private Object[] m_values;
    private String[] m_texts;

    public EntityNode(IComposerField composerField, IDataModelEntity entity) {
        super(composerField, false);
        this.m_entity = entity;
        this.callInitializer();
    }

    @Override
    protected void execInitTreeNode() {
        ArrayList<IMenu> menus = new ArrayList<IMenu>();
        IMenu[] iMenuArray = this.getMenus();
        int n = iMenuArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMenu m = iMenuArray[n2];
            if (m.getClass() == AddEntityPlaceholderOnEntityMenu.class) {
                this.attachAddEntityMenus(menus);
            } else {
                menus.add(m);
            }
            ++n2;
        }
        if (menus.size() > 0 && ((IMenu)menus.get(menus.size() - 1)).getClass() == Separator2Menu.class) {
            menus.remove(menus.size() - 1);
        }
        this.setMenus(menus.toArray(new IMenu[menus.size()]));
    }

    @Override
    protected void execDecorateCell(Cell cell) {
        StringBuffer label = new StringBuffer();
        if (this.getSiblingBefore() != null) {
            label.append(String.valueOf(ScoutTexts.get((String)"ExtendedSearchAnd", (String[])new String[0])) + " ");
        }
        if (this.isNegative()) {
            label.append(ScoutTexts.get((String)"ExtendedSearchNot", (String[])new String[0]));
        }
        label.append(" " + this.m_entity.getText());
        if (this.getChildNodeCount() > 0) {
            label.append(" " + ScoutTexts.get((String)"ExtendedSearchEntitySuffix", (String[])new String[0]));
        }
        cell.setText(label.toString());
    }

    public IDataModelEntity getEntity() {
        return this.m_entity;
    }

    public void setEntity(IDataModelEntity e) {
        this.m_entity = e;
    }

    public boolean isNegative() {
        return this.m_negated;
    }

    public void setNegative(boolean b) {
        this.m_negated = b;
    }

    public Object[] getValues() {
        return this.m_values;
    }

    public void setValues(Object[] values) {
        this.m_values = values;
    }

    public String[] getTexts() {
        return this.m_texts;
    }

    public void setTexts(String[] a) {
        this.m_texts = a;
    }

    @Order(value=10.0)
    public class AddAttributeOnEntityMenu
    extends AbstractAddAttributeMenu {
        public AddAttributeOnEntityMenu() {
            super(EntityNode.this.getComposerField(), EntityNode.this);
        }
    }

    @Order(value=20.0)
    public class AddEitherOrOnEntityMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return ScoutTexts.get((String)"ExtendedSearchAddEitherOrMenu", (String[])new String[0]);
        }

        @Override
        protected void execPrepareAction() throws ProcessingException {
            IDataModelAttribute[] atts = EntityNode.this.m_entity.getAttributes();
            IDataModelEntity[] ents = EntityNode.this.m_entity.getEntities();
            this.setVisible(atts != null && atts.length > 0 || ents != null && ents.length > 0);
        }

        @Override
        protected void execAction() throws ProcessingException {
            EitherOrNode node = EntityNode.this.getComposerField().addEitherNode(EntityNode.this, false);
            EntityNode.this.getComposerField().addAdditionalOrNode(node, false);
        }
    }

    @Order(value=70.0)
    public class AddEntityPlaceholderOnEntityMenu
    extends MenuSeparator {
    }

    @Order(value=50.0)
    public class DeleteEntityMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return ScoutTexts.get((String)"ExtendedSearchRemoveMenu", (String[])new String[0]);
        }

        @Override
        protected void execAction() throws ProcessingException {
            EntityNode.this.getTree().selectPreviousParentNode();
            EntityNode.this.getTree().removeNode(EntityNode.this);
        }
    }

    @Order(value=40.0)
    public class NegateEntityMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return ScoutTexts.get((String)"ExtendedSearchNegateMenu", (String[])new String[0]);
        }

        @Override
        protected void execAction() throws ProcessingException {
            EntityNode.this.setNegative(!EntityNode.this.isNegative());
            if (!EntityNode.this.isStatusInserted()) {
                EntityNode.this.setStatusInternal(2);
            }
            EntityNode.this.update();
        }
    }

    @Order(value=60.0)
    public class Separator2Menu
    extends MenuSeparator {
    }
}

