/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.decimalfield;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.VetoException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.decimalfield.IDecimalField;
import org.eclipse.scout.rt.client.ui.form.fields.decimalfield.IDecimalFieldUIFacade;
import org.eclipse.scout.rt.shared.ScoutTexts;

public abstract class AbstractDecimalField<T extends Number>
extends AbstractValueField<T>
implements IDecimalField<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractDecimalField.class);
    private IDecimalFieldUIFacade m_uiFacade;
    private String m_format;
    private boolean m_groupingUsed;
    private int m_fractionDigits;
    private int m_minFractionDigits;
    private int m_maxFractionDigits;
    private int m_multiplier;
    private boolean m_percent;
    private T m_minValue;
    private T m_maxValue;

    public AbstractDecimalField() {
        this(true);
    }

    public AbstractDecimalField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="STRING")
    @Order(value=230.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredFormat() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=290.0)
    @ConfigPropertyValue(value="2")
    protected int getConfiguredFractionDigits() {
        return 2;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=240.0)
    @ConfigPropertyValue(value="2")
    protected int getConfiguredMinFractionDigits() {
        return 2;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=250.0)
    @ConfigPropertyValue(value="2")
    protected int getConfiguredMaxFractionDigits() {
        return 2;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=260.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredGroupingUsed() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=270.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredPercent() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=280.0)
    @ConfigPropertyValue(value="1")
    protected int getConfiguredMultiplier() {
        return 1;
    }

    @Override
    @ConfigPropertyValue(value="1")
    protected int getConfiguredHorizontalAlignment() {
        return 1;
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        super.initConfig();
        this.setFormat(this.getConfiguredFormat());
        this.setMinFractionDigits(this.getConfiguredMinFractionDigits());
        this.setMaxFractionDigits(this.getConfiguredMaxFractionDigits());
        this.setGroupingUsed(this.getConfiguredGroupingUsed());
        this.setPercent(this.getConfiguredPercent());
        this.setFractionDigits(this.getConfiguredFractionDigits());
        this.setMultiplier(this.getConfiguredMultiplier());
    }

    @Override
    public void setMinFractionDigits(int i) {
        try {
            this.setFieldChanging(true);
            if (i > this.getMaxFractionDigits()) {
                this.m_maxFractionDigits = i;
            }
            this.m_minFractionDigits = i;
            if (this.isInitialized() && this.isAutoDisplayText()) {
                this.setDisplayText(this.execFormatValue((Number)this.getValue()));
            }
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public int getMinFractionDigits() {
        return this.m_minFractionDigits;
    }

    @Override
    public void setMaxFractionDigits(int i) {
        try {
            this.setFieldChanging(true);
            if (i < this.getMinFractionDigits()) {
                this.m_minFractionDigits = i;
            }
            this.m_maxFractionDigits = i;
            if (this.isInitialized() && this.isAutoDisplayText()) {
                this.setDisplayText(this.execFormatValue((Number)this.getValue()));
            }
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public int getMaxFractionDigits() {
        return this.m_maxFractionDigits;
    }

    @Override
    public void setPercent(boolean b) {
        this.m_percent = b;
        if (this.isInitialized() && this.isAutoDisplayText()) {
            this.setDisplayText(this.execFormatValue((Number)this.getValue()));
        }
    }

    @Override
    public boolean isPercent() {
        return this.m_percent;
    }

    @Override
    public void setFractionDigits(int i) {
        this.m_fractionDigits = i;
        if (this.isInitialized()) {
            this.setValue((Number)this.getValue());
        }
    }

    @Override
    public int getFractionDigits() {
        return this.m_fractionDigits;
    }

    @Override
    public void setFormat(String s) {
        this.m_format = s;
        if (this.isInitialized() && this.isAutoDisplayText()) {
            this.setDisplayText(this.execFormatValue((Number)this.getValue()));
        }
    }

    @Override
    public String getFormat() {
        return this.m_format;
    }

    @Override
    public void setGroupingUsed(boolean b) {
        this.m_groupingUsed = b;
        if (this.isInitialized() && this.isAutoDisplayText()) {
            this.setDisplayText(this.execFormatValue((Number)this.getValue()));
        }
    }

    @Override
    public boolean isGroupingUsed() {
        return this.m_groupingUsed;
    }

    private int compareInternal(T a, T b) {
        return CompareUtility.compareTo((Comparable)((Comparable)a), (Comparable)((Comparable)b));
    }

    @Override
    public void setMinValue(T n) {
        try {
            this.setFieldChanging(true);
            T max = this.getMaxValue();
            if (n != null && max != null && this.compareInternal(n, max) > 0) {
                this.m_maxValue = n;
            }
            this.m_minValue = n;
            if (this.isInitialized()) {
                this.setValue((Number)this.getValue());
            }
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public T getMinValue() {
        return this.m_minValue;
    }

    @Override
    public void setMaxValue(T n) {
        try {
            this.setFieldChanging(true);
            T min = this.getMinValue();
            if (n != null && min != null && this.compareInternal(n, min) < 0) {
                this.m_minValue = n;
            }
            this.m_maxValue = n;
            if (this.isInitialized()) {
                this.setValue((Number)this.getValue());
            }
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public T getMaxValue() {
        return this.m_maxValue;
    }

    @Override
    public void setMultiplier(int i) {
        this.m_multiplier = i;
        if (this.isInitialized()) {
            this.setValue((Number)this.getValue());
        }
    }

    @Override
    public int getMultiplier() {
        return this.m_multiplier;
    }

    @Override
    public IDecimalFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    protected String formatValueInternal(T validValue) {
        if (validValue == null) {
            return "";
        }
        String displayValue = this.createNumberFormat().format(validValue);
        return displayValue;
    }

    @Override
    protected T validateValueInternal(T rawValue) throws ProcessingException {
        T validValue = null;
        if ((rawValue = (Number)super.validateValueInternal(rawValue)) == null) {
            validValue = null;
        } else {
            if (this.getMaxValue() != null && this.compareInternal(rawValue, this.getMaxValue()) > 0) {
                throw new VetoException(ScoutTexts.get((String)"NumberTooLargeMessageXY", (String[])new String[]{this.formatValueInternal(this.getMinValue()), this.formatValueInternal(this.getMaxValue())}));
            }
            if (this.getMinValue() != null && this.compareInternal(rawValue, this.getMinValue()) < 0) {
                throw new VetoException(ScoutTexts.get((String)"NumberTooSmallMessageXY", (String[])new String[]{this.formatValueInternal(this.getMinValue()), this.formatValueInternal(this.getMaxValue())}));
            }
            validValue = rawValue;
        }
        return validValue;
    }

    protected NumberFormat createNumberFormat() {
        NumberFormat fmt = this.isPercent() ? NumberFormat.getPercentInstance(LocaleThreadLocal.get()) : NumberFormat.getNumberInstance(LocaleThreadLocal.get());
        if (fmt instanceof DecimalFormat) {
            ((DecimalFormat)fmt).setMultiplier(this.getMultiplier());
            if (this.getFormat() != null) {
                ((DecimalFormat)fmt).applyPattern(this.getFormat());
            } else {
                fmt.setMinimumFractionDigits(this.getMinFractionDigits());
                fmt.setMaximumFractionDigits(this.getMaxFractionDigits());
                fmt.setGroupingUsed(this.isGroupingUsed());
            }
        } else {
            fmt.setMinimumFractionDigits(this.getMinFractionDigits());
            fmt.setMaximumFractionDigits(this.getMaxFractionDigits());
            fmt.setGroupingUsed(this.isGroupingUsed());
        }
        return fmt;
    }

    private class P_UIFacade
    implements IDecimalFieldUIFacade {
        private P_UIFacade() {
        }

        @Override
        public boolean setTextFromUI(String newText) {
            if (newText != null && newText.length() == 0) {
                newText = null;
            }
            return AbstractDecimalField.this.parseValue(newText);
        }
    }
}

