/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.smartfield;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.VetoException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientAsyncJob;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.lookup.FormFieldProvisioningContext;
import org.eclipse.scout.rt.client.services.lookup.ILookupCallProvisioningService;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.ParsingFailedStatus;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.DefaultSmartFieldProposalFormProvider;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartFieldProposalForm;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartFieldProposalFormProvider;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartFieldUIFacade;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.SmartFieldEvent;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.SmartFieldListener;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.data.form.ValidationRule;
import org.eclipse.scout.rt.shared.services.common.code.CODES;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.lookup.CodeLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCallFetcher;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractSmartField<T>
extends AbstractValueField<T>
implements ISmartField<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractSmartField.class);
    private final EventListenerList m_listenerList = new EventListenerList();
    private ISmartFieldUIFacade m_uiFacade;
    private Class<? extends ICodeType> m_codeTypeClass;
    private LookupCall m_lookupCall;
    private Thread m_textFetchBackgroundThread;
    private LookupRow m_currentLookupRow;
    private P_GetLookupRowByKeyJob m_currentGetLookupRowByKeyJob;
    private P_ProposalFormListener m_proposalFormListener;
    private ISmartFieldProposalFormProvider m_proposalFormProvider;
    private int m_maxRowCount;
    private String m_browseNewText;
    private boolean m_installingRowContext = false;
    private LookupRow m_decorationRow;
    private IMenu[] m_menus;
    private TriState m_activeFilter;
    private boolean m_activeFilterEnabled;
    private boolean m_browseAutoExpandAll;
    private boolean m_browseHierarchy;
    private boolean m_loadIncremental;
    private boolean m_allowCustomText;

    public AbstractSmartField() {
        this(true);
    }

    public AbstractSmartField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=270.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredBrowseIconId() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=230.0)
    @ConfigPropertyValue(value="AbstractIcons.SmartFieldBrowse")
    protected String getConfiguredIconId() {
        return "smartfield_browse";
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=280.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredBrowseAutoExpandAll() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=290.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredAllowCustomText() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=300.0)
    @ConfigPropertyValue(value="true")
    @ValidationRule(value="zeroNullEquality")
    protected boolean getConfiguredTreat0AsNull() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=240.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredBrowseLoadIncremental() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=310.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredBrowseHierarchy() {
        return false;
    }

    @ConfigProperty(value="STRING")
    @Order(value=315.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredBrowseNewText() {
        return null;
    }

    @ConfigProperty(value="CODE_TYPE")
    @Order(value=260.0)
    @ConfigPropertyValue(value="null")
    @ValidationRule(value="codeType")
    protected Class<? extends ICodeType<?>> getConfiguredCodeType() {
        return null;
    }

    @ConfigProperty(value="LOOKUP_CALL")
    @Order(value=250.0)
    @ConfigPropertyValue(value="null")
    @ValidationRule(value="lookupCall")
    protected Class<? extends LookupCall> getConfiguredLookupCall() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=265.0)
    @ConfigPropertyValue(value="100")
    protected int getConfiguredBrowseMaxRowCount() {
        return 100;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=270.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredActiveFilterEnabled() {
        return false;
    }

    @ConfigOperation
    @Order(value=225.0)
    protected LookupRow execBrowseNew(String searchText) throws ProcessingException {
        return null;
    }

    @ConfigOperation
    @Order(value=230.0)
    protected void execPrepareLookup(LookupCall call) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=240.0)
    protected void execPrepareKeyLookup(LookupCall call, T key) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=250.0)
    protected void execPrepareTextLookup(LookupCall call, String text) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=260.0)
    protected void execPrepareBrowseLookup(LookupCall call, String browseHint) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=270.0)
    protected void execPrepareRecLookup(LookupCall call, T parentKey) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=280.0)
    protected void execFilterLookupResult(LookupCall call, List<LookupRow> result) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=290.0)
    protected void execFilterKeyLookupResult(LookupCall call, List<LookupRow> result) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=300.0)
    protected void execFilterTextLookupResult(LookupCall call, List<LookupRow> result) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=310.0)
    protected void execFilterBrowseLookupResult(LookupCall call, List<LookupRow> result) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=320.0)
    protected void execFilterRecLookupResult(LookupCall call, List<LookupRow> result) throws ProcessingException {
    }

    @Override
    public boolean acceptBrowseHierarchySelection(T value, int level, boolean leaf) {
        return true;
    }

    private Class<? extends IMenu>[] getConfiguredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])dca, IMenu.class);
    }

    @Override
    @ConfigPropertyValue(value="true")
    protected final boolean getConfiguredAutoDisplayText() {
        return true;
    }

    @Override
    public void setTooltipText(String text) {
        super.setTooltipText(text);
        if (!this.m_installingRowContext) {
            this.m_decorationRow.setTooltipText(this.getTooltipText());
        }
    }

    @Override
    public void setBackgroundColor(String c) {
        super.setBackgroundColor(c);
        if (!this.m_installingRowContext) {
            this.m_decorationRow.setBackgroundColor(this.getBackgroundColor());
        }
    }

    @Override
    public void setForegroundColor(String c) {
        super.setForegroundColor(c);
        if (!this.m_installingRowContext) {
            this.m_decorationRow.setForegroundColor(this.getForegroundColor());
        }
    }

    @Override
    public void setFont(FontSpec f) {
        super.setFont(f);
        if (!this.m_installingRowContext) {
            this.m_decorationRow.setFont(this.getFont());
        }
    }

    @Override
    protected void initConfig() {
        Class<LookupCall> lsCls;
        this.m_uiFacade = new P_UIFacade();
        this.m_activeFilter = TriState.TRUE;
        this.m_decorationRow = new LookupRow(null, "", null, null, null, null, null, true);
        super.initConfig();
        this.setActiveFilterEnabled(this.getConfiguredActiveFilterEnabled());
        this.setBrowseHierarchy(this.getConfiguredBrowseHierarchy());
        this.setBrowseAutoExpandAll(this.getConfiguredBrowseAutoExpandAll());
        this.setBrowseIconId(this.getConfiguredBrowseIconId());
        this.setBrowseLoadIncremental(this.getConfiguredBrowseLoadIncremental());
        this.setIconId(this.getConfiguredIconId());
        this.setBrowseMaxRowCount(this.getConfiguredBrowseMaxRowCount());
        this.setBrowseNewText(this.getConfiguredBrowseNewText());
        this.setAllowCustomText(this.getConfiguredAllowCustomText());
        this.setProposalFormProvider(this.createProposalFormProvider());
        if (this.getConfiguredCodeType() != null) {
            this.setCodeTypeClass(this.getConfiguredCodeType());
        }
        if ((lsCls = this.getConfiguredLookupCall()) != null) {
            try {
                LookupCall call = lsCls.newInstance();
                this.setLookupCall(call);
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException(this.getClass().getSimpleName(), (Throwable)e));
            }
        }
        ArrayList<IMenu> menuList = new ArrayList<IMenu>();
        Class<IMenu>[] a = this.getConfiguredMenus();
        int i = 0;
        while (i < a.length) {
            try {
                IMenu menu = (IMenu)ConfigurationUtility.newInnerInstance((Object)this, a[i]);
                menuList.add(menu);
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException(this.getClass().getSimpleName(), (Throwable)e));
            }
            ++i;
        }
        try {
            this.injectMenusInternal(menuList);
        }
        catch (Exception e) {
            LOG.error("error occured while dynamically contributing menus.", (Throwable)e);
        }
        this.m_menus = menuList.toArray(new IMenu[0]);
        if (this.isAllowCustomText() && this.getHolderType() != String.class) {
            LOG.warn(String.valueOf(this.getClass().getName()) + ": allowCustomText=true is normally used only on smart fields of generic type String.");
        }
    }

    protected void injectMenusInternal(List<IMenu> menuList) {
    }

    @Override
    public IMenu[] getMenus() {
        return this.m_menus;
    }

    @Override
    public boolean hasMenus() {
        return this.m_menus.length > 0;
    }

    @Override
    public void addSmartFieldListener(SmartFieldListener listener) {
        this.m_listenerList.add(SmartFieldListener.class, (EventListener)listener);
    }

    @Override
    public void removeSmartFieldListener(SmartFieldListener listener) {
        this.m_listenerList.remove(SmartFieldListener.class, (EventListener)listener);
    }

    private void fireSmartFieldEvent(SmartFieldEvent e) {
        EventListener[] listeners = this.m_listenerList.getListeners(SmartFieldListener.class);
        if (listeners != null && listeners.length > 0) {
            int i = 0;
            while (i < listeners.length) {
                ((SmartFieldListener)listeners[i]).smartFieldChanged(e);
                ++i;
            }
        }
    }

    @Override
    public boolean isActiveFilterEnabled() {
        return this.m_activeFilterEnabled;
    }

    @Override
    public void setActiveFilterEnabled(boolean b) {
        this.m_activeFilterEnabled = b;
    }

    @Override
    public TriState getActiveFilter() {
        return this.m_activeFilter;
    }

    @Override
    public void setActiveFilter(TriState t) {
        if (this.isActiveFilterEnabled()) {
            if (t == null) {
                t = TriState.TRUE;
            }
            this.m_activeFilter = t;
        }
    }

    @Override
    public void doBrowseNew(String newText) {
        if (this.getBrowseNewText() != null) {
            try {
                LookupRow newRow = this.execBrowseNew(newText);
                if (newRow != null) {
                    if (newRow.getKey() != null) {
                        this.setValue(newRow.getKey());
                    } else if (newRow.getText() != null) {
                        this.parseValue(newRow.getText());
                    }
                }
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
            }
        }
    }

    @Override
    public String getBrowseIconId() {
        return this.propertySupport.getPropertyString("browseIconId");
    }

    @Override
    public void setBrowseIconId(String s) {
        this.propertySupport.setPropertyString("browseIconId", s);
    }

    @Override
    public String getIconId() {
        return this.propertySupport.getPropertyString("iconId");
    }

    @Override
    public void setIconId(String s) {
        this.propertySupport.setPropertyString("iconId", s);
    }

    @Override
    public boolean isBrowseAutoExpandAll() {
        return this.m_browseAutoExpandAll;
    }

    @Override
    public void setBrowseAutoExpandAll(boolean b) {
        this.m_browseAutoExpandAll = b;
    }

    @Override
    public boolean isBrowseLoadIncremental() {
        return this.m_loadIncremental;
    }

    @Override
    public void setBrowseLoadIncremental(boolean b) {
        this.m_loadIncremental = b;
    }

    @Override
    public boolean isBrowseHierarchy() {
        return this.m_browseHierarchy;
    }

    @Override
    public void setBrowseHierarchy(boolean b) {
        this.m_browseHierarchy = b;
    }

    @Override
    public int getBrowseMaxRowCount() {
        return this.m_maxRowCount;
    }

    @Override
    public void setBrowseMaxRowCount(int n) {
        this.m_maxRowCount = n;
    }

    @Override
    public String getBrowseNewText() {
        return this.m_browseNewText;
    }

    @Override
    public void setBrowseNewText(String s) {
        this.m_browseNewText = s;
    }

    @Override
    public boolean isAllowCustomText() {
        return this.m_allowCustomText;
    }

    @Override
    public void setAllowCustomText(boolean b) {
        this.m_allowCustomText = b;
    }

    @Override
    public Class<? extends ICodeType> getCodeTypeClass() {
        return this.m_codeTypeClass;
    }

    @Override
    public void setCodeTypeClass(Class<? extends ICodeType> codeType) {
        this.m_codeTypeClass = codeType;
        this.m_lookupCall = null;
        if (this.m_codeTypeClass != null) {
            this.m_lookupCall = CodeLookupCall.newInstanceByService(this.m_codeTypeClass);
            ICodeType t = CODES.getCodeType(this.m_codeTypeClass);
            if (t != null && !ConfigurationUtility.isMethodOverwrite(AbstractSmartField.class, (String)"getConfiguredBrowseHierarchy", (Class[])new Class[0], this.getClass())) {
                this.setBrowseHierarchy(t.isHierarchy());
            }
        }
    }

    @Override
    public LookupCall getLookupCall() {
        return this.m_lookupCall;
    }

    @Override
    public void setLookupCall(LookupCall call) {
        this.m_lookupCall = call;
    }

    @Override
    public void setUniquelyDefinedValue(boolean background) throws ProcessingException {
        ILookupCallFetcher fetcher = new ILookupCallFetcher(){

            public void dataFetched(LookupRow[] rows, ProcessingException failed) {
                if (failed == null && rows.length == 1) {
                    Object uniqueValue = rows[0].getKey();
                    AbstractSmartField.this.setValue(uniqueValue);
                }
            }
        };
        if (background) {
            this.callBrowseLookupInBackground("*", 2, fetcher);
        } else {
            fetcher.dataFetched(this.callBrowseLookup("*", 2), null);
        }
    }

    @Override
    public ISmartFieldProposalForm getProposalForm() {
        return (ISmartFieldProposalForm)this.propertySupport.getProperty("proposalForm");
    }

    private void registerProposalFormInternal(ISmartFieldProposalForm form) {
        ISmartFieldProposalForm oldForm = this.getProposalForm();
        if (oldForm == form) {
            return;
        }
        if (oldForm != null) {
            if (this.m_proposalFormListener != null) {
                oldForm.removeFormListener(this.m_proposalFormListener);
                this.m_proposalFormListener = null;
            }
            try {
                oldForm.doClose();
            }
            catch (Throwable throwable) {}
        }
        if (form != null) {
            if (this.m_proposalFormListener == null) {
                this.m_proposalFormListener = new P_ProposalFormListener();
            }
            form.addFormListener(this.m_proposalFormListener);
        }
        this.propertySupport.setProperty("proposalForm", (Object)form);
    }

    private void unregisterProposalFormInternal(ISmartFieldProposalForm form) {
        if (form != null) {
            ISmartFieldProposalForm oldForm = this.getProposalForm();
            if (oldForm == form) {
                this.propertySupport.setProperty("proposalForm", null);
            }
            if (form.isFormOpen()) {
                try {
                    form.doClose();
                }
                catch (ProcessingException processingException) {}
            }
        }
    }

    @Override
    public ISmartFieldProposalFormProvider getProposalFormProvider() {
        return this.m_proposalFormProvider;
    }

    @Override
    public void setProposalFormProvider(ISmartFieldProposalFormProvider provider) {
        this.m_proposalFormProvider = provider;
    }

    public LookupRow getCurrentLookupRow() {
        return this.m_currentLookupRow;
    }

    protected ISmartFieldProposalForm createProposalForm() throws ProcessingException {
        ISmartFieldProposalFormProvider proposalFormProvider = this.getProposalFormProvider();
        if (proposalFormProvider == null) {
            return null;
        }
        return proposalFormProvider.createProposalForm(this);
    }

    protected ISmartFieldProposalFormProvider createProposalFormProvider() {
        return new DefaultSmartFieldProposalFormProvider();
    }

    @Override
    protected T parseValueInternal(String text) throws ProcessingException {
        if (text != null && text.length() == 0) {
            text = null;
        }
        ISmartFieldProposalForm smartForm = this.getProposalForm();
        LookupRow acceptedProposalRow = null;
        if (smartForm != null && StringUtility.equalsIgnoreNewLines((String)smartForm.getSearchText(), (String)text)) {
            acceptedProposalRow = smartForm.getAcceptedProposal();
        }
        try {
            String oldText = this.getDisplayText();
            boolean parsingError = this.getErrorStatus() instanceof ParsingFailedStatus;
            if (acceptedProposalRow == null && !parsingError && this.m_currentLookupRow != null && StringUtility.equalsIgnoreNewLines((String)StringUtility.emptyIfNull((Object)text), (String)StringUtility.emptyIfNull((Object)oldText))) {
                Object t = this.getValue();
                return t;
            }
            if (acceptedProposalRow != null) {
                this.m_currentLookupRow = acceptedProposalRow;
                Object object = TypeCastUtility.castValue((Object)this.m_currentLookupRow.getKey(), this.getHolderType());
                return (T)object;
            }
            if (text == null) {
                this.m_currentLookupRow = EMPTY_LOOKUP_ROW;
                return null;
            }
            if (smartForm == null) {
                smartForm = this.createProposalForm();
                smartForm.setSearchText(text);
                smartForm.startForm();
                smartForm.update(false, true);
            } else {
                smartForm.setSearchText(text);
                smartForm.update(false, true);
            }
            acceptedProposalRow = smartForm.getAcceptedProposal();
            if (acceptedProposalRow != null) {
                this.m_currentLookupRow = acceptedProposalRow;
                Object object = TypeCastUtility.castValue((Object)this.m_currentLookupRow.getKey(), this.getHolderType());
                return (T)object;
            }
            this.registerProposalFormInternal(smartForm);
            smartForm = null;
            if (this.isAllowCustomText()) {
                this.m_currentLookupRow = new LookupRow((Object)text, text);
                Object object = TypeCastUtility.castValue((Object)this.m_currentLookupRow.getKey(), this.getHolderType());
                return (T)object;
            }
            throw new VetoException(ScoutTexts.get((String)"SmartFieldCannotComplete", (String[])new String[]{text}));
        }
        finally {
            this.unregisterProposalFormInternal(smartForm);
        }
    }

    @Override
    protected final T execValidateValue(T rawValue) throws ProcessingException {
        return rawValue;
    }

    @Override
    protected T validateValueInternal(T rawKey) throws ProcessingException {
        if (rawKey instanceof Number) {
            if (this.getConfiguredTreat0AsNull() && ((Number)rawKey).longValue() == 0L) {
                rawKey = null;
            }
        } else if (rawKey instanceof String && this.getConfiguredTreat0AsNull() && ((String)rawKey).length() == 0) {
            rawKey = null;
        }
        return super.validateValueInternal(rawKey);
    }

    @Override
    protected String formatValueInternal(T validKey) {
        if (!(this.m_currentLookupRow == null || validKey == this.m_currentLookupRow.getKey() || validKey != null && validKey.equals(this.m_currentLookupRow.getKey()))) {
            this.m_currentLookupRow = null;
        }
        if (this.m_currentGetLookupRowByKeyJob != null) {
            this.m_currentGetLookupRowByKeyJob.cancel();
            this.m_currentGetLookupRowByKeyJob = null;
        }
        if (this.m_currentLookupRow == null && validKey == null) {
            this.m_currentLookupRow = EMPTY_LOOKUP_ROW;
        }
        if (this.m_currentLookupRow != null) {
            this.installLookupRowContext(this.m_currentLookupRow);
            String text = this.m_currentLookupRow.getText();
            if (text != null) {
                text = text.replaceAll("[\\n\\r]+", " ");
            }
            return text;
        }
        if (this.getLookupCall() != null) {
            try {
                if (this.getLookupCall() instanceof LocalLookupCall) {
                    LookupRow[] rows = this.callKeyLookup(validKey);
                    if (rows != null && rows.length > 0) {
                        this.installLookupRowContext(rows[0]);
                    } else {
                        this.installLookupRowContext(EMPTY_LOOKUP_ROW);
                    }
                } else {
                    LookupCall call = ((ILookupCallProvisioningService)SERVICES.getService(ILookupCallProvisioningService.class)).newClonedInstance(this.getLookupCall(), new FormFieldProvisioningContext(this));
                    this.prepareKeyLookup(call, validKey);
                    this.m_currentGetLookupRowByKeyJob = new P_GetLookupRowByKeyJob(call);
                    this.m_currentGetLookupRowByKeyJob.schedule();
                }
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
        return this.propertySupport.getPropertyString("displayText");
    }

    @Override
    public void refreshDisplayText() {
        if (this.getLookupCall() != null && this.getValue() != null) {
            try {
                LookupRow[] rows = this.callKeyLookup(this.getValue());
                if (rows != null && rows.length > 0) {
                    this.installLookupRowContext(rows[0]);
                }
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
    }

    @Override
    public void revertValue() {
        this.setValue(this.getValue());
    }

    @Override
    public void acceptProposal(LookupRow row) {
        this.m_currentLookupRow = row;
        if (this.isAllowCustomText()) {
            this.setValue(row.getText());
        } else {
            this.setValue(row.getKey());
        }
    }

    @Override
    public ISmartFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    private void installLookupRowContext(LookupRow row) {
        try {
            this.m_installingRowContext = true;
            this.m_currentLookupRow = row;
            String text = row.getText();
            if (text != null) {
                text = text.replaceAll("[\\n\\r]+", " ");
            }
            this.setDisplayText(text);
            if (StringUtility.hasText((String)row.getTooltipText())) {
                this.setTooltipText(row.getTooltipText());
            } else {
                this.setTooltipText(this.m_decorationRow.getTooltipText());
            }
            if (StringUtility.hasText((String)row.getBackgroundColor())) {
                this.setBackgroundColor(row.getBackgroundColor());
            } else {
                this.setBackgroundColor(this.m_decorationRow.getBackgroundColor());
            }
            if (StringUtility.hasText((String)row.getForegroundColor())) {
                this.setForegroundColor(row.getForegroundColor());
            } else {
                this.setForegroundColor(this.m_decorationRow.getForegroundColor());
            }
            if (row.getFont() != null) {
                this.setFont(row.getFont());
            } else {
                this.setFont(this.m_decorationRow.getFont());
            }
        }
        finally {
            this.m_installingRowContext = false;
        }
    }

    @Override
    public void applyLazyStyles() {
        if (this.m_currentGetLookupRowByKeyJob != null && this.m_currentGetLookupRowByKeyJob.getClientSession() == ClientSyncJob.getCurrentSession() && ClientSyncJob.isSyncClientJob()) {
            this.m_currentGetLookupRowByKeyJob.runNow((IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Override
    public String getDisplayText() {
        this.applyLazyStyles();
        return super.getDisplayText();
    }

    @Override
    public String getTooltipText() {
        this.applyLazyStyles();
        return super.getTooltipText();
    }

    @Override
    public String getBackgroundColor() {
        this.applyLazyStyles();
        return super.getBackgroundColor();
    }

    @Override
    public String getForegroundColor() {
        this.applyLazyStyles();
        return super.getForegroundColor();
    }

    @Override
    public FontSpec getFont() {
        this.applyLazyStyles();
        return super.getFont();
    }

    @Override
    public void prepareKeyLookup(LookupCall call, T key) throws ProcessingException {
        call.setKey(key);
        call.setText(null);
        call.setAll(null);
        call.setRec(null);
        call.setActive(TriState.UNDEFINED);
        if (this.getMasterValue() != null || this.getLookupCall() == null || this.getLookupCall().getMaster() == null) {
            call.setMaster(this.getMasterValue());
        }
        this.execPrepareLookup(call);
        this.execPrepareKeyLookup(call, key);
    }

    @Override
    public void prepareTextLookup(LookupCall call, String text) throws ProcessingException {
        String textPattern = text;
        if (textPattern == null) {
            textPattern = "";
        }
        textPattern = textPattern.toLowerCase();
        IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
        if (desktop != null && desktop.isAutoPrefixWildcardForTextSearch()) {
            textPattern = "*" + textPattern;
        }
        if (!textPattern.endsWith("*")) {
            textPattern = String.valueOf(textPattern) + "*";
        }
        call.setKey(null);
        call.setText(textPattern);
        call.setAll(null);
        call.setRec(null);
        call.setActive(this.isActiveFilterEnabled() ? this.getActiveFilter() : TriState.TRUE);
        if (this.getMasterValue() != null || this.getLookupCall() == null || this.getLookupCall().getMaster() == null) {
            call.setMaster(this.getMasterValue());
        }
        this.execPrepareLookup(call);
        this.execPrepareTextLookup(call, text);
    }

    @Override
    public void prepareBrowseLookup(LookupCall call, String browseHint, TriState activeState) throws ProcessingException {
        call.setKey(null);
        call.setText(null);
        call.setAll(browseHint);
        call.setRec(null);
        call.setActive(activeState);
        if (this.getMasterValue() != null || this.getLookupCall() == null || this.getLookupCall().getMaster() == null) {
            call.setMaster(this.getMasterValue());
        }
        this.execPrepareLookup(call);
        this.execPrepareBrowseLookup(call, browseHint);
    }

    @Override
    public void prepareRecLookup(LookupCall call, T parentKey, TriState activeState) throws ProcessingException {
        call.setKey(null);
        call.setText(null);
        call.setAll(null);
        call.setRec(parentKey);
        if (this.getMasterValue() != null || this.getLookupCall() == null || this.getLookupCall().getMaster() == null) {
            call.setMaster(this.getMasterValue());
        }
        call.setActive(activeState);
        this.execPrepareLookup(call);
        this.execPrepareRecLookup(call, parentKey);
    }

    private void filterKeyLookup(LookupCall call, List<LookupRow> result) throws ProcessingException {
        this.execFilterLookupResult(call, result);
        this.execFilterKeyLookupResult(call, result);
        if (result.size() == 0 && this.isAllowCustomText()) {
            String key = "" + call.getKey();
            result.add(new LookupRow((Object)key, key));
        }
    }

    private void filterTextLookup(LookupCall call, List<LookupRow> result) throws ProcessingException {
        this.execFilterLookupResult(call, result);
        this.execFilterTextLookupResult(call, result);
    }

    private void filterBrowseLookup(LookupCall call, List<LookupRow> result) throws ProcessingException {
        this.execFilterLookupResult(call, result);
        this.execFilterBrowseLookupResult(call, result);
    }

    private void filterRecLookup(LookupCall call, List<LookupRow> result) throws ProcessingException {
        this.execFilterLookupResult(call, result);
        this.execFilterRecLookupResult(call, result);
    }

    @Override
    public LookupRow[] callKeyLookup(T key) throws ProcessingException {
        LookupRow[] data = null;
        LookupCall call = this.getLookupCall();
        if (call != null) {
            call = ((ILookupCallProvisioningService)SERVICES.getService(ILookupCallProvisioningService.class)).newClonedInstance(call, new FormFieldProvisioningContext(this));
            this.prepareKeyLookup(call, key);
            data = call.getDataByKey();
        }
        ArrayList<Object> result = data != null ? new ArrayList<LookupRow>(Arrays.asList(data)) : new ArrayList();
        this.filterKeyLookup(call, result);
        return this.cleanupResultList(result);
    }

    @Override
    public LookupRow[] callTextLookup(String text, int maxRowCount) throws ProcessingException {
        final Holder rowsHolder = new Holder(LookupRow[].class);
        final Holder failedHolder = new Holder(ProcessingException.class, (Object)new ProcessingException("callback was not invoked"));
        this.callTextLookupInternal(text, maxRowCount, new ILookupCallFetcher(){

            public void dataFetched(LookupRow[] rows, ProcessingException failed) {
                rowsHolder.setValue((Object)rows);
                failedHolder.setValue((Object)failed);
            }
        }, false);
        if (failedHolder.getValue() != null) {
            throw (ProcessingException)((Object)failedHolder.getValue());
        }
        return (LookupRow[])rowsHolder.getValue();
    }

    @Override
    public JobEx callTextLookupInBackground(String text, int maxRowCount, ILookupCallFetcher fetcher) {
        return this.callTextLookupInternal(text, maxRowCount, fetcher, true);
    }

    private JobEx callTextLookupInternal(String text, int maxRowCount, final ILookupCallFetcher fetcher, final boolean background) {
        final LookupCall call = this.getLookupCall() != null ? ((ILookupCallProvisioningService)SERVICES.getService(ILookupCallProvisioningService.class)).newClonedInstance(this.getLookupCall(), new FormFieldProvisioningContext(this)) : null;
        final IClientSession session = ClientSyncJob.getCurrentSession();
        ILookupCallFetcher internalFetcher = new ILookupCallFetcher(){

            public void dataFetched(final LookupRow[] rows, final ProcessingException failed) {
                ClientSyncJob scoutSyncJob = new ClientSyncJob("Smartfield text lookup", session){

                    @Override
                    protected void runVoid(IProgressMonitor monitor) throws Throwable {
                        if (failed == null) {
                            ArrayList<LookupRow> result = new ArrayList<LookupRow>(Arrays.asList(rows));
                            try {
                                AbstractSmartField.this.filterTextLookup(call, result);
                                fetcher.dataFetched(AbstractSmartField.this.cleanupResultList(result), null);
                            }
                            catch (ProcessingException e) {
                                fetcher.dataFetched(null, e);
                            }
                        } else {
                            fetcher.dataFetched(null, failed);
                        }
                    }
                };
                if (background) {
                    scoutSyncJob.schedule();
                } else {
                    scoutSyncJob.runNow((IProgressMonitor)new NullProgressMonitor());
                }
            }
        };
        if (call != null) {
            if (maxRowCount > 0) {
                call.setMaxRowCount(maxRowCount);
            } else {
                call.setMaxRowCount(this.getBrowseMaxRowCount());
            }
            if (background) {
                try {
                    this.prepareTextLookup(call, text);
                    return call.getDataByTextInBackground(internalFetcher);
                }
                catch (ProcessingException e1) {
                    internalFetcher.dataFetched(null, e1);
                }
            } else {
                try {
                    this.prepareTextLookup(call, text);
                    internalFetcher.dataFetched(call.getDataByText(), null);
                }
                catch (ProcessingException e) {
                    internalFetcher.dataFetched(null, e);
                }
            }
        } else {
            internalFetcher.dataFetched(new LookupRow[0], null);
        }
        return null;
    }

    @Override
    public LookupRow[] callBrowseLookup(String browseHint, int maxRowCount) throws ProcessingException {
        return this.callBrowseLookup(browseHint, maxRowCount, this.isActiveFilterEnabled() ? this.getActiveFilter() : TriState.TRUE);
    }

    @Override
    public LookupRow[] callBrowseLookup(String browseHint, int maxRowCount, TriState activeState) throws ProcessingException {
        final Holder rowsHolder = new Holder(LookupRow[].class);
        final Holder failedHolder = new Holder(ProcessingException.class, (Object)new ProcessingException("callback was not invoked"));
        this.callBrowseLookupInternal(browseHint, maxRowCount, activeState, new ILookupCallFetcher(){

            public void dataFetched(LookupRow[] rows, ProcessingException failed) {
                rowsHolder.setValue((Object)rows);
                failedHolder.setValue((Object)failed);
            }
        }, false);
        if (failedHolder.getValue() != null) {
            throw (ProcessingException)((Object)failedHolder.getValue());
        }
        return (LookupRow[])rowsHolder.getValue();
    }

    @Override
    public JobEx callBrowseLookupInBackground(String browseHint, int maxRowCount, ILookupCallFetcher fetcher) {
        return this.callBrowseLookupInBackground(browseHint, maxRowCount, this.isActiveFilterEnabled() ? this.getActiveFilter() : TriState.TRUE, fetcher);
    }

    @Override
    public JobEx callBrowseLookupInBackground(String browseHint, int maxRowCount, TriState activeState, ILookupCallFetcher fetcher) {
        return this.callBrowseLookupInternal(browseHint, maxRowCount, activeState, fetcher, true);
    }

    private JobEx callBrowseLookupInternal(String browseHint, int maxRowCount, TriState activeState, final ILookupCallFetcher fetcher, final boolean background) {
        final LookupCall call = this.getLookupCall() != null ? ((ILookupCallProvisioningService)SERVICES.getService(ILookupCallProvisioningService.class)).newClonedInstance(this.getLookupCall(), new FormFieldProvisioningContext(this)) : null;
        final IClientSession session = ClientSyncJob.getCurrentSession();
        ILookupCallFetcher internalFetcher = new ILookupCallFetcher(){

            public void dataFetched(final LookupRow[] rows, final ProcessingException failed) {
                ClientSyncJob scoutSyncJob = new ClientSyncJob("Smartfield browse lookup", session){

                    @Override
                    protected void runVoid(IProgressMonitor monitor) throws Throwable {
                        if (failed == null) {
                            ArrayList<LookupRow> result = new ArrayList<LookupRow>(Arrays.asList(rows));
                            try {
                                AbstractSmartField.this.filterBrowseLookup(call, result);
                                fetcher.dataFetched(AbstractSmartField.this.cleanupResultList(result), null);
                            }
                            catch (ProcessingException e) {
                                fetcher.dataFetched(null, e);
                            }
                        } else {
                            fetcher.dataFetched(null, failed);
                        }
                    }
                };
                if (background) {
                    scoutSyncJob.schedule();
                } else {
                    scoutSyncJob.runNow((IProgressMonitor)new NullProgressMonitor());
                }
            }
        };
        if (call != null) {
            if (maxRowCount > 0) {
                call.setMaxRowCount(maxRowCount);
            } else {
                call.setMaxRowCount(this.getBrowseMaxRowCount());
            }
            if (background) {
                try {
                    this.prepareBrowseLookup(call, browseHint, activeState);
                    return call.getDataByAllInBackground(internalFetcher);
                }
                catch (ProcessingException e1) {
                    internalFetcher.dataFetched(null, e1);
                }
            } else {
                try {
                    this.prepareBrowseLookup(call, browseHint, activeState);
                    internalFetcher.dataFetched(call.getDataByAll(), null);
                }
                catch (ProcessingException e) {
                    internalFetcher.dataFetched(null, e);
                }
            }
        } else {
            internalFetcher.dataFetched(new LookupRow[0], null);
        }
        return null;
    }

    @Override
    public LookupRow[] callSubTreeLookup(T parentKey) throws ProcessingException {
        return this.callSubTreeLookup(parentKey, this.isActiveFilterEnabled() ? this.getActiveFilter() : TriState.TRUE);
    }

    @Override
    public LookupRow[] callSubTreeLookup(T parentKey, TriState activeState) throws ProcessingException {
        LookupRow[] data = null;
        LookupCall call = this.getLookupCall();
        if (call != null) {
            call = ((ILookupCallProvisioningService)SERVICES.getService(ILookupCallProvisioningService.class)).newClonedInstance(call, new FormFieldProvisioningContext(this));
            call.setMaxRowCount(this.getBrowseMaxRowCount());
            this.prepareRecLookup(call, parentKey, activeState);
            data = call.getDataByRec();
        }
        ArrayList<Object> result = data != null ? new ArrayList<LookupRow>(Arrays.asList(data)) : new ArrayList(0);
        this.filterRecLookup(call, result);
        return this.cleanupResultList(result);
    }

    private LookupRow[] cleanupResultList(List<LookupRow> list) {
        int len = 0;
        for (LookupRow r : list) {
            if (r == null) continue;
            ++len;
        }
        LookupRow[] a = new LookupRow[len];
        int index = 0;
        for (LookupRow r : list) {
            if (r == null) continue;
            a[index] = r;
            ++index;
        }
        return a;
    }

    private class P_GetLookupRowByKeyJob
    extends ClientSyncJob {
        private LookupRow[] m_rows;
        private final ClientAsyncJob m_backgroundJob;

        public P_GetLookupRowByKeyJob(final LookupCall call) {
            super("Fetch smartfield data for " + AbstractSmartField.this.getLabel(), P_GetLookupRowByKeyJob.getCurrentSession());
            this.m_backgroundJob = new ClientAsyncJob("Fetch smartfield data", ClientSyncJob.getCurrentSession()){

                @Override
                protected void runVoid(IProgressMonitor monitor) throws Throwable {
                    ArrayList<LookupRow> result = new ArrayList<LookupRow>(Arrays.asList(call.getDataByKey()));
                    AbstractSmartField.this.filterKeyLookup(call, result);
                    P_GetLookupRowByKeyJob.this.m_rows = AbstractSmartField.this.cleanupResultList(result);
                }
            };
            this.m_backgroundJob.schedule();
        }

        @Override
        protected void runVoid(IProgressMonitor monitor) throws Throwable {
            if (this == AbstractSmartField.this.m_currentGetLookupRowByKeyJob) {
                AbstractSmartField.this.m_currentGetLookupRowByKeyJob = null;
                try {
                    this.m_backgroundJob.join();
                }
                catch (InterruptedException interruptedException) {}
                if (this.m_backgroundJob.getResult() != null) {
                    if (this.m_backgroundJob.getResult().getException() == null) {
                        if (this.m_rows != null && this.m_rows.length > 0) {
                            AbstractSmartField.this.installLookupRowContext(this.m_rows[0]);
                        } else {
                            AbstractSmartField.this.installLookupRowContext(EMPTY_LOOKUP_ROW);
                        }
                    } else {
                        LOG.error(null, this.m_backgroundJob.getResult().getException());
                    }
                }
            }
        }
    }

    private class P_ProposalFormListener
    implements FormListener {
        private P_ProposalFormListener() {
        }

        @Override
        public void formChanged(FormEvent e) throws ProcessingException {
            switch (e.getType()) {
                case 3010: {
                    if (AbstractSmartField.this.getProposalForm() != e.getForm()) break;
                    ISmartFieldProposalForm f = (ISmartFieldProposalForm)e.getForm();
                    if (f.getCloseSystemType() == 3) {
                        LookupRow row = f.getAcceptedProposal();
                        if (row != null) {
                            AbstractSmartField.this.acceptProposal(row);
                        }
                    } else if (!AbstractSmartField.this.isAllowCustomText()) {
                        AbstractSmartField.this.revertValue();
                    }
                    AbstractSmartField.this.registerProposalFormInternal(null);
                }
            }
        }
    }

    private class P_UIFacade
    implements ISmartFieldUIFacade {
        private Map<ICell, LookupRow> m_validProposals;

        private P_UIFacade() {
        }

        @Override
        public IMenu[] firePopupFromUI() {
            Object smartValue = AbstractSmartField.this.getValue();
            ArrayList<IMenu> filteredMenus = new ArrayList<IMenu>();
            IMenu[] iMenuArray = AbstractSmartField.this.getMenus();
            int n = iMenuArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMenu m = iMenuArray[n2];
                IMenu validMenu = null;
                if (!m.isInheritAccessibility() || AbstractSmartField.this.isEnabled()) {
                    if (m.isEmptySpaceAction()) {
                        validMenu = m;
                    } else if (m.isSingleSelectionAction() && smartValue != null) {
                        validMenu = m;
                    }
                }
                if (validMenu != null) {
                    validMenu.prepareAction();
                    if (validMenu.isVisible()) {
                        filteredMenus.add(validMenu);
                    }
                }
                ++n2;
            }
            return filteredMenus.toArray(new IMenu[0]);
        }

        @Override
        public void openProposalFromUI(String newText, boolean selectCurrentValue) {
            if (newText == null) {
                newText = "*";
            }
            try {
                ISmartFieldProposalForm smartForm = AbstractSmartField.this.getProposalForm();
                if (smartForm == null) {
                    AbstractSmartField.this.setActiveFilter(TriState.TRUE);
                    smartForm = AbstractSmartField.this.createProposalForm();
                    smartForm.setSearchText(newText);
                    smartForm.startForm();
                    if (smartForm.isFormOpen()) {
                        smartForm.update(selectCurrentValue, false);
                        AbstractSmartField.this.registerProposalFormInternal(smartForm);
                    }
                } else if (!StringUtility.equalsIgnoreNewLines((String)smartForm.getSearchText(), (String)newText)) {
                    smartForm.setSearchText(newText);
                    smartForm.update(false, false);
                }
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }

        @Override
        public boolean acceptProposalFromUI() {
            block4: {
                ISmartFieldProposalForm smartForm;
                block6: {
                    block5: {
                        smartForm = AbstractSmartField.this.getProposalForm();
                        if (smartForm == null) break block4;
                        if (smartForm.getAcceptedProposal() == null) break block5;
                        smartForm.doOk();
                        return true;
                    }
                    if (!StringUtility.isNullOrEmpty((String)AbstractSmartField.this.getDisplayText())) break block6;
                    return true;
                }
                try {
                    smartForm.forceProposalSelection();
                    return false;
                }
                catch (ProcessingException e) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                }
            }
            return false;
        }

        @Override
        public boolean setTextFromUI(String text) {
            block10: {
                String currentValidText;
                block8: {
                    ISmartFieldProposalForm smartForm;
                    block9: {
                        currentValidText = AbstractSmartField.this.m_currentLookupRow != null ? AbstractSmartField.this.m_currentLookupRow.getText() : null;
                        smartForm = AbstractSmartField.this.getProposalForm();
                        try {
                            if (smartForm != null && smartForm.getAcceptedProposal() != null) {
                                return this.acceptProposalFromUI();
                            }
                            if (smartForm == null || !StringUtility.equalsIgnoreNewLines((String)text, (String)smartForm.getSearchText()) && !StringUtility.equalsIgnoreNewLines((String)StringUtility.emptyIfNull((Object)text), (String)StringUtility.emptyIfNull((Object)currentValidText))) break block8;
                            if (text == null || text.length() == 0) {
                                boolean b = AbstractSmartField.this.parseValue(text);
                                return b;
                            }
                            if (StringUtility.equalsIgnoreNewLines((String)StringUtility.emptyIfNull((Object)text), (String)StringUtility.emptyIfNull((Object)currentValidText))) break block9;
                            if (AbstractSmartField.this.isAllowCustomText()) {
                                return AbstractSmartField.this.parseValue(text);
                            }
                            smartForm.forceProposalSelection();
                            return false;
                        }
                        catch (ProcessingException e) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                            return true;
                        }
                    }
                    smartForm.doClose();
                    return true;
                }
                if (!CompareUtility.equals((Object)text, (Object)currentValidText)) break block10;
                return true;
            }
            return AbstractSmartField.this.parseValue(text);
        }

        @Override
        public void unregisterProposalFormFromUI(ISmartFieldProposalForm form) {
            AbstractSmartField.this.unregisterProposalFormInternal(form);
        }
    }
}

