/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.internal;

import java.util.TreeMap;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.rt.client.ui.form.IFormFieldVisitor;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.shared.data.form.FormDataUtility;

public class FindFieldByFormDataIdVisitor
implements IFormFieldVisitor {
    private static final CompositeObject PERFECT_VALUE_FIELD_MATCH_KEY = new CompositeObject(new Object[]{0, 0});
    private String[] m_fieldIdParts;
    private TreeMap<CompositeObject, IFormField> m_prioMap;

    public FindFieldByFormDataIdVisitor(String fieldId) {
        this.m_fieldIdParts = fieldId.split("[/]");
        this.m_prioMap = new TreeMap();
    }

    @Override
    public boolean visitField(IFormField field, int level, int fieldIndex) {
        if (this.matchesAllParts(field)) {
            int fieldTypeRank = field instanceof IValueField ? 0 : (!(field instanceof ICompositeField) ? 1 : 2);
            int enclosingFieldPathRank = this.getEnclosingFieldPathRank(field);
            this.m_prioMap.put(new CompositeObject(new Object[]{fieldTypeRank, enclosingFieldPathRank}), field);
        }
        return !this.m_prioMap.containsKey(PERFECT_VALUE_FIELD_MATCH_KEY);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean matchesAllParts(IFormField f) {
        int i = this.m_fieldIdParts.length - 1;
        if (!this.m_fieldIdParts[i].equals(FormDataUtility.getFieldDataId((String)f.getFieldId()))) {
            return false;
        }
        --i;
        f = f.getParentField();
        while (i >= 0 && f != null) {
            if (this.m_fieldIdParts[i].equals(FormDataUtility.getFieldDataId((String)f.getFieldId()))) {
                --i;
            }
            f = f.getParentField();
        }
        return i < 0;
    }

    private int getEnclosingFieldPathRank(IFormField f) {
        int rank = 0;
        int i = this.m_fieldIdParts.length - 2;
        Class currentEnclosingContainerType = ConfigurationUtility.getEnclosingContainerType((Object)f);
        ICompositeField p = f.getParentField();
        while (p != null) {
            Class enclosingContainerType = ConfigurationUtility.getEnclosingContainerType((Object)p);
            if (enclosingContainerType != currentEnclosingContainerType) {
                if (i >= 0 && this.m_fieldIdParts[i].equals(FormDataUtility.getFieldDataId((String)p.getFieldId()))) {
                    --i;
                } else {
                    ++rank;
                }
                currentEnclosingContainerType = enclosingContainerType;
            }
            p = p.getParentField();
        }
        return rank;
    }

    public IFormField getField() {
        return this.m_prioMap.size() > 0 ? this.m_prioMap.get(this.m_prioMap.firstKey()) : null;
    }
}

