/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.security.AccessController;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.osgi.BundleInspector;
import org.eclipse.scout.http.servletfilter.HttpServletEx;
import org.eclipse.scout.rt.server.DefaultTransactionDelegate;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ServerJob;
import org.eclipse.scout.rt.server.ThreadContext;
import org.eclipse.scout.rt.server.VirtualSessionCache;
import org.eclipse.scout.rt.server.admin.html.AdminSession;
import org.eclipse.scout.rt.server.internal.Activator;
import org.eclipse.scout.rt.server.services.common.session.IServerSessionRegistryService;
import org.eclipse.scout.rt.shared.servicetunnel.DefaultServiceTunnelContentHandler;
import org.eclipse.scout.rt.shared.servicetunnel.IServiceTunnelContentHandler;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelRequest;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelResponse;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.service.SERVICES;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class ServiceTunnelServlet
extends HttpServletEx {
    public static final String HTTP_DEBUG_PARAM = "org.eclipse.scout.rt.server.http.debug";
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ServiceTunnelServlet.class);
    private transient IServiceTunnelContentHandler m_contentHandler;
    private transient Bundle[] m_orderedBundleList;
    private Object m_orderedBundleListLock = new Boolean(true);
    private VirtualSessionCache m_ajaxSessionCache = new VirtualSessionCache();
    private Object m_msgEncoderLock = new Boolean(true);
    private Class<? extends IServerSession> m_serverSessionClass;
    private Version m_requestMinVersion;
    private boolean m_debug;

    public ServiceTunnelServlet() {
        String text = Activator.getDefault().getBundle().getBundleContext().getProperty(HTTP_DEBUG_PARAM);
        if (text != null && text.equalsIgnoreCase("true")) {
            this.m_debug = true;
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.m_requestMinVersion = this.initRequestMinVersion(config);
    }

    protected void lazyInit(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        String qname;
        if (this.m_serverSessionClass == null && (qname = this.getServletConfig().getInitParameter("session")) != null) {
            int i = qname.lastIndexOf(46);
            try {
                this.m_serverSessionClass = Platform.getBundle((String)qname.substring(0, i)).loadClass(qname);
            }
            catch (ClassNotFoundException e) {
                throw new ServletException("Loading class " + qname, (Throwable)e);
            }
        }
        if (this.m_serverSessionClass == null) {
            try {
                Bundle bundle = this.findServletContributor(req.getServletPath());
                if (bundle != null) {
                    this.m_serverSessionClass = bundle.loadClass(String.valueOf(bundle.getSymbolicName()) + ".ServerSession");
                }
            }
            catch (Throwable throwable) {}
        }
        if (this.m_serverSessionClass == null) {
            throw new ServletException("Expected init-param \"session\"");
        }
    }

    protected Version initRequestMinVersion(ServletConfig config) {
        Version version = null;
        String v = config.getInitParameter("min-version");
        if (v != null) {
            Version tmp = Version.parseVersion((String)v);
            version = new Version(tmp.getMajor(), tmp.getMinor(), tmp.getMicro());
        } else if (Platform.getProduct() != null) {
            v = (String)Platform.getProduct().getDefiningBundle().getHeaders().get("Bundle-Version");
            Version tmp = Version.parseVersion((String)v);
            version = new Version(tmp.getMajor(), tmp.getMinor(), tmp.getMicro());
        }
        return version;
    }

    @Deprecated
    protected IServiceTunnelContentHandler createMessageEncoder(Class<? extends IServerSession> sessionClass) {
        return this.createContentHandler(sessionClass);
    }

    protected IServiceTunnelContentHandler createContentHandler(Class<? extends IServerSession> sessionClass) {
        DefaultServiceTunnelContentHandler e = new DefaultServiceTunnelContentHandler();
        e.initialize(this.getOrderedBundleList(), sessionClass.getClassLoader());
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IServiceTunnelContentHandler getServiceTunnelContentHandler() {
        Object object = this.m_msgEncoderLock;
        synchronized (object) {
            if (this.m_contentHandler == null) {
                this.m_contentHandler = this.createMessageEncoder(this.m_serverSessionClass);
            }
        }
        return this.m_contentHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle[] getOrderedBundleList() {
        Object object = this.m_orderedBundleListLock;
        synchronized (object) {
            if (this.m_orderedBundleList == null) {
                String prefix = this.m_serverSessionClass.getPackage().getName().replaceAll("^(.*\\.)(client|shared|server)(\\.core)?.*$", "$1");
                this.m_orderedBundleList = BundleInspector.getOrderedBundleList((String[])new String[]{prefix, "org.eclipse.scout."});
            }
        }
        return this.m_orderedBundleList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IServerSession lookupScoutServerSessionOnHttpSession(HttpServletRequest req, HttpServletResponse res, Subject subject, UserAgent userAgent) throws ProcessingException, ServletException {
        HttpSession httpSession = req.getSession();
        synchronized (httpSession) {
            IServerSession serverSession = (IServerSession)req.getSession().getAttribute(IServerSession.class.getName());
            if (serverSession == null) {
                serverSession = ((IServerSessionRegistryService)SERVICES.getService(IServerSessionRegistryService.class)).newServerSession(this.m_serverSessionClass, subject, userAgent);
                req.getSession().setAttribute(IServerSession.class.getName(), (Object)serverSession);
            }
            return serverSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IServerSession lookupScoutServerSessionOnVirtualSession(HttpServletRequest req, HttpServletResponse res, String ajaxSessionId, Subject subject, UserAgent userAgent) throws ProcessingException, ServletException {
        VirtualSessionCache virtualSessionCache = this.m_ajaxSessionCache;
        synchronized (virtualSessionCache) {
            int maxInactive = req.getSession().getMaxInactiveInterval();
            if (maxInactive < 0) {
                maxInactive = 3600;
            }
            this.m_ajaxSessionCache.setSessionTimeoutMillis(Math.max(1000L, 1000L * (long)maxInactive));
            IServerSession serverSession = (IServerSession)this.m_ajaxSessionCache.get(ajaxSessionId);
            if (serverSession == null) {
                serverSession = ((IServerSessionRegistryService)SERVICES.getService(IServerSessionRegistryService.class)).newServerSession(this.m_serverSessionClass, subject, userAgent);
                this.m_ajaxSessionCache.put(ajaxSessionId, serverSession);
            } else {
                this.m_ajaxSessionCache.touch(ajaxSessionId);
            }
            return serverSession;
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject == null) {
            res.sendError(403);
            return;
        }
        Map<Class, Object> backup = ThreadContext.backup();
        try {
            try {
                this.lazyInit(req, res);
                ThreadContext.putHttpServletRequest(req);
                ThreadContext.putHttpServletResponse(res);
                UserAgent userAgent = UserAgent.createDefault();
                IServerSession serverSession = this.lookupScoutServerSessionOnHttpSession(req, res, subject, userAgent);
                AdminServiceJob job = new AdminServiceJob(serverSession, subject, req, res);
                job.runNow((IProgressMonitor)new NullProgressMonitor());
                job.throwOnError();
            }
            catch (ProcessingException e) {
                throw new ServletException((Throwable)e);
            }
        }
        finally {
            ThreadContext.restore(backup);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block10: {
            subject = Subject.getSubject(AccessController.getContext());
            if (subject == null) {
                res.sendError(403);
                return;
            }
            try {
                this.lazyInit(req, res);
                backup = ThreadContext.backup();
                oldLocale = LocaleThreadLocal.get();
                try {
                    ThreadContext.putHttpServletRequest(req);
                    ThreadContext.putHttpServletResponse(res);
                    serviceRequest = this.deserializeInput((InputStream)req.getInputStream());
                    LocaleThreadLocal.set((Locale)serviceRequest.getLocale());
                    virtualSessionId = serviceRequest.getVirtualSessionId();
                    userAgent = UserAgent.createByIdentifier((String)serviceRequest.getUserAgent());
                    serverSession = virtualSessionId != null ? this.lookupScoutServerSessionOnVirtualSession(req, res, virtualSessionId, subject, userAgent) : this.lookupScoutServerSessionOnHttpSession(req, res, subject, userAgent);
                    serviceResponseHolder = new AtomicReference<ServiceTunnelResponse>();
                    job = this.createServiceTunnelServerJob(serverSession, serviceRequest, serviceResponseHolder, subject);
                    job.setTransactionSequence(serviceRequest.getRequestSequence());
                    job.runNow((IProgressMonitor)new NullProgressMonitor());
                    job.throwOnError();
                    this.serializeOutput(res, serviceResponseHolder.get());
                    break block10;
                }
                finally {
                    ThreadContext.restore(backup);
                    LocaleThreadLocal.set((Locale)oldLocale);
                }
            }
            catch (Throwable t) {
                cause = t;
                ** while (cause != null)
            }
lbl-1000:
            // 1 sources

            {
                if (cause instanceof SocketException) {
                    return;
                }
                if (cause.getClass().getSimpleName().equalsIgnoreCase("EofException")) {
                    return;
                }
                if (cause instanceof InterruptedIOException) {
                    return;
                }
                cause = cause.getCause();
                continue;
            }
lbl40:
            // 1 sources

            ServiceTunnelServlet.LOG.error("Session=" + req.getSession().getId() + ", Client=" + req.getRemoteUser() + "@" + req.getRemoteAddr() + "/" + req.getRemoteHost(), t);
            res.sendError(500);
        }
    }

    protected ServiceTunnelRequest deserializeInput(InputStream in) throws Exception {
        ServiceTunnelRequest req = this.getServiceTunnelContentHandler().readRequest(in);
        return req;
    }

    protected void serializeOutput(HttpServletResponse httpResponse, ServiceTunnelResponse res) throws Exception {
        if (res.getException() != null) {
            res.getException().setStackTrace(new StackTraceElement[0]);
        }
        httpResponse.setDateHeader("Expires", -1L);
        httpResponse.setHeader("Cache-Control", "no-cache");
        httpResponse.setHeader("pragma", "no-cache");
        httpResponse.setContentType("text/xml");
        this.getServiceTunnelContentHandler().writeResponse((OutputStream)httpResponse.getOutputStream(), res);
    }

    private Bundle findServletContributor(String alias) throws CoreException {
        IExtensionPoint xpServlet;
        IExtensionRegistry reg;
        BundleContext context = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(IExtensionRegistry.class.getName());
        Bundle bundle = null;
        if (ref != null && (reg = (IExtensionRegistry)context.getService(ref)) != null && (xpServlet = reg.getExtensionPoint("org.eclipse.equinox.http.registry.servlets")) != null) {
            IExtension[] iExtensionArray = xpServlet.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension xServlet = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = xServlet.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement cServlet = iConfigurationElementArray[n4];
                    if (cServlet.getName().equals("servlet") && ((Object)((Object)this)).getClass().getName().equals(cServlet.getAttribute("class"))) {
                        bundle = Platform.getBundle((String)xServlet.getContributor().getName());
                        if (alias.equals(cServlet.getAttribute("alias"))) {
                            return bundle;
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return bundle;
    }

    protected ServerJob createServiceTunnelServerJob(IServerSession serverSession, ServiceTunnelRequest serviceRequest, AtomicReference<ServiceTunnelResponse> serviceResponseHolder, Subject subject) {
        return new RemoteServiceJob(serverSession, serviceRequest, serviceResponseHolder, subject);
    }

    protected ServiceTunnelResponse runServerJobTransaction(ServiceTunnelRequest req) throws Exception {
        return this.runServerJobTransactionWithDelegate(req, this.getOrderedBundleList(), this.m_requestMinVersion, this.m_debug);
    }

    protected ServiceTunnelResponse runServerJobTransactionWithDelegate(ServiceTunnelRequest req, Bundle[] loaderBundles, Version requestMinVersion, boolean debug) throws Exception {
        return new DefaultTransactionDelegate(loaderBundles, requestMinVersion, debug).invoke(req);
    }

    private class AdminServiceJob
    extends ServerJob {
        protected HttpServletRequest m_request;
        protected HttpServletResponse m_response;

        public AdminServiceJob(IServerSession serverSession, Subject subject, HttpServletRequest request, HttpServletResponse response) {
            super("AdminServiceCall", serverSession, subject);
            this.m_request = request;
            this.m_response = response;
        }

        @Override
        protected IStatus runTransaction(IProgressMonitor monitor) throws Exception {
            String key;
            HttpSession session = this.m_request.getSession();
            AdminSession as = (AdminSession)session.getAttribute(key = AdminSession.class.getName());
            if (as == null) {
                as = new AdminSession();
                session.setAttribute(key, (Object)as);
            }
            as.serviceRequest(this.m_request, this.m_response);
            return Status.OK_STATUS;
        }
    }

    private class RemoteServiceJob
    extends ServerJob {
        private final ServiceTunnelRequest m_serviceRequest;
        private final AtomicReference<ServiceTunnelResponse> m_serviceResponseHolder;

        public RemoteServiceJob(IServerSession serverSession, ServiceTunnelRequest serviceRequest, AtomicReference<ServiceTunnelResponse> serviceResponseHolder, Subject subject) {
            super("RemoteServiceCall", serverSession, subject);
            this.m_serviceRequest = serviceRequest;
            this.m_serviceResponseHolder = serviceResponseHolder;
        }

        public ServiceTunnelRequest getServiceRequest() {
            return this.m_serviceRequest;
        }

        public AtomicReference<ServiceTunnelResponse> getServiceResponseHolder() {
            return this.m_serviceResponseHolder;
        }

        @Override
        protected IStatus runTransaction(IProgressMonitor monitor) throws Exception {
            ServiceTunnelResponse serviceRes = ServiceTunnelServlet.this.runServerJobTransaction(this.getServiceRequest());
            this.getServiceResponseHolder().set(serviceRes);
            return Status.OK_STATUS;
        }
    }
}

