/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ThreadContext;
import org.eclipse.scout.rt.server.transaction.ITransaction;

@Deprecated
public final class ThreadContextLegacy {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ThreadContextLegacy.class);
    private static final Object MAP_LOCK = new Object();
    private static final WeakHashMap<Thread, HashMap<Class, Object>> MAP = new WeakHashMap();

    private ThreadContextLegacy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<Class, Object> getThreadMap(boolean autoCreate) {
        Object object = MAP_LOCK;
        synchronized (object) {
            HashMap<Class<Object>, Object> threadMap = MAP.get(Thread.currentThread());
            if (threadMap == null && autoCreate) {
                threadMap = new HashMap();
                MAP.put(Thread.currentThread(), threadMap);
            }
            return threadMap;
        }
    }

    public static <T> T getCustomValue(Class<T> key) {
        return ThreadContextLegacy.getInternal(key);
    }

    public static <T> T get(Class<T> key) {
        return ThreadContextLegacy.getInternal(key);
    }

    private static <T> T getInternal(Class<T> key) {
        if (key == null) {
            return null;
        }
        if (Locale.class.isAssignableFrom(key)) {
            return (T)LocaleThreadLocal.get();
        }
        if (HttpServletRequest.class.isAssignableFrom(key)) {
            return (T)ThreadContext.getHttpServletRequest();
        }
        if (HttpServletResponse.class.isAssignableFrom(key)) {
            return (T)ThreadContext.getHttpServletResponse();
        }
        if (IServerSession.class.isAssignableFrom(key)) {
            return (T)ThreadContext.getServerSession();
        }
        if (ITransaction.class.isAssignableFrom(key)) {
            return (T)ThreadContext.getTransaction();
        }
        HashMap<Class, Object> threadMap = ThreadContextLegacy.getThreadMap(false);
        if (threadMap != null) {
            return (T)threadMap.get(key);
        }
        return null;
    }

    public static Map<Class, Object> backup() {
        HashMap<Class, Object> copyMap = new HashMap<Class, Object>();
        HashMap<Class, Object> rawMap = ThreadContextLegacy.getThreadMap(false);
        if (rawMap != null) {
            copyMap.putAll(rawMap);
        }
        copyMap.put(HttpServletRequest.class, ThreadContext.getHttpServletRequest());
        copyMap.put(HttpServletResponse.class, ThreadContext.getHttpServletResponse());
        copyMap.put(IServerSession.class, ThreadContext.getServerSession());
        copyMap.put(ITransaction.class, ThreadContext.getTransaction());
        return copyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restore(Map<Class, Object> map) {
        HashMap<Class, Object> copyMap = map != null ? new HashMap<Class, Object>(map) : new HashMap();
        ThreadContext.putHttpServletRequest((HttpServletRequest)copyMap.remove(HttpServletRequest.class));
        ThreadContext.putHttpServletResponse((HttpServletResponse)copyMap.remove(HttpServletResponse.class));
        ThreadContext.putServerSession((IServerSession)copyMap.remove(IServerSession.class));
        ThreadContext.putTransaction((ITransaction)copyMap.remove(ITransaction.class));
        Object object = MAP_LOCK;
        synchronized (object) {
            MAP.put(Thread.currentThread(), copyMap);
        }
    }

    public static <T> void putCustomValue(T value) {
        ThreadContextLegacy.putInternal(value);
    }

    public static <T> void put(T value) {
        ThreadContextLegacy.putInternal(value);
    }

    private static <T> void putInternal(T value) {
        if (value == null) {
            return;
        }
        if (value instanceof Locale) {
            LocaleThreadLocal.set((Locale)((Locale)value));
            return;
        }
        if (value instanceof HttpServletRequest) {
            ThreadContext.putHttpServletRequest((HttpServletRequest)value);
            return;
        }
        if (value instanceof HttpServletResponse) {
            ThreadContext.putHttpServletResponse((HttpServletResponse)value);
            return;
        }
        if (value instanceof IServerSession) {
            ThreadContext.putServerSession((IServerSession)value);
            return;
        }
        if (value instanceof ITransaction) {
            ThreadContext.putTransaction((ITransaction)value);
            return;
        }
        HashMap<Class, Object> threadMap = ThreadContextLegacy.getThreadMap(true);
        HashSet<Class> keys = new HashSet<Class>();
        ThreadContextLegacy.enumKeys(value.getClass(), keys);
        for (Class key : keys) {
            threadMap.put(key, value);
        }
    }

    public static <T> void clear(T value) {
        ThreadContextLegacy.clearInternal(value);
    }

    public static <T> void clearInternal(T value) {
        if (value == null) {
            return;
        }
        HashMap<Class, Object> threadMap = ThreadContextLegacy.getThreadMap(false);
        if (threadMap != null) {
            HashSet<Class> keys = new HashSet<Class>();
            ThreadContextLegacy.enumKeys(value.getClass(), keys);
            for (Class key : keys) {
                threadMap.remove(key);
            }
        }
    }

    private static void enumKeys(Class c, HashSet<Class> keys) {
        if (c != null) {
            keys.add(c);
            Class<?>[] classArray = c.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> i = classArray[n2];
                ThreadContextLegacy.enumKeys(i, keys);
                ++n2;
            }
            ThreadContextLegacy.enumKeys(c.getSuperclass(), keys);
        }
    }
}

