/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.builder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.server.services.common.jdbc.builder.EntityContributionUtility;

public class EntityContribution {
    private final List<String> m_selectParts = new ArrayList<String>(2);
    private final List<String> m_fromParts = new ArrayList<String>(2);
    private final List<String> m_whereParts = new ArrayList<String>(2);
    private final List<String> m_groupByParts = new ArrayList<String>(2);
    private final List<String> m_havingParts = new ArrayList<String>(2);

    public static EntityContribution create(String wherePart) {
        return EntityContributionUtility.constraintTextToContribution(wherePart);
    }

    public EntityContribution() {
    }

    public EntityContribution(EntityContribution ... contributions) {
        this();
        if (contributions != null) {
            EntityContribution[] entityContributionArray = contributions;
            int n = contributions.length;
            int n2 = 0;
            while (n2 < n) {
                EntityContribution contrib = entityContributionArray[n2];
                this.add(contrib);
                ++n2;
            }
        }
    }

    public boolean isEmpty() {
        return this.m_selectParts.size() + this.m_fromParts.size() + this.m_whereParts.size() + this.m_groupByParts.size() + this.m_havingParts.size() == 0;
    }

    public void add(EntityContribution c) {
        if (c == null) {
            return;
        }
        this.getSelectParts().addAll(c.getSelectParts());
        this.getFromParts().addAll(c.getFromParts());
        this.getWhereParts().addAll(c.getWhereParts());
        this.getGroupByParts().addAll(c.getGroupByParts());
        this.getHavingParts().addAll(c.getHavingParts());
    }

    public List<String> getSelectParts() {
        return this.m_selectParts;
    }

    public List<String> getFromParts() {
        return this.m_fromParts;
    }

    public List<String> getWhereParts() {
        return this.m_whereParts;
    }

    public List<String> getGroupByParts() {
        return this.m_groupByParts;
    }

    public List<String> getHavingParts() {
        return this.m_havingParts;
    }

    public void addSelectExpression(String expression, boolean aggregating) {
        this.getSelectParts().add(expression);
        if (!aggregating) {
            this.getGroupByParts().add(expression);
        }
    }

    public void addFromExpression(String expression) {
        this.getFromParts().add(expression);
    }

    public void addWhereConstraint(String constraint) {
        this.getWhereParts().add(constraint);
    }

    public void addGroupByExpression(String expression) {
        this.getGroupByParts().add(expression);
    }

    public void addHavingConstraint(String constraint) {
        this.getHavingParts().add(constraint);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.m_fromParts == null ? 0 : this.m_fromParts.hashCode());
        result = 31 * result + (this.m_groupByParts == null ? 0 : this.m_groupByParts.hashCode());
        result = 31 * result + (this.m_havingParts == null ? 0 : this.m_havingParts.hashCode());
        result = 31 * result + (this.m_selectParts == null ? 0 : this.m_selectParts.hashCode());
        result = 31 * result + (this.m_whereParts == null ? 0 : this.m_whereParts.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityContribution other = (EntityContribution)obj;
        if (this.m_fromParts == null ? other.m_fromParts != null : !this.m_fromParts.equals(other.m_fromParts)) {
            return false;
        }
        if (this.m_groupByParts == null ? other.m_groupByParts != null : !this.m_groupByParts.equals(other.m_groupByParts)) {
            return false;
        }
        if (this.m_havingParts == null ? other.m_havingParts != null : !this.m_havingParts.equals(other.m_havingParts)) {
            return false;
        }
        if (this.m_selectParts == null ? other.m_selectParts != null : !this.m_selectParts.equals(other.m_selectParts)) {
            return false;
        }
        return !(this.m_whereParts == null ? other.m_whereParts != null : !this.m_whereParts.equals(other.m_whereParts));
    }
}

