/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.test;

import java.lang.reflect.Method;
import org.eclipse.scout.rt.server.ThreadContext;
import org.eclipse.scout.rt.server.services.common.test.AbstractServerTest;
import org.eclipse.scout.rt.shared.services.lookup.ILookupService;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.SERVICES;
import org.osgi.framework.Bundle;

public class DefaultLookupServicesTest
extends AbstractServerTest {
    public void run() throws Throwable {
        ILookupService[] services;
        ILookupService[] iLookupServiceArray = services = (ILookupService[])SERVICES.getServices(ILookupService.class);
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            ILookupService s = iLookupServiceArray[n2];
            this.testMethodInvocation(s, "getDataByKey");
            this.testMethodInvocation(s, "getDataByText");
            this.testMethodInvocation(s, "getDataByAll");
            this.testMethodInvocation(s, "getDataByRec");
            ++n2;
        }
    }

    protected void testMethodInvocation(ILookupService s, String methodName) {
        this.setSubTitle(String.valueOf(s.getClass().getSimpleName()) + "." + methodName);
        try {
            LookupCall call = this.createLookupCall(s, methodName);
            Method m = s.getClass().getMethod(methodName, LookupCall.class);
            LookupRow[] cfr_ignored_0 = (LookupRow[])m.invoke((Object)s, call);
            this.addOkStatus();
        }
        catch (Throwable t) {
            this.addErrorStatus(t);
        }
    }

    protected LookupCall createLookupCall(ILookupService s, String methodName) throws Throwable {
        Bundle serverBundle = ThreadContext.getServerSession().getBundle();
        String groupName = serverBundle.getSymbolicName().replace("\\.server$", "");
        String lookupCallClassName = String.valueOf(groupName) + ".shared.services.lookup." + s.getClass().getSimpleName().replaceAll("LookupService$", "") + "LookupCall";
        LookupCall call = (LookupCall)serverBundle.loadClass(lookupCallClassName).newInstance();
        call.setKey((Object)1L);
        call.setText("XXX");
        call.setAll("XXX");
        call.setRec((Object)1L);
        call.setMaster((Object)1L);
        call.setMaxRowCount(1);
        return call;
    }

    protected String getConfiguredTitle() {
        return "Lookup Services";
    }
}

