/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.security;

import java.security.Permission;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.security.ServicePermission;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.service.SERVICES;
import org.eclipse.scout.service.ServiceUtility;

public final class ACCESS {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ACCESS.class);

    private ACCESS() {
    }

    public static boolean check(Permission p) {
        return ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).checkPermission(p);
    }

    public static int getLevel(Permission p) {
        return ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).getPermissionLevel(p);
    }

    @Deprecated
    public static void checkService(Object service, String operation) throws ProcessingException {
        IAccessControlService acs = (IAccessControlService)SERVICES.getService(IAccessControlService.class);
        if (acs != null) {
            Class<?> c = service.getClass();
            Class[] classArray = ServiceUtility.getInterfacesHierarchy(c, Object.class);
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class i = classArray[n2];
                if (Object.class.isAssignableFrom(i) && acs.checkPermission(new ServicePermission(i, operation))) {
                    return;
                }
                ++n2;
            }
            throw new ProcessingException("service: " + service + ", operation: " + operation, (Throwable)new SecurityException("access denied"));
        }
    }
}

