/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.workflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.services.common.workflow.AbstractWorkflowStepData;

public abstract class AbstractWorkflowData
implements Serializable {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractWorkflowData.class);
    private static final long serialVersionUID = 1L;
    private String m_definitionText;
    private boolean m_definitionActive = true;
    private String m_definitionServiceClass;
    private Date m_finishDate;
    private List<AbstractWorkflowStepData> m_stepList = new ArrayList<AbstractWorkflowStepData>(0);
    private int m_currentStepIndex = 0;
    private long m_definitionNr;
    private long m_workflowNr;
    private int m_statusUid;
    private Date m_creationDate;
    private long m_creationUserNr;
    private String m_comment;

    public AbstractWorkflowData() {
        this.initConfig();
    }

    private Class<? extends AbstractWorkflowStepData>[] getConfiguredStepDatas() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClasses((Class[])dca, AbstractWorkflowStepData.class);
    }

    protected void initConfig() {
        Class<? extends AbstractWorkflowStepData>[] stepArray = this.getConfiguredStepDatas();
        int i = 0;
        while (i < stepArray.length) {
            try {
                AbstractWorkflowStepData f = (AbstractWorkflowStepData)ConfigurationUtility.newInnerInstance((Object)this, stepArray[i]);
                this.m_stepList.add(f);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
            ++i;
        }
    }

    public long getDefinitionNr() {
        return this.m_definitionNr;
    }

    public void setDefinitionNr(long l) {
        this.m_definitionNr = l;
    }

    public String getDefinitionText() {
        return this.m_definitionText;
    }

    public void setDefinitionText(String s) {
        this.m_definitionText = s;
    }

    public boolean isDefinitionActive() {
        return this.m_definitionActive;
    }

    public void setDefinitionActive(boolean b) {
        this.m_definitionActive = b;
    }

    public String getDefinitionServiceClass() {
        return this.m_definitionServiceClass;
    }

    public void setDefinitionServiceClass(String s) {
        this.m_definitionServiceClass = s;
    }

    public long getWorkflowNr() {
        return this.m_workflowNr;
    }

    public void setWorkflowNr(long l) {
        this.m_workflowNr = l;
    }

    public Date getCreationDate() {
        return this.m_creationDate;
    }

    public void setCreationDate(Date d) {
        this.m_creationDate = d;
    }

    public long getCreationUserNr() {
        return this.m_creationUserNr;
    }

    public void setCreationUserNr(long l) {
        this.m_creationUserNr = l;
    }

    public int getStatusUid() {
        return this.m_statusUid;
    }

    public void setStatusUid(int l) {
        this.m_statusUid = l;
    }

    public String getComment() {
        return this.m_comment;
    }

    public void setComment(String s) {
        this.m_comment = s;
    }

    public boolean isFinished() {
        return this.m_finishDate != null;
    }

    public Date getFinishDate() {
        return this.m_finishDate;
    }

    public void setFinishDate(Date d) {
        this.m_finishDate = d;
    }

    public void addStepData(AbstractWorkflowStepData d) {
        if (d != null) {
            this.m_stepList.add(d);
        }
    }

    public AbstractWorkflowStepData[] getStepDataList() {
        AbstractWorkflowStepData[] copyUnmodifiableList = (AbstractWorkflowStepData[])CollectionUtility.toArray(this.m_stepList, AbstractWorkflowStepData.class);
        return copyUnmodifiableList;
    }

    public void setStepDataList(Collection<AbstractWorkflowStepData> c) {
        if (c != null && c.size() > 0) {
            this.m_stepList = CollectionUtility.copyList(c);
        } else {
            this.m_stepList.clear();
        }
    }

    public <T extends AbstractWorkflowStepData> T findStepData(Class<T> workflowStepClass) {
        for (AbstractWorkflowStepData step : this.m_stepList) {
            if (!step.getClass().equals(workflowStepClass)) continue;
            return (T)step;
        }
        return null;
    }

    public AbstractWorkflowStepData findStepData(Long stepDefinitionNr) {
        if (stepDefinitionNr == null) {
            return null;
        }
        for (AbstractWorkflowStepData step : this.m_stepList) {
            if (step.getDefinitionNr() != stepDefinitionNr.longValue()) continue;
            return step;
        }
        return null;
    }

    public int findStepDataIndex(AbstractWorkflowStepData stepData) {
        if (stepData != null) {
            int i = 0;
            while (i < this.m_stepList.size()) {
                if (this.m_stepList.get(i) == stepData) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int findStepDataIndex(Long stepDefinitionNr) {
        if (stepDefinitionNr != null) {
            int i = 0;
            while (i < this.m_stepList.size()) {
                if (this.m_stepList.get(i).getDefinitionNr() == stepDefinitionNr.longValue()) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int getCurrentStepDataIndex() {
        return this.m_currentStepIndex;
    }

    public void setCurrentStepData(AbstractWorkflowStepData stepData) {
        this.setCurrentStepDataIndex(this.findStepDataIndex(stepData));
    }

    public void setCurrentStepDataIndex(int index) {
        if (index < 0) {
            index = 0;
        }
        if (index >= this.m_stepList.size()) {
            index = this.m_stepList.size();
        }
        this.m_currentStepIndex = index;
    }

    public void advanceStepDataIndex() {
        ++this.m_currentStepIndex;
    }

    public AbstractWorkflowStepData getCurrentStepData() {
        if (this.m_currentStepIndex < this.m_stepList.size()) {
            return this.m_stepList.get(this.m_currentStepIndex);
        }
        return null;
    }

    public List<AbstractWorkflowStepData> getExpectedFuture() {
        int a = this.m_currentStepIndex;
        int b = this.m_stepList.size() - 1;
        if (a <= b && b < this.m_stepList.size()) {
            return Collections.unmodifiableList(this.m_stepList.subList(a, b + 1));
        }
        return Collections.emptyList();
    }

    public List<AbstractWorkflowStepData> getHistory() {
        int a = 0;
        int b = this.m_currentStepIndex;
        if (a <= b && b < this.m_stepList.size()) {
            return Collections.unmodifiableList(this.m_stepList.subList(a, b + 1));
        }
        return Collections.emptyList();
    }

    public AbstractWorkflowStepData getPreviousStepData() {
        if (this.m_currentStepIndex - 1 >= 0 && this.m_currentStepIndex - 1 < this.m_stepList.size()) {
            return this.m_stepList.get(this.m_currentStepIndex - 1);
        }
        return null;
    }

    public AbstractWorkflowStepData getNextStepData() {
        if (this.m_currentStepIndex + 1 >= 0 && this.m_currentStepIndex + 1 < this.m_stepList.size()) {
            return this.m_stepList.get(this.m_currentStepIndex + 1);
        }
        return null;
    }

    public AbstractWorkflowStepData getFirstStepData() {
        if (this.m_stepList.size() > 0) {
            return this.m_stepList.get(0);
        }
        return null;
    }

    public AbstractWorkflowStepData getLastStepData() {
        if (this.m_stepList.size() > 0) {
            return this.m_stepList.get(this.m_stepList.size() - 1);
        }
        return null;
    }
}

