/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.lookup;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.shared.services.lookup.ILookupService;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

public class LocalLookupCall
extends LookupCall {
    private static final long serialVersionUID = 0L;

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @ConfigOperation
    @Order(value=30.0)
    protected List<LookupRow> execCreateLookupRows() throws ProcessingException {
        return null;
    }

    protected Pattern createSearchPattern(String humanReadbleFilterPattern) {
        return LocalLookupCall.createLowerCaseSearchPattern(humanReadbleFilterPattern);
    }

    public static Pattern createLowerCaseSearchPattern(String s) {
        return StringUtility.toRegEx((String)s, (int)34);
    }

    @Override
    protected final Class<? extends ILookupService> getConfiguredService() {
        return null;
    }

    @Override
    public LookupRow[] getDataByKey() throws ProcessingException {
        if (this.getKey() == null) {
            return LookupRow.EMPTY_ARRAY;
        }
        Object key = this.getKey();
        ArrayList<LookupRow> list = new ArrayList<LookupRow>();
        for (LookupRow row : this.execCreateLookupRows()) {
            if (!key.equals(row.getKey())) continue;
            list.add(row);
        }
        return list.toArray(new LookupRow[list.size()]);
    }

    @Override
    public LookupRow[] getDataByText() throws ProcessingException {
        ArrayList<LookupRow> list = new ArrayList<LookupRow>();
        Pattern p = this.createSearchPattern(this.getText());
        for (LookupRow row : this.execCreateLookupRows()) {
            if (row.getText() == null || !p.matcher(row.getText().toLowerCase()).matches()) continue;
            list.add(row);
        }
        return list.toArray(new LookupRow[list.size()]);
    }

    @Override
    public LookupRow[] getDataByAll() throws ProcessingException {
        ArrayList<LookupRow> list = new ArrayList<LookupRow>();
        Pattern p = this.createSearchPattern(this.getAll());
        for (LookupRow row : this.execCreateLookupRows()) {
            if (row.getText() == null || !p.matcher(row.getText().toLowerCase()).matches()) continue;
            list.add(row);
        }
        return list.toArray(new LookupRow[list.size()]);
    }

    @Override
    public LookupRow[] getDataByRec() throws ProcessingException {
        ArrayList<LookupRow> list = new ArrayList<LookupRow>();
        Object parentKey = this.getRec();
        if (parentKey == null) {
            for (LookupRow row : this.execCreateLookupRows()) {
                if (row.getParentKey() != null) continue;
                list.add(row);
            }
        } else {
            for (LookupRow row : this.execCreateLookupRows()) {
                if (!parentKey.equals(row.getParentKey())) continue;
                list.add(row);
            }
        }
        return list.toArray(new LookupRow[list.size()]);
    }
}

