/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.validate;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.eclipse.scout.rt.shared.validate.annotations.FieldReference;
import org.eclipse.scout.rt.shared.validate.annotations.ValidateAnnotationMarker;

public final class ValidationUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ValidationUtility.class);
    public static final Collection<Annotation> NO_ANNOTATIONS = Collections.unmodifiableList(Collections.EMPTY_LIST);
    private static final HashMap<Class<?>, ClassMetaData> classMetaDataCache = new HashMap();
    private static final ClassMetaData NO_CLASS_META_DATA = new ClassMetaData();
    private static final HashMap<Method, MethodMetaData> methodMetaDataCache = new HashMap();
    private static final MethodMetaData NO_METHOD_META_DATA = new MethodMetaData();

    private ValidationUtility() {
    }

    public static Object treat0AsNull(Object value) {
        if (value != null && value instanceof Number && ((Number)value).longValue() == 0L) {
            return null;
        }
        return value;
    }

    public static void checkArray(Object array) throws ProcessingException {
        if (array == null || !array.getClass().isArray()) {
            throw new ProcessingException("value  is no array");
        }
    }

    public static void checkMandatoryValue(Object value) throws ProcessingException {
        if (value == null) {
            throw new ProcessingException("value  is required");
        }
    }

    public static void checkMandatoryArray(Object array) throws ProcessingException {
        ValidationUtility.checkArray(array);
        if (Array.getLength(array) == 0) {
            throw new ProcessingException("value  is required");
        }
    }

    public static void checkMinLength(Object value, Object minLength) throws ProcessingException {
        if (value == null || minLength == null) {
            return;
        }
        int min = ((Number)minLength).intValue();
        if (value instanceof String ? ((String)value).length() < min : (value.getClass().isArray() ? Array.getLength(value) < min : (value instanceof Collection ? ((Collection)value).size() < min : (value instanceof Map ? ((Map)value).size() < min : value.toString().length() < min)))) {
            throw new ProcessingException("value  is too short");
        }
    }

    public static void checkMaxLength(Object value, Object maxLength) throws ProcessingException {
        if (value == null || maxLength == null) {
            return;
        }
        int max = ((Number)maxLength).intValue();
        if (value instanceof String ? ((String)value).length() > max : (value.getClass().isArray() ? Array.getLength(value) > max : (value instanceof Collection ? ((Collection)value).size() > max : (value instanceof Map ? ((Map)value).size() > max : value.toString().length() > max)))) {
            throw new ProcessingException("value  is too long");
        }
    }

    public static void checkMinValue(Object value, Object minValue) throws ProcessingException {
        if (value == null || minValue == null) {
            return;
        }
        if (((Comparable)value).compareTo(minValue = TypeCastUtility.castValue((Object)minValue, value.getClass())) < 0) {
            throw new ProcessingException("value  is too small");
        }
    }

    public static void checkMaxValue(Object value, Object maxValue) throws ProcessingException {
        if (value == null || maxValue == null) {
            return;
        }
        if (((Comparable)value).compareTo(maxValue = TypeCastUtility.castValue((Object)maxValue, value.getClass())) > 0) {
            throw new ProcessingException("value  is too large");
        }
    }

    public static void checkCodeTypeValue(Object codeKey, ICodeType<?> codeType) throws ProcessingException {
        if (codeKey == null || codeType == null) {
            return;
        }
        if (codeType.getCode(codeKey) == null) {
            throw new ProcessingException("value  " + codeKey + " is illegal for " + codeType.getClass().getSimpleName());
        }
    }

    public static void checkCodeTypeArray(Object codeKeyArray, ICodeType<?> codeType) throws ProcessingException {
        if (codeKeyArray == null || codeType == null) {
            return;
        }
        ValidationUtility.checkArray(codeKeyArray);
        int len = Array.getLength(codeKeyArray);
        if (len == 0) {
            return;
        }
        int i = 0;
        while (i < len) {
            Object codeKey = Array.get(codeKeyArray, i);
            if (codeType.getCode(codeKey) == null) {
                throw new ProcessingException("value  " + codeKey + " is illegal for " + codeType.getClass().getSimpleName());
            }
            ++i;
        }
    }

    public static void checkLookupCallValue(Object lookupKey, LookupCall call) throws ProcessingException {
        if (lookupKey == null || call == null) {
            return;
        }
        call.setKey(lookupKey);
        if (call.getDataByKey().length == 0) {
            throw new ProcessingException("value  " + lookupKey + " is illegal for " + call.getClass().getSimpleName());
        }
    }

    public static void checkLookupCallArray(Object lookupKeyArray, LookupCall call) throws ProcessingException {
        if (lookupKeyArray == null || call == null) {
            return;
        }
        ValidationUtility.checkArray(lookupKeyArray);
        int len = Array.getLength(lookupKeyArray);
        if (len == 0) {
            return;
        }
        int i = 0;
        while (i < len) {
            Object lookupKey = Array.get(lookupKeyArray, i);
            call.setKey(lookupKey);
            if (call.getDataByKey().length == 0) {
                throw new ProcessingException("value  " + lookupKey + " is illegal for " + call.getClass().getSimpleName());
            }
            ++i;
        }
    }

    public static void checkRegexMatchValue(Object value, Pattern regex) throws ProcessingException {
        if (value == null || regex == null) {
            return;
        }
        if (!(value instanceof String)) {
            throw new ProcessingException("value  value is no string");
        }
        if (!regex.matcher((String)value).matches()) {
            throw new ProcessingException("value  is not valid");
        }
    }

    public static void checkRegexMatchArray(Object arrayOfStrings, Pattern regex) throws ProcessingException {
        if (arrayOfStrings == null || regex == null) {
            return;
        }
        ValidationUtility.checkArray(arrayOfStrings);
        int len = Array.getLength(arrayOfStrings);
        if (len == 0) {
            return;
        }
        int i = 0;
        while (i < len) {
            Object value = Array.get(arrayOfStrings, i);
            if (!(value instanceof String)) {
                throw new ProcessingException("value  value is no string");
            }
            if (!regex.matcher((String)value).matches()) {
                throw new ProcessingException("value  is not valid");
            }
            ++i;
        }
    }

    public static Collection<Annotation>[] getParameterAnnotations(Method m) {
        MethodMetaData meta = ValidationUtility.getMethodMetaData(m);
        if (meta == NO_METHOD_META_DATA) {
            return new Collection[0];
        }
        Collection[] copy = new Collection[meta.paramAnnotationList.length];
        System.arraycopy(meta.paramAnnotationList, 0, copy, 0, copy.length);
        return copy;
    }

    private static synchronized ClassMetaData getClassMetaData(Class<?> c) {
        ClassMetaData meta = classMetaDataCache.get(c);
        if (meta != null) {
            return meta;
        }
        HashMap fieldMap = new HashMap();
        HashMap phantomFieldMap = new HashMap();
        Class<?> tmp = c;
        while (tmp != null && tmp != Object.class) {
            Field[] fields = tmp.getDeclaredFields();
            if (fields != null && fields.length > 0) {
                Field[] fieldArray = fields;
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    FieldReference refAnnotation = field.getAnnotation(FieldReference.class);
                    if (refAnnotation != null || !field.isSynthetic() && (field.getModifiers() & 8) == 0) {
                        ArrayList<Annotation> aList = new ArrayList<Annotation>();
                        Annotation[] aArray = field.getAnnotations();
                        if (aArray != null) {
                            Annotation[] annotationArray = aArray;
                            int n3 = aArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Annotation a = annotationArray[n4];
                                if (a.annotationType().getAnnotation(ValidateAnnotationMarker.class) != null) {
                                    aList.add(a);
                                }
                                ++n4;
                            }
                        }
                        if (refAnnotation != null) {
                            String fname = field.getAnnotation(FieldReference.class).value();
                            phantomFieldMap.put(fname, aList);
                        } else {
                            fieldMap.put(field, aList);
                        }
                    }
                    ++n2;
                }
            }
            tmp = tmp.getSuperclass();
        }
        if (phantomFieldMap.size() > 0) {
            for (Map.Entry entry : fieldMap.entrySet()) {
                List aList = (List)phantomFieldMap.get(((Field)entry.getKey()).getName());
                if (aList == null) continue;
                ((List)entry.getValue()).addAll(aList);
            }
            for (Field f : fieldMap.keySet()) {
                phantomFieldMap.remove(f.getName());
            }
            for (String fname : phantomFieldMap.keySet()) {
                LOG.warn("The phantom field " + c.getName() + "#" + fname + " points to @FieldReference(" + fname + ") that does not exist");
            }
        }
        if (fieldMap.size() == 0) {
            meta = NO_CLASS_META_DATA;
        } else {
            meta = new ClassMetaData();
            meta.fields = new Field[fieldMap.size()];
            meta.fieldAnnotationList = new Collection[fieldMap.size()];
            int index = 0;
            for (Map.Entry entry : fieldMap.entrySet()) {
                meta.fields[index] = (Field)entry.getKey();
                Collection value = (Collection)entry.getValue();
                meta.fieldAnnotationList[index] = value.size() == 0 ? NO_ANNOTATIONS : Collections.unmodifiableCollection(value);
                ++index;
            }
        }
        classMetaDataCache.put(c, meta);
        return meta;
    }

    private static synchronized MethodMetaData getMethodMetaData(Method m) {
        MethodMetaData meta = methodMetaDataCache.get(m);
        if (meta != null) {
            return meta;
        }
        String name = m.getName();
        Class<?>[] types = m.getParameterTypes();
        if (types == null || types.length == 0) {
            methodMetaDataCache.put(m, NO_METHOD_META_DATA);
            return NO_METHOD_META_DATA;
        }
        int paramCount = types.length;
        Class<?> c = m.getDeclaringClass();
        ArrayList<Annotation[][]> stack = new ArrayList<Annotation[][]>();
        while (c != null && c != Object.class) {
            try {
                stack.add(c.getMethod(name, types).getParameterAnnotations());
            }
            catch (Throwable throwable) {}
            Class<?>[] ifs = c.getInterfaces();
            if (ifs != null && ifs.length > 0) {
                Class<?>[] classArray = ifs;
                int n = ifs.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> i = classArray[n2];
                    try {
                        stack.add(i.getMethod(name, types).getParameterAnnotations());
                    }
                    catch (Throwable throwable) {}
                    ++n2;
                }
            }
            c = c.getSuperclass();
        }
        ArrayList[] annListPerParam = new ArrayList[paramCount];
        int p = 0;
        while (p < paramCount) {
            annListPerParam[p] = new ArrayList(0);
            ++p;
        }
        int s = stack.size() - 1;
        while (s >= 0) {
            Annotation[][] elem = (Annotation[][])stack.get(s);
            if (elem != null) {
                int p2 = 0;
                while (p2 < paramCount) {
                    Annotation[] annotationArray = elem[p2];
                    int n = annotationArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Annotation a = annotationArray[n3];
                        if (a.annotationType().getAnnotation(ValidateAnnotationMarker.class) != null) {
                            annListPerParam[p2].add(a);
                        }
                        ++n3;
                    }
                    ++p2;
                }
            }
            --s;
        }
        meta = new MethodMetaData();
        meta.paramAnnotationList = new Collection[paramCount];
        p = 0;
        while (p < paramCount) {
            meta.paramAnnotationList[p] = Collections.unmodifiableCollection(annListPerParam[p]);
            ++p;
        }
        methodMetaDataCache.put(m, meta);
        return meta;
    }

    private static class ClassMetaData {
        Field[] fields;
        Collection<Annotation>[] fieldAnnotationList;

        private ClassMetaData() {
        }
    }

    private static class MethodMetaData {
        Collection<Annotation>[] paramAnnotationList;

        private MethodMetaData() {
        }
    }

    public static abstract class ValidateTreeVisitor {
        private HashMap<Field, Annotation[]> m_fieldToAnnotationsCache = new HashMap();
        private HashSet<Object> m_markedSet;

        public void start(Object obj, Collection<Annotation> annotations) throws Exception {
            this.m_markedSet = new HashSet();
            this.processNode(obj, annotations == null ? NO_ANNOTATIONS : annotations);
            this.m_markedSet = null;
        }

        protected void visitObject(Object obj, Collection<Annotation> annotationList) throws Exception {
            this.visitSubTree(obj);
        }

        protected void markObject(Object obj) throws Exception {
            this.m_markedSet.add(obj);
        }

        protected void visitSubTree(Object obj) throws Exception {
            this.processSubTree(obj);
        }

        private void processNode(Object obj, Collection<Annotation> annotationList) throws Exception {
            if (obj == null && annotationList.size() == 0) {
                return;
            }
            if (obj != null) {
                if (this.m_markedSet.contains(obj)) {
                    return;
                }
                this.markObject(obj);
            }
            this.visitObject(obj, annotationList);
        }

        private void processSubTree(Object obj) throws Exception {
            if (obj == null) {
                return;
            }
            Class<?> c = obj.getClass();
            if (c == null) {
                return;
            }
            if (c.isPrimitive() || c == Byte.class || c == Short.class || c == Integer.class || c == Long.class || c == Float.class || c == Double.class || c == Character.class || c == Boolean.class || c == String.class) {
                return;
            }
            if (obj instanceof Type) {
                return;
            }
            if (c.isArray()) {
                int len = Array.getLength(obj);
                int i = 0;
                while (i < len) {
                    this.processNode(Array.get(obj, i), NO_ANNOTATIONS);
                    ++i;
                }
                return;
            }
            if (obj instanceof Collection) {
                for (Object elem : (Collection)obj) {
                    this.processNode(elem, NO_ANNOTATIONS);
                }
                return;
            }
            if (obj instanceof Map) {
                for (Map.Entry entry : ((Map)obj).entrySet()) {
                    this.processNode(entry.getKey(), NO_ANNOTATIONS);
                    this.processNode(entry.getValue(), NO_ANNOTATIONS);
                }
                return;
            }
            ClassMetaData meta = ValidationUtility.getClassMetaData(c);
            if (meta != NO_CLASS_META_DATA) {
                int i = 0;
                while (i < meta.fields.length) {
                    Collection<Annotation> ann;
                    Field field = meta.fields[i];
                    field.setAccessible(true);
                    Object childObj = field.get(obj);
                    if (childObj instanceof CharSequence) {
                        childObj = ((CharSequence)childObj).toString();
                    }
                    this.processNode(childObj, (ann = meta.fieldAnnotationList[i]) != null ? ann : NO_ANNOTATIONS);
                    ++i;
                }
            }
        }
    }
}

