/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.validate.checks;

import org.eclipse.scout.rt.shared.validate.ValidationUtility;
import org.eclipse.scout.rt.shared.validate.checks.IValidateCheck;

public class MandatoryCheck
implements IValidateCheck {
    public static final String ID = "mandatory";
    private final boolean m_value;

    public MandatoryCheck(boolean value) {
        this.m_value = value;
    }

    @Override
    public String getCheckId() {
        return ID;
    }

    @Override
    public boolean accept(Object obj) {
        return true;
    }

    @Override
    public void check(Object obj) throws Exception {
        if (!this.m_value) {
            return;
        }
        if (obj != null && obj.getClass().isArray()) {
            ValidationUtility.checkMandatoryArray(obj);
        } else {
            ValidationUtility.checkMandatoryValue(obj);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.m_value;
    }
}

