/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.basic.tree;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.IDNDSupport;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeListener;
import org.eclipse.scout.rt.ui.rap.RwtMenuUtility;
import org.eclipse.scout.rt.ui.rap.basic.RwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.basic.tree.IRwtScoutTree;
import org.eclipse.scout.rt.ui.rap.basic.tree.RwtScoutTreeModel;
import org.eclipse.scout.rt.ui.rap.ext.MenuAdapterEx;
import org.eclipse.scout.rt.ui.rap.ext.tree.TreeEx;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.rap.form.fields.AbstractRwtScoutDndSupport;
import org.eclipse.scout.rt.ui.rap.keystroke.IRwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.keystroke.RwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;

public class RwtScoutTree
extends RwtScoutComposite<ITree>
implements IRwtScoutTree {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutTree.class);
    private P_ScoutTreeListener m_scoutTreeListener;
    private Menu m_contextMenu;
    private TreeViewer m_treeViewer;
    private boolean m_enabledFromScout = true;
    private IRwtKeyStroke[] m_keyStrokes;
    private String m_variant = "";

    public RwtScoutTree() {
    }

    public RwtScoutTree(String variant) {
        this.m_variant = variant;
    }

    @Override
    protected void initializeUi(Composite parent) {
        TreeViewer viewer = this.createTreeModel(parent);
        this.setUiTreeViewer(viewer);
        this.setUiField((Control)viewer.getTree());
        this.initNodeHeight();
        this.initializeTreeModel();
        viewer.getTree().setData("org.eclipse.rap.rwt.markupEnabled", (Object)Boolean.TRUE);
        viewer.getTree().setData("org.eclipse.rap.rwt.markupValidationDisabled", (Object)Boolean.TRUE);
        viewer.addSelectionChangedListener((ISelectionChangedListener)new P_RwtSelectionListener());
        viewer.addTreeListener((ITreeViewerListener)new P_RwtExpansionListener());
        viewer.addDoubleClickListener((IDoubleClickListener)new P_RwtDoubleClickListener());
        P_RwtTreeListener treeListener = new P_RwtTreeListener();
        viewer.getTree().addListener(3, (Listener)treeListener);
        viewer.getTree().addListener(4, (Listener)treeListener);
        viewer.getTree().addListener(2, (Listener)treeListener);
        this.getUiEnvironment().addKeyStroke((Control)viewer.getTree(), new P_RwtKeyReturnAvoidDoubleClickListener(), false);
        this.m_contextMenu = new Menu((Decorations)viewer.getTree().getShell(), 8);
        this.m_contextMenu.addMenuListener((MenuListener)new P_ContextMenuListener());
        viewer.getTree().setMenu(this.m_contextMenu);
    }

    protected TreeViewer createTreeModel(Composite parent) {
        int style = this.isMultiSelect() ? 2 : 4;
        TreeEx tree = this.getUiEnvironment().getFormToolkit().createTree(parent, style |= 0xB00);
        if (StringUtility.hasText((String)this.m_variant)) {
            tree.setData("org.eclipse.rwt.themeVariant", this.m_variant);
        }
        tree.setLayoutDeferred(true);
        TreeViewer viewer = new TreeViewer((Tree)tree);
        viewer.setUseHashlookup(true);
        return viewer;
    }

    @Override
    public boolean isUiDisposed() {
        return this.getUiField() == null || this.getUiField().isDisposed();
    }

    protected void initializeTreeModel() {
        RwtScoutTreeModel model = this.createTreeModel();
        this.getUiTreeViewer().setContentProvider((IContentProvider)model);
        this.getUiTreeViewer().setLabelProvider((IBaseLabelProvider)model);
        this.getUiTreeViewer().setInput((Object)model);
    }

    protected RwtScoutTreeModel createTreeModel() {
        return new RwtScoutTreeModel((ITree)this.getScoutObject(), this, this.getUiTreeViewer());
    }

    protected boolean isMultiSelect() {
        if (this.getScoutObject() != null) {
            return ((ITree)this.getScoutObject()).isMultiSelect();
        }
        return false;
    }

    protected void setUiTreeViewer(TreeViewer viewer) {
        this.m_treeViewer = viewer;
    }

    @Override
    public TreeViewer getUiTreeViewer() {
        return this.m_treeViewer;
    }

    protected ITreeContentProvider getContentProvider() {
        return (ITreeContentProvider)this.getUiTreeViewer().getContentProvider();
    }

    @Override
    public TreeEx getUiField() {
        return (TreeEx)super.getUiField();
    }

    protected void initNodeHeight() {
        int height = UiDecorationExtensionPoint.getLookAndFeel().getTreeNodeHeight();
        if (height >= 0) {
            this.getUiField().setData("org.eclipse.rap.rwt.customItemHeight", height);
        }
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        if (this.getScoutObject() == null) {
            return;
        }
        if (this.m_scoutTreeListener == null) {
            this.m_scoutTreeListener = new P_ScoutTreeListener();
            ((ITree)this.getScoutObject()).addUITreeListener((TreeListener)this.m_scoutTreeListener);
        }
        if (((ITree)this.getScoutObject()).isRootNodeVisible()) {
            this.setExpansionFromScout(((ITree)this.getScoutObject()).getRootNode());
        } else {
            ITreeNode[] iTreeNodeArray = ((ITree)this.getScoutObject()).getRootNode().getFilteredChildNodes();
            int n = iTreeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode node = iTreeNodeArray[n2];
                this.setExpansionFromScout(node);
                ++n2;
            }
        }
        this.setSelectionFromScout(((ITree)this.getScoutObject()).getSelectedNodes());
        this.setKeyStrokeFormScout();
        this.setNodeHeightFromScout();
        this.attachDndSupport();
        this.handleEventsFromRecentHistory();
    }

    protected void attachDndSupport() {
        if (UiDecorationExtensionPoint.getLookAndFeel().isDndSupportEnabled()) {
            new P_DndSupport((IPropertyObserver)this.getScoutObject(), (IDNDSupport)this.getScoutObject(), (Control)this.getUiField());
        }
    }

    private void handleEventsFromRecentHistory() {
        final IEventHistory h = ((ITree)this.getScoutObject()).getEventHistory();
        if (h == null) {
            return;
        }
        this.getUiEnvironment().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (TreeEvent e : h.getRecentEvents()) {
                    RwtScoutTree.this.handleScoutTreeEventInUi(e);
                }
            }
        });
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        if (this.getScoutObject() == null) {
            return;
        }
        if (this.m_scoutTreeListener != null) {
            ((ITree)this.getScoutObject()).removeTreeListener((TreeListener)this.m_scoutTreeListener);
            this.m_scoutTreeListener = null;
        }
    }

    @Override
    public void setEnabledFromScout(boolean enabled) {
        this.m_enabledFromScout = enabled;
        if (this.getUiField() instanceof TreeEx) {
            this.getUiField().setReadOnly(!enabled);
        } else {
            this.getUiField().setEnabled(enabled);
        }
    }

    public boolean isEnabledFromScout() {
        return this.m_enabledFromScout;
    }

    protected void setExpansionFromScout(ITreeNode scoutNode) {
        if (scoutNode != null) {
            this.setExpansionFromScoutRec(scoutNode);
        }
    }

    private void setExpansionFromScoutRec(ITreeNode scoutNode) {
        boolean hasChilds;
        boolean exp = scoutNode.getParentNode() == null ? true : scoutNode.isExpanded();
        ITreeNode[] filteredChildNodes = scoutNode.getFilteredChildNodes();
        boolean bl = hasChilds = filteredChildNodes.length > 0;
        if (hasChilds && exp != this.getUiTreeViewer().getExpandedState((Object)scoutNode)) {
            this.getUiTreeViewer().setExpandedState((Object)scoutNode, exp);
        }
        if (exp) {
            ITreeNode[] iTreeNodeArray = filteredChildNodes;
            int n = filteredChildNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode childNode = iTreeNodeArray[n2];
                this.setExpansionFromScoutRec(childNode);
                ++n2;
            }
        }
    }

    protected void setSelectionFromScout(ITreeNode[] scoutNodes) {
        if (this.getUiField().isDisposed()) {
            return;
        }
        this.getUiTreeViewer().setSelection((ISelection)new StructuredSelection((Object[])scoutNodes));
        this.updateScrollToSelectionFromScout();
    }

    protected void setKeyStrokeFormScout() {
        IKeyStroke[] scoutKeyStrokes;
        if (this.m_keyStrokes != null) {
            IRwtKeyStroke[] iRwtKeyStrokeArray = this.m_keyStrokes;
            int n = this.m_keyStrokes.length;
            int n2 = 0;
            while (n2 < n) {
                IRwtKeyStroke keyStroke = iRwtKeyStrokeArray[n2];
                this.getUiEnvironment().removeKeyStroke((Control)this.getUiField(), keyStroke);
                ++n2;
            }
        }
        ArrayList<IRwtKeyStroke> newKeyStrokes = new ArrayList<IRwtKeyStroke>();
        IKeyStroke[] iKeyStrokeArray = scoutKeyStrokes = ((ITree)this.getScoutObject()).getKeyStrokes();
        int n = scoutKeyStrokes.length;
        int n3 = 0;
        while (n3 < n) {
            IRwtKeyStroke[] strokes;
            IKeyStroke scoutKeyStroke = iKeyStrokeArray[n3];
            IRwtKeyStroke[] iRwtKeyStrokeArray = strokes = RwtUtility.getKeyStrokes(scoutKeyStroke, this.getUiEnvironment());
            int n4 = strokes.length;
            int n5 = 0;
            while (n5 < n4) {
                IRwtKeyStroke stroke = iRwtKeyStrokeArray[n5];
                this.getUiEnvironment().addKeyStroke((Control)this.getUiField(), stroke, false);
                newKeyStrokes.add(stroke);
                ++n5;
            }
            ++n3;
        }
        this.m_keyStrokes = newKeyStrokes.toArray(new IRwtKeyStroke[newKeyStrokes.size()]);
    }

    protected void setNodeHeightFromScout() {
        int h = ((ITree)this.getScoutObject()).getNodeHeightHint();
        if (h >= 0) {
            this.getUiField().setData("org.eclipse.rap.rwt.customItemHeight", h);
        }
        if (this.isCreated()) {
            this.getUiTreeViewer().refresh();
        }
    }

    protected void handleScoutTreeEventBatchInUi(List<TreeEvent> eventList) {
        HashSet<ITreeNode> processedParentNodes = new HashSet<ITreeNode>();
        for (TreeEvent e : eventList) {
            ITreeNode parentNode = null;
            switch (e.getType()) {
                case 10: 
                case 20: 
                case 30: 
                case 50: {
                    parentNode = e.getCommonParentNode();
                    break;
                }
                case 400: {
                    parentNode = ((ITree)this.getScoutObject()).getRootNode();
                }
            }
            if (parentNode == null || processedParentNodes.contains(parentNode)) continue;
            processedParentNodes.add(parentNode);
            this.updateTreeStructureAndKeepSelection(parentNode);
            this.setExpansionFromScout(parentNode);
        }
        for (TreeEvent e : eventList) {
            switch (e.getType()) {
                case 800: {
                    this.getUiField().setFocus();
                    break;
                }
                case 100: 
                case 101: {
                    this.setExpansionFromScout(e.getNode());
                    break;
                }
                case 40: {
                    this.setSelectionFromScout(e.getNodes());
                    break;
                }
                case 830: {
                    this.scrollToSelection();
                }
            }
        }
    }

    private void updateTreeStructureAndKeepSelection(ITreeNode node) {
        if (this.getUiTreeViewer() != null && this.getUiTreeViewer().getTree() != null && !this.getUiTreeViewer().getTree().isDisposed()) {
            if (node == ((ITree)this.getScoutObject()).getRootNode()) {
                this.getUiTreeViewer().refresh();
            } else {
                this.getUiTreeViewer().refresh((Object)node);
            }
        }
    }

    protected void setSelectionFromRwt(final ITreeNode[] nodes) {
        if (this.getUpdateUiFromScoutLock().isAcquired()) {
            return;
        }
        if (this.getScoutObject() != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    try {
                        RwtScoutTree.this.addIgnoredScoutEvent(TreeEvent.class, "40");
                        ((ITree)RwtScoutTree.this.getScoutObject()).getUIFacade().setNodesSelectedFromUI(nodes);
                    }
                    finally {
                        RwtScoutTree.this.removeIgnoredScoutEvent(TreeEvent.class, "40");
                    }
                }
            };
            this.getUiEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void updateScrollToSelectionFromScout() {
        if (((ITree)this.getScoutObject()).isScrollToSelection()) {
            this.scrollToSelection();
        }
    }

    protected void scrollToSelection() {
        if (this.getUiField() != null && !this.getUiField().isDisposed()) {
            this.getUiField().showSelection();
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        if (name.equals("keyStroks")) {
            this.setKeyStrokeFormScout();
        } else if (name.equals("scrollToSelection")) {
            this.updateScrollToSelectionFromScout();
        } else if (name.equals("propNodeHeightHint")) {
            this.setNodeHeightFromScout();
        }
        super.handleScoutPropertyChange(name, newValue);
    }

    protected void setExpansionFromUi(final ITreeNode node, final boolean expanded) {
        if (this.getUpdateUiFromScoutLock().isAcquired()) {
            return;
        }
        if (this.getScoutObject() != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    if (node.isExpanded() != expanded) {
                        ((ITree)RwtScoutTree.this.getScoutObject()).getUIFacade().setNodeExpandedFromUI(node, expanded);
                    }
                }
            };
            this.getUiEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected boolean isHandleScoutTreeEvent(TreeEvent[] a) {
        TreeEvent[] treeEventArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            TreeEvent element = treeEventArray[n2];
            switch (element.getType()) {
                case 10: 
                case 20: 
                case 30: 
                case 40: 
                case 50: 
                case 100: 
                case 101: 
                case 400: 
                case 800: 
                case 830: {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    protected void handleScoutTreeEventInUi(TreeEvent e) {
        if (this.isUiDisposed()) {
            return;
        }
        switch (e.getType()) {
            case 10: 
            case 30: 
            case 50: {
                this.updateTreeStructureAndKeepSelection(e.getCommonParentNode());
                this.setExpansionFromScout(e.getCommonParentNode());
                break;
            }
            case 20: {
                ISelection oldSelection = this.getUiTreeViewer().getSelection();
                StructuredSelection newSelection = new StructuredSelection((Object[])((ITree)this.getScoutObject()).getSelectedNodes());
                this.updateTreeStructureAndKeepSelection(e.getCommonParentNode());
                if (!newSelection.equals(oldSelection)) {
                    this.getUiTreeViewer().setSelection((ISelection)newSelection);
                }
                this.setExpansionFromScout(e.getCommonParentNode());
                break;
            }
            case 400: {
                this.updateTreeStructureAndKeepSelection(((ITree)this.getScoutObject()).getRootNode());
                this.setExpansionFromScout(((ITree)this.getScoutObject()).getRootNode());
                break;
            }
            case 800: {
                this.getUiField().setFocus();
                break;
            }
            case 100: 
            case 101: {
                this.setExpansionFromScout(e.getNode());
                break;
            }
            case 40: {
                this.setSelectionFromScout(e.getNodes());
                break;
            }
            case 830: {
                this.scrollToSelection();
            }
        }
    }

    protected void handleUiNodeClick(final ITreeNode node) {
        if (this.getScoutObject() != null && node != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITree)RwtScoutTree.this.getScoutObject()).getUIFacade().fireNodeClickFromUI(node);
                }
            };
            this.getUiEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void handleUiNodeAction(final ITreeNode node) {
        if (this.getScoutObject() != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITree)RwtScoutTree.this.getScoutObject()).getUIFacade().fireNodeActionFromUI(node);
                }
            };
            this.getUiEnvironment().invokeScoutLater(t, 400L);
        }
    }

    protected void handleUiHyperlinkAction(final ITreeNode node, final URL url) {
        if (this.getScoutObject() != null && node != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITree)RwtScoutTree.this.getScoutObject()).getUIFacade().fireHyperlinkActionFromUI(node, url);
                }
            };
            this.getUiEnvironment().invokeScoutLater(t, 0L);
        }
    }

    public static TreePath scoutNodeToTreePath(ITreeNode scoutNode) {
        if (scoutNode == null) {
            return null;
        }
        Object[] path = RwtScoutTree.getPathToRoot(scoutNode, 0);
        return new TreePath(path);
    }

    public static TreePath[] scoutNodesToTreePaths(ITreeNode[] scoutNodes) {
        if (scoutNodes == null) {
            return new TreePath[0];
        }
        TreePath[] paths = new TreePath[scoutNodes.length];
        int i = 0;
        while (i < scoutNodes.length) {
            paths[i] = RwtScoutTree.scoutNodeToTreePath(scoutNodes[i]);
            ++i;
        }
        return paths;
    }

    public static ITreeNode[] getPathToRoot(ITreeNode scoutNode, int depth) {
        ITreeNode[] retNodes;
        if (scoutNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new ITreeNode[depth];
        } else {
            retNodes = scoutNode.getParentNode() == null ? new ITreeNode[depth] : RwtScoutTree.getPathToRoot(scoutNode.getParentNode(), ++depth);
            retNodes[retNodes.length - depth] = scoutNode;
        }
        return retNodes;
    }

    private void showMenu(Point eventPosition) {
        this.getUiField().setMenu(this.m_contextMenu);
        this.getUiField().getMenu().addMenuListener((MenuListener)new MenuAdapter(){
            private static final long serialVersionUID = 1L;

            public void menuHidden(MenuEvent e) {
                RwtScoutTree.this.getUiField().setMenu(null);
                ((Menu)e.getSource()).removeMenuListener((MenuListener)this);
            }
        });
        this.getUiField().getMenu().setLocation(eventPosition);
        this.getUiField().getMenu().setVisible(true);
    }

    private void handleUiDoubleClick(StructuredSelection sel) {
        ITreeNode[] nodes = sel.toList().toArray(new ITreeNode[sel.size()]);
        if (nodes != null && nodes.length == 1) {
            if (!nodes[0].isLeaf()) {
                this.setExpansionFromUi(nodes[0], !this.getUiTreeViewer().getExpandedState((Object)nodes[0]));
            } else {
                this.handleUiNodeAction(nodes[0]);
                if (((ITree)this.getScoutObject()).isCheckable()) {
                    this.handleUiNodeClick(nodes[0]);
                }
            }
        }
    }

    private class P_ContextMenuListener
    extends MenuAdapterEx {
        private static final long serialVersionUID = 1L;

        public P_ContextMenuListener() {
            super((Control)RwtScoutTree.this.getUiTreeViewer().getTree(), (Control)RwtScoutTree.this.getUiTreeViewer().getTree().getParent());
        }

        @Override
        protected Menu getContextMenu() {
            return RwtScoutTree.this.m_contextMenu;
        }

        @Override
        protected void setContextMenu(Menu contextMenu) {
            RwtScoutTree.this.m_contextMenu = contextMenu;
        }

        @Override
        public void menuShown(MenuEvent e) {
            super.menuShown(e);
            if (RwtScoutTree.this.getScoutObject() == null || !RwtScoutTree.this.isEnabledFromScout()) {
                return;
            }
            boolean emptySpace = RwtScoutTree.this.getUiField().getContextItem() == null;
            IMenu[] menus = RwtMenuUtility.collectMenus((ITree)RwtScoutTree.this.getScoutObject(), emptySpace, !emptySpace, RwtScoutTree.this.getUiEnvironment());
            RwtMenuUtility.fillContextMenu(menus, RwtScoutTree.this.getUiEnvironment(), RwtScoutTree.this.m_contextMenu);
        }
    }

    private class P_DndSupport
    extends AbstractRwtScoutDndSupport {
        public P_DndSupport(IPropertyObserver scoutObject, IDNDSupport scoutDndSupportable, Control control) {
            super(scoutObject, scoutDndSupportable, control, RwtScoutTree.this.getUiEnvironment());
        }

        @Override
        protected TransferObject handleUiDragRequest() {
            final Holder result = new Holder(TransferObject.class, null);
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    TransferObject scoutTransferable = ((ITree)RwtScoutTree.this.getScoutObject()).getUIFacade().fireNodesDragRequestFromUI();
                    result.setValue((Object)scoutTransferable);
                }
            };
            try {
                this.getUiEnvironment().invokeScoutLater(t, 20000L).join(20000L);
            }
            catch (InterruptedException interruptedException) {}
            return (TransferObject)result.getValue();
        }

        @Override
        protected void handleUiDropAction(DropTargetEvent event, final TransferObject scoutTransferObject) {
            Object dropTarget = event.item != null ? event.item.getData() : null;
            final ITreeNode node = dropTarget instanceof ITreeNode ? (ITreeNode)dropTarget : null;
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    ((ITree)RwtScoutTree.this.getScoutObject()).getUIFacade().fireNodeDropActionFromUI(node, scoutTransferObject);
                }
            };
            this.getUiEnvironment().invokeScoutLater(job, 200L);
        }
    }

    private class P_RwtDoubleClickListener
    implements IDoubleClickListener {
        private P_RwtDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            if (event.getSelection() instanceof StructuredSelection) {
                StructuredSelection sel = (StructuredSelection)event.getSelection();
                RwtScoutTree.this.handleUiDoubleClick(sel);
            }
        }
    }

    private class P_RwtExpansionListener
    implements ITreeViewerListener {
        private P_RwtExpansionListener() {
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            RwtScoutTree.this.setExpansionFromUi((ITreeNode)event.getElement(), false);
        }

        public void treeExpanded(TreeExpansionEvent event) {
            RwtScoutTree.this.setExpansionFromUi((ITreeNode)event.getElement(), true);
        }
    }

    private class P_RwtKeyReturnAvoidDoubleClickListener
    extends RwtKeyStroke {
        private static final long serialVersionUID = 1L;

        public P_RwtKeyReturnAvoidDoubleClickListener() {
            super(13);
        }

        @Override
        public void handleUiAction(Event e) {
            e.doit = false;
        }
    }

    private class P_RwtSelectionListener
    implements ISelectionChangedListener {
        private P_RwtSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (RwtScoutTree.this.isEnabledFromScout()) {
                StructuredSelection sel = (StructuredSelection)event.getSelection();
                ITreeNode[] nodes = sel.toList().toArray(new ITreeNode[sel.size()]);
                RwtScoutTree.this.setSelectionFromRwt(nodes);
            }
        }
    }

    private class P_RwtTreeListener
    implements Listener {
        private static final long serialVersionUID = 1L;

        private P_RwtTreeListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 4: {
                    ViewerCell cell = RwtScoutTree.this.getUiTreeViewer().getCell(new Point(event.x, event.y));
                    if (cell == null || !(cell.getElement() instanceof ITreeNode)) break;
                    ITreeNode nodeToClick = (ITreeNode)cell.getElement();
                    RwtScoutTree.this.handleUiNodeClick(nodeToClick);
                    break;
                }
                case 2: {
                    if (!((ITree)RwtScoutTree.this.getScoutObject()).isCheckable() || event.stateMask != 0) break;
                    switch (event.keyCode) {
                        case 32: {
                            StructuredSelection sel = (StructuredSelection)RwtScoutTree.this.getUiTreeViewer().getSelection();
                            ITreeNode[] nodes = sel.toList().toArray(new ITreeNode[sel.size()]);
                            if (nodes != null && nodes.length > 0) {
                                RwtScoutTree.this.handleUiNodeClick(nodes[0]);
                            }
                            event.doit = false;
                        }
                    }
                    break;
                }
                case 11: {
                    RwtScoutTree.this.updateScrollToSelectionFromScout();
                }
            }
        }
    }

    private class P_ScoutTreeListener
    implements TreeListener {
        private P_ScoutTreeListener() {
        }

        public void treeChanged(final TreeEvent e) {
            if (RwtScoutTree.this.isHandleScoutTreeEvent(new TreeEvent[]{e})) {
                if (RwtScoutTree.this.isIgnoredScoutEvent(TreeEvent.class, "" + e.getType())) {
                    return;
                }
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RwtScoutTree.this.getUpdateUiFromScoutLock().acquire();
                            RwtScoutTree.this.handleScoutTreeEventInUi(e);
                        }
                        finally {
                            RwtScoutTree.this.getUpdateUiFromScoutLock().release();
                        }
                    }
                };
                RwtScoutTree.this.getUiEnvironment().invokeUiLater(t);
            }
        }

        public void treeChangedBatch(TreeEvent[] a) {
            if (RwtScoutTree.this.isHandleScoutTreeEvent(a)) {
                final ArrayList<TreeEvent> filteredList = new ArrayList<TreeEvent>();
                TreeEvent[] treeEventArray = a;
                int n = a.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeEvent element = treeEventArray[n2];
                    if (!RwtScoutTree.this.isIgnoredScoutEvent(TreeEvent.class, "" + element.getType())) {
                        filteredList.add(element);
                    }
                    ++n2;
                }
                if (filteredList.size() == 0) {
                    return;
                }
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RwtScoutTree.this.getUpdateUiFromScoutLock().acquire();
                            if (!RwtScoutTree.this.getUiField().isDisposed()) {
                                RwtScoutTree.this.getUiField().setRedraw(false);
                            }
                            RwtScoutTree.this.handleScoutTreeEventBatchInUi(filteredList);
                        }
                        finally {
                            RwtScoutTree.this.getUpdateUiFromScoutLock().release();
                            if (!RwtScoutTree.this.getUiField().isDisposed()) {
                                RwtScoutTree.this.getUiField().setRedraw(true);
                            }
                        }
                    }
                };
                RwtScoutTree.this.getUiEnvironment().invokeUiLater(t);
            }
        }
    }
}

