/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.busy;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.scout.rt.ui.rap.window.IRwtScoutPart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.widgets.Form;

public class RwtScoutPartBlockingDecorator {
    private static final String ATTACH_MARKER_DATA = String.valueOf(RwtScoutPartBlockingDecorator.class.getName()) + "#marker";
    private final IRwtScoutPart m_part;
    private final boolean m_showCancelButton;
    private boolean m_attached;
    private final IRwtEnvironment m_env;
    private Control m_oldFocus;
    private IContributionItem m_cancelAction;

    public RwtScoutPartBlockingDecorator(IRwtScoutPart part, boolean showCancelButton, IRwtEnvironment env) {
        this.m_part = part;
        this.m_showCancelButton = showCancelButton;
        this.m_env = env;
    }

    public void attach(final IProgressMonitor monitor) {
        Form rwtForm = this.m_part.getUiForm();
        if (rwtForm == null || rwtForm.isDisposed()) {
            return;
        }
        if (rwtForm.getData(ATTACH_MARKER_DATA) != null) {
            return;
        }
        this.m_attached = true;
        rwtForm.setData(ATTACH_MARKER_DATA, (Object)true);
        Control focusControl = Display.getCurrent().getFocusControl();
        if (focusControl != null && RwtUtility.isAncestorOf((Control)rwtForm, focusControl)) {
            this.m_oldFocus = focusControl;
        }
        if (this.m_showCancelButton) {
            if (this.m_cancelAction != null) {
                this.m_cancelAction.dispose();
            }
            this.m_cancelAction = new ContributionItem(){
                private static final long serialVersionUID = 1L;
                private ToolItem m_item;

                public void fill(ToolBar parent, int index) {
                    if (this.m_item == null) {
                        this.m_item = new ToolItem(parent, 0, index);
                        this.m_item.setText(RwtUtility.getNlsText(Display.getCurrent(), "BusyBlockingMessage", new String[0]));
                        this.m_item.setImage(RwtScoutPartBlockingDecorator.this.m_env.getIcon("progress_stop"));
                        this.m_item.addSelectionListener((SelectionListener)new SelectionAdapter(){
                            private static final long serialVersionUID = 1L;

                            public void widgetSelected(SelectionEvent e) {
                                monitor.setCanceled(true);
                                ((ToolItem)e.getSource()).setEnabled(false);
                            }
                        });
                    }
                }

                public void dispose() {
                    if (this.m_item != null) {
                        this.m_item.dispose();
                        this.m_item = null;
                    }
                }
            };
            rwtForm.getToolBarManager().add(this.m_cancelAction);
            rwtForm.getToolBarManager().update(true);
        }
        rwtForm.getBody().setEnabled(false);
        rwtForm.layout(true);
    }

    public void detach() {
        if (!this.m_attached) {
            return;
        }
        this.m_attached = false;
        Form rwtForm = this.m_part.getUiForm();
        if (rwtForm == null || rwtForm.isDisposed()) {
            return;
        }
        rwtForm.setData(ATTACH_MARKER_DATA, null);
        if (this.m_cancelAction != null) {
            rwtForm.getToolBarManager().remove(this.m_cancelAction);
            this.m_cancelAction.dispose();
            this.m_cancelAction = null;
            rwtForm.getToolBarManager().update(true);
        }
        rwtForm.getBody().setEnabled(true);
        rwtForm.layout(true);
        if (this.m_oldFocus != null && !this.m_oldFocus.isDisposed() && this.m_part.isActive()) {
            this.m_oldFocus.forceFocus();
            this.m_oldFocus = null;
        }
    }
}

