/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.busy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.busy.BusyJob;
import org.eclipse.scout.rt.client.busy.IBusyHandler;
import org.eclipse.scout.rt.ui.rap.busy.BlockPartsJob;
import org.eclipse.scout.rt.ui.rap.busy.RwtBusyHandler;
import org.eclipse.scout.rt.ui.rap.window.IRwtScoutPart;
import org.eclipse.scout.rt.ui.rap.window.dialog.RwtScoutDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class WaitForBlockingJob
extends BusyJob {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(WaitForBlockingJob.class);
    private List<IRwtScoutPart> m_parts;

    public WaitForBlockingJob(String name, RwtBusyHandler handler) {
        super(name, (IBusyHandler)handler);
    }

    protected RwtBusyHandler getBusyHandler() {
        return (RwtBusyHandler)super.getBusyHandler();
    }

    protected void runBusy(IProgressMonitor monitor) {
        Display display = this.getBusyHandler().getDisplay();
        final Control busyControl = (Control)this.getBusyHandler().getUiEnvironment().getClientSession().getData("RwtBusyHandler.busyControl");
        try {
            if (display != null && !display.isDisposed()) {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        WaitForBlockingJob.this.m_parts = WaitForBlockingJob.this.findAffectedParts();
                        if (busyControl != null && !busyControl.isDisposed()) {
                            busyControl.setVisible(true);
                        }
                    }
                });
            }
            super.runBusy(monitor);
        }
        catch (Throwable throwable) {
            if (display != null && !display.isDisposed()) {
                display.syncExec(new Runnable(busyControl){
                    private final /* synthetic */ Control val$busyControl;
                    {
                        this.val$busyControl = control;
                    }

                    @Override
                    public void run() {
                        if (this.val$busyControl != null && !this.val$busyControl.isDisposed()) {
                            this.val$busyControl.setVisible(false);
                        }
                    }
                });
            }
            throw throwable;
        }
        if (display != null && !display.isDisposed()) {
            display.syncExec(new /* invalid duplicate definition of identical inner class */);
        }
    }

    protected void runBlocking(IProgressMonitor monitor) {
        new BlockPartsJob(this.getName(), this.getBusyHandler(), this.m_parts).schedule();
    }

    protected List<IRwtScoutPart> findAffectedParts() {
        ArrayList<IRwtScoutPart> candidateParts = new ArrayList<IRwtScoutPart>();
        for (IRwtScoutPart part : this.getBusyHandler().getUiEnvironment().getOpenFormParts()) {
            if (!WaitForBlockingJob.isDialogPart(part) && !WaitForBlockingJob.isViewOrEditorPart(part)) continue;
            candidateParts.add(part);
        }
        ArrayList<IRwtScoutPart> affectedParts = new ArrayList<IRwtScoutPart>();
        for (IRwtScoutPart part : candidateParts) {
            if (!part.isActive() || !WaitForBlockingJob.isDialogPart(part)) continue;
            affectedParts.add(part);
            return affectedParts;
        }
        for (IRwtScoutPart part : candidateParts) {
            if (!part.isActive() || !WaitForBlockingJob.isDialogPart(part)) continue;
            affectedParts.add(part);
            return affectedParts;
        }
        for (IRwtScoutPart part : candidateParts) {
            if (!part.isActive() || !WaitForBlockingJob.isViewOrEditorPart(part)) continue;
            affectedParts.addAll(candidateParts);
            affectedParts.remove(part);
            affectedParts.add(0, part);
            return affectedParts;
        }
        affectedParts.add(null);
        affectedParts.addAll(candidateParts);
        return affectedParts;
    }

    public static boolean isDialogPart(IRwtScoutPart part) {
        return part instanceof RwtScoutDialog;
    }

    public static boolean isViewOrEditorPart(IRwtScoutPart part) {
        return part != null && !part.getClass().getSimpleName().contains("Popup");
    }

    protected List<IRwtScoutPart> getParts() {
        return this.m_parts;
    }
}

