/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.basic;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.swt.graphics.Image;

public class IconGroup {
    private final Map<IconState, Image> iconMap = new HashMap<IconState, Image>();

    public IconGroup() {
    }

    public IconGroup(IRwtEnvironment env, String iconId) {
        Image selected;
        if (iconId == null) {
            return;
        }
        Image normal = env.getIcon(iconId);
        Image rollover = env.getIcon(String.valueOf(iconId) + "_mouse_over");
        if (rollover == null) {
            rollover = env.getIcon(String.valueOf(iconId) + "_rollover");
        }
        if ((selected = env.getIcon(String.valueOf(iconId) + "_active")) == null && (selected = env.getIcon(String.valueOf(iconId) + "_pressed")) == null) {
            selected = env.getIcon(String.valueOf(iconId) + "_selected");
        }
        Image disabled = env.getIcon(String.valueOf(iconId) + "_disabled");
        this.iconMap.put(IconState.NORMAL, normal);
        if (rollover != null) {
            this.iconMap.put(IconState.ROLLOVER, rollover);
        }
        if (selected != null) {
            this.iconMap.put(IconState.SELECTED, selected);
        }
        if (disabled != null) {
            this.iconMap.put(IconState.DISABLED, disabled);
        }
    }

    public Image getIcon(IconState state) {
        Image icon = this.iconMap.get((Object)state);
        if (icon == null && state != IconState.NORMAL) {
            icon = this.iconMap.get((Object)IconState.NORMAL);
        }
        return icon;
    }

    public void setIcon(IconState state, Image icon) {
        this.iconMap.put(state, icon);
    }

    public boolean hasIcon(IconState state) {
        return this.iconMap.containsKey((Object)state);
    }

    public static enum IconState {
        NORMAL,
        ROLLOVER,
        SELECTED,
        DISABLED;

    }
}

